package com.bcxin.ins.weixin.web;


import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.utils.FreemarkerUtil;
import com.bcxin.ins.weixin.product.service.OnLineOfferService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import java.util.Map;

/**
 * @Author: wuxiaozhen
 * @Date: 2018/6/27 16:56
 * @Description:微信在线报价
 */
@Controller
@RequestMapping("${weixin}/onlineoffer")
public class WeiXinOnLineOfferController extends BaseController{

    /*选择报价险种页面*/
    private static final String CHOICE_OFFER = getViewPath("weixin/onlineoffer/weixin_choice_offer_type");

    /*报价GZX信息填写页面*/
    private static final String FILL_IN_GZX_OFFER = getViewPath("weixin/onlineoffer/weixin_fill_in_gzx_offer");

    /*报价ZZX信息填写页面*/
    private static final String FILL_IN_ZZX_OFFER = getViewPath("weixin/onlineoffer/weixin_fill_in_zzx_offer");

    /*报价TX信息填写页面(团险)*/
    private static final String FILL_IN_TX_OFFER = getViewPath("weixin/onlineoffer/weixin_fill_in_tx_offer");

    /*报价TX信息结果页(团险)*/
    private static final String FILL_IN_TX_RESULT = getViewPath("weixin/onlineoffer/weixin_fill_in_tx_result");

    /*打开图片页面*/
    private static final String OPENIMG = getViewPath("weixin/onlineoffer/weixin_fill_in_img");


    @Autowired
    private OnLineOfferService onLineOfferService;


    /*报价险种初始页面*/
    @RequestMapping(value = "/init")
    public String choice(Model model, @RequestParam Map<Object,Object> param){
        return CHOICE_OFFER;
    }

    /*报价信息填写（判断险种分别显示）*/
    @RequestMapping(value = "/detail")
    public String detail(Model model,@RequestParam Map<Object,Object> param){
        String type = (String)param.get("type");
        model.addAttribute("fBody","/policy/");
        model.addAttribute("fName",DateUtil.generatorRadomNumber());
        model.addAttribute("ptTop", GlobalResources.DONOW_PATH);
        if("1".equals(type)){
            return FILL_IN_GZX_OFFER;
        }else if("2".equals(type)){
            return FILL_IN_ZZX_OFFER;
        }else if("3".equals(type)){
            return FILL_IN_TX_OFFER;
        }
        return null;
    }

    /**
     * 团险选项检索
     * @param param
     * @return
     */
    @RequestMapping(value = "/matching")
    public @ResponseBody R matching(@RequestParam Map<String ,Object> param){
        return onLineOfferService.matching(param);
    }

    /**
     * 生成PDF报价方案书
     * @param param
     * @return
     */
    @RequestMapping(value = "/proposal")
    public @ResponseBody R buildOffer(@RequestParam Map<String ,Object> param){
        return onLineOfferService.buildPDF(param);
    }

    /*报价信息填写（判断险种分别显示）*/
    @RequestMapping(value = "/build-proposal")
    public String buildProposal(Model model,@RequestParam Map<String, Object> param){
        onLineOfferService.buildProposal(param);
        model.addAttribute("param",param);
        model.addAttribute("zhtype",param.get("zhtype"));
        model.addAttribute("productVo",param.get("productVo"));
        model.addAttribute("txlist",param.get("txlist"));
        model.addAttribute("ptTop", GlobalResources.DONOW_PATH);
        return FILL_IN_TX_RESULT;
    }

    /*报价信息填写（判断险种分别显示）*/
    @RequestMapping(value = "/open-img")
    public String openImg(Model model,String path){
        model.addAttribute("imgPath","/getResource?path="+path);
        return OPENIMG;
    }

}
