package com.bcxin.ins.weixin.product.service.impl;


import com.bcxin.ins.core.entity.PageResult;
import com.bcxin.ins.weixin.product.dao.WeiXinProductMapper;
import com.bcxin.ins.weixin.product.service.WeiXinProductService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

@Service
@Transactional
public class WeiXinProductServiceImpl implements WeiXinProductService {

    private static Logger log = LoggerFactory.getLogger("");

    @Autowired
    private WeiXinProductMapper weiXinProductMapper;

    /** 补充保障责任表的数据 */
    private void supplyResponsebility(List<Map<Object, Object>> l) {
        List<Map<Object,Object>> l2=  weiXinProductMapper.queryResponseByProPrimaryIDs(l); //一口气查出所有的相关的数据
        for(Map<Object,Object> m : l){
            List<Map<Object,Object>> responsesList = Lists.newArrayList();
            for(Map<Object,Object> m2 : l2){
                //根据ID一口气分别赋值给对应的行记录，完成一对多
                if(String.valueOf(m2.get("pro_primary_id")).equals(String.valueOf(m.get("pro_primary_id")))) responsesList.add(m2);
            }
            m.put("responsesList",responsesList);
        }
    }

    /** 补充保险条款的数据 */
    private void supplyClauses(List<Map<Object, Object>> l) {
        List<Map<Object,Object>> l2=  weiXinProductMapper.queryClausesByProPrimaryIDs(l); //一口气查出所有的相关的数据
        for(Map<Object,Object> m : l){
            List<Map<Object,Object>> clausesList = Lists.newArrayList();
            for(Map<Object,Object> m2 : l2){
                //根据ID一口气分别赋值给对应的行记录，完成一对多
                if(String.valueOf(m2.get("pro_primary_id")).equals(String.valueOf(m.get("pro_primary_id")))) clausesList.add(m2);
            }
            m.put("clausesList",clausesList);
        }
    }

    /**
     * 产品列表分页查询
     */
    public PageResult query(Map<Object, Object> p) {
        List<Map<Object,Object>> l = weiXinProductMapper.query(p);
        if(l.size()>0) supplyResponsebility(l); //如果有记录，就进行补充一多的数据
        return new PageResult(weiXinProductMapper.queryCnt(p),l);
    }

    /**
     * 根据产品ID查询产品详情
     */
    public Map<Object, Object> queryByProductID(Map<Object, Object> p) {
        List<Map<Object,Object>> l = weiXinProductMapper.queryByProductID(p);
        if(l.size()>0){//如果有记录，就进行补充一多的数据
            supplyResponsebility(l);
            supplyClauses(l);
            return l.get(0);
        }
        return null;
    }

    /**
     * 根据产品编码查询产品详情
     */
    public Map<Object, Object> queryByProductCode(Map<Object, Object> p) {
        List<Map<Object,Object>> l = weiXinProductMapper.queryByProductCode(p);
//        if(l.size()>0){//如果有记录，就进行补充一多的数据
//            supplyResponsebility(l);
//            supplyClauses(l);
//            return l.get(0);
//        }
        return l.get(0);
    }


    /**
     * 传入product_codes 的数组对象，通过String转换为json获取列表，然后通过列表获取产品详情
     * 产品编码数组 例如：1，2，3
     * @apiNote  作者  陈堂君
     * @since 创建于 2018/1/22 13:10
     */
    public List<Map<Object, Object>> queryByProductCodes(Map<Object, Object> p) {
        List<Map<Object,Object>> list = Lists.newArrayList();
        for (String product_code : String.valueOf(p.get("product_codes")).split(",")){
            Map param = Maps.newHashMap();
            param.put("product_code",product_code);
            list.add(this.queryByProductCode(param));
        }
        return list;
    }



}
