package com.bcxin.ins.supply;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 保险供应商注解
 * @author hzp
 * @date 2018/06/12
 */
@Target(ElementType.TYPE)//表示只能给类添加该注解
@Retention(RetentionPolicy.RUNTIME)//这个必须要将注解保留在运行时
public @interface SupplyType {

    SupplyTypeEnum type() default SupplyTypeEnum.DEFAULT;

    public enum SupplyTypeEnum{

        //默认
        DEFAULT("DEFAULT","默认无"),
        //太平洋保险
        TAI_BAO("TAI_BAO","太平洋保险"),
        //阳光财险
        YANG_GUANG_CAI("YANG_GUANG_CAI","阳光财险"),
        //都邦财险
        DU_BANG_CAI("DU_BANG_CAI","都邦保险"),
        //太平财保险
        TAI_PING_CAI("TAI_PING_CAI","太平洋财险"),
        //平安寿险
        PING_AN_SHOU("PING_AN_SHOU","平安寿险"),
        //平安财险
        PING_AN_CAI("PING_AN_CAI","平安财险"),
        //泰康财险
        TAI_KANG_CAI("TAI_KANG_CAI","泰康财险"),
        //众安财险
        ZHONG_AN_CAI("ZHONG_AN_CAI","众安财险"),
        //人保财险
        REN_BAO_CAI("REN_BAO_CAI","人保财险"),
        //华泰财险
        HUA_TAI_CAI("HUA_TAI_CAI","华泰财险");

        private String key;
        private String alias;

        private SupplyTypeEnum(String key,String alias){
            this.key=key;
            this.alias=alias;
        }

        public String getKey() {
            return this.key;
        }

        public String getAlias(){
            return this.alias;
        }

        public static String getAlias(String key){
            for(SupplyTypeEnum e : SupplyTypeEnum.values()){
                if(e.getKey().equals(key)){
                    return e.getAlias();
                }
            }
            return "";
        }
    }
}
