package com.bcxin.ins.coninsweb.user.web;


import com.bcxin.ins.service.product.InsProductAPIService;
import com.bcxin.ins.spring.executor.MyAsyncExecutor;
import com.bcxin.ins.utils.ComDeployConfigUtils;
import com.bcxin.ins.service.order.ComRegionAPIService;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.service.ComDeployConfigService;
import com.bcxin.ins.dto.ResultDto;
import com.bcxin.ins.entity.common.ComBlogroll;
import com.bcxin.ins.entity.common.ComPartners;
import com.bcxin.ins.entity.common.ComRegion;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.ConstProp;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 用户信息
 */
@Controller
@RequestMapping(value = "")
public class IndexController extends BaseController {



    @Autowired
    ComDeployConfigService  configService;
    @Autowired
    private ComRegionAPIService regionService;
    @Autowired
    private InsProductAPIService insProductAPIService;

    @Autowired
    private MyAsyncExecutor myAsyncExecutor;
    @RequestMapping( value={""})
    public ModelAndView webIndex1(HttpServletRequest request){

//        ModelAndView view = new ModelAndView("/coninsweb/index/multi_index");
        ModelAndView view = new ModelAndView("/coninsweb/index/multi_index_new");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if(userdetail != null){
            view.addObject(ConstProp.USERDETAIL,userdetail);
        }
       request.getSession().setAttribute("indexType", "");
        setTokenByApi(view);
        return view;
    }



    @RequestMapping( value={"insuranceService"})
    @OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】首页-保险服务")
    public ModelAndView insuranceService(HttpServletRequest request){

//        ModelAndView view = new ModelAndView("/coninsweb/index/multi_index");
        ModelAndView view = new ModelAndView("/coninsweb/synopsis/insuranceService");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if(userdetail != null){
            view.addObject(ConstProp.USERDETAIL,userdetail);
        }
        setTokenByApi(view);

        return view;
    }


    @RequestMapping( value={"policies_1"})
    @OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】关于我们-政策法规")
    public ModelAndView policies_1(HttpServletRequest request){
        ModelAndView view = new ModelAndView("/coninsweb/synopsis/policies/policies_1");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if(userdetail != null){
            view.addObject(ConstProp.USERDETAIL,userdetail);
        }
        setTokenByApi(view);
        return view;
    }

    @RequestMapping( value={"policies_2"})
    @OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】关于我们-政策法规")
    public ModelAndView policies_2(HttpServletRequest request){
        ModelAndView view = new ModelAndView("/coninsweb/synopsis/policies/policies_2");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if(userdetail != null){
            view.addObject(ConstProp.USERDETAIL,userdetail);
        }
        setTokenByApi(view);
        return view;
    }


    @RequestMapping( value={"policies_3"})
    @OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】关于我们-政策法规")
    public ModelAndView policies_3(HttpServletRequest request){
        ModelAndView view = new ModelAndView("/coninsweb/synopsis/policies/policies_3");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if(userdetail != null){
            view.addObject(ConstProp.USERDETAIL,userdetail);
        }
        setTokenByApi(view);
        return view;
    }

    @RequestMapping( value={"policies_4"})
    @OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】关于我们-政策法规")
    public ModelAndView policies_4(HttpServletRequest request){
        ModelAndView view = new ModelAndView("/coninsweb/synopsis/policies/policies_4");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if(userdetail != null){
            view.addObject(ConstProp.USERDETAIL,userdetail);
        }
        setTokenByApi(view);
        return view;
    }



    /**
     * <b>页面底部合作伙伴列表展示 </b>
     */
    @RequestMapping("footer_partners/init")
    public List<ComPartners> footer_partners() {
//        PartnersImpl partners = new PartnersImpl();
//        partners.setActive(Active.Y);
        List<ComPartners> partnersList =null;
                //partnersService.findPartnersList(partners, null);
        return partnersList;
    }



    /**
     * <b>页面底部友情链接列表 </b>

     */
    @RequestMapping("footer_blogroll/init")
    public List<ComBlogroll> footer_blogroll() {
//        BlogrollImpl blogroll = new BlogrollImpl();
//        blogroll.setActive(Active.Y);
//        List<Blogroll> blogrollList = BlogrollService.findBlogrollList(blogroll, null);
//        return blogrollList;
          return null;
    }


    /**
     * <b>加载数据库的配置文件</b>
     */
    @PostConstruct
    public void  loadConfig() {
        ComDeployConfigUtils.setResource();
   }

    /**
     * <b>加载数据库的全国区域代码数据到RegionUtils工具类中</b>
     */
    @PostConstruct
    public void loadComRegion() {
//        List<ComRegion> list =regionService.findRegionListByLevel("","");
        loadRegion();
        myAsyncExecutor.execute(()->{
            insProductAPIService.loadDefaultProducts();
        });
    }

    private void loadRegion() {
        List<ComRegion> list = Lists.newArrayList();
        List<ComRegion> plist =regionService.findRegionListByLevel("1","");
        List<ComRegion> clist =regionService.findRegionListByLevel("2","");
        List<ComRegion> alist =regionService.findRegionListByLevel("3","");
        list.addAll(plist);
        list.addAll(clist);
        list.addAll(alist);
        RegionUtils.regionList=list;
        RegionUtils.p_regionList=plist;
        RegionUtils.c_regionList=clist;
        RegionUtils.a_regionList=alist;
    }


    @RequestMapping("/config/init")
    @ResponseBody
    public ResultDto configInit() {
        ComDeployConfigUtils.setResource();
        loadRegion();
       return new ResultDto("", ConstProp.CODE_SUCCESS,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);//ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR

    }


    @ResponseBody
    @RequestMapping("getIframeUrl")
    public String getIframeUrl(String  type){
        return  GlobalResources.map.get(type);
    }

}
