package com.bcxin.ins.coninsweb.report.controller;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.service.order.InsCommonReportAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.vo.*;
import com.bcxin.ins.vo.report_pac.InsCommonReportVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.util.Date;

/**
 * 报案理赔控制器
 * @author zxf
 *
 */
@Controller
@RequestMapping("/pc/report")
public class InsCommonReportController extends BaseController {

	@Autowired
	private InsCommonReportAPIService insCommonReportAPIService;

	@Autowired
	private PolicyService policyService;

	/**
	 * <b> 报案列表 </b>
	 * @param keyword 报案号/保单号
	 * @param status 状态
	 * @param startDate 报案时间区间
	 * @param endDate 报案时间区间
	 * @author ZXF
	 * @create 2019/11/21 0021 11:22
	 * @version
	 * @注意事项 </b>
	 */
	@LoginRequired(methodParamKey={},requestParamKey={"keyword","status","startDate","endDate"}, redirectUrl = "pc/report/reportList?status={status}&startDate={startDate}&endDate={endDate}&keyword={keyword}")
	@RequestMapping("reportList")
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】我的账户-理赔管理-报案列表")
	public ModelAndView reportList( HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String keyword = request.getParameter("keyword");
		String status = request.getParameter("status");
		String startDate = request.getParameter("startDate");
		String endDate = request.getParameter("endDate");
		if(StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/report/reportList");
		page.setNumPerPage(10);
		view.addObject("reportList",insCommonReportAPIService.selectInsCommonReportVoListByOrderID( keyword, status, startDate, endDate, Long.parseLong(userdetail.getOid()), page));
		view.addObject("status",status);
		view.addObject("startDate",startDate);
		view.addObject("endDate",endDate);
		view.addObject("keyword",keyword);
		setTokenByApi(view);
		return view;
	}

	@LoginRequired(redirectUrl = "redirect:/synopsis/unSession")
	@RequestMapping("getReportListForPage")
	public ModelAndView getPayListForPage( HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String keyword = request.getParameter("keyword");
		String status = request.getParameter("status");
		String startDate = request.getParameter("startDate");
		String endDate = request.getParameter("endDate");
		if(StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/report/reportList_table");
		view.addObject("reportList",insCommonReportAPIService.selectInsCommonReportVoListByOrderID( keyword, status, startDate, endDate, Long.parseLong(userdetail.getOid()), page));
		setTokenByApi(view);
		return view;
	}
	
	/**
	 * <b>查看报案信息详情 </b>
	 * 
	 * @param report_id
	 * @return
	 * @author ZXF 
	 * @date 2017年1月12日 上午10:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@LoginRequired(methodParamKey={"0#report_id"}, redirectUrl = "pc/report/getInsCommonReportByReportId/{report_id}")
	@RequestMapping("getInsCommonReportByReportId/{report_id}")
	public ModelAndView getInsCommonReportByReportId(@PathVariable Long report_id, HttpServletRequest request){
		ModelAndView view = new ModelAndView();
		InsCommonReportVo vo = insCommonReportAPIService.getInsCommonReportVoById(report_id);
		OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(vo.getIns_insurance_slip_id()));
		if("1".equals(vo.getIs_sync())&&(dto.getProduct_code().contains(ConstProp.GZZRX_PAC)||dto.getProduct_code().contains(ConstProp.GZZRX_CA))){
			view.setViewName("/coninsweb/personalCenter/report/xxReportDetail");
		}else{
			view.setViewName("/coninsweb/personalCenter/report/reportDetail");
		}
		view.addObject("report_id",report_id);
		view.addObject("product_code",dto.getProduct_code());
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b> 报案信息录入页面 </b>
	 * @author ZXF
	 * @create 2019/11/29 0029 14:33
	 * @version
	 * @注意事项 </b>
	 */
	@LoginRequired(methodParamKey={"0#order_id"}, redirectUrl = "pc/report/reportInit/{order_id}")
	@RequestMapping("reportInit/{order_id}")
	public ModelAndView reportInit(@PathVariable Long order_id, HttpServletRequest request){
		ModelAndView view = new ModelAndView();
		OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(order_id);
		view.setViewName("/coninsweb/personalCenter/report/addReport");
		view.addObject("policy_no",dto.getExternal_reference());
		view.addObject("order_id",dto.getOid());
		view.addObject("product_code",dto.getProduct_code());
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b> 报案信息录入页面 </b>
	 * @author ZXF
	 * @create 2019/11/29 0029 14:33
	 * @version
	 * @注意事项 </b>
	 */
	@LoginRequired(methodParamKey={"0#report_id"}, redirectUrl = "pc/report/continueReport/{report_id}")
	@RequestMapping("continueReport/{report_id}")
	public ModelAndView continueReport(@PathVariable Long report_id, HttpServletRequest request){
		ModelAndView view = new ModelAndView();
		InsCommonReportVo vo = insCommonReportAPIService.getInsCommonReportVoById(report_id);
		OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(vo.getIns_insurance_slip_id()));
		view.setViewName("/coninsweb/personalCenter/report/addReport");
		view.addObject("report_id",report_id);
		view.addObject("order_id",dto.getOid());
		view.addObject("product_code",dto.getProduct_code());
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b>报案详情</b>
	 */
	@RequestMapping(value="/queryByID/{report_id}")
	public @ResponseBody Object queryByID(@PathVariable Long report_id, Model model){
		return insCommonReportAPIService.getInsCommonReportVoInfoById(report_id,0);
	}

	@RequestMapping(value="/isValidTime")
	public @ResponseBody ResultDto isValidTime(String order_id,String time){
		if(StringUtils.isEmpty(order_id)||StringUtils.isEmpty(time)){
			return new ResultDto(ConstProp.BLANK_CHAR, ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(order_id));
		if(dto == null){
			return new ResultDto(ConstProp.BLANK_CHAR, ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		Date d1 = DateUtil.convertStringToDate(time);//出险日期
		Date d2 = DateUtil.convertStringToDate(dto.getInception_date());//生效日期
		Date d3 = DateUtil.convertStringToDate(dto.getPlanned_end_date());//失效日期
		//出险时间小于生效日期
		boolean b1 = DateUtil.compareDates(d2,d1);
		//出险时间大于当前日期
		boolean b2 = DateUtil.compareDates(d1,new Date());
		//出险时间大于失效日期
		boolean b3 = DateUtil.compareDates(d1,d3);
		if(b1&&b2&&b3){
			return new ResultDto(ConstProp.BLANK_CHAR, ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		return new ResultDto(ConstProp.BLANK_CHAR, ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
	}

	/**
	 * <b> 提交报案信息 </b>
	 * @author ZXF
	 * @create 2019/11/29 0029 14:11
	 * @version
	 * @注意事项 </b>
	 */
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT_ORDER,title ="【请求】报案-提交报案信息")
	@RequestMapping("/saveReport")
	@ResponseBody
	public ResultDto saveReport(InsCommonReportVo vo, HttpServletRequest request) {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(userdetail==null){
			return new ResultDto("登录状态已过期！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		return insCommonReportAPIService.saveInsCommonReport(vo,Long.parseLong(userdetail.getOid()));
	}

	/**
	 * <b> 报案理流程附件补传 </b>
	 * @author ZXF
	 * @create 2019/11/29 0029 14:11
	 * @version
	 * @注意事项 </b>
	 */
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT_ORDER,title ="【请求】报案-附件补传")
	@RequestMapping("/saveUploadFile")
	@ResponseBody
	public ResultDto saveUploadFile(InsCommonReportVo vo) {
		return insCommonReportAPIService.saveUploadFile(vo);
	}

	@RequestMapping("deleteReport")
	@ResponseBody
	public JSONObject deleteReport(long oid){
		JSONObject json = new JSONObject();
		String message="报案申请信息删除失败！";
		String status =ConstProp.CODE_FAILURE;
		if(insCommonReportAPIService.delectInsCommonReportByOid(oid)){
			message="报案申请信息删除成功！";
			status=ConstProp.CODE_SUCCESS;
		}
		json.put("message", message);
		json.put("status", status);
		return json;
	}

	@RequestMapping("sendApi/{report_id}")
	@ResponseBody
	public String sendApi(@PathVariable Long report_id) throws Exception{
		String a = insCommonReportAPIService.draftWord(report_id);
		return a;
	}

}
