package com.bcxin.ins.coninsweb.product.controller;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.entity.user.SysClientUser;
import com.bcxin.ins.service.product.InsProductAPIService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.service.user.ClientUserService;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.util.Constant;
import com.bcxin.ins.util.ErweimaUtil;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.MD5Util;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.awt.image.BufferedImage;
import java.util.Date;
import java.util.List;

/**
 * 建筑产品相关业务逻辑处理（不包括后台产品配置）
 * @author zxf
 *
 */
@Controller
public class InsuranceProductController extends BaseController {

	@Autowired
	private InsProductAPIService insProductAPIService;
	@Autowired
	private ProductService productService;

	@Autowired
	private ClientUserService userService;

	private static String PRODUCT_ID = "product_id";

	/**
	 * <b> 生成二维码 </b>
	 * @author ZXF
	 * @create 2023/10/07 0007 17:12
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/insurance/product/getQRCode")
	@ResponseBody
	public String getQRCode() {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		JSONObject data = new JSONObject();
		try {
			String qrId = "BLB:"+MD5Util.string2MD5(System.currentTimeMillis()+"QR");
			UserSupportUtil.setQrCode(qrId,userdetail.getOid());
			JSONObject json = new JSONObject();
			json.put("qrId",qrId);
			System.out.println(qrId);
			//用于pc前端轮询
			String lx_url = "/insurance/product/isBindThr";
			String ewmBase64 = ErweimaUtil.createErWeiMaToBase64(json.toJSONString());
			data.put("ret",ConstProp.CODE_SUCCESS);
			data.put("obj",lx_url+"||"+GlobalResources.ESTAND_XCX_QR_CODE+"||"+ewmBase64);
		} catch (Exception e) {
			data.put("ret",ConstProp.CODE_FAILURE);
			data.put("msg",e.getMessage());
		}
		return data.toJSONString();
	}

	/**
	 * <b> 确认用户是否属于E站风评系统 </b>
	 * @author ZXF
	 * @create 2024/01/29 0029 10:41
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/insurance/product/isBindThr")
	@ResponseBody
	public String isBindThr() {
		JSONObject data = new JSONObject();
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(userdetail != null && StringUtils.isNotEmpty(userdetail.getWeb_type())&&userdetail.getWeb_type().contains(ConstProp.ESTAND_PSS)){
			data.put("ret",ConstProp.CODE_SUCCESS);
		}else{
			SysClientUser user = userService.selectById(Long.parseLong(userdetail.getOid()));
			if(user != null && StringUtils.isNotEmpty(user.getWeb_type())&&user.getWeb_type().contains(ConstProp.ESTAND_PSS)){
				userdetail.setWeb_type(user.getWeb_type());
				userdetail.setWeb_id(user.getWeb_id());
				userdetail.setWeb_user_name(user.getWeb_user_name());
//				userdetail.setTelephone(user.getTelephone());
				UserSupportUtil.setSessionUser(userdetail);
				data.put("ret",ConstProp.CODE_SUCCESS);
			}else{
				data.put("ret",ConstProp.CODE_FAILURE);
			}
		}
		return data.toJSONString();
	}

	/**
	 * <b> E站风评扫码后携带用户信息请求绑定用户 </b>
	 * @author ZXF
	 * @create 2024/01/29 0029 10:07
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/insurance/product/bindEStandUser/{qrId}")
	@ResponseBody
	public String bindEStandUser(@PathVariable String qrId, HttpServletRequest reqeust) {
		String webId = reqeust.getParameter("id");
		String webUsername = reqeust.getParameter("username");
		String phone = reqeust.getParameter("phone");
//		String plat = reqeust.getParameter("plat");

		String userId = UserSupportUtil.getQrCode(qrId);
		String webType;
		if(GlobalResources.IS_TEST_ENVI){
			webType = "ESTAND-PSS-TEST";
		}else{
			webType = "ESTAND-PSS";
		}
		if(userService.bindThrUser(webId, webUsername, phone, userId, webType)){
			return "1";
		}
		return "0";
	}

	/**
	 * <b>前台页面产品详情(iframe包裹产品详情)（InsuranceProductController.productInfo） </b>
	 * 大部分访问产品都经过该方法访问产品详情
	 * @param request
	 * @param oid
	 * @return
	 * @author ZXF 
	 * @date 2016年12月21日 下午1:39:31
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/insurance/product/productInfo/{oid}")
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT_PRODUCT,title ="【视图】首页-产品详情")
	public ModelAndView productInfo(HttpServletRequest request, @PathVariable long oid, @RequestParam(value = "recommendCode", required = false) String recommendCode) {
		ModelAndView view = new ModelAndView();
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		ProductVo pd = productService.getProduct(oid);
		if(pd == null){
			return null;
		}
        if(StringUtils.isNotEmpty(pd.getOid())){
			try {
				view.addObject(ConstProp.SHAREPATH,productService.setSharePath(oid,userdetail));
			}catch (Exception e){
				e.printStackTrace();
			}
        }else{
        	return null;
		}
		if(StringUtils.isEmpty(pd.getProduct_code()) ? false : ConstProp.XYX_DQCK.equals(pd.getProduct_code())){
			view.setViewName("/coninsweb/insurance/customs/product/productInfo_qy");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : ConstProp.XYX_XWCK.equals(pd.getProduct_code())){
			view.setViewName("/coninsweb/insurance/customs/product/productInfo_mi");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : ConstProp.BZX_TB_GCTB.equals(pd.getProduct_code())){
			view.setViewName("/coninsweb/insurance/build/product/build_tb_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : ConstProp.BZX_YG_GCTB.equals(pd.getProduct_code())){
			view.setViewName("/coninsweb/insurance/build/product/build_yg_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : ConstProp.BZX_DB_GCTB.equals(pd.getProduct_code())){
			view.setViewName("/coninsweb/insurance/build/product/build_db_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : ConstProp.BZX_GCLY.equals(pd.getProduct_code())){
			view.setViewName("/coninsweb/insurance/build/product/productInfo_ly");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : ConstProp.BZX_SSBQ.equals(pd.getProduct_code())){
			view.setViewName("/coninsweb/insurance/lawsuit/product/productInfo");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().indexOf(ConstProp.TYX)!=-1){
			if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.TYX_PAS)){
				view.setViewName("/coninsweb/insurance/tyx/product/gmr_pn_product_info");
			}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.TYX_PAC)){
				view.setViewName("/coninsweb/insurance/tyx/product/gmr_pnc_product_info");
			}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.TYX_TK)){
				view.setViewName("/coninsweb/insurance/tyx/product/gmr_tk_product_info");
			}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.TYX_RB)){
				view.setViewName("/coninsweb/insurance/tyx/product/gmr_rb_product_info");
			}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.TYX_CA)){
				view.setViewName("/coninsweb/insurance/tyx/product/gmr_ca_product_info");
			}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.TYX_QH)){
				view.setViewName("/coninsweb/insurance/tyx/product/gmr_qh_product_info");
			}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.TYX_HT)){
				view.setViewName("/coninsweb/insurance/tyx/product/gmr_ht_product_info");
			}
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().indexOf(ConstProp.GYX_TB)!=-1){
			view.setViewName("/coninsweb/insurance/gyx/product/gyx_tb_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().indexOf(ConstProp.GYX_CA)!=-1){
			view.setViewName("/coninsweb/insurance/gyx/product/gyx_ca_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().indexOf(ConstProp.GZX_HT)!=-1){
			view.setViewName("/coninsweb/insurance/gzx/product/gzx_ht_product_info");
//			view.setViewName("/coninsweb/insurance/afr/product/gzx_ht_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().indexOf(ConstProp.GZX_PAC)!=-1){
			view.setViewName("/coninsweb/insurance/gzx/product/gzx_pac_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().indexOf(ConstProp.GZX_CA)!=-1){
			view.setViewName("/coninsweb/insurance/gzx/product/gzx_ca_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().indexOf(ConstProp.ZZX)!=-1){
			if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.ZZX_ZA)){
				view.setViewName("/coninsweb/insurance/zzx/product/zzx_za_product_info");
			}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.ZZX_PAC)){
				view.setViewName("/coninsweb/insurance/zzx/product/zzx_pac_product_info");
			}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.ZZX_YA)){
				view.setViewName("/coninsweb/insurance/zzx/product/zzx_ya_product_info");
			}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.ZZX_CA)){
				view.setViewName("/coninsweb/insurance/zzx/product/zzx_ca_product_info");
			}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.ZZX_HT)){
				view.setViewName("/coninsweb/insurance/zzx/product/zzx_ht_product_info");
			}
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().indexOf(ConstProp.GZZRX)!=-1){
			if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GZZRX_QH)){
				view.setViewName("/coninsweb/insurance/gzzrx/product/gzzrx_qh_product_info");
			}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GZZRX_RB)){
				view.setViewName("/coninsweb/insurance/gzzrx/product/gzzrx_rb_product_info");
			}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GZZRX_ZH)){
				view.setViewName("/coninsweb/insurance/gzzrx/product/gzzrx_zh_product_info");
			}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GZZRX_PAC)){
				view.setViewName("/coninsweb/insurance/gzzrx/product/gzzrx_pac_product_info");
			}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GZZRX_XZH)){
				view.setViewName("/coninsweb/insurance/gzzrx/product/gzzrx_xzh_product_info");
			}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GZZRX_TB)){
				view.setViewName("/coninsweb/insurance/gzzrx/product/gzzrx_tb_product_info");
			}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GZZRX_CA)){
				if(pd.getProduct_code().contains(ConstProp.GZZRX_CA_DQ)){
					view.setViewName("/coninsweb/insurance/gzzrx/product/gzzrx_ca_dq_product_info");
				}else{
					view.setViewName("/coninsweb/insurance/gzzrx/product/gzzrx_ca_product_info");
				}
			}
		}
		if(StringUtils.isNotEmpty(recommendCode)){
			UserSupportUtil.setRecommendCode(recommendCode);
		}
		UserSupportUtil.setCustomSession("goToUrl", GlobalResources.WEB_PRO_URL+"/insurance/product/productInfo/"+oid);
		view.addObject(ConstProp.PRODUCTDTO, pd);
		view.addObject(PRODUCT_ID, pd.getOid());
		view.addObject(ConstProp.USERDETAIL,userdetail);
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b>前台页面产品详情不包含iframe </b>
	 * 投保流程中面包屑引用的访问产品地址都经过该方法，因为在投保流程大部分页面（不包含投标，诉讼，履约，小微）都在iframe中替换内容展示
	 * @param oid
	 * @return
	 * @author ZXF
	 * @date 2016年12月21日 下午1:40:41
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/insurance/product/product-info-no-iframe/{oid}")
	public ModelAndView productInfoByNoIframe(@PathVariable long oid) {
		ModelAndView view = new ModelAndView();
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		ProductVo pd = productService.getProduct(oid);
		if(StringUtils.isNotEmpty(pd.getOid())){
			view.addObject(ConstProp.SHAREPATH,productService.setSharePath(oid,userdetail));
		}else{
			return null;
		}
		if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GZX_PAC)){
			view.setViewName("/coninsweb/api/gzx/product/gzx_pac_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.TYX_PAS)){
			view.setViewName("/coninsweb/api/gmr/product/gmr_pn_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.TYX_PAC)){
			view.setViewName("/coninsweb/api/gmr/product/gmr_pnc_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.TYX_TK)){
			view.setViewName("/coninsweb/api/gmr/product/gmr_tk_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.TYX_RB)){
			view.setViewName("/coninsweb/api/gmr/product/gmr_rb_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.TYX_CA)){
			view.setViewName("/coninsweb/api/gmr/product/gmr_ca_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.TYX_QH)){
			view.setViewName("/coninsweb/api/gmr/product/gmr_qh_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.TYX_HT)){
			view.setViewName("/coninsweb/api/gmr/product/gmr_ht_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GZZRX_RB)){
			view.setViewName("/coninsweb/api/gzzrx/product/gzzrx_rb_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GZZRX_ZH)){
			view.setViewName("/coninsweb/api/gzzrx/product/gzzrx_zh_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GZZRX_PAC)){
			view.setViewName("/coninsweb/api/gzzrx/product/gzzrx_pac_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GZZRX_XZH)){
			view.setViewName("/coninsweb/api/gzzrx/product/gzzrx_xzh_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GZZRX_TB)){
			view.setViewName("/coninsweb/api/gzzrx/product/gzzrx_tb_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GZZRX_CA)){
			if(pd.getProduct_code().contains(ConstProp.GZZRX_CA_DQ)){
				view.setViewName("/coninsweb/api/gzzrx/product/gzzrx_ca_dq_product_info");
			}else{
				view.setViewName("/coninsweb/api/gzzrx/product/gzzrx_ca_product_info");
			}
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.ZZX_ZA)){
			view.setViewName("/coninsweb/api/lote/product/zzx_za_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.ZZX_PAC)){
			view.setViewName("/coninsweb/api/lote/product/zzx_pac_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.ZZX_YA)){
			view.setViewName("/coninsweb/api/lote/product/zzx_ya_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.ZZX_HT)){
			view.setViewName("/coninsweb/api/lote/product/zzx_ht_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : ConstProp.BZX_TB_GCTB.equals(pd.getProduct_code())){
			view.setViewName("/coninsweb/insurance/build/product/build_tb_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : ConstProp.BZX_YG_GCTB.equals(pd.getProduct_code())){
			view.setViewName("/coninsweb/insurance/build/product/build_yg_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : ConstProp.BZX_DB_GCTB.equals(pd.getProduct_code())){
			view.setViewName("/coninsweb/insurance/build/product/build_db_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : ConstProp.BZX_GCLY.equals(pd.getProduct_code())){
			view.setViewName("/coninsweb/insurance/build/product/productInfo_ly");
		}
		view.addObject(ConstProp.PRODUCTDTO, pd);
		view.addObject(ConstProp.USERDETAIL,userdetail);
		setTokenByApi(view);

		return view;
	}

	@RequestMapping("/insurance/product/sharePath/{oid}")
	public @ResponseBody
	String productInfo(@PathVariable long oid) {
		JSONObject data = new JSONObject();
		data.put("ret",ConstProp.CODE_SUCCESS);
		data.put("obj",productService.setSharePath(oid, UserSupportUtil.getSessionUser()));
		data.put("msg","");
		return data.toJSONString();
	}

	@RequestMapping("/insurance/product/toLogin/{oid}")
	public ModelAndView productInfo(HttpServletRequest request, @PathVariable String oid) {
		return new ModelAndView(Constant.LOGIN_URL_COM);
	}

	/**
	 * <b> 公责险-外嵌-产品列表 </b>
	 * @author ZXF
	 * @create 2018/07/26 0026 17:19
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/insurance/product/gzx-product-all")
	public ModelAndView gzxProductAll() {
		ModelAndView view = new ModelAndView("/coninsweb/api/product/gzx_product_all");
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String[] codes = new String[]{ConstProp.GZX_HT,ConstProp.ZZX_HT,ConstProp.TYX_HT,ConstProp.TYX_QH};
		view.addObject(ConstProp.LISTVO, findProByCodes(codes));
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b> 短期团体意外险-外嵌-产品列表 </b>
	 * @author ZXF
	 * @create 2018/07/26 0026 17:19
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/insurance/product/dq-product-all")
	public ModelAndView dqProductAll() {
		ModelAndView view = new ModelAndView("/coninsweb/api/product/dq_product_all");
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String[] codes = new String[]{ConstProp.TYX_HT};
		view.addObject(ConstProp.LISTVO, findProByCodes(codes));
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b> 团险-外嵌-产品列表（含：团意险，雇主责任险） </b>
	 * @author ZXF
	 * @create 2018/07/26 0026 17:19
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/insurance/product/tx-product-all")
	public ModelAndView txProductAll() {
		ModelAndView view = new ModelAndView("/coninsweb/api/product/tx_product_all");
//		JedisUtils.batchDel(ConstProp.REDIS_HEAD_PRODUCT_PCO);
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String province = "110000";
		if(userdetail != null){
			String key = ConstProp.ADDRESS_HEAD+userdetail.getOid();
			province = JedisUtils.get(key);
		}
		String[] codes;
		String pCodes = GlobalResources.map.get("SAAS_PRO_SORT_"+province);
		if(StringUtils.isNotEmpty(province)&&StringUtils.isNotEmpty(pCodes)){
			codes = pCodes.split(",");
		}else{
			pCodes = GlobalResources.map.get("SAAS_PRO_SORT_DEFAULT");
			if(StringUtils.isNotEmpty(pCodes)){
				codes = pCodes.split(",");
			}else{
				codes = new String[]{ConstProp.GZZRX_RB,ConstProp.TYX_RB,ConstProp.TYX_PAS,ConstProp.TYX_PAC,ConstProp.TYX_TK,ConstProp.GZZRX_ZH,ConstProp.GZZRX_CA,ConstProp.GZZRX_XZH};
			}
		}

		view.addObject(ConstProp.LISTVO, findProByCodes(codes));
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b> 根据标识数组遍历查询产品信息并汇总到list </b>
	 * @author ZXF
	 * @create 2019/04/22 0022 16:06
	 * @version
	 * @注意事项 </b>
	 */
	private List<ProductVo> findProByCodes(String[] codeArr){
		List<ProductVo> list = Lists.newArrayList();
		List<ProductVo> listVo = null;
		for(String code : codeArr){
			listVo = productService.getProductsByOnLine(code);
			if(listVo!=null){
				list.addAll(listVo);
			}
		}
		return list;
	}

	/**
	 *
	 * <b>跳转到投保界面 iframe页面，再通过iframe中的加载地址加载页面</b>
	 *
	 * @param oid
	 * @return
	 * @author ZXF
	 * @date 2016年12月14日 下午5:22:29
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/insurance/policy_init_iframe/{oid}")
	@LoginRequired(methodParamKey={"1#oid"}, redirectUrl = "insurance/policy_init_iframe/{oid}")
	public ModelAndView policyInitIframe(@PathVariable long oid) {
		ModelAndView view = new ModelAndView("/coninsweb/api/order/order_init");
		ProductVo pd = productService.getProduct(oid);
		String loadUrl = ConstProp.BLANK_CHAR;
		if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().indexOf(ConstProp.GYX)!=-1){
			loadUrl = "/api/gyx/policyInit/"+oid;
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().indexOf(ConstProp.TYX)!=-1){
			loadUrl = "/api/gmr/policyInit/"+oid;
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().indexOf(ConstProp.GZX_PAC)!=-1){
			loadUrl = "/api/gzx/policyInit/"+oid;
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().indexOf(ConstProp.ZZX)!=-1){
			loadUrl = "/api/lote/policyInit/"+oid;
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().indexOf(ConstProp.GZZRX)!=-1){
			loadUrl = "/api/gzzrx/policyInit/"+oid;
		}
		view.addObject("loadUrl", loadUrl);
		setTokenByApi(view);
		return view;
	}

}
