package com.bcxin.ins.coninsweb.preservation.controller;

import com.bcxin.ins.dto.Result;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.preservation.InsPreservationDetailAPIService;
import com.bcxin.ins.service.preservation.InsPreservationRecordAPIService;
import com.bcxin.ins.service.preservation.InsPreservationResultSetAPIService;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.spring.executor.MyAsyncExecutor;
import com.bcxin.ins.spring.listener.SessionContext;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.IpAddress;
import com.bcxin.ins.vo.*;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;

/**
 * 自用保全申请单控制器
 * @author zxf
 *
 */
@Controller
@RequestMapping("/pc/preservation/resultSet")
public class InsPreservationResultSetController extends BaseController {

	@Autowired
	private InsPreservationResultSetAPIService insPreservationResultSetAPIService;
	@Autowired
	private InsPreservationDetailAPIService insPreservationDetailAPIService;
	@Autowired
	private InsPreservationRecordAPIService insPreservationRecordAPIService;
	@Autowired
	private PolicyService policyService;

	@Autowired
	private MyAsyncExecutor myAsyncExecutor;

	private static String RESULTSETLIST = "resultSetList";
	private static String STATUS = "status";
	private static String START_TIME = "start_time";
	private static String END_TIME = "end_time";
	private static String KEYWORD = "keyword";
	private static String PRESERVATIONID = "preservationId";
	private static String POLICYID = "policyId";
	private static String NOWDATE = "nowDate";
	private static String IPRSVOLIST = "iprsVoList";
	private static String ORDERVO = "orderVo";
	private static String MIN = "min";
	private static String MAX = "max";


	/**
	 * 有效人员列表
	 * <b>从我的订单列表对已承保订单做保全，点击保全的按钮访问该控制器，获取人员列表，初始时加载订单的被保险人列表
	 * 如果已经做过保全且已审核就直接取最后一个有效保全申请单中获取有效人员结果集</b>
	 *
	 * @param request 关键字
	 * @param page
	 * @return
	 * @author ZXF
	 * @date 2016年12月29日 下午5:54:59
	 * @注意事项 </b>
	 * <b>
	 */
	@LoginRequired(methodParamKey={"0#policyId"},requestParamKey={"keyword"}, redirectUrl = "pc/preservation/resultSet/resultSetList?policyId={policyId}&keyword={keyword}")
	@RequestMapping("resultSetList")
	public ModelAndView resultSetList(Long policyId, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String keyword = request.getParameter("keyword");
		if(StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/resultSet/resultSetList");
		page.setNumPerPage(10);
		OrderFormVo orderVo = policyService.accordingToOrderIDToGetPolicyDto(policyId);
		if(userdetail.getOid().equals(orderVo.getUser_oid())){
			view.addObject(RESULTSETLIST,insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(page,policyId,keyword,ConstProp.DIGIT_ZERO,ConstProp.BLANK_CHAR,ConstProp.BLANK_CHAR));
			view.addObject(ORDERVO,orderVo);
		}
		view.addObject(KEYWORD,keyword);
		setTokenByApi(view);
		return view;
	}

	@LoginRequired(redirectUrl = "redirect:/synopsis/unSession")
	@RequestMapping("getResultSetListForPage")
	public ModelAndView ListForPage(Long policyId, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String keyword = request.getParameter("keyword");
		if(StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/resultSet/resultSetList_table");
		OrderFormVo orderVo = policyService.accordingToOrderIDToGetPolicyDto(policyId);
		if(userdetail.getOid().equals(orderVo.getUser_oid())){
			view.addObject(RESULTSETLIST,insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(page,policyId,keyword,ConstProp.DIGIT_ZERO,ConstProp.BLANK_CHAR,ConstProp.BLANK_CHAR));
		}
		setTokenByApi(view);
		return view;
	}

	/**
	 * 失效人员列表
	 * <b>从我的订单列表对已承保订单做保全，点击保全的按钮访问该控制器，获取人员列表，初始时加载订单的被保险人列表
	 * 如果已经做过保全且已审核就直接取最后一个有效保全申请单中获取有效人员结果集</b>
	 *
	 * @param start_time 批改时间开始
	 * @param end_time 批改时间截止
	 * @param request 关键字
	 * @param page
	 * @return
	 * @author ZXF
	 * @date 2016年12月29日 下午5:54:59
	 * @注意事项 </b>
	 * <b>
	 */
	@LoginRequired(methodParamKey={"0#policyId"},requestParamKey={"keyword"}, redirectUrl = "pc/preservation/resultSet/resultSetList?policyId={policyId}&keyword={keyword}")
	@RequestMapping("noResultSetList")
	public ModelAndView noResultSetList(Long policyId, String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String keyword = request.getParameter("keyword");

		if(StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/resultSet/noResultSetList");
		page.setNumPerPage(10);
		String et = ConstProp.BLANK_CHAR;
		if(StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		OrderFormVo orderVo = policyService.accordingToOrderIDToGetPolicyDto(policyId);
		if(userdetail.getOid().equals(orderVo.getUser_oid())){
			view.addObject(RESULTSETLIST,insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(page,policyId,keyword,ConstProp.DIGIT_ONE,start_time,et));
			view.addObject(ORDERVO,orderVo);
		}
		view.addObject(START_TIME,start_time);
		view.addObject(END_TIME,end_time);
		view.addObject(KEYWORD,keyword);
		setTokenByApi(view);
		return view;
	}

	@LoginRequired(redirectUrl = "redirect:/synopsis/unSession")
	@RequestMapping("getNoResultSetListForPage")
	public ModelAndView getNoResultSetListForPage(Long policyId, String start_time, String end_time, String keyword, DwzPage page){
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String et = ConstProp.BLANK_CHAR;
		if(StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/resultSet/noResultSetList_table");
		OrderFormVo orderVo = policyService.accordingToOrderIDToGetPolicyDto(policyId);
		if(userdetail.getOid().equals(orderVo.getUser_oid())){
			view.addObject(RESULTSETLIST,insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(page,policyId,keyword,ConstProp.DIGIT_ONE,start_time,et));
		}
		setTokenByApi(view);
		return view;
	}

	/**
	 * 查询保障服务内容
	 * @param policyId 订单id
	 * @return
	 */
	@LoginRequired(redirectUrl = "redirect:/synopsis/unSession")
	@RequestMapping("schemeDetail")
	public ModelAndView schemeDetail(Long policyId){
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/resultSet/scheme_detail");
		OrderFormVo orderVo = policyService.accordingToOrderIDToGetPolicyDto(policyId);
		view.addObject(ORDERVO,orderVo);
		setTokenByApi(view);
		return view;
	}

	/**
	 * 跳转到增员界面
	 * @param policyId 订单id
	 * @param preservationId 保全申请单id（如果已存在id，且状态为待提交说明该单为暂存单页面需要可修改）
	 * @return
	 */
	@LoginRequired(redirectUrl = "redirect:/synopsis/unSession")
	@RequestMapping("add_preservation_view")
	public ModelAndView add_preservation_view(Long policyId,Long preservationId){
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/resultSet/add_preservation_list");
		if(preservationId != null){
			view.addObject(IPRSVOLIST,insPreservationRecordAPIService.findInsPreservationRecordVoById(preservationId));
		}
		String resultDate = insPreservationRecordAPIService.getEffectiveByPolicyId(policyId);
		OrderFormVo orderVo = policyService.accordingToOrderIDToGetPolicyDto(policyId);
		view.addObject(ORDERVO,orderVo);
		view.addObject(MIN,resultDate.split(",")[0]);
		view.addObject(MAX,resultDate.split(",")[1]);
		view.addObject(POLICYID,policyId);
		view.addObject(PRESERVATIONID,preservationId);
		view.addObject(NOWDATE, DateUtil.getCurrentDateTime());
		setTokenByApi(view);
		return view;
	}

	/**
	 * 人员导入跳转到增员界面
	 * @param preservationId 保全申请单id（如果已存在id，且状态为待提交说明该单为暂存单页面需要可修改）
	 * @return
	 */
	@LoginRequired(redirectUrl = "redirect:/synopsis/unSession")
	@RequestMapping("add_upload_view")
	public ModelAndView add_upload_view(Long preservationId,HttpServletRequest request){
		String product_code = request.getParameter("product_code");
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/resultSet/add_upload_list");
		if(preservationId != null){
			view.addObject(IPRSVOLIST,insPreservationRecordAPIService.findInsPreservationRecordVoById(preservationId));
		}
		view.addObject("product_code",product_code);
		view.addObject(IPRSVOLIST,getValueSession());
		setTokenByApi(view);
		return view;
	}

	/**
	 * 增员业务做校验及数据更新
	 * @param vo 保全申请单辅助类，其中包含保全人员信息列表
	 * @param sign 标识数据是否暂存，0直接提交，1暂存
	 * @return
	 */
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT_RECORD,title ="【请求】个人中心-增员")
	@LoginRequired
	@RequestMapping("add_preservation_service")
	@ResponseBody
	public ResultDto add_preservation_service(InsPreservationRecordVo vo,String sign) {
		stopSubmitAgain("PC_ADD_BQ:"+getToken(),3);
		if(!stopSubmitAgain("PC_ADD_BQ:"+getToken(),1)){
			return new ResultDto("业务处理中，请勿重复提交！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		if(ConstProp.DIGIT_ONE.equals(sign)){
			List<InsPreservationDetailVo> ipdVoSortList = new ArrayList<InsPreservationDetailVo>();
			for(InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()){
				if(StringUtils.isEmpty(ipdVo.getName())
						&&StringUtils.isEmpty(ipdVo.getBirthday())
						&&StringUtils.isEmpty(ipdVo.getCareer())
						&&StringUtils.isEmpty(ipdVo.getId_card())
						&&StringUtils.isEmpty(ipdVo.getId_type())
						&&StringUtils.isEmpty(ipdVo.getSex())){
					continue;
				}
				ipdVoSortList.add(ipdVo);
			}
			vo.setInsPreservationDetailVoList(ipdVoSortList);
			vo.resetName();
			String result = insPreservationDetailAPIService.batchDetailSortAndValidator(vo);
			if(ConstProp.CODE_FAILURE.equals(result.split(ConstProp.POUND_SIGN)[0])){
				stopSubmitAgain("PC_ADD_BQ:"+getToken(),3);
				return new ResultDto(result.split(ConstProp.POUND_SIGN)[1], ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}else{
			List<InsPreservationDetailVo> ipdVoSortList = new ArrayList<InsPreservationDetailVo>();
			for(InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()){
				if(StringUtils.isNotEmpty(ipdVo.getName())
						||StringUtils.isNotEmpty(ipdVo.getId_card())
						||StringUtils.isNotEmpty(ipdVo.getTel())
						||StringUtils.isNotEmpty(ipdVo.getBirthday())){
					ipdVoSortList.add(ipdVo);
				}
			}
			if(ipdVoSortList.size() == 0){
				stopSubmitAgain("PC_ADD_BQ:"+getToken(),3);
				return new ResultDto("暂存人员信息不能为空！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			vo.setInsPreservationDetailVoList(ipdVoSortList);
		}
		//过滤重复人员投保
		String str = insPreservationDetailAPIService.isDuplicateIdCardNoToPreservationDetail(vo.getIns_insurance_slip_id(),vo.getInsPreservationDetailVoList());
		if(ConstProp.CODE_FAILURE.equals(str.split(ConstProp.POUND_SIGN)[0])){
			stopSubmitAgain("PC_ADD_BQ:"+getToken(),3);
			return new ResultDto(str.split(ConstProp.POUND_SIGN)[1], ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		Map<String, String> map = insPreservationRecordAPIService.recordRestToRB(vo, sign);
		if(map != null){
			if("300".equals(map.get("ret"))){
				stopSubmitAgain("PC_ADD_BQ:"+getToken(),3);
				if(StringUtils.isNotEmpty(map.get("msg"))&&map.get("msg").contains("系统响应超时，请重试")){
					insPreservationRecordAPIService.recordRestPAC(vo);
					myAsyncExecutor.execute(()->{
						//前海批改超时补偿
						insPreservationRecordAPIService.addFindPDTask(vo.getOid());
					});
				}
				return new ResultDto(map.get("msg"), ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			if(StringUtils.isNotEmpty(map.get("batchApplyNumber"))){
				vo.setRevise_serial_number(map.get("batchApplyNumber"));
			}
		}
		//数据更新创建保全申请单
		if(insPreservationRecordAPIService.createInsPreservationRecord(Integer.parseInt(sign),vo,vo.getInsPreservationDetailVoList())){
			if(!ConstProp.DIGIT_ONE.equals(sign)){
				stopSubmitAgain("PC_ADD_BQ:"+getToken(),2);
				//暂存
				return new ResultDto("保存成功，请进入“批改申请记录”中查看保存的批改申请！", ConstProp.CODE_SUCCESS,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			insPreservationRecordAPIService.updateRecordStatus(vo.getOid(), map);
			String m = "批改信息成功提交审核！";
			if(map != null && !map.containsKey("isPendingApproval")){
				m = "批改信息已通过审核！";
			}
			stopSubmitAgain("PC_ADD_BQ:"+getToken(),2);

			String payurl = map.get("payurl");
//			if(org.apache.commons.lang.StringUtils.isNotEmpty(payurl)){
//				payurl = GlobalResources.WEB_URL+"/synopsis/proxyCashierPage/"+ Base64.getEncoder().encodeToString(payurl.getBytes());
//			}
			return new ResultDto(m, ConstProp.CODE_SUCCESS, vo.getOid(), ConstProp.BLANK_CHAR, payurl);
		}else{
			stopSubmitAgain("PC_ADD_BQ:"+getToken(),3);
			return new ResultDto("数据更新失败！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	/**
	 * <b> 根据批单ID查询最后一个批单号 </b>
	 * @author ZXF
	 * @create 2023/09/18 0018 15:23
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/last3Record/{redId}/{reNo}")
	public String last3Record(@PathVariable String redId,@PathVariable String reNo){
		return insPreservationRecordAPIService.last3Record(redId,reNo);
	}

	/**
	 * 跳转到减员或者替换界面
	 * @param policyId 订单id
	 * @param preservationId 保全申请单id（如果已存在id，且状态为待提交说明该单为暂存单页面需要可修改）
	 * @param check_some 页面勾选的条目数组字符串（格式：123123;ROLE#345345;THIS）
	 * @param operate 跳转减员或替换界面的标识
	 * @return
	 */
	@LoginRequired(redirectUrl = "redirect:/synopsis/unSession")
	@RequestMapping("minus_or_replace_view")
	public ModelAndView minus_preservation_view(Long policyId,Long preservationId,String check_some,String operate){
		ModelAndView view = new ModelAndView();
		if("minus".equals(operate)){
			view.setViewName("/coninsweb/personalCenter/preservation/resultSet/minus_preservation_list");
		}else if("replace".equals(operate)){
			view.setViewName("/coninsweb/personalCenter/preservation/resultSet/replace_preservation_list");
		}
		InsPreservationRecordVo iprVo = null;
		if(preservationId != null){
			iprVo = insPreservationRecordAPIService.findInsPreservationRecordVoById(preservationId);
		}else{
			iprVo = new InsPreservationRecordVo();
			iprVo.setIns_insurance_slip_id(String.valueOf(policyId));
			List<InsPreservationResultSetVo> iprsVoList = new ArrayList<InsPreservationResultSetVo>();
			InsPreservationResultSetVo iprsVo = null;
			String[] arr = check_some.split(ConstProp.POUND_SIGN);
			for(String str : arr){
				if(StringUtils.isNotEmpty(str)){
					String oid = str.split(ConstProp.SEMICOLON)[0],sign = str.split(ConstProp.SEMICOLON)[1];
					iprsVo = insPreservationResultSetAPIService.getInsPreservationResultSetVoByOidAndSign(oid,sign);
					iprsVoList.add(iprsVo);
					iprsVo = null;
				}
			}
			iprVo.setInsPreservationResultSetVoList(iprsVoList);
		}
		OrderFormVo orderVo = policyService.accordingToOrderIDToGetPolicyDto(policyId);
		view.addObject(ORDERVO,orderVo);
		String resultDate = insPreservationRecordAPIService.getEffectiveByPolicyId(policyId);
		view.addObject(MIN,resultDate.split(",")[0]);
		view.addObject(MAX,resultDate.split(",")[1]);
		view.addObject(POLICYID,policyId);
		view.addObject("check_some",check_some);
		view.addObject("preservationVo",iprVo);
		view.addObject(NOWDATE, DateUtil.getCurrentDateTime());
		setTokenByApi(view);
		return view;
	}

	/**
	 * 人员导入跳转到替换界面
	 * @return
	 */
	@LoginRequired(redirectUrl = "redirect:/synopsis/unSession")
	@RequestMapping("replace_upload_view")
	public ModelAndView replace_upload_view(HttpServletRequest request){
		String ins_insurance_slip_id = request.getParameter("ins_insurance_slip_id");
		String replace_check_some = request.getParameter("replace_check_some");
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/resultSet/replace_upload_list");
		List<InsPreservationResultSetVo> iprsVoList = new ArrayList<InsPreservationResultSetVo>();
		InsPreservationResultSetVo iprsVo;
		String[] arr = replace_check_some.split(ConstProp.POUND_SIGN);
		List<InsPreservationResultSetVo> setList = getValueSession();
		for(String str : arr){
			if(StringUtils.isNotEmpty(str)){
				String oid = str.split(ConstProp.SEMICOLON)[0],sign = str.split(ConstProp.SEMICOLON)[1];
				iprsVo = insPreservationResultSetAPIService.getInsPreservationResultSetVoByOidAndSign(oid,sign);
				for(InsPreservationResultSetVo v : setList){
					if(StringUtils.isNotEmpty(iprsVo.getCareer())&&iprsVo.getCareer().equals(v.getCareer())){
						iprsVo.setOpposeVo(v);
						setList.remove(v);
						break;
					}
				}
				iprsVoList.add(iprsVo);
				iprsVo = null;
			}
		}
		OrderFormVo orderVo = policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(ins_insurance_slip_id));
		view.addObject(ORDERVO,orderVo);
		view.addObject(IPRSVOLIST,iprsVoList);
		setTokenByApi(view);
		return view;
	}

	/**
	 * 人员导入跳转到替换界面
	 * @return
	 */
	@LoginRequired(redirectUrl = "redirect:/synopsis/unSession")
	@RequestMapping("minus_upload_view")
	public ModelAndView minus_upload_view(HttpServletRequest request){
		String ins_insurance_slip_id = request.getParameter("ins_insurance_slip_id");
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/resultSet/minus_upload_list");
		List<InsPreservationResultSetVo> setList = getValueSession();
		OrderFormVo orderVo = policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(ins_insurance_slip_id));
		view.addObject(ORDERVO,orderVo);
		view.addObject(IPRSVOLIST,setList);
		setTokenByApi(view);
		return view;
	}

	/**
	 * 批量减员业务做校验及数据更新（用于解决：同个账号多个保单都要减员过程繁琐问题）
	 * @param orderId 订单id
	 * @param importBatchId 批次号
	 * @return
	 */
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT_RECORD,title ="【请求】个人中心-批量减员")
	@LoginRequired
	@RequestMapping("batch_minus_preservation_service")
	@ResponseBody
	public ResultDto batch_minus_preservation_service(String orderId,String importBatchId) throws Exception {
		if(!stopSubmitAgain("PC_MINUS_BQ:"+getToken(),1)){
			return new ResultDto("业务处理中，请勿重复提交！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		String sign = "1";
		InsPreservationRecordVo vo = new InsPreservationRecordVo();
		vo.setIns_insurance_slip_id(orderId);
		vo.setRevise_type("2");
		vo.setInception_date(DateUtil.getTomorrow());
		List<InsPreservationDetailVo> ipdVoSortList = insPreservationResultSetAPIService.findInsPreservationDetailVoByImportBatchId(Long.parseLong(orderId),importBatchId);
		vo.setInsPreservationDetailVoList(ipdVoSortList);
		vo.resetName();
		//校验人员信息
		String result = insPreservationDetailAPIService.batchDetailSortAndValidator(vo);
		if(ConstProp.CODE_FAILURE.equals(result.split(ConstProp.POUND_SIGN)[0])){
			stopSubmitAgain("PC_MINUS_BQ:"+getToken(),3);
			return new ResultDto(result.split(ConstProp.POUND_SIGN)[1], ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		Map<String, String> map = insPreservationRecordAPIService.recordRestToRB(vo, sign);
		if(map != null){
			if("300".equals(map.get("ret"))){
				stopSubmitAgain("PC_MINUS_BQ:"+getToken(),3);
				if(StringUtils.isNotEmpty(map.get("msg"))&&map.get("msg").contains("系统响应超时，请重试")){
					insPreservationRecordAPIService.recordRestPAC(vo);
					myAsyncExecutor.execute(()->{
						//前海批改超时补偿
						insPreservationRecordAPIService.addFindPDTask(vo.getOid());
					});
				}
				return new ResultDto(map.get("msg"), ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}
		//数据更新创建保全申请单
		if(insPreservationRecordAPIService.createInsPreservationRecord(Integer.parseInt(sign),vo,vo.getInsPreservationDetailVoList())){
			insPreservationRecordAPIService.updateRecordStatus(vo.getOid(), map);
			String m = "批改信息成功提交审核！";
			if(map != null && !map.containsKey("isPendingApproval")){
				m = "批改信息已通过审核！";
			}
			stopSubmitAgain("PC_MINUS_BQ:"+getToken(),2);
			return new ResultDto(m, ConstProp.CODE_SUCCESS,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}else{
			stopSubmitAgain("PC_MINUS_BQ:"+getToken(),3);
			return new ResultDto("数据更新失败！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	/**
	 * 减员业务做校验及数据更新
	 * @param vo 保全申请单辅助类
	 * @param sign 标识数据是否暂存，0直接提交，1暂存
	 * @return
	 */
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT_RECORD,title ="【请求】个人中心-减员")
	@LoginRequired
	@RequestMapping("minus_preservation_service")
	@ResponseBody
	public ResultDto minus_preservation_service(InsPreservationRecordVo vo,String sign) throws Exception {
		if(!stopSubmitAgain("PC_MINUS_BQ:"+getToken(),1)){
			return new ResultDto("业务处理中，请勿重复提交！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		if(ConstProp.DIGIT_ONE.equals(sign)){
			List<InsPreservationDetailVo> ipdVoSortList = new ArrayList<InsPreservationDetailVo>();
			for(InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()){
				if(StringUtils.isEmpty(ipdVo.getName())
						&&StringUtils.isEmpty(ipdVo.getBirthday())
						&&StringUtils.isEmpty(ipdVo.getCareer())
						&&StringUtils.isEmpty(ipdVo.getId_card())
						&&StringUtils.isEmpty(ipdVo.getId_type())
						&&StringUtils.isEmpty(ipdVo.getSex())){
					continue;
				}
				ipdVoSortList.add(ipdVo);
			}
			vo.setInsPreservationDetailVoList(ipdVoSortList);
			vo.resetName();
			//校验人员信息
			String result = insPreservationDetailAPIService.batchDetailSortAndValidator(vo);
			if(ConstProp.CODE_FAILURE.equals(result.split(ConstProp.POUND_SIGN)[0])){
				stopSubmitAgain("PC_MINUS_BQ:"+getToken(),3);
				return new ResultDto(result.split(ConstProp.POUND_SIGN)[1], ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}else{
			List<InsPreservationDetailVo> ipdVoSortList = new ArrayList<InsPreservationDetailVo>();
			for(InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()){
				if(StringUtils.isNotEmpty(ipdVo.getBusiness_id())
						||StringUtils.isNotEmpty(ipdVo.getBusiness_type())){
					ipdVoSortList.add(ipdVo);
				}
			}
			vo.setInsPreservationDetailVoList(ipdVoSortList);
		}
		//过滤重复操作减员的人员
		String str = insPreservationDetailAPIService.notUnderWarrantyIdCardNo(vo.getIns_insurance_slip_id(),vo.getInsPreservationDetailVoList());
		if(ConstProp.CODE_FAILURE.equals(str.split(ConstProp.POUND_SIGN)[0])){
			stopSubmitAgain("PC_MINUS_BQ:"+getToken(),3);
			return new ResultDto(str.split(ConstProp.POUND_SIGN)[1], ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		Map<String, String> map = insPreservationRecordAPIService.recordRestToRB(vo, sign);
		if(map != null){
			if("300".equals(map.get("ret"))){
				stopSubmitAgain("PC_MINUS_BQ:"+getToken(),3);
				if(StringUtils.isNotEmpty(map.get("msg"))&&map.get("msg").contains("系统响应超时，请重试")){
					insPreservationRecordAPIService.recordRestPAC(vo);
					myAsyncExecutor.execute(()->{
						//前海批改超时补偿
						insPreservationRecordAPIService.addFindPDTask(vo.getOid());
					});
				}
				return new ResultDto(map.get("msg"), ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}
		//数据更新创建保全申请单
		if(insPreservationRecordAPIService.createInsPreservationRecord(Integer.parseInt(sign),vo,vo.getInsPreservationDetailVoList())){
			if(!ConstProp.DIGIT_ONE.equals(sign)){
				stopSubmitAgain("PC_MINUS_BQ:"+getToken(),2);
				//暂存
				return new ResultDto("保存成功，请进入“批改申请记录”中查看保存的批改申请！", ConstProp.CODE_SUCCESS,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			insPreservationRecordAPIService.updateRecordStatus(vo.getOid(), map);
			String m = "批改信息成功提交审核！";
			if(map != null && !map.containsKey("isPendingApproval")){
				m = "批改信息已通过审核！";
			}
			stopSubmitAgain("PC_MINUS_BQ:"+getToken(),2);
			return new ResultDto(m, ConstProp.CODE_SUCCESS,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}else{
			stopSubmitAgain("PC_MINUS_BQ:"+getToken(),3);
			return new ResultDto("数据更新失败！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	/**
	 * 保全申请单的详情页中如果该单状态为待提交减员业务就调用该控制器
	 * @param vo 保全申请单辅助类
	 * @param sign 标识数据是否暂存，0直接提交，1暂存
	 * @return
	 */
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT_RECORD,title ="【请求】个人中心-减员")
	@LoginRequired
	@RequestMapping("update_detail_minus_service")
	@ResponseBody
	public ResultDto update_detail_minus_service(InsPreservationRecordVo vo,String sign) throws Exception {
		//校验人员信息
		List<InsPreservationDetailVo> ipdVoList = vo.getInsPreservationDetailVoList();
		if(ipdVoList == null){
			return new ResultDto("当前保全无有效人员信息请手动删除该单", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		vo.resetName();
		//校验人员信息
		String valid = insPreservationDetailAPIService.detailSortAndValidator(vo);
		if(ConstProp.CODE_FAILURE.equals(valid.split(ConstProp.POUND_SIGN)[0])){
			return new ResultDto(valid.split(ConstProp.POUND_SIGN)[1], ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
//		String result;
//		for(InsPreservationDetailVo ipdVo : ipdVoList){
//			result = insPreservationDetailAPIService.personnelToCheck(ipdVo,vo.getRevise_type());
//			if(ConstProp.CODE_FAILURE.equals(result.split(ConstProp.POUND_SIGN)[0])){
//				return new ResultDto(result.split(ConstProp.POUND_SIGN)[1], ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
//			}
//		}
		List<InsPreservationDetailVo> ipdVoSortList = new ArrayList<InsPreservationDetailVo>();
		for(InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()){
			if(StringUtils.isNotEmpty(ipdVo.getOid())){
				ipdVoSortList.add(ipdVo);
			}
		}
		vo.setInsPreservationDetailVoList(ipdVoSortList);
		//过滤重复操作减员的人员
		String str = insPreservationDetailAPIService.notUnderWarrantyIdCardNo(vo.getIns_insurance_slip_id(),vo.getInsPreservationDetailVoList());
		if(ConstProp.CODE_FAILURE.equals(str.split(ConstProp.POUND_SIGN)[0])){
			return new ResultDto(str.split(ConstProp.POUND_SIGN)[1], ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		Map<String, String> map = insPreservationRecordAPIService.recordRestToRB(vo, sign);
		if(map != null){
			if("300".equals(map.get("ret"))){
				if(StringUtils.isNotEmpty(map.get("msg"))&&map.get("msg").contains("系统响应超时，请重试")){
					insPreservationRecordAPIService.recordRestPAC(vo);
					myAsyncExecutor.execute(()->{
						//前海批改超时补偿
						insPreservationRecordAPIService.addFindPDTask(vo.getOid());
					});
				}
				return new ResultDto(map.get("msg"), ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}
		//数据更新创建保全申请单
		if(insPreservationRecordAPIService.minusInsPreservationRecord(Integer.parseInt(sign),vo,vo.getInsPreservationDetailVoList())){
			if(!ConstProp.DIGIT_ONE.equals(sign)){
				//暂存
				return new ResultDto("保存成功，请进入“批改申请记录”中查看保存的批改申请！", ConstProp.CODE_SUCCESS,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			insPreservationRecordAPIService.updateRecordStatus(vo.getOid(), map);
			String m = "批改信息成功提交审核！";
			if(map != null && !map.containsKey("isPendingApproval")){
				m = "批改信息已通过审核！";
			}
			return new ResultDto(m, ConstProp.CODE_SUCCESS,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}else{
			return new ResultDto("数据更新失败！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	/**
	 * 增员业务做校验及数据更新
	 * @param vo 保全申请单辅助类，其中包含保全人员信息列表
	 * @param sign 标识数据是否暂存，0直接提交，1暂存
	 * @return
	 */
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT_RECORD,title ="【请求】个人中心-替换")
	@LoginRequired
	@RequestMapping("replace_preservation_service")
	@ResponseBody
	public ResultDto replace_preservation_service(InsPreservationRecordVo vo,String sign) {
		if(!stopSubmitAgain("PC_REPLACE_BQ:"+getToken(),1)){
			return new ResultDto("业务处理中，请勿重复提交！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		if(ConstProp.DIGIT_ONE.equals(sign)){
			List<InsPreservationDetailVo> ipdVoSortList = new ArrayList<InsPreservationDetailVo>();
			for(InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()){
				if(StringUtils.isEmpty(ipdVo.getName())
						&&StringUtils.isEmpty(ipdVo.getBirthday())
						&&StringUtils.isEmpty(ipdVo.getCareer())
						&&StringUtils.isEmpty(ipdVo.getId_card())
						&&StringUtils.isEmpty(ipdVo.getId_type())
						&&StringUtils.isEmpty(ipdVo.getSex())){
					continue;
				}
				ipdVoSortList.add(ipdVo);
			}
			vo.setInsPreservationDetailVoList(ipdVoSortList);
			vo.resetName();
			String result = insPreservationDetailAPIService.batchDetailSortAndValidator(vo);
			if(ConstProp.CODE_FAILURE.equals(result.split(ConstProp.POUND_SIGN)[0])){
				stopSubmitAgain("PC_REPLACE_BQ:"+getToken(),3);
				return new ResultDto(result.split(ConstProp.POUND_SIGN)[1], ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}else{
			List<InsPreservationDetailVo> ipdVoSortList = new ArrayList<InsPreservationDetailVo>();
			for(InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()){
				if(StringUtils.isNotEmpty(ipdVo.getBusiness_id())
						||StringUtils.isNotEmpty(ipdVo.getBusiness_type())
						||StringUtils.isNotEmpty(ipdVo.getOid())){
					ipdVoSortList.add(ipdVo);
				}
			}
			vo.setInsPreservationDetailVoList(ipdVoSortList);
		}
		//过滤重复人员投保
		String str = insPreservationDetailAPIService.isDuplicateIdCardNoToPreservationDetail(vo.getIns_insurance_slip_id(),vo.getInsPreservationDetailVoList());
		if(ConstProp.CODE_FAILURE.equals(str.split(ConstProp.POUND_SIGN)[0])){
			stopSubmitAgain("PC_REPLACE_BQ:"+getToken(),3);
			return new ResultDto(str.split(ConstProp.POUND_SIGN)[1], ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		Map<String, String> map = insPreservationRecordAPIService.recordRestToRB(vo, sign);
		if(map != null){
			if("300".equals(map.get("ret"))){
				stopSubmitAgain("PC_REPLACE_BQ:"+getToken(),3);
				if(StringUtils.isNotEmpty(map.get("msg"))&&map.get("msg").contains("系统响应超时，请重试")){
					insPreservationRecordAPIService.recordRestPAC(vo);
					myAsyncExecutor.execute(()->{
						//前海批改超时补偿
						insPreservationRecordAPIService.addFindPDTask(vo.getOid());
					});
				}
				return new ResultDto(map.get("msg"), ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}
		//数据更新创建保全申请单
		if(insPreservationRecordAPIService.createInsPreservationRecord(Integer.parseInt(sign),vo,vo.getInsPreservationDetailVoList())){
			if(!ConstProp.DIGIT_ONE.equals(sign)){
				stopSubmitAgain("PC_REPLACE_BQ:"+getToken(),2);
				//暂存
				return new ResultDto("保存成功，请进入“批改申请记录”中查看保存的批改申请！", ConstProp.CODE_SUCCESS,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			insPreservationRecordAPIService.updateRecordStatus(vo.getOid(), map);
			String m = "批改信息成功提交审核！";
			if(map != null && !map.containsKey("isPendingApproval")){
				m = "批改信息已通过审核！";
			}
			stopSubmitAgain("PC_REPLACE_BQ:"+getToken(),2);
			return new ResultDto(m, ConstProp.CODE_SUCCESS,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}else{
			stopSubmitAgain("PC_REPLACE_BQ:"+getToken(),3);
			return new ResultDto("数据更新失败！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	@RequestMapping("deleteRecordDetail")
	@ResponseBody
	public JSONObject deleteRecordDetail(long oid){
		JSONObject json = new JSONObject();
		String message="人员信息删除失败！";
		String status =ConstProp.CODE_FAILURE;
		if(insPreservationDetailAPIService.deleteInsPreservationDetail(oid)){
			message="人员信息删除成功！";
			status=ConstProp.CODE_SUCCESS;
		}
		json.put("message", message);
		json.put("status", status);
		return json;
	}

	/**
	 * excel文件上传并解析,批量导入人员，增员的导入功能
	 * @param request
	 * @return
	 * @throws IOException
	 */
	@RequestMapping("/uploadRoleFile")
	@ResponseBody
	public ResultDto uploadRoleFile(MultipartHttpServletRequest request) throws Exception {
		MultipartFile roleFile = request.getFile("role_record");
		List<InsPreservationResultSetVo> list = null;
		if(roleFile != null){
			com.alibaba.fastjson.JSONObject jo = insPreservationResultSetAPIService.readIPRSExcel(roleFile);
			if(ConstProp.CODE_SUCCESS.equals(jo.get("ret"))){
				list = (List<InsPreservationResultSetVo>)jo.get("list");
				if(list.size()<1){
					return new ResultDto("Excel中无人员数据或存在空白行！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
				}
			}else{
				return new ResultDto(String.valueOf(jo.get("msg")), ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}else{
			return new ResultDto("文件上传失败！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		if(list!=null && !list.isEmpty()){
			if(setValueSession(list)){
				return new ResultDto("文件解析成功！", ConstProp.CODE_SUCCESS,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("数据缓存失败！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}else{
			return new ResultDto("未解析到可用数据！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	/**
	 * excel文件上传并解析,批量导入人员，替换的导入功能
	 * @param request
	 * @return
	 * @throws IOException
	 */
	@RequestMapping("/replaceUploadRoleFile")
	@ResponseBody
	public ResultDto replaceUploadRoleFile(MultipartHttpServletRequest request) throws Exception {
		MultipartFile roleFile = request.getFile("role_record");
		String replace_check_some = request.getParameter("replace_check_some");
		String ins_insurance_slip_id = request.getParameter("ins_insurance_slip_id");
		if(StringUtils.isEmpty(replace_check_some)||StringUtils.isEmpty(ins_insurance_slip_id)){
			return new ResultDto("订单信息或替换人员信息丢失！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		List<InsPreservationResultSetVo> list = null;
		if(roleFile != null){
			com.alibaba.fastjson.JSONObject jo = insPreservationResultSetAPIService.readIPRSExcel(roleFile);
			if(ConstProp.CODE_SUCCESS.equals(jo.get("ret"))){
				list = (List<InsPreservationResultSetVo>)jo.get("list");
				if(list.size()<1){
					return new ResultDto("Excel中无人员数据或存在空白行！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
				}
			}else{
				return new ResultDto(String.valueOf(jo.get("msg")), ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			String[] strArr = replace_check_some.replace("ROLE","").replace("PRESERVE","").replace("THIS","").replace(";","").split(ConstProp.POUND_SIGN);
			Map<String,Integer> m = insPreservationResultSetAPIService.countCareer(strArr);
			if(m == null){
				return new ResultDto("未匹配到选中人员职业信息！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			if(!String.valueOf(m.get("career1")).equals(String.valueOf(jo.get("career1")))
					||!String.valueOf(m.get("career2")).equals(String.valueOf(jo.get("career2")))
					||!String.valueOf(m.get("career3")).equals(String.valueOf(jo.get("career3")))
					||!String.valueOf(m.get("career4")).equals(String.valueOf(jo.get("career4")))){
				return new ResultDto("对应职业人员人数不匹配！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}else{
			return new ResultDto("文件上传失败！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		if(list!=null && !list.isEmpty()){
			String[] checkNum = replace_check_some.split(ConstProp.POUND_SIGN);
			if(checkNum.length != list.size()){
				return new ResultDto("上传人员人数与勾选人数不一致！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			if(setValueSession(list)){
				return new ResultDto("文件解析成功！", ConstProp.CODE_SUCCESS,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("数据缓存失败！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}else{
			return new ResultDto("未解析到可用数据！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	/**
	 * excel文件上传并解析,批量导入人员，减员的导入功能
	 * @param request
	 * @return
	 * @throws IOException
	 */
	@RequestMapping("/minusUploadRoleFile")
	@ResponseBody
	public ResultDto minusUploadRoleFile(MultipartHttpServletRequest request) throws Exception {
		MultipartFile roleFile = request.getFile("role_record");
		String ins_insurance_slip_id = request.getParameter("ins_insurance_slip_id");
		if(StringUtils.isEmpty(ins_insurance_slip_id)){
			return new ResultDto("订单信息信息丢失！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		List<InsPreservationResultSetVo> list = null;
		if(roleFile != null){
			com.alibaba.fastjson.JSONObject jo = insPreservationResultSetAPIService.readIPRSExcel(roleFile);
			if(ConstProp.CODE_SUCCESS.equals(jo.get("ret"))){
				list = (List<InsPreservationResultSetVo>)jo.get("list");
				if(list.size()<1){
					return new ResultDto("Excel中无人员数据或存在空白行！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
				}
				List<String> idCards = Lists.newArrayList();
				for (InsPreservationResultSetVo vo : list){
					idCards.add(vo.getId_card());
				}
				list = insPreservationResultSetAPIService.getInsPreservationResultSetVoByIdCardsAndOrderId(Long.parseLong(ins_insurance_slip_id),idCards);
			}else{
				return new ResultDto(String.valueOf(jo.get("msg")), ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}

		}else{
			return new ResultDto("文件上传失败！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		if(list!=null && !list.isEmpty()){
			if(setValueSession(list)){
				return new ResultDto("文件解析成功！", ConstProp.CODE_SUCCESS,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("数据缓存失败！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}else{
			return new ResultDto("未解析到可用数据！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	@RequestMapping("/down_result_set/{oid}")
	public void downResultSet(@PathVariable Long oid, HttpServletResponse resp) {
		insPreservationResultSetAPIService.downResultSet(oid, resp);
	}

	/**
	 * <b> 阻止业务重复提交 </b>
	 * @param key 某个提交的自定义标识
	 * @param type 规则类型：1.校验session（刚进入业务方法时）；2.销毁session（返回成功信息前）；3.重置session值（返回失败信息前）
	 * @author ZXF
	 * @create 2020/04/22 0022 16:20
	 * @version
	 * @注意事项 </b>
	 */
	private boolean stopSubmitAgain(String key,int type) {
		boolean bool = false;

//		if (RequestContextHolder.getRequestAttributes() == null) {
//			return bool;
//		}
//		HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
//		HttpSession session = request.getSession();
		switch (type) {
			case 1:
				//创建session（加载操作页面前）
				String typeStr = JedisUtils.get(key);
				if(StringUtils.isNotEmpty(typeStr)){
					if("0".equals(typeStr)){
						JedisUtils.set(key,"1",10 * 60);
//						session.setAttribute(key,"1");
						bool = true;
					}
				}else{
					JedisUtils.set(key,"1",10 * 60);
//					session.setAttribute(key,"1");
					bool = true;
				}
				break;
			case 2:
				//销毁session（返回成功信息前）
				JedisUtils.del(key);
//				session.removeAttribute(key);
				bool = true;
				break;
			case 3:
				//重置session值（返回失败信息前）
				JedisUtils.set(key,"0",10 * 60);
//				session.setAttribute(key,"0");
				bool = true;
				break;
		}
		return bool;
	}

	private boolean setValueSession(List<InsPreservationResultSetVo> list) {
		JedisUtils.setObject(ConstProp.TB_IPRS_LIST + getToken(),list,3 * 60);
		return true;
//		HttpServletRequest request = null;
//		if (RequestContextHolder.getRequestAttributes() != null) {
//			request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
//			HttpSession session = null;
//			String sessionId = JedisUtils.get(ConstProp.REDIS_HEAD_THR_TOKEN + getToken());
//			if(StringUtils.isNotEmpty(sessionId)){
//				//获取session
//				session = SessionContext.getInstance().getSession(sessionId);
//			}else{
//				session = request.getSession();
//			}
//			session.setAttribute("iprsVoList",list);
//			return true;
//		}else{
//			return false;
//		}
	}

	private List<InsPreservationResultSetVo> getValueSession() {
		List<InsPreservationResultSetVo> list = (List<InsPreservationResultSetVo>)JedisUtils.getObject(ConstProp.TB_IPRS_LIST + getToken());
		JedisUtils.delObject(ConstProp.TB_IPRS_LIST + getToken());
//		HttpServletRequest request = null;
//		List<InsPreservationResultSetVo> list = null;
//		if (RequestContextHolder.getRequestAttributes() != null) {
//			request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
//			HttpSession session = null;
//			String sessionId = JedisUtils.get(ConstProp.REDIS_HEAD_THR_TOKEN + getToken());
//			if(StringUtils.isNotEmpty(sessionId)){
//				//获取session
//				session = SessionContext.getInstance().getSession(sessionId);
//			}else{
//				session = request.getSession();
//			}
//			list = (List<InsPreservationResultSetVo>)session.getAttribute("iprsVoList");
//			session.removeAttribute("iprsVoList");
//		}
		return list;
	}

}
