package com.bcxin.ins.coninsweb.preservation.controller;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.dto.Result;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.preservation.InsPreservationPayAPIService;
import com.bcxin.ins.service.preservation.InsPreservationRecordAPIService;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.entity.policy_core.InsPreservationPay;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.util.OSSFileUtil;
import com.bcxin.ins.vo.*;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.util.List;

/**
 * 自用保全缴费控制器
 * @author zxf
 *
 */
@Controller
@RequestMapping("/pc/preservation/pay")
public class InsPreservationPayController extends BaseController {

	@Autowired
	private InsPreservationRecordAPIService insPreservationRecordAPIService;
	@Autowired
	private InsPreservationPayAPIService insPreservationPayAPIService;
	@Autowired
	private PolicyService policyService;
	@Autowired
	private ProductService productService;

	private static String PAYLIST = "payList";
	private static String PAY_STATUS = "pay_status";
	private static String START_TIME = "start_time";
	private static String END_TIME = "end_time";
	private static String KEYWORD = "keyword";
	private static String PAYVO = "payVo";
	private static String RECORDVOLIST = "recordVoList";


	/**
	 * <b>我的订单-出口险 页面初始化 </b>
	 *
	 * @param pay_status
	 * @param start_time
	 * @param end_time
	 * @param request
	 * @param page
	 * @return
	 * @author ZXF
	 * @date 2016年12月29日 下午5:54:59
	 * @注意事项 </b>
	 * <b>
	 */
	@LoginRequired(methodParamKey={"0#pay_status","1#start_time","2#end_time"},requestParamKey={"keyword"}, redirectUrl = "pc/preservation/pay/payList?pay_status={pay_status}&start_time={start_time}&end_time={end_time}&keyword={keyword}")
	@RequestMapping("payList")
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】我的账户-人员管理-保全账单")
	public ModelAndView payList(String pay_status, String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String keyword = request.getParameter("keyword");
		if(StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/pay/payList");
		page.setNumPerPage(5);
		String et = ConstProp.BLANK_CHAR;
		if(StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		view.addObject(PAYLIST,insPreservationPayAPIService.findInsPreservationBillVoByKeyword( page, Long.parseLong(userdetail.getOid()), pay_status, start_time, et, keyword));
		view.addObject(PAY_STATUS,pay_status);
		view.addObject(START_TIME,start_time);
		view.addObject(END_TIME,end_time);
		view.addObject(KEYWORD,keyword);
		setTokenByApi(view);
		return view;
	}

	@LoginRequired(redirectUrl = "redirect:/synopsis/unSession")
	@RequestMapping("getPayListForPage")
	public ModelAndView getPayListForPage(String pay_status, String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String keyword = request.getParameter("keyword");
		if(StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		String et = ConstProp.BLANK_CHAR;
		if(StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/pay/payList_table");
		view.addObject(PAYLIST,insPreservationPayAPIService.findInsPreservationBillVoByKeyword( page, Long.parseLong(userdetail.getOid()), pay_status, start_time, et, keyword));
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b>汇总账单下级账单列表 </b>
	 *
	 * @param pay_status
	 * @param start_time
	 * @param end_time
	 * @param request
	 * @param page
	 * @return
	 * @author ZXF
	 * @date 2016年12月29日 下午5:54:59
	 * @注意事项 </b>
	 * <b>
	 */
	@LoginRequired(methodParamKey={"0#pay_status","1#start_time","2#end_time"},requestParamKey={"keyword","parentPayId","isPart"}, redirectUrl = "pc/preservation/pay/billList?pay_status={pay_status}&start_time={start_time}&end_time={end_time}&keyword={keyword}&parentPayId={parentPayId}&isPart={isPart}")
	@RequestMapping("billList")
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】我的账户-人员管理-保全账单-账单详情")
	public ModelAndView billList(String pay_status, String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String keyword = request.getParameter("keyword");
		String parentPayId = request.getParameter("parentPayId");
		String isPart = request.getParameter("isPart");
		if(StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/pay/billList");
		page.setNumPerPage(5);
		String et = ConstProp.BLANK_CHAR;
		if(StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		InsPreservationPayVo payVo = insPreservationPayAPIService.findInsPreservationPayVoById(Long.parseLong(parentPayId));
		view.addObject(PAYLIST,insPreservationPayAPIService.findInsPreservationChildBillVoByKeyword( page, Long.parseLong(userdetail.getOid()), Long.parseLong(parentPayId), pay_status, start_time, et, keyword));
		view.addObject(PAY_STATUS,pay_status);
		view.addObject(START_TIME,start_time);
		view.addObject(END_TIME,end_time);
		view.addObject(KEYWORD,keyword);
		view.addObject("insPreservationPayVo",payVo);
		view.addObject("parentPayId",parentPayId);
		view.addObject("isPart",isPart);
		setTokenByApi(view);
		return view;
	}

	@LoginRequired(redirectUrl = "redirect:/synopsis/unSession")
	@RequestMapping("getBillListForPage")
	public ModelAndView getBillListForPage(String pay_status, String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String keyword = request.getParameter("keyword");
		String parentPayId = request.getParameter("parentPayId");
		if(StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		String et = ConstProp.BLANK_CHAR;
		if(StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/pay/billList_table");
		view.addObject(PAYLIST,insPreservationPayAPIService.findInsPreservationChildBillVoByKeyword( page, Long.parseLong(userdetail.getOid()), Long.parseLong(parentPayId), pay_status, start_time, et, keyword));
		setTokenByApi(view);
		return view;
	}

	@LoginRequired(methodParamKey={"0#start_time","1#end_time"},requestParamKey={"keyword"}, redirectUrl = "pc/preservation/pay/settlementList?start_time={start_time}&end_time={end_time}&keyword={keyword}")
	@RequestMapping("settlementList")
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】我的账户-人员管理-保全结算单")
	public ModelAndView settlementList(String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String keyword = request.getParameter("keyword");
		if(StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/pay/settlementList");
		page.setNumPerPage(5);
		String et = ConstProp.BLANK_CHAR;
		if(StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		view.addObject(PAYLIST,insPreservationPayAPIService.findInsPreservationSettlementVoByKeyword( page, Long.parseLong(userdetail.getOid()), start_time, et, keyword));
		view.addObject(START_TIME,start_time);
		view.addObject(END_TIME,end_time);
		view.addObject(KEYWORD,keyword);
		setTokenByApi(view);
		return view;
	}

	@LoginRequired(redirectUrl = "redirect:/synopsis/unSession")
	@RequestMapping("getSettlementListForPage")
	public ModelAndView getSettlementListForPage(String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String keyword = request.getParameter("keyword");
		if(StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		String et = ConstProp.BLANK_CHAR;
		if(StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/pay/settlementList_table");
		view.addObject(PAYLIST,insPreservationPayAPIService.findInsPreservationSettlementVoByKeyword( page, Long.parseLong(userdetail.getOid()), start_time, et, keyword));
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b>汇总账单下级账单列表 </b>
	 *
	 * @param pay_status
	 * @param start_time
	 * @param end_time
	 * @param request
	 * @param page
	 * @return
	 * @author ZXF
	 * @date 2016年12月29日 下午5:54:59
	 * @注意事项 </b>
	 * <b>
	 */
	@LoginRequired(methodParamKey={"0#start_time","1#end_time"},requestParamKey={"keyword","parentPayId"}, redirectUrl = "pc/preservation/pay/settlementBillList?start_time={start_time}&end_time={end_time}&keyword={keyword}&parentPayId={parentPayId}")
	@RequestMapping("settlementBillList")
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】我的账户-人员管理-保全结算单-结算详情")
	public ModelAndView settlementBillList(String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String keyword = request.getParameter("keyword");
		String parentPayId = request.getParameter("parentPayId");
		if(StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/pay/settlementBillList");
		page.setNumPerPage(5);
		String et = ConstProp.BLANK_CHAR;
		if(StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		view.addObject(PAYLIST,insPreservationPayAPIService.findInsPreservationChildSettlementVoByKeyword( page, Long.parseLong(userdetail.getOid()), Long.parseLong(parentPayId), start_time, et, keyword));
		view.addObject(START_TIME,start_time);
		view.addObject(END_TIME,end_time);
		view.addObject(KEYWORD,keyword);
		view.addObject("parentPayId",parentPayId);
		setTokenByApi(view);
		return view;
	}

	@LoginRequired(redirectUrl = "redirect:/synopsis/unSession")
	@RequestMapping("getSettlementBillListForPage")
	public ModelAndView getSettlementBillListForPage(String start_time, String end_time, HttpServletRequest request, DwzPage page) throws UnsupportedEncodingException {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String keyword = request.getParameter("keyword");
		String parentPayId = request.getParameter("parentPayId");
		if(StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		String et = ConstProp.BLANK_CHAR;
		if(StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/pay/settlementBillList_table");
		view.addObject(PAYLIST,insPreservationPayAPIService.findInsPreservationChildSettlementVoByKeyword( page, Long.parseLong(userdetail.getOid()), Long.parseLong(parentPayId), start_time, et, keyword));
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b>查看保全缴费详情 </b>
	 * 
	 * @param payId
	 * @return
	 * @author ZXF 
	 * @date 2017年1月12日 上午10:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@LoginRequired(methodParamKey={"0#payId"}, redirectUrl = "pc/preservation/pay/getInsPreservationPayByPayId/{payId}")
	@RequestMapping("getInsPreservationPayByPayId/{payId}")
	public ModelAndView getInsPreservationPayByPayId(@PathVariable Long payId, HttpServletRequest request){
		ModelAndView view = new ModelAndView();
		InsPreservationPayVo payVo = insPreservationPayAPIService.findInsPreservationPayVoById(payId);
		List<ProductVo> list = productService.getProductsByOnLine(payVo.getProduct_code());
		view.setViewName("/coninsweb/personalCenter/preservation/pay/payDetail");
		view.addObject(PAYVO,payVo);
		view.addObject("productDto",list.get(0));
		view.addObject(RECORDVOLIST,payVo.getInsPreservationRecordVoList());
		setTokenByApi(view);
		return view;
	}

	/**
	 * 保全缴费详情中保全申请单列表分页
	 * @param payId 保全缴费id
	 * @param keyword 关键字
	 * @param page
	 * @return
	 */
	@LoginRequired(redirectUrl = "redirect:/synopsis/unSession")
	@RequestMapping("getRecordVoListForPage")
	public ModelAndView getRecordVoListForPage(Long payId, String keyword, DwzPage page){
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/pay/recordVoList_table");
		view.addObject(RECORDVOLIST,insPreservationRecordAPIService.findInsPreservationRecordVoByPayId( page, payId, keyword));
		setTokenByApi(view);
		return view;
	}

	/**
	 * excel文件上传并解析,批量导入人员，增员的导入功能
	 * @param request
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("/uploadFilePay")
	@ResponseBody
	public ResultDto uploadFilePay(MultipartHttpServletRequest request) throws Exception {
		MultipartFile pay_file = request.getFile("pay_file");
		String payId = request.getParameter("payId");
		if(pay_file != null&& StringUtils.isNotEmpty(payId)){
//			String path = insPreservationPayAPIService.uploadFile(pay_file,"/record/");
			String path = OSSFileUtil.huaweiOBSFileUpload(pay_file,"/record/");
			if(StringUtils.isNotEmpty(path)){
				if(insPreservationPayAPIService.savePayPath(Long.parseLong(payId),path)){
					return new ResultDto("保全缴费数据更新成功！", ConstProp.CODE_SUCCESS,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
				}else{
					return new ResultDto("保全缴费数据更新失败！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
				}
			}else{
				return new ResultDto("文件保存失败！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}else{
			return new ResultDto("上传数据丢失！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	@LoginRequired(redirectUrl = "redirect:/synopsis/unSession")
	@RequestMapping("recordPayment/{oid}")
	public ModelAndView recordPayment(@PathVariable String oid){
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/pay/recordPayment");
		InsPreservationRecordVo record = insPreservationRecordAPIService.findIPRVoById(Long.parseLong(oid));
		InsPreservationPayVo ippay = insPreservationPayAPIService.findIPPayVoById(Long.parseLong(record.getIns_preservation_pay_id()));
		OrderFormVo vo = policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(record.getIns_insurance_slip_id()));
		view.addObject("record",record);
		view.addObject("ippay",ippay);
		view.addObject("vo",vo);
		setTokenByApi(view);
		return view;
	}

    /**
     * <b>根据页面勾选条目生成部分账单 </b>
     * @param isSummaryBill 是否为汇总账单
     * @param payIds 勾选数据列的id集合
     * @author ZXF
     * @create 2024/04/26 0026 11:04
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("createPartBill")
    public @ResponseBody String createPartBill(String isSummaryBill, String payIds){
		JSONObject json = insPreservationPayAPIService.createPartBill(isSummaryBill,payIds.split(","));
        return json.toJSONString();
    }

    @RequestMapping("createPartBillByNo")
    public @ResponseBody String createPartBillByNo(String isSummaryBill, String payNos){
		JSONObject json = insPreservationPayAPIService.createPartBillByNo(isSummaryBill,payNos.split(","));
        return json.toJSONString();
    }

	@RequestMapping("/downBillPay")
	public void downBillPay(HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException {
		String keyword = req.getParameter("keyword");
		String start_time = req.getParameter("start_time");
		String end_time = req.getParameter("end_time");
		String pay_status = req.getParameter("pay_status");
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		String et = ConstProp.BLANK_CHAR;
		if(StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		insPreservationPayAPIService.downBillPay( Long.parseLong(userdetail.getOid()), pay_status, start_time, et, keyword, resp);

	}

	@RequestMapping("/downChildBillPay")
	public void downChildBillPay(HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException {
		String keyword = req.getParameter("keyword");
		String start_time = req.getParameter("start_time");
		String end_time = req.getParameter("end_time");
		String pay_status = req.getParameter("pay_status");
		String parentPayId = req.getParameter("parentPayId");
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		String et = ConstProp.BLANK_CHAR;
		if(StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		insPreservationPayAPIService.downChildBillPay( Long.parseLong(userdetail.getOid()), Long.parseLong(parentPayId), pay_status, start_time, et, keyword, resp);

	}

	@RequestMapping("/downSettlementPay")
	public void downSettlementPay(HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException {
		String keyword = req.getParameter("keyword");
		String start_time = req.getParameter("start_time");
		String end_time = req.getParameter("end_time");
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		String et = ConstProp.BLANK_CHAR;
		if(StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		insPreservationPayAPIService.downSettlementPay( Long.parseLong(userdetail.getOid()), start_time, et, keyword, resp);

	}

	@RequestMapping("/downChildSettlementBillPay")
	public void downChildSettlementBillPay(HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException {
		String keyword = req.getParameter("keyword");
		String start_time = req.getParameter("start_time");
		String end_time = req.getParameter("end_time");
		String parentPayId = req.getParameter("parentPayId");
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(StringUtils.isNotEmpty(keyword)){
			keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
		}
		String et = ConstProp.BLANK_CHAR;
		if(StringUtils.isNotEmpty(end_time)){
			et = end_time+ConstProp.DAY_23;
		}
		insPreservationPayAPIService.downChildSettlementBillPay( Long.parseLong(userdetail.getOid()), Long.parseLong(parentPayId), start_time, et, keyword, resp);

	}

	/**
	 * <b> 检索保全缴费是否成功 </b>
	 * @author ZXF
	 * @create 2018/06/06 0006 16:11
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("isSuccessPay/{oid}")
	public @ResponseBody String isSuccessPay(@PathVariable long oid){
		JSONObject json = new JSONObject();
		InsPreservationPay pay = insPreservationPayAPIService.selectById(oid);
		String status = ConstProp.CODE_FAILURE;
		if(pay != null){
			if(DictConst.RECORD_PAY_STATUS_YZF.equals(pay.getPay_status())){
				status = ConstProp.CODE_SUCCESS;
			}
		}
		json.put("status", status);
		return json.toJSONString();
	}

	@RequestMapping("getFP/{oid}")
	public @ResponseBody
	Result getFP(@PathVariable long oid){
		return insPreservationPayAPIService.getFP(oid);
	}

	/**
	 * <b> 保全缴费结果页面跳转 </b>
	 * @author ZXF
	 * @create 2018/06/06 0006 16:11
	 * @version
	 * @注意事项 </b>
	 */
	@LoginRequired(redirectUrl = "redirect:/synopsis/unSession")
	@RequestMapping("finishPay")
	public ModelAndView finishPay() {
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/preservation/pay/finishPay");
		setTokenByApi(view);
		return view;
	}

}
