package com.bcxin.ins.coninsweb.order.stragegy.order.impl;

import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.coninsweb.order.stragegy.order.OrderSupplyStrategy;
import com.bcxin.ins.coninsweb.order.stragegy.order.OrderSupplyType;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.core.util.SysDictUtils;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.util.enums.IdType;
import com.bcxin.ins.util.enums.NatureLinkage;
import com.bcxin.ins.util.enums.OfficeType;
import com.bcxin.ins.vo.*;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

/**
 * 订单初始化数据策略
 * @author zxf
 * @date 2018/08/30
 * @说明 策略方案提议及案例提供人：hzp 2018/06/12
 */
@Component
@OrderSupplyType(type = OrderSupplyType.OrderSupplyTypeEnum.POLICY_INIT)
public class StragegyPolicyInit implements OrderSupplyStrategy {

    @Autowired
    private PolicyService policyService;

    @Autowired
    private ProductService productService;

    @Override
    public ModelAndView policyInitService(HttpServletRequest request, Long product_id) {
        ModelAndView view = new ModelAndView();
        ProductVo pd = productService.getProduct(product_id);
        if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.XYX_DQCK)){
            dqckInit(pd, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.XYX_XWCK)){
            xwckInit(pd, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.BZX_SSBQ)){
            ssbqInit(pd, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GZX)){
            gzxInit(pd, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.TYX)){
            String personNum = request.getParameter("personNum");
            tyxInit(personNum, pd, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GZZRX)){
            String personNum = request.getParameter("personNum");
            gzzrxInit(personNum, pd, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.ZZX)){
            zzxInit(pd, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GCTB)){
            gctbInit(pd, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GCLY)){
            gclyInit(pd, view);
        }
        view.addObject(ConstProp.PD,pd);
        return view;
    }

    @Override
    public ModelAndView getPolicyService(Long order_id, int page) {
        return null;
    }

    @Override
    public ResultDto pendingPolicyService(Object object, HttpServletRequest request) {
        return null;
    }

    @Override
    public ModelAndView confirmPolicyService(Long order_id) {
        return null;
    }

    @Override
    public ModelAndView paymentRequestService(Long order_id) {
        return null;
    }

    @Override
    public ResultDto underwritingRequestService(HttpServletRequest request) {
        return null;
    }

    @Override
    public ResultDto insuranceCalculationService(HttpServletRequest request) {
        return null;
    }

    @Override
    public ResultDto getElectronicInsuranceService(Long order_id) {
        return null;
    }

    private void tyxInit(String personNum, ProductVo pd, ModelAndView view){
        view.setViewName("/coninsweb/api/gmr/policy/gmr_enterBasicInfo");
        int num = 0;
        if(StringUtils.isNotEmpty(personNum)){
            num = Integer.parseInt(personNum);
        }
        //请求百保盾返回企业信息及员工信息
        GMRPolicyVo vo = new GMRPolicyVo();
        MailPolicyVo mVo = new MailPolicyVo();
        mVo.setNeed_receipt(ConstProp.DIGIT_ONE);
        vo.setMailPolicyVo(mVo);
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if(StringUtils.isNotEmpty(userdetail.getWeb_type())){
            List<RoleSubjectVo> doList = null;
            if(userdetail.getWeb_type().contains(ConstProp.ARS)){
                doList = policyService.getComAndEmpByUserID_BBDAPI(userdetail.getWeb_id(),userdetail.getWeb_type());
            }
            if(userdetail.getWeb_type().contains(ConstProp.SAAS)||userdetail.getWeb_type().contains(ConstProp.PASP)){
                doList = policyService.getComAndEmpByUserID_API(userdetail.getWeb_id(),userdetail.getWeb_type());
            }
            if(doList!=null){
                List<RoleSubjectVo> voList = sortRoleList(doList,num,0);
                vo.setRoleSubjectList(voList);
                //最低标准需要3条别保险人，不足就补齐
                if(doList.size()>0&&doList.size()<4){
                    int ct = 4-doList.size();
                    RoleSubjectVo nullVo = null;
                    for(int i = 0; i < ct; i++){
                        nullVo = new RoleSubjectVo();
                        nullVo.setKind(ConstProp.DIGIT_TWO);
                        doList.add(nullVo);
                        nullVo = null;
                    }
                }
            }
        }
        view.addObject(ConstProp.VO, vo);
        view.addObject(ConstProp.RECOMMEND_CODE,UserSupportUtil.getRecommendCode());
        OrderFormVo dto = new OrderFormVo();
        dto.setProduct_oid(pd.getOid());
        dto.setProduct_code(pd.getProduct_code());
        dto.setGross_premium(pd.getPremium_min());
        view.addObject(ConstProp.DTO,dto);
        view.addObject("comTypeList", IdType.comList());
        view.addObject("personTypeList", IdType.personList());
        view.addObject("natureList", NatureLinkage.getListByProvince(""));
        view.addObject("idOptionList", SysDictUtils.getDictList("idOption"));
        view.addObject("businessAreaList", SysDictUtils.getDictList("businessArea"));
        view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
    }

    /**
     * 根据获取到的投保人被保人列表筛选排序
     * @param doList
     * @param num 被保人人数限制
     * @param type 0为初始1为已存在被保险人
     * @return
     */
    private List<RoleSubjectVo> sortRoleList(List<RoleSubjectVo> doList,int num,int type){
        List<RoleSubjectVo> results = new ArrayList<RoleSubjectVo>();
        if(doList == null){
            if(num>0){
                RoleSubjectVo appRole = new RoleSubjectVo();
                appRole.setKind(ConstProp.DIGIT_ONE);
                results.add(appRole);
                RoleSubjectVo insRole = null;
                for(int i=0;i<num;i++){
                    insRole = new RoleSubjectVo();
                    insRole.setKind(ConstProp.DIGIT_TWO);
                    insRole.setMajor_group(ConstProp.DIGIT_ONE);
                    results.add(insRole);
                    insRole = null;
                }
                return results;
            }else{
                return null;
            }
        }
        List<RoleSubjectVo> insurceRoleList = new ArrayList<RoleSubjectVo>();
        for(RoleSubjectVo vo : doList){
            if(ConstProp.DIGIT_ONE.equals(vo.getKind())){
                results.add(vo);
            }else{
                insurceRoleList.add(vo);
            }
        }
        if(results.size() == 0){
            RoleSubjectVo vo = new RoleSubjectVo();
            vo.setKind(ConstProp.DIGIT_ONE);
            results.add(vo);
        }
        if(type == 0){
            //以上筛选投保人，筛选被保险人
            if(insurceRoleList.size()>0){
                int insRoleNum = insurceRoleList.size();
                if(insRoleNum<num){//加载被保险人，被保险人小于限制人数
                    results.addAll(insurceRoleList);
                    int lastNum = num-insRoleNum;
                    for(int i=0;i<lastNum;i++){
                        RoleSubjectVo rvo = new RoleSubjectVo();
                        rvo.setKind(ConstProp.DIGIT_TWO);
                        rvo.setMajor_group(ConstProp.DIGIT_ONE);
                        results.add(rvo);
                    }
                }else if(insRoleNum==num){
                    results.addAll(insurceRoleList);
                }else if(num == 0){
                    results.addAll(insurceRoleList);
                }else{
                    for(int i=0;i<num;i++){
                        results.add(insurceRoleList.get(i));
                    }
                }
            }
        }else{
            results.addAll(insurceRoleList);
        }

        return results;
    }

    private void gzzrxInit(String personNum, ProductVo pd, ModelAndView view){
        view.setViewName("/coninsweb/api/gzzrx/policy/gzzrx_enter_basic_info");
        int num = 0;
        if(StringUtils.isNotEmpty(personNum)){
            num = Integer.parseInt(personNum);
        }
        //请求百保盾返回企业信息及员工信息
        SpecialHirelingVo vo = new SpecialHirelingVo();
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if(StringUtils.isNotEmpty(userdetail.getWeb_type())){
            List<RoleSubjectVo> doList = null;
            if(userdetail.getWeb_type().contains(ConstProp.ARS)){
                doList = policyService.getComAndEmpByUserID_BBDAPI(userdetail.getWeb_id(),userdetail.getWeb_type());
            }
            if(userdetail.getWeb_type().contains(ConstProp.SAAS)||userdetail.getWeb_type().contains(ConstProp.PASP)){
                doList = policyService.getComAndEmpByUserID_API(userdetail.getWeb_id(),userdetail.getWeb_type());
            }
            if(doList!=null){
                List<RoleSubjectVo> appList = Lists.newArrayList();
                List<RoleSubjectVo> voList = sortRoleList(doList,num,0);
                appList.add(voList.get(0));
                vo.setRoleSubjectList(appList);
                vo.setHirelingVoList(setHVoByRole(voList));
            }
        }
        view.addObject(ConstProp.VO, vo);
        view.addObject(ConstProp.RECOMMEND_CODE,UserSupportUtil.getRecommendCode());
        OrderFormVo dto = new OrderFormVo();
        dto.setProduct_oid(pd.getOid());
        dto.setProduct_code(pd.getProduct_code());
        dto.setGross_premium(pd.getPremium_min());
        view.addObject(ConstProp.DTO,dto);
        view.addObject("comTypeList", IdType.comList());
        view.addObject("personTypeList", IdType.personList());
        view.addObject("natureList", NatureLinkage.getListByProvince(ConstProp.BLANK_CHAR));
        view.addObject("idOptionList", SysDictUtils.getDictList("idOption"));
        view.addObject("businessAreaList", SysDictUtils.getDictList("businessArea"));
        view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
    }

    private List<HirelingVo> setHVoByRole(List<RoleSubjectVo> voList){
        List<HirelingVo> hVoList = Lists.newArrayList();
        HirelingVo hVo = null;
        for(RoleSubjectVo rsVo : voList){
            if(!"1".equals(rsVo.getKind())){
                hVo = new HirelingVo();
                hVo.setName(rsVo.getName_cn());
                hVo.setId_card(rsVo.getOrganization_code());
                hVo.setId_type(rsVo.getId_type());
                hVo.setMobile(rsVo.getMobile());
                hVo.setBirth_date(rsVo.getBirth_date());
                hVo.setCareer(rsVo.getMajor_group());
                hVo.setSex(rsVo.getSex());
                hVoList.add(hVo);
            }
        }
        if(hVoList.size()<3){
            for(int i=0;i<=(3-hVoList.size());i++){
                hVo = new HirelingVo();
                hVoList.add(hVo);
            }
        }
        return hVoList;
    }

    private void zzxInit(ProductVo pd, ModelAndView view){
        view.setViewName("/coninsweb/api/lote/policy/lote_enterBasicInfo");
        //请求百保盾返回企业信息及员工信息
        LOTEPolicyVo vo = new LOTEPolicyVo();
        MailPolicyVo mVo = new MailPolicyVo();
        vo.setMailPolicyVo(mVo);
        view.addObject(ConstProp.VO, vo);
        view.addObject(ConstProp.RECOMMEND_CODE,UserSupportUtil.getRecommendCode());
        OrderFormVo dto = new OrderFormVo();
        dto.setProduct_oid(pd.getOid());
        dto.setProduct_code(pd.getProduct_code());
        dto.setGross_premium(pd.getPremium_min());
        view.addObject(ConstProp.DTO,dto);
        view.addObject("comTypeList", IdType.comList());
        view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
    }

    private void dqckInit(ProductVo pd, ModelAndView view){
        view.setViewName("/coninsweb/insurance/customs/policy/enterBasicInfo_my_1");
        OrderFormVo dto = new OrderFormVo();
        dto.setProduct_oid(pd.getOid());
        dto.setProduct_code(pd.getProduct_code());
        dto.setGross_premium(pd.getPremium_min());
        view.addObject(ConstProp.DTO,dto);
        view.addObject(ConstProp.RECOMMEND_CODE,UserSupportUtil.getRecommendCode());
        view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
        view.addObject("listType", SysDictUtils.getDictList("organizationType"));
        view.addObject("listCurrency", SysDictUtils.getDictList("currencyRequired"));
        view.addObject("listPaymentTerms", SysDictUtils.getDictList("paymentTerms"));
    }

    private void xwckInit(ProductVo pd, ModelAndView view){
        view.setViewName("/coninsweb/insurance/customs/policy/enterBasicInfo_mi");
        OrderFormVo dto = new OrderFormVo();
        dto.setProduct_oid(pd.getOid());
        dto.setProduct_code(pd.getProduct_code());
        dto.setGross_premium(pd.getPremium_min());
        view.addObject(ConstProp.DTO,dto);
        view.addObject(ConstProp.RECOMMEND_CODE,UserSupportUtil.getRecommendCode());
        view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
        MicroExportVo vo = new MicroExportVo();
        setDay(vo);
        view.addObject(ConstProp.VO,vo);
        view.addObject("listComType", SysDictUtils.getDictList("comType"));
        view.addObject("listComNature", SysDictUtils.getDictList("comNature"));
        view.addObject("listIndustry", SysDictUtils.getDictList("industry"));
        view.addObject("listPayLimit", SysDictUtils.getDictList("payLimit"));
        view.addObject("listProRata", SysDictUtils.getDictList("proRata"));
        view.addObject("listAnnualCurrency", SysDictUtils.getDictList("annualCurrency"));
        view.addObject("listDisputes", SysDictUtils.getDictList("disputes"));
    }

    private void setDay(MicroExportVo vo){
        String tom = DateUtil.getTomorrow();
        String nextOne = ConstProp.BLANK_CHAR;
        try {
            nextOne = DateUtil.dateAdd(1,tom,1);
            nextOne = DateUtil.dateAdd(3,nextOne,-1);
        } catch (Exception e) {
            e.printStackTrace();
        }
        vo.setInception_date(tom);
        vo.setPlanned_end_date(nextOne);
    }

    private void gzxInit(ProductVo pd, ModelAndView view){
        view.setViewName("/coninsweb/api/gzx/policy/gzx_enterBasicInfo");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        //请求百保盾返回企业信息及员工信息
        SpecialPublicDutyVo vo = new SpecialPublicDutyVo();
        MailPolicyVo mVo = new MailPolicyVo();
        vo.setMailPolicyVo(mVo);
        if(StringUtils.isNotEmpty(userdetail.getWeb_type())){
            if(userdetail.getWeb_type().contains(ConstProp.PSS)){
                List<BLBCommunicationDto> actList = policyService.getBLBCommunicationDtoByUserID_PSSAPI(userdetail.getWeb_id(),pd.getProduct_code().split(ConstProp.MINUS)[2],userdetail.getWeb_type(),"");
                List<RoleSubjectVo> roleList = policyService.getRoleSubjectVoByUserID_PSSAPI(userdetail.getWeb_id(),userdetail.getWeb_type());
                if(roleList != null){
                    vo.setRoleSubjectList(roleList);
                }
                view.addObject("acts", actList);
            }
        }

        view.addObject(ConstProp.VO, vo);
        view.addObject(ConstProp.RECOMMEND_CODE,UserSupportUtil.getRecommendCode());
        OrderFormVo dto = new OrderFormVo();
        dto.setProduct_oid(pd.getOid());
        dto.setProduct_code(pd.getProduct_code());
        dto.setGross_premium(pd.getPremium_min());
        view.addObject(ConstProp.DTO,dto);
        view.addObject("comTypeList", IdType.comList());
        view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
    }

    private void ssbqInit(ProductVo pd, ModelAndView view){
        view.setViewName("/coninsweb/insurance/lawsuit/policy/enterBasicInfo_ss_1");
        view.addObject(ConstProp.RECOMMEND_CODE,UserSupportUtil.getRecommendCode());
        view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
    }

    private void gctbInit(ProductVo pd, ModelAndView view){
        view.setViewName("/coninsweb/insurance/build/policy/enterBasicInfo_bd");
        OrderFormVo dto = new OrderFormVo();
        dto.setProduct_oid(pd.getOid());
        dto.setProduct_code(pd.getProduct_code());
        dto.setGross_premium(pd.getPremium_min());
        view.addObject(ConstProp.DTO,dto);
        view.addObject(ConstProp.RECOMMEND_CODE, UserSupportUtil.getRecommendCode());
        view.addObject("otList", OfficeType.listT(pd.getProduct_code().contains("DB")?"DB":"OT"));
        view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
    }

    private void gclyInit(ProductVo pd, ModelAndView view){
        view.setViewName("/coninsweb/insurance/build/policy/enterBasicInfo_ly_1");
        OrderFormVo dto = new OrderFormVo();
        dto.setProduct_oid(pd.getOid());
        dto.setProduct_code(pd.getProduct_code());
        dto.setGross_premium(pd.getPremium_min());
        view.addObject(ConstProp.DTO,dto);
        view.addObject(ConstProp.RECOMMEND_CODE, UserSupportUtil.getRecommendCode());
        view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
    }
}
