package com.bcxin.ins.coninsweb.order.stragegy.order.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.ins.third.build.yangguang.YGGCService;
import com.bcxin.ins.third.build.yangguang.yggc.Result;
import com.bcxin.ins.third.build.yangguang.yggc.YGGC;
import com.bcxin.ins.service.order.InsTransactionAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.coninsweb.order.stragegy.order.OrderSupplyStrategy;
import com.bcxin.ins.coninsweb.order.stragegy.order.OrderSupplyType;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.vo.*;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.xiaoleilu.hutool.thread.ThreadUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;

/**
 * 支付请求策略
 * @author zxf
 * @date 2018/08/30
 * @说明 策略方案提议及案例提供人：hzp 2018/06/12
 */
@Component
@OrderSupplyType(type = OrderSupplyType.OrderSupplyTypeEnum.PAYMENT_REQUEST)
public class StragegyPaymentRequest implements OrderSupplyStrategy {

    @Autowired
    private PolicyService policyService;

    @Autowired
    private ProductService productService;

    @Autowired
    private InsTransactionAPIService insTransactionAPIService;

    @Autowired
    private YGGCService yGGCService;

    @Override
    public ModelAndView policyInitService(HttpServletRequest request, Long product_id) {
        return null;
    }

    @Override
    public ModelAndView getPolicyService(Long order_id, int page) {
        return null;
    }

    @Override
    public ResultDto pendingPolicyService(Object object, HttpServletRequest request) {
        return null;
    }

    @Override
    public ModelAndView confirmPolicyService(Long order_id) {
        return null;
    }

    @Override
    public ModelAndView paymentRequestService(Long order_id) {
        ModelAndView view = new ModelAndView();
        OrderFormVo vo = policyService.accordingToOrderIDToGetPolicyDto(order_id);
        ProductVo pd = productService.getProduct(Long.parseLong(vo.getProduct_oid()));
        if(StringUtils.isEmpty(pd.getProduct_code()) ? false : (pd.getProduct_code().contains(ConstProp.XYX_DQCK)||pd.getProduct_code().contains(ConstProp.XYX_XWCK))){
            xyxPayment(vo, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.BZX_SSBQ)){
            ssPayment(vo, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GZX)){
            gzxPayment(vo, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.TYX)){
            tyxPayment(vo, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GZZRX)){
            gzzrxPayment(vo, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.ZZX)){
            zzxPayment(vo, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : (pd.getProduct_code().contains(ConstProp.GCTB)||pd.getProduct_code().contains(ConstProp.GCLY))){
            gcPayment(vo, view);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GYX)){
            gyxPayment(vo, view);
        }
        view.addObject(ConstProp.PD,pd);
        view.addObject(ConstProp.DTO,vo);
        view.addObject(ConstProp.NOWTIME,new Date());
        return view;
    }

    @Override
    public ResultDto underwritingRequestService(HttpServletRequest request) {
        return null;
    }

    @Override
    public ResultDto insuranceCalculationService(HttpServletRequest request) {
        return null;
    }

    @Override
    public ResultDto getElectronicInsuranceService(Long order_id) {
        return null;
    }

    private void xyxPayment(OrderFormVo vo, ModelAndView view){
        if(vo.getPolicy_status().equals(DictConst.ORDER_STATUS_DSH)){//待核保
            view = new ModelAndView("/coninsweb/insurance/customs/transaction/waitOffer");
        }else if(vo.getPolicy_status().equals(DictConst.ORDER_STATUS_YCB)){//核保通过
            view = new ModelAndView("/coninsweb/insurance/customs/transaction/passUnderwriting");
        }else if(vo.getPolicy_status().equals(DictConst.ORDER_STATUS_YJB)){//拒保
            view = new ModelAndView("/coninsweb/insurance/customs/transaction/declinature");
        }else if(vo.getPolicy_status().equals(DictConst.ORDER_STATUS_YSH)){//已报价
            UnderwriteVo underwriteVo = policyService.accordingToOrderIDGainInsUnderwrite(Long.parseLong(vo.getOid()));
            view = new ModelAndView("/coninsweb/insurance/customs/transaction/offer");
            view.addObject("underwriteVo", underwriteVo);
        }else if(vo.getPolicy_status().equals(DictConst.ORDER_STATUS_HZF)){//待支付
            //TODO 最低保险费,保费缴纳方式 值未确定
            AdviceNoteVo anVo = policyService.accordingToOrderIDToGetAdviceNoteVo(Long.parseLong(vo.getOid()));
            String path_sign = policyService.accordingToOrderIDGainPathSign(Long.parseLong(vo.getOid()));
            view = new ModelAndView("/coninsweb/insurance/customs/transaction/paymentNotice");
            view.addObject(ConstProp.PATH_SIGN, path_sign);
            view.addObject(ConstProp.ANVO, anVo);
        }else if(vo.getPolicy_status().equals(DictConst.ORDER_STATUS_DCB)){//待承保
            if(org.apache.commons.lang.StringUtils.isEmpty(vo.getProduct_code()) ? false : ConstProp.XYX_XWCK.equals(vo.getProduct_code())){
                ThreadUtil.excAsync(()->{
                    policyService.yxTimer(Long.parseLong(vo.getOid()));
                },false);
                view = new ModelAndView("/coninsweb/insurance/customs/transaction/finishPay_xw");
            }else{
                view = new ModelAndView("/coninsweb/insurance/customs/transaction/finishPay");

            }
        }
    }
    private void ssPayment(OrderFormVo vo, ModelAndView view){
        if(vo.getPolicy_status().equals(DictConst.ORDER_STATUS_DSH)){//待核保
            view = new ModelAndView("/coninsweb/insurance/lawsuit/transaction/waitOffer");
        }else if(vo.getPolicy_status().equals(DictConst.ORDER_STATUS_YCB)){//核保通过
            view = new ModelAndView("/coninsweb/insurance/lawsuit/transaction/passUnderwriting");
        }else if(vo.getPolicy_status().equals(DictConst.ORDER_STATUS_YJB)){//拒保
            view = new ModelAndView("/coninsweb/insurance/lawsuit/transaction/declinature");
        }else if(vo.getPolicy_status().equals(DictConst.ORDER_STATUS_DZF)){//待支付
            //TODO 最低保险费,保费缴纳方式 值未确定
            try {
                AdviceNoteVo anVo = policyService.accordingToOrderIDToGetAdviceNoteVo(Long.parseLong(vo.getOid()));
                String path_sign = policyService.accordingToOrderIDGainPathSign(Long.parseLong(vo.getOid()));
                view = new ModelAndView("/coninsweb/insurance/transaction/paymentNotice");
                view.addObject(ConstProp.ANVO, anVo);
                view.addObject(ConstProp.PATH_SIGN, path_sign);
            }catch (Exception e){
                e.printStackTrace();
            }
        }else if(vo.getPolicy_status().equals(DictConst.ORDER_STATUS_DCB)){//待承保
            view = new ModelAndView("/coninsweb/insurance/lawsuit/transaction/finishPay");
        }
    }
    private void gzxPayment(OrderFormVo vo, ModelAndView view){
        if(StringUtils.isNotEmpty(vo.getPay_methods())){
            AdviceNoteVo anVo = policyService.accordingToOrderIDToGetAdviceNoteVo(Long.parseLong(vo.getOid()));
            view = new ModelAndView("/coninsweb/api/gzx/transaction/paymentNotice");
            view.addObject(ConstProp.ANVO, anVo);
        }else{
            if(vo.getPolicy_status().equals(ConstProp.DIGIT_TWO)){//待核保
                view = new ModelAndView("/coninsweb/api/gzx/transaction/waitOffer");
            }else if(vo.getPolicy_status().equals(ConstProp.DIGIT_SIX)){//核保通过
                view = new ModelAndView("/coninsweb/api/gzx/transaction/passUnderwriting");
            }else if(vo.getPolicy_status().equals(ConstProp.DIGIT_FIFTEEN)){//拒保
                view = new ModelAndView("/coninsweb/api/gzx/transaction/declinature");
            }else if(vo.getPolicy_status().equals(ConstProp.DIGIT_FOUR)){//待支付
                if(productService.api_request_sign(vo.getProduct_code()) == 2){//平安财
                    view = new ModelAndView("/coninsweb/api/gzx/transaction/policyPayment_PAC");
                }
            }else if(vo.getPolicy_status().equals(ConstProp.DIGIT_FIVE)){//待承保
                view = new ModelAndView("/coninsweb/api/gzx/transaction/finishPay");
            }
        }
    }
    private void tyxPayment(OrderFormVo vo, ModelAndView view){
        if(StringUtils.isNotEmpty(vo.getPay_methods())&&productService.api_request_sign(vo.getProduct_code()) == ConstProp.INT_NUMBER_ONE){
            AdviceNoteVo anVo = policyService.accordingToOrderIDToGetAdviceNoteVo(Long.parseLong(vo.getOid()));
            view.setViewName("/coninsweb/api/gmr/transaction/paymentNotice");
            view.addObject(ConstProp.ANVO, anVo);
        }else{
            if(vo.getPolicy_status().equals(ConstProp.DIGIT_TWO)){//待核保
                view.setViewName("/coninsweb/api/gmr/transaction/waitOffer");
            }else if(vo.getPolicy_status().equals(ConstProp.DIGIT_SIX)){//核保通过
                view.setViewName("/coninsweb/api/gmr/transaction/passUnderwriting");
            }else if(vo.getPolicy_status().equals(ConstProp.DIGIT_FIFTEEN)){//拒保
                view.setViewName("/coninsweb/api/gmr/transaction/declinature");
            }else if(vo.getPolicy_status().equals(ConstProp.DIGIT_FOUR)){//待支付
                if(productService.api_request_sign(vo.getProduct_code()) == ConstProp.INT_NUMBER_ONE){//跳转泰康支付页面
                    view.setViewName("/coninsweb/api/gmr/transaction/policyPayment");
                }else if(productService.api_request_sign(vo.getProduct_code()) == ConstProp.INT_NUMBER_TWO){//跳转平安支付页面
                    view.setViewName("/coninsweb/api/gmr/transaction/policyPayment_PA");
                }else if(productService.api_request_sign(vo.getProduct_code()) == ConstProp.INT_NUMBER_FOUR){//跳转平安支付页面
                    view.setViewName("/coninsweb/api/gmr/transaction/policyPayment_RB");
                }else{
                    //失败界面
                }
            }else if(vo.getPolicy_status().equals(ConstProp.DIGIT_FIVE)){//待承保
                view.setViewName("/coninsweb/api/gmr/transaction/finishPay");
            }
        }
    }
    private void gzzrxPayment(OrderFormVo vo, ModelAndView view){
        try {
            policyService.payUrlChange(Long.parseLong(vo.getOid()));
        } catch (Exception e) {
            e.printStackTrace();
        }
        //待支付
        if(vo.getPolicy_status().equals(ConstProp.DIGIT_FOUR)){
            //人保支付页面
            if(vo.getProduct_code().contains(ConstProp.GZZRX_RB)){
                view = new ModelAndView("/coninsweb/api/gzzrx/transaction/policyPaymentRB");
            }
        }
    }
    private void zzxPayment(OrderFormVo vo, ModelAndView view){
        if(vo.getPolicy_status().equals(ConstProp.DIGIT_TWO)){//待核保
            view = new ModelAndView("/coninsweb/api/lote/transaction/waitOffer");
        }else if(vo.getPolicy_status().equals(ConstProp.DIGIT_SIX)){//核保通过
            view = new ModelAndView("/coninsweb/api/lote/transaction/passUnderwriting");
        }else if(vo.getPolicy_status().equals(ConstProp.DIGIT_FIFTEEN)){//拒保
            view = new ModelAndView("/coninsweb/api/lote/transaction/declinature");
        }else if(vo.getPolicy_status().equals(ConstProp.DIGIT_FOUR)){//待支付
            if(productService.api_request_sign(vo.getProduct_code()) == 1){//众安
                view = new ModelAndView("/coninsweb/api/lote/transaction/policyPayment_ZA");
            }else if(productService.api_request_sign(vo.getProduct_code()) == 2){//平安财
                view = new ModelAndView("/coninsweb/api/lote/transaction/policyPayment_PAC");
            }else if(productService.api_request_sign(vo.getProduct_code()) == 3){//永安
                view = new ModelAndView("/coninsweb/api/lote/transaction/policyPayment_YA");
                List<InsTransaction> tList = insTransactionAPIService.selectInsTransactionByInsOrderForm(Long.parseLong(vo.getOid()));
                if(tList.size()>0){
                    String du = tList.get(0).getDeal_url();
                    view.addObject("deal_url",du);
                }
            }
        }else if(vo.getPolicy_status().equals(ConstProp.DIGIT_FIVE)){//待承保
            view = new ModelAndView("/coninsweb/api/lote/transaction/finishPay");
        }
    }
    private void gcPayment(OrderFormVo vo, ModelAndView view){
        if (vo.getPolicy_status().equals(ConstProp.DIGIT_TWO)) {//待核保
            view = new ModelAndView("/coninsweb/insurance/build/transaction/waitOffer");
        } else if (vo.getPolicy_status().equals(ConstProp.DIGIT_SIX)) {//承保通过
            view = new ModelAndView("/coninsweb/insurance/build/transaction/finishPay");
            view.addObject("code", ConstProp.CODE_SUCCESS);
            view.addObject("msg", "支付成功！");
        } else if (vo.getPolicy_status().equals(ConstProp.DIGIT_FIFTEEN)) {//拒保
            view = new ModelAndView("/coninsweb/insurance/build/transaction/declinature");
        } else if (vo.getPolicy_status().equals(ConstProp.DIGIT_FOUR)) {//待支付
            if (StringUtils.isEmpty(vo.getProduct_code()) ? false : ConstProp.BZX_TB_GCTB.equals(vo.getProduct_code())) {
                view = new ModelAndView("/coninsweb/insurance/build/transaction/policyPayment");
            } else if (StringUtils.isEmpty(vo.getProduct_code()) ? false : ConstProp.BZX_YG_GCTB.equals(vo.getProduct_code())) {
                String url = null;
                boolean isSuccess = true;
                try {
                    SpecialBidVo specialBidVo = policyService.accordingToOrderIDToGetSpecialBidVo(Long.valueOf(vo.getOid()));
                    Result result = yGGCService.underwritingHttpSend(JSON.toJSONString(YGGC.getDemo(vo, specialBidVo)), "1");
                    String errorCode = result.getTbResultList().get(0).getErrorCode();
                    String policyNo = result.getTbResultList().get(0).getPolicyNo();
                    String premiumP = specialBidVo.getPremium();
                    if ("SUCCESS00000".equals(errorCode)) {
                        R r = yGGCService.payUrlZFB(policyNo, premiumP);
                        if (r.getSuccess()) {
                            PolicyTransactionVo pvo = new PolicyTransactionVo();
                            pvo.setPolicy_id(vo.getOid());
                            pvo.setPolicy_serial_number(policyNo);//设置投保单号
                            policyService.saveTransaction(pvo);
                            url = r.getMsg();
                        }
                    } else {
                        String operateMessage = result.getTbResultList().get(0).getOperateMessage();
                        isSuccess = false;
                        url = "/insurance/build/policy/updateOrderFormStatus";
                        view.addObject("wrongMessage", operateMessage);
                    }
                    view = new ModelAndView("/coninsweb/insurance/build/transaction/policyPaymentYG");
                    view.addObject("oid", vo.getOid());
                    view.addObject("isSuccess", isSuccess);
                    view.addObject("url", url);

                } catch (Exception e) {
                    e.printStackTrace();
                }
            }else if (StringUtils.isEmpty(vo.getProduct_code()) ? false : "BZX-DB-GCTB".equals(vo.getProduct_code())) {
                view = new ModelAndView("/coninsweb/insurance/build/transaction/policyPaymentDB");
            } else if (StringUtils.isEmpty(vo.getProduct_code()) ? false : "BZX-GCLY".equals(vo.getProduct_code())) {
                //TODO 最低保险费,保费缴纳方式 值未确定
                AdviceNoteVo anVo = policyService.accordingToOrderIDToGetAdviceNoteVo(Long.parseLong(vo.getOid()));
                String path_sign = policyService.accordingToOrderIDGainPathSign(Long.parseLong(vo.getOid()));
                view = new ModelAndView("/coninsweb/insurance/transaction/paymentNotice");
                view.addObject(ConstProp.ANVO, anVo);
                view.addObject(ConstProp.PATH_SIGN, path_sign);
            }
        } else if (vo.getPolicy_status().equals(ConstProp.DIGIT_FIVE)) {//待承保
            view = new ModelAndView("/coninsweb/insurance/build/transaction/finishPay_ly");
        }
    }

    private void gyxPayment(OrderFormVo vo, ModelAndView view){
        if(StringUtils.isNotEmpty(vo.getPay_methods())){
            AdviceNoteVo anVo = policyService.accordingToOrderIDToGetAdviceNoteVo(Long.parseLong(vo.getOid()));
            view = new ModelAndView("/coninsweb/api/gyx/transaction/paymentNotice");
            view.addObject(ConstProp.ANVO, anVo);
        }else{
            if(vo.getPolicy_status().equals(ConstProp.DIGIT_FOUR)){//待支付
                if(ConstProp.GYX.equals(vo.getProduct_code().split(ConstProp.MINUS)[0])){//跳转太保支付页面
                    view = new ModelAndView("/coninsweb/api/gyx/transaction/policyPayment_TB");
                }else{
                    //失败界面
                }
            }else if(vo.getPolicy_status().equals(ConstProp.DIGIT_FIVE)){//待承保
                view = new ModelAndView("/coninsweb/api/gyx/transaction/finishPay");
            }
        }
    }
}
