package com.bcxin.ins.coninsweb.order.stragegy.order.impl;

import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.coninsweb.order.stragegy.order.OrderSupplyStrategy;
import com.bcxin.ins.coninsweb.order.stragegy.order.OrderSupplyType;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;

/**
 * 获取电子保单策略
 * @author zxf
 * @date 2018/08/30
 * @说明 策略方案提议及案例提供人：hzp 2018/06/12
 */
@Component
@OrderSupplyType(type = OrderSupplyType.OrderSupplyTypeEnum.INSURANCE_CALCULATION)
public class StragegyElectronicInsurance implements OrderSupplyStrategy {

    @Autowired
    private PolicyService policyService;

    @Autowired
    private ProductService productService;

    @Override
    public ModelAndView policyInitService(HttpServletRequest request, Long product_id) {
        return null;
    }

    @Override
    public ModelAndView getPolicyService(Long order_id, int page) {
        return null;
    }

    @Override
    public ResultDto pendingPolicyService(Object object, HttpServletRequest request) {
        return null;
    }

    @Override
    public ModelAndView confirmPolicyService(Long order_id) {
        return null;
    }

    @Override
    public ModelAndView paymentRequestService(Long order_id) {
        return null;
    }

    @Override
    public ResultDto underwritingRequestService(HttpServletRequest request) {
        return null;
    }

    @Override
    public ResultDto insuranceCalculationService(HttpServletRequest request) {
        return null;
    }

    @Override
    public ResultDto getElectronicInsuranceService(Long order_id) {
        //订单基础信息
        OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(order_id);
        if(StringUtils.isEmpty(dto.getProduct_code()) ? false : dto.getProduct_code().contains(ConstProp.XYX_DQCK)){

        }else if(StringUtils.isEmpty(dto.getProduct_code()) ? false : dto.getProduct_code().contains(ConstProp.XYX_XWCK)){
            if(dto.getProduct_code().indexOf(ConstProp.XYX_XWCK)!=-1){
                String path = policyService.HTTP_TPC_XYX_DZBD(order_id);
                if(StringUtils.isNotEmpty(path)){
                    return new ResultDto(ConstProp.BLANK_CHAR, ConstProp.CODE_SUCCESS, path, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
                }
                return new ResultDto("获取电子保单失败，请联系客服人员", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }
            return new ResultDto("电子保单下载异常，请联系客服人员", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
        }else if(StringUtils.isEmpty(dto.getProduct_code()) ? false : dto.getProduct_code().contains(ConstProp.BZX_SSBQ)){

        }else if(StringUtils.isEmpty(dto.getProduct_code()) ? false : dto.getProduct_code().contains(ConstProp.GZX)){
            if(dto.getProduct_code().indexOf(ConstProp.GZX_PAC)!=-1&&StringUtils.isEmpty(dto.getInsure_path())){
                policyService.HTTP_PAC_GZX_DZBD(order_id,null,dto);
            }
            if(StringUtils.isNotEmpty(dto.getInsure_path())){
                return new ResultDto(ConstProp.BLANK_CHAR, ConstProp.CODE_SUCCESS, dto.getInsure_path(), ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }
            return new ResultDto("电子保单生成中(这可能需要半个小时，请稍后重试)...", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
        }else if(StringUtils.isEmpty(dto.getProduct_code()) ? false : dto.getProduct_code().contains(ConstProp.TYX)){
            if(productService.api_request_sign(dto.getProduct_code()) == 2){
                try {
                    policyService.HTTP_PAS_TYX_DZBD(order_id, null, dto);
                } catch (Exception e) {
                    return new ResultDto("异常信息："+e.getMessage(), ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
                }
            }
            if(StringUtils.isNotEmpty(dto.getInsure_path())){
                return new ResultDto(ConstProp.BLANK_CHAR, ConstProp.CODE_SUCCESS, dto.getInsure_path(), ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }
            return new ResultDto("电子保单生成中(这可能需要半个小时，请稍后重试)...", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
        }else if(StringUtils.isEmpty(dto.getProduct_code()) ? false : dto.getProduct_code().contains(ConstProp.GZZRX)){
            if(productService.api_request_sign(dto.getProduct_code()) == 2){
                try {
                    policyService.HTTP_PAS_TYX_DZBD(order_id, null, dto);
                } catch (Exception e) {
                    return new ResultDto("异常信息："+e.getMessage(), ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
                }
            }
            if(StringUtils.isNotEmpty(dto.getInsure_path())){
                return new ResultDto(ConstProp.BLANK_CHAR, ConstProp.CODE_SUCCESS, dto.getInsure_path(), ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }
            return new ResultDto("电子保单生成中(这可能需要半个小时，请稍后重试)...", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
        }else if(StringUtils.isEmpty(dto.getProduct_code()) ? false : dto.getProduct_code().contains(ConstProp.ZZX)){
            if(dto.getProduct_code().indexOf("ZZX-PAC")!=-1){
                String path = policyService.HTTP_PAC_ZZX_DZBD(order_id);
                if(StringUtils.isNotEmpty(path)){
                    return new ResultDto(ConstProp.BLANK_CHAR, ConstProp.CODE_SUCCESS, path, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
                }
                return new ResultDto("获取电子保单失败，请联系客服人员", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }
            return new ResultDto("电子保单下载异常，请联系客服人员", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
        }else if(StringUtils.isEmpty(dto.getProduct_code()) ? false : dto.getProduct_code().contains(ConstProp.GCTB)){
            if(dto.getProduct_code().indexOf("GCTB-YG")!=-1){
                String path = policyService.HTTP_YG_BUILD_DZBD(String.valueOf(order_id));
                if(StringUtils.isNotEmpty(path)){
                    return new ResultDto("电子保单下载地址获取成功", ConstProp.CODE_SUCCESS, "请求ID:" + order_id, ConstProp.BLANK_CHAR, path);
                }
            }
            return new ResultDto("保单下载请求失败", ConstProp.CODE_FAILURE, "请求ID:" + order_id, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
        }else if(StringUtils.isEmpty(dto.getProduct_code()) ? false : dto.getProduct_code().contains(ConstProp.GCLY)){

        }
        return null;
    }


}
