package com.bcxin.ins.coninsweb.order.stragegy.order;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 投保流程处理步骤注解
 * @author hzp
 * @date 2018/06/12
 */
@Target(ElementType.TYPE)//表示只能给类添加该注解
@Retention(RetentionPolicy.RUNTIME)//这个必须要将注解保留在运行时
public @interface OrderSupplyType {

    OrderSupplyTypeEnum type() default OrderSupplyTypeEnum.POLICY_INIT;

    public enum OrderSupplyTypeEnum{

        //初始化投保页面数据
        POLICY_INIT("POLICY_INIT","初始化投保页面数据"),
        //继续投保（返回修改）操作加载数据
        GET_POLICY("GET_POLICY","继续投保（返回修改）操作加载数据"),
        //不同产品投保页面表单数据提交更新数据库
        PENDING_POLICY("PENDING_POLICY","不同产品投保页面表单数据提交更新数据库"),
        //确认订单页面加载数据
        CONFIRM_POLICY("CONFIRM_POLICY","确认订单页面加载数据"),
        //保费计算
        INSURANCE_CALCULATION("INSURANCE_CALCULATION","保费计算"),
        //支付请求
        PAYMENT_REQUEST("PAYMENT_REQUEST","支付请求"),
        //核保请求
        UNDERWRITING_REQUEST("UNDERWRITING_REQUEST","核保请求");

        private String key;
        private String alias;

        private OrderSupplyTypeEnum(String key,String alias){
            this.key=key;
            this.alias=alias;
        }

        public String getKey() {
            return this.key;
        }

        public String getAlias(){
            return this.alias;
        }

        public static String getAlias(String key){
            for(OrderSupplyTypeEnum e : OrderSupplyTypeEnum.values()){
                if(e.getKey().equals(key)){
                    return e.getAlias();
                }
            }
            return "";
        }
    }
}
