package com.bcxin.ins.coninsweb.order.controller.lawsuit;

import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.util.Constant;
import com.bcxin.ins.util.DSUtil;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.vo.*;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;

/**
 * 负责前台诉讼类投保流程的业务逻辑处理
 * @author luopeng
 *
 */
@Controller
@RequestMapping("/insurance/lawsuit")
public class Lawsuit_Policy_Controller extends BaseController {

	@Autowired
	private ProductService productService;
	@Autowired
	private PolicyService policyService;


	/**
	 * 新跳到投保界面方法
	 * @param request
	 * @param product_id
	 * @param model
	 * @return
	 */
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】产品-访问投保页")
	@RequestMapping("/policyInit/{product_id}")
	public ModelAndView policyInit(HttpServletRequest request, @PathVariable Long product_id, ModelMap model) throws Exception {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if (  userdetail == null ) {
			return new ModelAndView(DSUtil.operation()+"/insurance/lawsuit/policyInit/"+product_id);
		}
		ModelAndView view = new ModelAndView();
		ProductVo pd = productService.getProduct(product_id);
		view.addObject(ConstProp.RECOMMEND_CODE,UserSupportUtil.getRecommendCode());
		view.addObject(ConstProp.USERDETAIL,userdetail);
		view.addObject(ConstProp.PD,pd);
		view.addObject("sigId", String.valueOf(IdWorker.getId()));//普通的页面标识
		view.setViewName("/coninsweb/insurance/lawsuit/policy/enterBasicInfo_ss_1");
		initEnumList(view);
		setTokenByApi(view);
		return view;
	}

	private void initEnumList(ModelAndView view){
		view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
	}

	/**
	 * <b>履约投保单向下3页操作到确认投保界面 </b>
	 *
	 * @param reqeust 页码投保单数据
	 * @return
	 * @throws Exception
	 * @author ZXF
	 * @date 2016年12月28日 下午4:20:11
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/policy/lt_policy/{order_id}/{page}")
	public ModelAndView pg_policy(@PathVariable Long order_id, @PathVariable int page, HttpServletRequest reqeust) throws Exception{

		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if (  userdetail == null ) {
			return new ModelAndView(DSUtil.operation()+"/insurance/lawsuit/policy/lt_policy/"+order_id+ConstProp.SLASH+page);
		}
		ModelAndView view = new ModelAndView();
		view.addObject(ConstProp.USERDETAIL,userdetail);
		if(page <= 0){
			return view;
		}
		view.addObject(ConstProp.DTO,policyService.accordingToOrderIDToGetPolicyDto(order_id));
		if(page == 1){
			view.setViewName("/coninsweb/insurance/lawsuit/policy/enterBasicInfo_ss_1");
			//第一页内容存储
			SpecialLitigationVo_1 vo = policyService.accordingToOrderIDToGetSpecialLitigationVo_1(order_id);
			view.addObject(ConstProp.VO,vo);
			view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
			if(StringUtils.isNotEmpty(vo.getProvince())){
				view.addObject(ConstProp.CITYLIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getProvince()));
			}
			if(StringUtils.isNotEmpty(vo.getProvince())){
				view.addObject(ConstProp.AREALIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_THREE, vo.getCity()));
			}
			if(vo.getRoleSubjectList().size()<=0){
				initEnumList(view);
				setTokenByApi(view);
				return view;
			}
			//投保人地址
			if(StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getReg_province())){
				view.addObject(ConstProp.REG_CITYLIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getRoleSubjectList().get(0).getReg_province()));
			}
			if(StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getReg_city())){
				view.addObject(ConstProp.REG_AREALIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_THREE, vo.getRoleSubjectList().get(0).getReg_city()));
			}
		}else if(page == 2){
			view.setViewName("/coninsweb/insurance/lawsuit/policy/enterBasicInfo_ss_2");
			//第二页内容存储
			SpecialLitigationVo_2 vo = policyService.accordingToOrderIDToGetSpecialLitigationVo_2(order_id);
			view.addObject(ConstProp.VO,vo);
			view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
			view.addObject(ConstProp.BANKCITYLIST,RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getMailPolicyVo().getBank_province()));
		}else if(page == 3){
			view.setViewName("/coninsweb/insurance/lawsuit/policy/enterBasicInfo_ss_3");
			//第三页内容存储
			view.addObject(ConstProp.VO,policyService.accordingToOrderIDToGetSpecialLitigationVo_3(order_id));
		}
		initEnumList(view);
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b>投标/履约保险投保界面跳转到确认页面中间的业务 </b>
	 *
	 * @param order_id
	 * @param reqeust
	 * @return
	 * @throws Exception
	 * @author ZXF
	 * @date 2016年12月28日 下午4:21:44
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/policy/confirmPage/{order_id}")
	public ModelAndView confirmPage(@PathVariable Long order_id, HttpServletRequest reqeust) throws Exception{

		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if (  userdetail == null ) {
			return new ModelAndView(DSUtil.operation()+"/insurance/lawsuit/policy/confirmPage/"+order_id);
		}
		ModelAndView view = new ModelAndView();
		view.addObject(ConstProp.USERDETAIL,userdetail);
		view.addObject(ConstProp.DTO,policyService.accordingToOrderIDToGetPolicyDto(order_id));
		view.setViewName("/coninsweb/insurance/lawsuit/policy/policyConfirm_ss");
		SpecialLitigationVo_1 vo1 = policyService.accordingToOrderIDToGetSpecialLitigationVo_1(order_id);
		SpecialLitigationVo_2 vo2 = policyService.accordingToOrderIDToGetSpecialLitigationVo_2(order_id);
		SpecialLitigationVo_3 vo3 = policyService.accordingToOrderIDToGetSpecialLitigationVo_3(order_id);
		view.addObject(ConstProp.VO1,vo1);
		view.addObject(ConstProp.VO2,vo2);
		view.addObject(ConstProp.VO3,vo3);
		view.addObject(ConstProp.REG_POLICY, RegionUtils.getRegionNameByALLCode(vo1.getProvince(),vo1.getCity(),vo1.getArea_code()));
		view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo1.getRoleSubjectList().get(0).getReg_province(),vo1.getRoleSubjectList().get(0).getReg_city(),vo1.getRoleSubjectList().get(0).getReg_district()));
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b>企业短期第一页投保单客户填一半暂存，方法 </b>
	 *
	 * @param reqeust
	 * @param response
	 * @param model
	 * @return
	 * @throws Exception
	 * @author ZXF
	 * @date 2016年12月21日 下午1:47:55
	 * @注意事项 </b>
	 * <b>
	 */
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT_ORDER,title ="【请求】产品-订单投保")
	@RequestMapping("/policy/pendingSpecialLitigation_1VoPolicy")
	@ResponseBody
	public ResultDto pendingSpecialLitigation_1VoPolicy(SpecialLitigationVo_1 vo, HttpServletRequest reqeust, HttpServletResponse response, ModelMap model) throws Exception{
		String recommendCode = reqeust.getParameter(ConstProp.RECOMMEND_CODE);
		return policyService.pendingSpecialLitigation_1VoPolicy(vo, recommendCode);
	}

	/**
	 * <b>企业短期第二页投保单客户填一半暂存，方法 </b>
	 *
	 * @param reqeust
	 * @param response
	 * @param model
	 * @return
	 * @throws Exception
	 * @author ZXF
	 * @date 2016年12月21日 下午1:47:55
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/policy/pendingSpecialLitigation_2VoPolicy")
	@ResponseBody
	public ResultDto pendingSpecialLitigation_2VoPolicy(SpecialLitigationVo_2 vo, HttpServletRequest reqeust, HttpServletResponse response, ModelMap model) throws Exception{
		return policyService.pendingSpecialLitigation_2VoPolicy(vo);
	}

	/**
	 * <b>企业短期第三页投保单客户填一半暂存，方法 </b>
	 *
	 * @param reqeust
	 * @param response
	 * @param model
	 * @return
	 * @throws Exception
	 * @author ZXF
	 * @date 2016年12月21日 下午1:47:55
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/policy/pendingSpecialLitigation_3VoPolicy")
	@ResponseBody
	public ResultDto pendingSpecialLitigation_3VoPolicy(SpecialLitigationVo_3 vo, HttpServletRequest reqeust, HttpServletResponse response, ModelMap model) throws Exception{
		return policyService.pendingSpecialLitigation_3VoPolicy(vo);
	}


	/**
	 * <b>修改订单状态</b>
	 *
	 * @return
	 * @throws Exception
	 * @author ZXF
	 * @date 2016年12月21日 下午1:47:55
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/policy/updateOrderFormStatus")
	@ResponseBody
	public ResultDto updateOrderFormStatus( HttpServletRequest reqeust) throws Exception{

		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if ( userdetail == null ) {
			return new ResultDto("账户已过期，请登录后操作", ConstProp.SLASH);
		}
		String order_id = reqeust.getParameter(ConstProp.ORDER_ID);
		String status = reqeust.getParameter("status");
		if(StringUtils.isEmpty(order_id) || StringUtils.isEmpty(status)){
			return new ResultDto("数据丢失，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		OrderFormVo vo = new OrderFormVo();
		vo.setOid(String.valueOf(order_id));
		vo.setPolicy_status(status);
		String orderID = policyService.updateOrderFormStatus(vo);
		if(StringUtils.isNotEmpty(orderID)){
			return new ResultDto("订单录入成功。", ConstProp.CODE_SUCCESS, orderID, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}else{
			return new ResultDto("数据丢失，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	/**
	 * <b>业务逻辑处理，保存保单信息
	 * 页面流转：点击保单保存，跳转支付页面 </b>
	 *
	 * @return
	 * @author ZXF
	 * @date 2016年12月21日 下午1:46:17
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/policy/policyPayment/{oid}")
	public ModelAndView policyPayment(@PathVariable long oid) {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(userdetail == null){
			return new ModelAndView(DSUtil.operation()+"/insurance/lawsuit/policy/policyPayment/"+oid);
		}
		OrderFormVo vo = policyService.accordingToOrderIDToGetPolicyDto(oid);
		ModelAndView view = null;
		if(vo.getPolicy_status().equals(ConstProp.DIGIT_TWO)){//待核保
			view = new ModelAndView("/coninsweb/insurance/lawsuit/transaction/waitOffer");
		}else if(vo.getPolicy_status().equals(ConstProp.DIGIT_SIX)){//核保通过
			view = new ModelAndView("/coninsweb/insurance/lawsuit/transaction/passUnderwriting");
		}else if(vo.getPolicy_status().equals(ConstProp.DIGIT_FIFTEEN)){//拒保
			view = new ModelAndView("/coninsweb/insurance/lawsuit/transaction/declinature");
		}else if(vo.getPolicy_status().equals(ConstProp.DIGIT_FOUR)){//待支付
			//TODO 最低保险费,保费缴纳方式 值未确定
			try {
				AdviceNoteVo anVo = policyService.accordingToOrderIDToGetAdviceNoteVo(oid);
				String path_sign = policyService.accordingToOrderIDGainPathSign(oid);
				view = new ModelAndView("/coninsweb/insurance/transaction/paymentNotice");
				view.addObject(ConstProp.ANVO, anVo);
				view.addObject(ConstProp.PATH_SIGN, path_sign);
			}catch (Exception e){
				e.printStackTrace();
			}
		}else if(vo.getPolicy_status().equals(ConstProp.DIGIT_FIVE)){//待承保
			view = new ModelAndView("/coninsweb/insurance/lawsuit/transaction/finishPay");
		}
		view.addObject(ConstProp.USERDETAIL,userdetail);
		view.addObject(ConstProp.NOWTIME,new Date());
		view.addObject(ConstProp.DTO,vo);
		setTokenByApi(view);
		return view;
	}

	@RequestMapping("/policy/deleteLnAccusedByOid")
	@ResponseBody
	public ResultDto deleteLnAccusedByOid(HttpServletRequest request) {
		String lna_id = request.getParameter("lna_id");
		if(StringUtils.isEmpty(lna_id)){
			return new ResultDto("数据丢失，删除失败！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		if(policyService.deleteLnAccusedByOid(lna_id)){
			return new ResultDto("删除成功！", ConstProp.CODE_SUCCESS,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}else{
			return new ResultDto("运行时异常，删除失败！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

}
