package com.bcxin.ins.coninsweb.order.controller.insurance.tyx;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;

/**
 * 团意险产品相关业务逻辑处理（不包括后台产品配置）
 * @author zxf
 *
 */
@Controller
@RequestMapping("/insurance/tyx/product")
public class TYXProductController extends BaseController {

	@Autowired
	private ProductService productService;
	@Autowired
	private PolicyService policyService;

	private static String CTXSTATIC = "ctxStatic";//百宝盾web页面服务器访问地址



	/**
	 * <b>前台页面产品详情 </b> 
	 * 
	 * @param request
	 * @param oid
	 * @return
	 * @author ZXF 
	 * @date 2016年12月21日 下午1:40:41
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/productInfo/{oid}")
	public ModelAndView productInfo(HttpServletRequest request, @PathVariable long oid) {
		ModelAndView view = new ModelAndView();
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		ProductVo pd = productService.getProduct(oid);
		if(StringUtils.isNotEmpty(pd.getOid())){
			view.addObject(ConstProp.SHAREPATH,productService.setSharePath(oid,userdetail));
		}else{
			return null;
		}
		if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.TYX_PAS)){
			view.setViewName("/coninsweb/insurance/tyx/product/gmr_pn_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.TYX_PAC)){
			view.setViewName("/coninsweb/insurance/tyx/product/gmr_pnc_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.TYX_TK)){
			view.setViewName("/coninsweb/insurance/tyx/product/gmr_tk_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.TYX_RB)){
			view.setViewName("/coninsweb/insurance/tyx/product/gmr_rb_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.TYX_CA)){
			view.setViewName("/coninsweb/insurance/tyx/product/gmr_ca_product_info");
		}else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.TYX_QH)){
			view.setViewName("/coninsweb/insurance/tyx/product/gmr_qh_product_info");
		}

		view.addObject(ConstProp.PRODUCTDTO, pd);
		setTokenByApi(view);
		return view;
	}

	@RequestMapping( value={"occupation_table"})
	public ModelAndView policies_1(HttpServletRequest request){
		ModelAndView view = new ModelAndView("/coninsweb/insurance/tyx/occupation_table");
		setTokenByApi(view);
		return view;
	}

}
