package com.bcxin.ins.coninsweb.order.controller.api.gzzrx.renbao;

import com.bcxin.ins.spring.executor.MyAsyncExecutor;
import com.bcxin.ins.third.gzzrx.renbao.GZZRX_PackageMessageRenBao;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.service.order.InsTransactionAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.preservation.InsPreservationPayAPIService;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.PolicyTransactionVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

/**
 * <b>人保-雇主责任险接口Controller控制器，用于回调</b>
 *
 * @author zxf
 * @date 2017年10月11日 上午10:29:46
 * @注意事项 </b>
 * <b>
 */
@Controller
public class GZZRX_RB_API_Controller extends BaseController {


	@Autowired
	private InsTransactionAPIService insTransactionAPIService;
	@Autowired
	private PolicyService policyService;
	@Autowired
	private InsPreservationPayAPIService insPreservationPayAPIService;

	@Autowired
	private MyAsyncExecutor myAsyncExecutor;
	/**
	 * 批单接口回调
	 */
	@RequestMapping(value = "/RB-API/GZZRX/callback-rider")
	public void callbackPay(@RequestBody String xml) throws UnsupportedEncodingException {
		if(xml.contains("%3C%")){
			xml = URLDecoder.decode(xml, ConstProp.ENCODE_UTF8);
		}
		logger.info("批单接口回调-callback-rider-RB-GZZRX：请求报文-"+xml);
		GZZRX_PackageMessageRenBao gpm = new GZZRX_PackageMessageRenBao();
		String result = gpm.returnAnalysisXML(xml, TransTypeEnum.HDZF.getValue());
		logger.info("批单接口回调-callback-rider-RB-GZZRX：接口返回数据-"+result);
		String msg = "接收失败";
		if (StringUtils.isNotEmpty(result)
				&&ConstProp.CODE_SUCCESS.equals(result.split(ConstProp.POUND_SIGN)[0])) {
			boolean flag = insPreservationPayAPIService.updatePayStatusBySerialNum(result.split(ConstProp.POUND_SIGN)[1]);
			if(flag){
				msg = "接收成功";
			}
		}
		renderString(response, msg, ConstProp.CT_JSON);
		logger.info("批单接口回调-callback-rider-RB-GZZRX：业务结束：end");
	}

	/**
	 * 保单接口回调
	 * @param xml 请求报文
	 */
	@RequestMapping(value = "/RB-API/GZZRX/callback-policy")
	public void callbackPolicy(@RequestBody String xml) throws UnsupportedEncodingException {
		if(xml.contains("%3C%")){
			xml = URLDecoder.decode(xml, ConstProp.ENCODE_UTF8);
		}
		logger.info("保单生效接口回调-callback-policy-RB-GZZRX：请求报文-"+xml);
		GZZRX_PackageMessageRenBao gpm = new GZZRX_PackageMessageRenBao();
		String result = gpm.returnAnalysisXML(xml, TransTypeEnum.HDCB.getValue());
		logger.info("保单生效接口回调-callback-policy-RB-GZZRX：接口返回数据-"+result);
		String msg = "接收失败";
		if(StringUtils.isEmpty(result)){
			renderString(response, msg, ConstProp.CT_JSON);
			logger.info("保单生效接口回调-callback-policy-RB-GZZRX：业务结束：end");
			return;
		}
		if(!ConstProp.CODE_SUCCESS.equals(result.split(ConstProp.POUND_SIGN)[0])){
			renderString(response, msg, ConstProp.CT_JSON);
			logger.info("保单生效接口回调-callback-policy-RB-GZZRX：业务结束：end");
			return;
		}
		OrderFormVo orderVo = policyService.getPolicyDtoByRcptNo(result.split(ConstProp.POUND_SIGN)[1]);
		if(orderVo == null){
			renderString(response, msg, ConstProp.CT_JSON);
			logger.info("保单生效接口回调-callback-policy-RB-GZZRX：业务结束：end");
			return;
		}
		if(StringUtils.isEmpty(orderVo.getExternal_reference())){
			PolicyTransactionVo vo= new PolicyTransactionVo();
			//保存保单号
			vo.setPolicy_number(result.split(ConstProp.POUND_SIGN)[2]);//policy.setExternalReference();
			vo.setPolicy_id(orderVo.getOid());
			insTransactionAPIService.savePolicyExternalReference(vo);
			if(result.split(ConstProp.POUND_SIGN).length == 4){
				//保存保单地址
				vo.setInsure_path(result.split(ConstProp.POUND_SIGN)[3]);//保单地址
				insTransactionAPIService.savePolicyOther(vo);
			}
			myAsyncExecutor.execute(()->{
				try {
					//返回订单给指定平台
					policyService.returnsAnOrderToTheSpecifiedPlatform(orderVo.getOid());
				} catch(Exception e) {
					logger.error("------------雇主责任险推送百保盾，异常："+e.getMessage());
				}
			});
		}
		msg = "接收成功";
		renderString(response, msg, ConstProp.CT_JSON);
		logger.info("保单生效接口回调-callback-policy-RB-GZZRX：业务结束：end");
	}
}

