package com.bcxin.ins.coninsweb.common.controller;

import com.bcxin.ins.service.order.ComRegionAPIService;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.util.SysDictUtils;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.spring.executor.MyAsyncExecutor;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.util.Constant;
import com.bcxin.ins.util.DSUtil;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.util.enums.IdType;
import com.bcxin.ins.util.enums.NatureLinkage;
import com.bcxin.ins.util.enums.OfficeType;
import com.bcxin.ins.vo.*;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 我的订单
 * @author 070
 *
 */
@Controller
@RequestMapping("/pc/order")
public class OrderController extends BaseController {

	@Autowired
	private ComRegionAPIService regionService;

	@Autowired
	private PolicyService policyService;

	@Autowired
	private ProductService productService;

	@Autowired
	private InsInsuranceSlipAPIService insInsuranceSlipAPIService;

	@Autowired
	private MyAsyncExecutor myAsyncExecutor;

	private static String POLICYTOTALS = "policyTotals";
	private static String POLICYSTATUS = "policyStatus";
	private static String TYPELIST = "typeList";
	private static String NATURELIST = "natureList";


//	@InitBinder
//	protected void initBinder(WebDataBinder binder) {
//		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
//		binder.registerCustomEditor(Date.class, new CustomDateEditor(dateFormat, true));
//	}
	/**
	 * <b>我的订单-出口险 页面初始化 </b>
	 *
	 * @param policyStatus
	 * @param page
	 * @return
	 * @author ZXF
	 * @date 2016年12月29日 下午5:54:59
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("myOrder")
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】我的账户-我的订单")
	public ModelAndView myOrderListInit(String policyStatus, DwzPage page){
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
 		if(userdetail == null){
			return new ModelAndView(DSUtil.operation()+"/pc/order/myOrder?policyStatus="+policyStatus);
		}
		if(GlobalResources.IS_POLICY_TP107001_OPEN.equals("YES")){
			myAsyncExecutor.execute(()->{
				policyService.policyEndStatus(userdetail.getOid());//TODO 检索投标产品支付完成重置状态并获取电子保单保函（等接口对接再使用）
			});
		}
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/order/pc_order_list");
		if(StringUtils.isEmpty(policyStatus) || "null".equals(policyStatus)) {
			policyStatus = ConstProp.DIGIT_ONE;
		}
		page.setNumPerPage(5);
		String keyword = getRequest().getParameter("keyword");
		String starDate = getRequest().getParameter("starDate");
		String endDate = getRequest().getParameter("endDate");
		InsOrderSearchVo search = InsOrderSearchVo.build(Long.parseLong(userdetail.getOid()),policyStatus,ConstProp.BLANK_CHAR, keyword, starDate, endDate, ConstProp.BLANK_CHAR,page);
		view.addObject(ConstProp.USERDETAIL,userdetail);
		view.addObject(POLICYTOTALS,policyService.findTotalPolicyNum(search));
		List<OrderFormVo> orderList = policyService.findPolicyForPage(search);
		view.addObject(ConstProp.ORDERLIST,orderList);
		view.addObject(POLICYSTATUS,policyStatus);
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b>我的订单-各状态值汇总 </b>
	 *
	 * @param policyStatus
	 * @return
	 * @author ZXF
	 * @date 2016年12月29日 下午5:54:59
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("tabTotal")
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】我的订单-各状态值汇总")
	public ModelAndView tabTotal(String policyStatus){
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/order/tabTotal");
		if(StringUtils.isEmpty(policyStatus) || "null".equals(policyStatus)) {
			policyStatus = ConstProp.DIGIT_ONE;
		}
		if(userdetail == null){
			return new ModelAndView("redirect:/user/login");
//			view.addObject(POLICYTOTALS,null);
		}else{
			String keyword = getRequest().getParameter("keyword");
			String starDate = getRequest().getParameter("starDate");
			String endDate = getRequest().getParameter("endDate");
			InsOrderSearchVo search = InsOrderSearchVo.build(Long.parseLong(userdetail.getOid()),policyStatus,ConstProp.BLANK_CHAR, keyword, starDate, endDate, ConstProp.BLANK_CHAR,null);
			view.addObject(POLICYTOTALS,policyService.findTotalPolicyNum(search));
		}
		view.addObject(POLICYSTATUS,policyStatus);
		setTokenByApi(view);
		return view;
	}

	@RequestMapping("getPcOrderListForPage")
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】我的订单-获取各标签订单列表")
	public ModelAndView getPcOrderListForPage(String policyStatus, DwzPage page){
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(userdetail == null){
			return new ModelAndView("redirect:/synopsis/unSession");
		}
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/order/pc_order_list_table");
		String keyword = getRequest().getParameter("keyword");
		String starDate = getRequest().getParameter("starDate");
		String endDate = getRequest().getParameter("endDate");
		try {
			InsOrderSearchVo search = InsOrderSearchVo.build(Long.parseLong(userdetail.getOid()),policyStatus,ConstProp.BLANK_CHAR, keyword, starDate, endDate, ConstProp.BLANK_CHAR,page);
			view.addObject(ConstProp.ORDERLIST,policyService.findPolicyForPage(search));
		}catch (Exception e){
			e.printStackTrace();
		}
		setTokenByApi(view);
		return view;
	}
	
	@RequestMapping("getOnGoingOrderListForPage")
	public ModelAndView getOnGoingOrderListForPage(String policyStatus, DwzPage page){
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(userdetail == null){
			return new ModelAndView("redirect:/synopsis/unSession");
		}
		String keyword = getRequest().getParameter("keyword");
		String starDate = getRequest().getParameter("starDate");
		String endDate = getRequest().getParameter("endDate");
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/order/pc_order_list_table");
		InsOrderSearchVo search = InsOrderSearchVo.build(Long.parseLong(userdetail.getOid()),policyStatus,ConstProp.BLANK_CHAR, keyword, starDate, endDate, ConstProp.BLANK_CHAR,page);
		view.addObject(ConstProp.ORDERLIST,policyService.findPolicyForPage(search));
		setTokenByApi(view);
		return view;
	}
	
	/**
	 * <b>出口险查看订单详情 </b> 
	 * 
	 * @param order_id
	 * @return
	 * @author ZXF 
	 * @date 2017年1月12日 上午10:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("exportDetailByOrderID/{order_id}")
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】我的订单-出口险订单详情")
	public ModelAndView exportDetailByOrderID(@PathVariable Long order_id, HttpServletRequest request){
		ModelAndView view = new ModelAndView();
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(userdetail == null){
			return new ModelAndView(DSUtil.operation()+"/pc/order/exportDetailByOrderID/"+order_id);
		}
		view.addObject(ConstProp.USERDETAIL,userdetail);
		OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(order_id);
		if(dto == null ){
			return view;
		}
		view.addObject(ConstProp.DTO, dto);
		if(StringUtils.isEmpty(dto.getProduct_code())){
			return view;
		}
		if(ConstProp.XYX_XWCK.equals(dto.getProduct_code())){
			view.setViewName("/coninsweb/personalCenter/order/policyDetail_mi");
			MicroExportVo vo = policyService.accordingToOrderIDToGetMicroExportVo(order_id);
			if(StringUtils.isEmpty(dto.getInsure_path())&&DictConst.ORDER_STATUS_YCB.equals(dto.getPolicy_status())){
				String path = policyService.HTTP_TPC_XYX_DZBD(Long.parseLong(dto.getOid()));
				dto.setInsure_path(path);
			}
			view.addObject(ConstProp.VO, vo);
			view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(0).getReg_province(),vo.getRoleSubjectList().get(0).getReg_city(),vo.getRoleSubjectList().get(0).getReg_district()));
			view.addObject(ConstProp.REG_RULE, RegionUtils.getRegionNameByALLCode(vo.getLawsuit_province(),vo.getLawsuit_city(),vo.getLawsuit_area())+vo.getLawsuit_address());
		} else if(ConstProp.XYX_DQCK.equals(dto.getProduct_code())){
			view.setViewName("/coninsweb/personalCenter/order/policyDetail_qy");
			CommonExportVo_1 vo1 = policyService.accordingToOrderIDToGetCommonExportVo_1(order_id);
			CommonExportVo_2 vo2 = policyService.accordingToOrderIDToGetCommonExportVo_2(order_id);
			CommonExportVo_3 vo3 = policyService.accordingToOrderIDToGetCommonExportVo_3(order_id);
			view.addObject(ConstProp.VO1,vo1);
			view.addObject(ConstProp.VO2,vo2);
			view.addObject(ConstProp.VO3,vo3);
			view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo1.getRoleSubjectList().get(0).getReg_province(),vo1.getRoleSubjectList().get(0).getReg_city(),vo1.getRoleSubjectList().get(0).getReg_district()));
		} else if (ConstProp.BZX_TB_GCTB.equals(dto.getProduct_code())
				||ConstProp.BZX_YG_GCTB.equals(dto.getProduct_code())
				||ConstProp.BZX_DB_GCTB.equals(dto.getProduct_code())) {
			view.setViewName("/coninsweb/personalCenter/order/policyDetail_bd");
			SpecialBidVo vo = policyService.accordingToOrderIDToGetSpecialBidVo(order_id);
			view.addObject("otList", OfficeType.listT(dto.getProduct_code().contains("DB")?"DB":"OT"));
			view.addObject(ConstProp.VO,vo);
			view.addObject(ConstProp.REG_POLICY, RegionUtils.getRegionNameByALLCode(vo.getProvince(),vo.getCity(),vo.getArea_code()));
			view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(0).getReg_province(),vo.getRoleSubjectList().get(0).getReg_city(),vo.getRoleSubjectList().get(0).getReg_district()));
			view.addObject(ConstProp.REG_ROLE_1, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(1).getReg_province(), vo.getRoleSubjectList().get(1).getReg_city(), vo.getRoleSubjectList().get(1).getReg_district()));
		} else if(ConstProp.BZX_GCLY.equals(dto.getProduct_code())){
			view.setViewName("/coninsweb/personalCenter/order/policyDetail_ly");
			SpecialPerformanceVo_1 vo1 = policyService.accordingToOrderIDToGetSpecialPerformanceVo_1(order_id);
			SpecialPerformanceVo_2 vo2 = policyService.accordingToOrderIDToGetSpecialPerformanceVo_2(order_id);
			SpecialPerformanceVo_3 vo3 = policyService.accordingToOrderIDToGetSpecialPerformanceVo_3(order_id);
			view.addObject(ConstProp.VO1,vo1);
			view.addObject(ConstProp.VO2,vo2);
			view.addObject(ConstProp.VO3,vo3);
			view.addObject(ConstProp.REG_POLICY, RegionUtils.getRegionNameByALLCode(vo1.getProvince(),vo1.getCity(),vo1.getArea_code()));
			view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo2.getRoleSubjectList().get(0).getReg_province(),vo2.getRoleSubjectList().get(0).getReg_city(),vo2.getRoleSubjectList().get(0).getReg_district()));
		} else if(ConstProp.BZX_SSBQ.equals(dto.getProduct_code())){
			view.setViewName("/coninsweb/personalCenter/order/policyDetail_ss");
			SpecialLitigationVo_1 vo1 = policyService.accordingToOrderIDToGetSpecialLitigationVo_1(order_id);
			SpecialLitigationVo_2 vo2 = policyService.accordingToOrderIDToGetSpecialLitigationVo_2(order_id);
			SpecialLitigationVo_3 vo3 = policyService.accordingToOrderIDToGetSpecialLitigationVo_3(order_id);
			view.addObject(ConstProp.VO1,vo1);
			view.addObject(ConstProp.VO2,vo2);
			view.addObject(ConstProp.VO3,vo3);
			view.addObject(ConstProp.REG_POLICY, RegionUtils.getRegionNameByALLCode(vo1.getProvince(),vo1.getCity(),vo1.getArea_code()));
			view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo1.getRoleSubjectList().get(0).getReg_province(),vo1.getRoleSubjectList().get(0).getReg_city(),vo1.getRoleSubjectList().get(0).getReg_district()));
		} else if(ConstProp.TYX.equals(dto.getProduct_code().split("-")[0])){
			view.setViewName("/coninsweb/insurance/tyx/policyDetails/gmr_policyDetail");
			GMRPolicyVo vo = policyService.accordingToOrderIDToGetGMRPolicyVo(order_id);
			if(vo != null){
				view.addObject(ConstProp.VO, vo);
				List<IdType> typeList = IdType.doList();
				List<NatureLinkage> natureList = NatureLinkage.doList();
				view.addObject(TYPELIST,typeList);
				view.addObject(NATURELIST,natureList);
				view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(0).getReg_province(),vo.getRoleSubjectList().get(0).getReg_city(),vo.getRoleSubjectList().get(0).getReg_district()));
				if(vo.getSpecialExhibitionVo() != null){
					view.addObject("ex_pca", RegionUtils.getRegionNameByALLCode(vo.getSpecialExhibitionVo().getEx_province(),vo.getSpecialExhibitionVo().getEx_city(),vo.getSpecialExhibitionVo().getEx_county()));
				}
			}
		} else if(ConstProp.GYX.equals(dto.getProduct_code().split("-")[0])){
			view.setViewName("/coninsweb/insurance/gyx/policyDetails/gyx_policyDetail");
			GYXPolicyVo vo = policyService.accordingToOrderIDToGetGYXPolicyVo(order_id);
			if(vo != null){
				List<IdType> typeList = IdType.doList();
				view.addObject(ConstProp.VO, vo);
				view.addObject(TYPELIST,typeList);
				view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(0).getReg_province(), vo.getRoleSubjectList().get(0).getReg_city(), vo.getRoleSubjectList().get(0).getReg_district()));
			}
		}else if(dto.getProduct_code().indexOf(ConstProp.GZX_HT) != -1){
			view.setViewName("/coninsweb/insurance/gzx/policyDetails/gzx_policy_detail");
			SpecialPublicDutyVo vo = policyService.accordingToOrderIDToGetSpecialPublicDutyVo(order_id);
			view.addObject(ConstProp.PD,productService.getProduct(Long.parseLong(dto.getProduct_oid())));
			view.addObject("comTypeList", IdType.comList());
			List<NatureLinkage> natureList = NatureLinkage.doList();
			view.addObject(NATURELIST,natureList);
			view.addObject(ConstProp.VO,vo);
			view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(0).getReg_province(),vo.getRoleSubjectList().get(0).getReg_city(),vo.getRoleSubjectList().get(0).getReg_district()));
			view.addObject(ConstProp.REG_ROLE_1, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(1).getReg_province(), vo.getRoleSubjectList().get(1).getReg_city(), vo.getRoleSubjectList().get(1).getReg_district()));
		}else if(dto.getProduct_code().indexOf(ConstProp.GZX_PAC) != -1 ){
			view.setViewName("/coninsweb/insurance/gzx/policyDetails/gzx_policy_detail");
			SpecialPublicDutyVo vo = policyService.accordingToOrderIDToGetSpecialPublicDutyVo(order_id);
			view.addObject(ConstProp.PD,productService.getProduct(Long.parseLong(dto.getProduct_oid())));
			view.addObject("comTypeList", IdType.comList());
			List<NatureLinkage> natureList = NatureLinkage.doList();
			view.addObject(NATURELIST,natureList);
			view.addObject(ConstProp.VO,vo);
			view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(0).getReg_province(),vo.getRoleSubjectList().get(0).getReg_city(),vo.getRoleSubjectList().get(0).getReg_district()));
			view.addObject(ConstProp.REG_ROLE_1, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(1).getReg_province(), vo.getRoleSubjectList().get(1).getReg_city(), vo.getRoleSubjectList().get(1).getReg_district()));
		}else if(ConstProp.ZZX.equals(dto.getProduct_code().split("-")[0])){
			view.setViewName("/coninsweb/insurance/zzx/policyDetails/lote_policy_detail");
			view.addObject(ConstProp.PD,productService.getProduct(Long.parseLong(dto.getProduct_oid())));
			LOTEPolicyVo vo = policyService.accordingToOrderIDToGetLOTEPolicyVo(order_id);
			view.addObject("comTypeList", IdType.comList());
			List<NatureLinkage> natureList = NatureLinkage.doList();
			view.addObject(NATURELIST,natureList);
			view.addObject(ConstProp.VO,vo);
			view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(0).getReg_province(),vo.getRoleSubjectList().get(0).getReg_city(),vo.getRoleSubjectList().get(0).getReg_district()));
			view.addObject(ConstProp.REG_ROLE_1, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(1).getReg_province(), vo.getRoleSubjectList().get(1).getReg_city(), vo.getRoleSubjectList().get(1).getReg_district()));
			view.addObject("ex_pca", RegionUtils.getRegionNameByALLCode(vo.getSpecialExhibitionVo().getEx_province(),vo.getSpecialExhibitionVo().getEx_city(),vo.getSpecialExhibitionVo().getEx_county()));

		}else if(dto.getProduct_code().contains(ConstProp.GZZRX)){
			view.setViewName("/coninsweb/insurance/gzzrx/policyDetails/gzzrx_policy_detail");
			view.addObject(ConstProp.PD,productService.getProduct(Long.parseLong(dto.getProduct_oid())));
			SpecialHirelingVo vo = policyService.accordingToOrderIDToGetSpecialHirelingVo(order_id);
			List<IdType> typeList = IdType.doList();
			List<NatureLinkage> natureList = NatureLinkage.doList();
			view.addObject(TYPELIST,typeList);
			view.addObject(NATURELIST,natureList);
			view.addObject(ConstProp.VO,vo);
			view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(0).getReg_province(),vo.getRoleSubjectList().get(0).getReg_city(),vo.getRoleSubjectList().get(0).getReg_district()));
			view.addObject(ConstProp.REG_ROLE_1, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(1).getReg_province(),vo.getRoleSubjectList().get(1).getReg_city(),vo.getRoleSubjectList().get(1).getReg_district()));
		}
		setTokenByApi(view);
		return view;
	}

	/**
	 *
	 * <b>订单详情 </b>
	 *
	 * @param oid
	 * @return
	 * @author ZXF
	 * @date 2016年12月14日 下午5:22:29
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/orderDetail_iframe/{oid}")
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】我的订单-订单详情")
	public ModelAndView orderDetail_iframe(@PathVariable long oid) {
		ModelAndView view = new ModelAndView("/coninsweb/api/order_detail");
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(userdetail==null){
			return new ModelAndView(DSUtil.operation()+"/pc/order/orderDetail_iframe/"+oid);
		}
		view.addObject(ConstProp.USERDETAIL,userdetail);
		view.addObject(ConstProp.ORDER_ID, String.valueOf(oid));
		setTokenByApi(view);
		return view;
	}



	@RequestMapping("deletePolicy")
	public JSONObject deletePolicyByOid(long policyId){
		JSONObject json = new JSONObject();
		String message  = ConstProp.BLANK_CHAR;
		String status =ConstProp.CODE_FAILURE;
		OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(policyId);
		if(!DictConst.ORDER_STATUS_DZF.equals(dto.getPolicy_status()) && !DictConst.ORDER_STATUS_TBZ.equals(dto.getPolicy_status())){
			message = SysDictUtils.getDictLabel(dto.getPolicy_status(), "order_status", ConstProp.BLANK_CHAR) + "无法删除！";
		}else{
			dto.setPolicy_status(DictConst.ORDER_STATUS_YFQ);
			String orderID = policyService.updateOrderFormStatus(dto);
			if(StringUtils.isNotEmpty(orderID)){
				message="订单删除成功！";
				status=ConstProp.CODE_SUCCESS;
			}else{
				message="订单删除失败！";
			}
		}
		json.put("message", message);
		json.put("status", status);
		return json;
	}

	@RequestMapping("copyOrder")
	@ResponseBody
	public ResultDto copyOrder( HttpServletRequest request){
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if (  userdetail == null ) {
			return new ResultDto("用户已过期，请重新登录！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		String order_id = request.getParameter(ConstProp.ORDER_ID);
		if(StringUtils.isEmpty(order_id)){
			return new ResultDto("订单ID不能为空！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		if(isCopyCount(userdetail.getOid())){
			return new ResultDto("复制功能使用次数已超过上限！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		return policyService.copyPolicy(Long.parseLong(order_id));
	}

	/**
	 * <b> 计算该用户复制功能触发次数是否超过限制（当前10次），如果超过返回true </b>
	 * @author ZXF
	 * @create 2021/12/01 0001 16:09
	 * @version
	 * @注意事项 </b>
	 */
	private boolean isCopyCount(String uId){
		String key = ConstProp.REDIS_HEAD_CPOY+uId;
		String countStr = JedisUtils.get(key);
		int count = 1;
		if(StringUtils.isNotEmpty(countStr)){
			count = Integer.parseInt(countStr);
			//每天限制订单最多复制10次，超过次数只能等第二天重置
			if(count == 10){
				return true;
			}
			count ++;
		}
		JedisUtils.set(key,count+"",ConstProp.ONE_DAY_TIMEOUT_SECONDS);
		return false;
	}
	
	@RequestMapping("deleteExportOrder")
	@ResponseBody
	public JSONObject deleteExportOrder(HttpServletRequest reqeust){
		JSONObject json = new JSONObject();
		String message  = ConstProp.BLANK_CHAR;
		String status =ConstProp.CODE_FAILURE;
		String order_id = reqeust.getParameter(ConstProp.ORDER_ID);
		OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(order_id));
		if(!DictConst.ORDER_STATUS_DZF.equals(dto.getPolicy_status()) && !DictConst.ORDER_STATUS_TBZ.equals(dto.getPolicy_status())){
			message = "状态为："+SysDictUtils.getDictLabel(dto.getPolicy_status(), "order_status", ConstProp.BLANK_CHAR) + " 订单无法删除！";
		}else{
			dto.setPolicy_status(DictConst.ORDER_STATUS_YFQ);
			String orderID = policyService.updateOrderFormStatus(dto);
			if(StringUtils.isNotEmpty(orderID)){
				message="订单删除成功！";
				status=ConstProp.CODE_SUCCESS;
			}else{
				message="订单删除失败！";
			}
		}
		json.put("message", message);
		json.put("status", status);
		return json;
	}

	@RequestMapping("addRemarksByOrder")
	@ResponseBody
	public JSONObject addRemarksByOrder(HttpServletRequest reqeust){
		JSONObject json = new JSONObject();
		String message;
		String status =ConstProp.CODE_FAILURE;
		String remarks = reqeust.getParameter("remarks");
		String order_id = reqeust.getParameter(ConstProp.ORDER_ID);
		if(StringUtils.isNotEmpty(remarks)&&StringUtils.isNotEmpty(order_id)){
			insInsuranceSlipAPIService.addRemarksByOrder(remarks,Long.parseLong(order_id));
			message="订单更新备注成功！";
			status=ConstProp.CODE_SUCCESS;
		}else{
			message="订单id、备注不能为空！";
		}
		json.put("message", message);
		json.put("status", status);
		return json;
	}

	@RequestMapping("policyReport")
	public ModelAndView policyReport(){
		ModelAndView view = new ModelAndView("/coninsweb/api/gmr/gmr_order_report");
		setTokenByApi(view);
		return view;
	}
}
