package com.bcxin.ins.coninsweb.common.controller;

import com.bcxin.ins.service.common.SysClientUserContractCService;
import com.bcxin.ins.service.common.SysClientUserContractPService;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.ME;
import com.bcxin.ins.entity.user.SysClientUserContractC;
import com.bcxin.ins.entity.user.SysClientUserContractP;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.util.Constant;
import com.bcxin.ins.util.DSUtil;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * 个人中心(我的账户) 常用投保人
 * @author 070
 *
 */
@Controller
@RequestMapping("/pc/commonApplicant")
public class CommonApplicantController  extends BaseController {

	@Autowired
	private SysClientUserContractPService sysClientUserContractPService;
	@Autowired
	private SysClientUserContractCService sysClientUserContractCService;

	
	/**
	 * <b>常用联系人 </b>
	 */
	@RequestMapping(value="/win")
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】我的账户-常用投保人")
	public String commonApplicantInit(@RequestParam Map<Object,Object> params, Model model){
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(userdetail == null) return DSUtil.operation()+"/pc/commonApplicant/win";
		model.addAttribute("userdetail",userdetail);
		setTokenByApi(model);
		return "/coninsweb/personalCenter/applicantList_new";
	}

	/**
	 * <b>常用联系人 列表</b>
	 */
	@RequestMapping(value="/c-p/query")
	public  @ResponseBody Object cpQuery(@RequestParam Map<Object,Object> params, Model model){
		if(UserSupportUtil.getSessionUser() == null) return DSUtil.operation()+"/pc/commonApplicant/win";
		List<Map<String,String>> list = Lists.newArrayList();
		Map<String,String> map = null;
		EntityWrapper ew=new EntityWrapper();
		ew.setEntity(new SysClientUserContractP());
		ew.where("sys_client_user_id = {0}",String.valueOf(params.get("sys_client_user_id")))
				.andNew("status = {0}",1).orderBy("create_time",false);
		List<SysClientUserContractP> p = sysClientUserContractPService.selectList(ew);
		for(SysClientUserContractP sp : p){
			map = Maps.newHashMap();
			map.put("id",String.valueOf(sp.getSys_client_user_contract_p_id()));
			map.put("user_name",sp.getUser_name());
			map.put("type","1");//个人1
			list.add(map);
		}
		ew=new EntityWrapper();
		ew.setEntity(new SysClientUserContractC());
		ew.where("sys_client_user_id = {0}",String.valueOf(params.get("sys_client_user_id")))
				.andNew("status = {0}",1).orderBy("create_time",false);
		List<SysClientUserContractC> c = sysClientUserContractCService.selectList(ew);
		for(SysClientUserContractC sc : c){
			map = Maps.newHashMap();
			map.put("id",String.valueOf(sc.getSys_client_user_contract_c_id()));
			map.put("user_name",sc.getCompany_name());
			map.put("type","2");//企业2
			list.add(map);
		}
		return list;
	}

	/**
	 * <b>常用联系人 列表</b>
	 */
	@RequestMapping(value="/person/query")
	public  @ResponseBody Object commonApplicantQuery(@RequestParam Map<Object,Object> params, Model model){
		if(UserSupportUtil.getSessionUser() == null) return DSUtil.operation()+"/pc/commonApplicant/win";
		EntityWrapper ew=new EntityWrapper();
		ew.setEntity(new SysClientUserContractP());
		ew.where("sys_client_user_id = {0}",String.valueOf(params.get("sys_client_user_id")))
				.andNew("status = {0}",1).orderBy("create_time",false);
		return sysClientUserContractPService.selectList(ew);
	}

	/**
	 * <b>常用联系人 个人 新增</b>
	 */
	@RequestMapping(value="/person/add")
	public @ResponseBody Object commonApplicantPersonAdd(@RequestParam Map<Object,Object> params, Model model){
		if(UserSupportUtil.getSessionUser() == null) return DSUtil.operation()+"/pc/commonApplicant/win";
		return sysClientUserContractPService.add(params);
	}

	/**
	 * <b>常用联系人 个人 修改</b>
	 */
	@RequestMapping(value="/person/upd")
	public @ResponseBody Object commonApplicantPersonUpd(@RequestParam Map<Object,Object> params, Model model, HttpServletRequest req){
		if(UserSupportUtil.getSessionUser() == null) return DSUtil.operation()+"/pc/commonApplicant/win";
		return sysClientUserContractPService.upd(params);
	}

	/**
	 * <b>常用联系人 个人 删除</b>
	 */
	@RequestMapping(value="/person/del")
	public @ResponseBody Object commonApplicantPersonDel(@RequestParam Map<Object,Object> params, Model model, HttpServletRequest req){
		if(UserSupportUtil.getSessionUser() == null) return DSUtil.operation()+"/pc/commonApplicant/win";
		return sysClientUserContractPService.del(params);
	}

	/**
	 * <b>常用联系人 个人 查询</b>
	 */
	@RequestMapping(value="/person/queryByID")
	public @ResponseBody Object commonApplicantPersonQueryByID(@RequestParam Map<Object,Object> params, Model model){
		if(UserSupportUtil.getSessionUser() == null) return DSUtil.operation()+"/pc/commonApplicant/win";
		return sysClientUserContractPService.selectByMap(new ME().put("sys_client_user_contract_p_id",String.valueOf(params.get("sys_client_user_contract_p_id"))).getM());
	}

	/**
	 * <b>常用联系人 企业 列表</b>
	 */
	@RequestMapping(value="/company/query")
	public  @ResponseBody Object companyQuery(@RequestParam Map<Object,Object> params, Model model){
		if(UserSupportUtil.getSessionUser() == null) return DSUtil.operation()+"/pc/commonApplicant/win";
		EntityWrapper ew=new EntityWrapper();
		ew.setEntity(new SysClientUserContractC());
		ew.where("sys_client_user_id = {0}",String.valueOf(params.get("sys_client_user_id")))
				.andNew("status = {0}",1).orderBy("create_time",false);
		return sysClientUserContractCService.selectList(ew);
	}

	/**
	 * <b>常用联系人 企业 新增</b>
	 */
	@RequestMapping(value="/company/add")
	public @ResponseBody Object companyAdd(@RequestParam Map<Object,Object> params, Model model){
		if(UserSupportUtil.getSessionUser() == null) return DSUtil.operation()+"/pc/commonApplicant/win";
		return sysClientUserContractCService.add(params);
	}

	/**
	 * <b>常用联系人 企业 修改</b>
	 */
	@RequestMapping(value="/company/upd")
	public @ResponseBody Object companyUpd(@RequestParam Map<Object,Object> params, Model model, HttpServletRequest req){
		if(UserSupportUtil.getSessionUser() == null) return DSUtil.operation()+"/pc/commonApplicant/win";
		return sysClientUserContractCService.upd(params);
	}

	/**
	 * <b>常用联系人 企业 删除</b>
	 */
	@RequestMapping(value="/company/del")
	public @ResponseBody Object companyDel(@RequestParam Map<Object,Object> params, Model model, HttpServletRequest req){
		if(UserSupportUtil.getSessionUser() == null) return DSUtil.operation()+"/pc/commonApplicant/win";
		return sysClientUserContractCService.del(params);
	}

	/**
	 * <b>常用联系人 企业 查询</b>
	 */
	@RequestMapping(value="/company/queryByID")
	public @ResponseBody Object companyQueryByID(@RequestParam Map<Object,Object> params, Model model){
		if(UserSupportUtil.getSessionUser() == null) return DSUtil.operation()+"/pc/commonApplicant/win";
		return sysClientUserContractCService.selectByMap(new ME().put("sys_client_user_contract_c_id",String.valueOf(params.get("sys_client_user_contract_c_id"))).getM());
	}

}
