/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.third.zzx.zhongan;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.entity.common.LogBusinessrequest;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.service.order.LogBusinessrequestService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.third.zzx.zhongan.PackageMessageZhongAn;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.vo.LOTEPolicyVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.zhongan.scorpoin.biz.common.CommonRequest;
import com.zhongan.scorpoin.biz.common.CommonResponse;
import com.zhongan.scorpoin.common.DefaultRequest;
import com.zhongan.scorpoin.common.ZhongAnApiClient;
import com.zhongan.scorpoin.common.ZhongAnEnvEnum;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="zARequestService")
@Transactional
public class ZARequestService {
    private Logger communicatorLog = LoggerFactory.getLogger(ZARequestService.class);
    @Autowired
    private PolicyService policyService;
    @Autowired
    private LogBusinessrequestService logBusinessrequestService;

    public String requestZA(Long order_id, String transType, Map<String, String> map) throws Exception {
        this.communicatorLog.info("requestZA\uff1astar-----------------------");
        this.communicatorLog.info("requestZA\uff1a\u63a5\u53e3\u7f16\u7801-" + transType + ",\u8ba2\u5355id-" + order_id + ",MAP-" + (map != null ? map.toString() : "null"));
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
        LOTEPolicyVo vo = this.policyService.accordingToOrderIDToGetLOTEPolicyVo(Long.parseLong(dto.getOid()));
        String result = "300#\uff08APP-ZA-300.00\uff09\u7f51\u7edc\u4e0d\u7a33\u5b9a\uff0c\u8bf7\u91cd\u65b0\u8bf7\u6c42\uff01";
        LogBusinessrequest lb = null;
        try {
            String env = ZARequestService.getEnvironmentSign();
            String version = "1.0.0";
            String privateKey = "MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAOJ1y7KBBd8rJQlrdUUuKqig4ieltSU58DXTft85ZNkRrXHpyixqNiMyacrKW6TlmG97NTVXk4SvhO7zLgepX+di76t6Zbzb9fhquRN/79b9f7jy4sr76FCNDg8RaDuLsHZ3P1wF+wEhmfuijLrolt0M+tmaSBeyHdnnHg2rKY5bAgMBAAECgYB0PdLZRbEl5JeWRjpj0FbFSA/OGhjpitvqRS2Sl3tUkOZe2oqUUdCIMJBtL4HrGo8saindv55RNWce4GR4OlCnFcgskoXXkDmNYGma4aItvNj7q0MTMJBycnS1m6PuWyk25LtZN/BaixwjnzIuyJC5cz3TYUBql65kEqH+xqdJQQJBAPLQea4phSbed10ayrd8WGKQogM9cqCOxQl4hfd8PLJTaiTWPNqVL79+jhAehM6GLf72KIWQD+AXYFPy83Xe/0cCQQDuwfgvVE9nhbcJ6ZFTxEl25xxC4NYq+8RajrdtnrlFL19gs0oBA2rGNCeoD0EKDrhma+TGZf79+R0XK7NQ8gpNAkBmQgX8ot/AjtAWFcJpo6RVXjPcyXQMyhOQ+YDxyRCGyTpaaR8Xrtx8+P87Kp8jmr6kMWa/WPxWk4Gt2RNPAKrhAkEAjud2Xw29gR7dkYdFPrgLqKlnlvfv+EY9Hl6xl2EbTzethLmLH9QlwoBRBBwtN5Hb+SG3CrDd0LGcIdQ8PcTBOQJBAKErshsBGv9IgK9duml2CXxP7AdVL/uVmE6L6aFRiTy0F79kGDTP2Kdsw6ojdHRPqHzorrm8ZurR0iJ0NYd2BqE=";
            String serviceName = ZARequestService.getServiceName(transType);
            ZhongAnApiClient client = new ZhongAnApiClient(env, ZARequestService.getAppKey(), privateKey, version);
            CommonRequest request = new CommonRequest(serviceName);
            JSONObject params = PackageMessageZhongAn.marshal(vo, dto, transType, map);
            this.communicatorLog.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + params);
            request.setParams(params);
            Date bTime = new Date();
            CommonResponse response = (CommonResponse)client.call((DefaultRequest)request);
            lb = this.logBusinessrequestService.initLogBusinessrequest(String.valueOf(order_id), transType, ZhongAnEnvEnum.get((String)env).getUrl(), params.toJSONString(), response.toString(), bTime, new Date(), TransTypeEnum.getAlias((String)transType));
            this.communicatorLog.info("\u8fd4\u56de\u62a5\u6587\uff1a" + response.toString());
            if (response == null) {
                result = "300#\uff08APP-ZA-300.01\uff09\u8bf7\u6c42\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff0c\u672a\u83b7\u53d6\u5230\u8fd4\u56de\u4fe1\u606f\uff01";
            } else {
                result = response.getBizContent() == null ? "300#\uff08APP-ZA-300.02\uff09" + response.getErrorMsg() : PackageMessageZhongAn.returnAnalysisJson(response.getBizContent(), transType);
                this.communicatorLog.info("\u8fd4\u56de\u62a5\u6587\u5904\u7406\uff1a" + result);
            }
            this.logBusinessrequestService.supplementDecAndSave(lb, result.startsWith("300") ? 1 : 0, "");
        }
        catch (Exception ex) {
            this.logBusinessrequestService.supplementDecAndSave(lb, 2, ex.getMessage());
            this.communicatorLog.error("APP-ZA-ERROR: request error", (Throwable)ex);
        }
        this.communicatorLog.info("requestZA\uff1aend-----------------------");
        return result;
    }

    private static String getServiceName(String transType) {
        if ("1".equals(transType)) {
            return "zhongan.normal.comm.new.galatea.insure.uw";
        }
        if ("2".equals(transType)) {
            return "zhongan.normal.comm.new.galatea.insure.issue";
        }
        if ("3".equals(transType)) {
            return "zhongan.normal.comm.cancel.policy";
        }
        return "";
    }

    private static String getEnvironmentSign() {
        if (!GlobalResources.IS_TEST_ENVI.booleanValue()) {
            return "prd";
        }
        return "dev";
    }

    private static String getAppKey() {
        if (!GlobalResources.IS_TEST_ENVI.booleanValue()) {
            return "a5def00b096dfd6857550a713b190434";
        }
        return "683e35864c00f3c97e2fa8eb2515e3a2";
    }
}

