/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.third.tyx.taikang;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.MD5Util;
import com.bcxin.ins.vo.GMRPolicyVo;
import com.bcxin.ins.vo.MailPolicyVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageMessageTK {
    private static Logger logger = LoggerFactory.getLogger(PackageMessageTK.class);
    private static final String FORMAT = "json";
    private static final String SIGNTYPE = "md5";
    private static final String CHARSET = "utf-8";
    private static final String VERSION = "1.0";
    private static final String BUSINESSCHANNEL = "05";
    private static final String FROMID = "62967";
    private static final String SALESMANCODE = "S131990026";
    private static final String GROUPIND = "2";
    private static final String SIGNKEY = "1234567890ABCDEF";
    private static final String CHANNELTIP = "01010106";
    private static final String SOLUTIONCODE = "0100000000006001120001";
    private static final String BLANK_CHAR = "";
    private static final String PRODUCTTYPE = "1301A003";
    private static final String COOPID = "bai_chuan_xin";

    public static String marshal(GMRPolicyVo vo, OrderFormVo dto, String transType) throws Exception {
        if (dto == null) {
            return BLANK_CHAR;
        }
        HashMap mapP = Maps.newHashMap();
        PackageMessageTK.doHead(mapP, dto, transType);
        String _md5 = BLANK_CHAR;
        if ("01".equals(transType)) {
            if (vo == null) {
                return BLANK_CHAR;
            }
            HashMap mapB = Maps.newHashMap();
            PackageMessageTK.doContent(mapB, dto);
            ArrayList<Map<String, Object>> list_app = new ArrayList<Map<String, Object>>();
            PackageMessageTK.doApplicant(list_app, vo.getRoleSubjectList());
            mapB.put("applicantList", list_app);
            ArrayList<Map<String, Object>> list_ins = new ArrayList<Map<String, Object>>();
            PackageMessageTK.doInsured(list_ins, vo.getRoleSubjectList(), dto);
            mapB.put("insuredList", list_ins);
            if ("1".equals(vo.getMailPolicyVo().getNeed_receipt())) {
                HashMap map_writ = Maps.newHashMap();
                PackageMessageTK.doInvoice(map_writ, vo.getMailPolicyVo());
                mapB.put("parameterMap", map_writ);
            }
            mapP.put("apply_content", mapB);
            _md5 = MD5Util.string2MD5((String)(SIGNKEY + JSONArray.toJSONString((Object)mapB)));
        } else if ("02".equals(transType)) {
            HashMap map2 = Maps.newHashMap();
            map2.put("proposalNo", dto.getPolicy_serial_number());
            mapP.put("apply_content", map2);
            _md5 = MD5Util.string2MD5((String)(SIGNKEY + JSONArray.toJSONString((Object)map2)));
        }
        mapP.put("sign", _md5);
        return JSONArray.toJSONString((Object)mapP);
    }

    private static void doHead(Map<String, Object> map, OrderFormVo dto, String transType) {
        map.put("coop_id", COOPID);
        map.put("service_id", transType);
        map.put("sign_type", SIGNTYPE);
        map.put("format", FORMAT);
        map.put("charset", CHARSET);
        map.put("version", VERSION);
        map.put("timestamp", String.valueOf(new Date().getTime()));
        map.put("serial_no", dto.getTrade_serial_number());
        map.put("product_type", PRODUCTTYPE);
    }

    private static void doContent(Map<String, Object> map, OrderFormVo dto) {
        map.put("requestId", dto.getTrade_serial_number());
        map.put("issueDate", dto.getStart_time());
        map.put("startDate", dto.getInception_date() + " 00:00:00");
        map.put("endDate", dto.getPlanned_end_date() + " 23:59:59");
        map.put("businessChannel", BUSINESSCHANNEL);
        map.put("comboId", PackageMessageTK.getCOMBOID(dto.getProduct_code()));
        map.put("customerId", String.valueOf(new Date().getTime()));
        map.put("fromId", FROMID);
        map.put("amount", dto.getInsured_amount());
        map.put("premium", dto.getGross_premium());
        map.put("salesmanCode", SALESMANCODE);
        map.put("channelTip", CHANNELTIP);
        map.put("solutionCode", SOLUTIONCODE);
        map.put("groupInd", GROUPIND);
    }

    private static void doApplicant(List<Map<String, Object>> list_app, List<RoleSubjectVo> roleList) {
        HashMap map_app = null;
        for (RoleSubjectVo vo : roleList) {
            if ("1".equals(vo.getKind())) {
                map_app = Maps.newHashMap();
                map_app.put("name", vo.getName_cn());
                map_app.put("identifyType", PackageMessageTK.typeConversion_TK(vo.getId_type()));
                map_app.put("identifyNumber", vo.getOrganization_code());
                map_app.put("itemprovinceCode", vo.getReg_province());
                map_app.put("itemcityCode", PackageMessageTK.getCityCodeByPro(vo.getReg_province(), vo.getReg_city()));
                map_app.put("itemdistrictCode", vo.getReg_district());
                map_app.put("detailedAddress", vo.getReg_address());
                map_app.put("contactName", vo.getLink_name());
                map_app.put("mobile", vo.getLink_tel());
                map_app.put("mail", vo.getLink_email());
                map_app.put("postCode", vo.getZip_code());
                map_app.put("insuredType", GROUPIND);
                map_app.put("insuredFlag", "1");
                map_app.put("officePhoneNumber", vo.getPhone());
                list_app.add(map_app);
            }
            map_app = null;
        }
    }

    private static void doInsured(List<Map<String, Object>> list_ins, List<RoleSubjectVo> roleList, OrderFormVo dto) {
        HashMap map_ins = null;
        for (RoleSubjectVo vo : roleList) {
            if (GROUPIND.equals(vo.getKind())) {
                map_ins = Maps.newHashMap();
                map_ins.put("name", vo.getName_cn());
                map_ins.put("sex", vo.getSex());
                map_ins.put("identifyType", PackageMessageTK.typeConversion_TK(vo.getId_type()));
                map_ins.put("identifyNumber", vo.getOrganization_code());
                map_ins.put("birthday", vo.getBirth_date());
                map_ins.put("mobile", vo.getMobile());
                map_ins.put("occupationCode", PackageMessageTK.getOccupation(vo.getMajor_group(), dto.getProduct_code()));
                map_ins.put("occupationName", "1".equals(vo.getMajor_group()) ? "\u5185\u52e4\u4eba\u5458" : (GROUPIND.equals(vo.getMajor_group()) ? "\u4fdd\u5b89\u4eba\u5458" : "\u6b66\u88c5\u62bc\u8fd0\u4eba\u5458"));
                map_ins.put("insuredFlag", GROUPIND);
                map_ins.put("healthStatus", "0");
                map_ins.put("projectCode", PackageMessageTK.getCOMBOID(dto.getProduct_code()));
                map_ins.put("insuredType", "1");
                map_ins.put("relatedperson", "99");
                map_ins.put("remark", "01");
                list_ins.add(map_ins);
            }
            map_ins = null;
        }
    }

    private static String getOccupation(String major, String product_code) {
        if ("TYX-TK-3".equals(product_code)) {
            if ("1".equals(major)) {
                return "18000101";
            }
            if (GROUPIND.equals(major)) {
                return "18000101";
            }
            return "16020071";
        }
        if ("TYX-TK-4".equals(product_code)) {
            if ("1".equals(major)) {
                return "18000102";
            }
            if (GROUPIND.equals(major)) {
                return "18000102";
            }
            return "16020072";
        }
        if ("TYX-TK-5".equals(product_code)) {
            if ("1".equals(major)) {
                return "18000103";
            }
            if (GROUPIND.equals(major)) {
                return "18000103";
            }
            return "16020073";
        }
        if ("TYX-TK-6".equals(product_code)) {
            if ("1".equals(major)) {
                return "18000104";
            }
            if (GROUPIND.equals(major)) {
                return "18000104";
            }
            return "16020074";
        }
        if ("TYX-TK-1".equals(product_code)) {
            if ("1".equals(major)) {
                return "18000105";
            }
            if (GROUPIND.equals(major)) {
                return "18000105";
            }
            return "16020075";
        }
        if ("TYX-TK-2".equals(product_code)) {
            if ("1".equals(major)) {
                return "18000106";
            }
            if (GROUPIND.equals(major)) {
                return "18000106";
            }
            return "16020076";
        }
        return BLANK_CHAR;
    }

    private static String typeConversion_TK(String value) {
        if ("0".equals(value)) {
            return "01";
        }
        if ("3".equals(value)) {
            return "02";
        }
        if ("4".equals(value)) {
            return BUSINESSCHANNEL;
        }
        if ("1".equals(value)) {
            return "1";
        }
        if ("6".equals(value)) {
            return GROUPIND;
        }
        if ("7".equals(value)) {
            return "3";
        }
        if (GROUPIND.equals(value)) {
            return "4";
        }
        if ("8".equals(value)) {
            return "99";
        }
        return "99";
    }

    private static void doInvoice(Map<String, Object> map, MailPolicyVo mVo) {
        map.put("fieldAL", "1");
        map.put("fieldAB", mVo.getReceipt_head());
        map.put("fieldAD", "1".equals(mVo.getInvoice_type()) ? "01" : "02");
        map.put("fieldAA", "1".equals(mVo.getInvoice_type()) ? GROUPIND : "1");
        if ("1".equals(mVo.getInvoice_type())) {
            map.put("fieldAC", mVo.getTaxpayer_number_invoice());
            map.put("fieldAT", mVo.getBank_invoice());
            map.put("fieldAU", mVo.getBank_account_invoice());
            map.put("fieldAJ", mVo.getBank_province());
            map.put("fieldAK", PackageMessageTK.getCityCodeByPro(mVo.getBank_province(), mVo.getBank_city()));
            map.put("fieldAI", mVo.getBank_invoice());
            map.put("fieldAE", mVo.getRegister_address_invoice());
            map.put("fieldAF", mVo.getReceipt_phone());
        } else {
            map.put("fieldAC", "123456789001");
            map.put("fieldAT", "123456789001");
            map.put("fieldAU", "123456789001");
            map.put("fieldAJ", "350000");
            map.put("fieldAK", "350600");
            map.put("fieldAI", "123456789001");
            map.put("fieldAE", "123456789001");
            map.put("fieldAF", "0592-6780000");
        }
    }

    public static String returnAnalysisJson(String json) {
        String result = BLANK_CHAR;
        Map map = null;
        try {
            map = (Map)JSON.parseObject((String)json, Map.class);
        }
        catch (Exception e) {
            return "300#\uff08APP-TK-002\uff09" + json;
        }
        if (map == null) {
            return "300#\uff08APP-TK-004\uff09\u62a5\u6587\u4fe1\u606f\u89e3\u6790\u5931\u8d25\uff01";
        }
        String result_code = (String)map.get("result_code");
        if (!"0".equals(result_code)) {
            return "300#\uff08APP-TK-003\uff09" + map.get("result_msg");
        }
        String service_id = (String)map.get("service_id");
        if (StringUtils.isEmpty((CharSequence)service_id)) {
            return result;
        }
        Map contentMap = (Map)map.get("result_content");
        logger.info("\u62a5\u6587\u89e3\u6790\uff1acontentMap=" + contentMap);
        if ("01".equals(service_id)) {
            String proposalNo = BLANK_CHAR;
            String startDate = BLANK_CHAR;
            String endDate = BLANK_CHAR;
            if (contentMap.get("proposalNo") != null) {
                proposalNo = (String)contentMap.get("proposalNo");
            }
            if (contentMap.get("startDate") != null) {
                startDate = (String)contentMap.get("startDate");
            }
            if (contentMap.get("endDate") != null) {
                endDate = (String)contentMap.get("endDate");
            }
            result = "200#" + proposalNo + "#" + startDate + "#" + endDate;
        } else if ("02".equals(service_id)) {
            String policyNo = BLANK_CHAR;
            String policyUrl = BLANK_CHAR;
            logger.info("\u62a5\u6587\u89e3\u6790\uff1apolicyNo=" + contentMap.get("policyNo"));
            if (contentMap.get("policyNo") != null) {
                policyNo = (String)contentMap.get("policyNo");
            }
            if (contentMap.get("policyUrl") != null) {
                policyUrl = (String)contentMap.get("policyUrl");
            }
            if (StringUtils.isNotEmpty((CharSequence)policyNo)) {
                result = "200#" + policyNo + "#" + policyUrl;
            } else {
                String result_msg = (String)map.get("result_msg");
                result = "300#\uff08APP-TK-003\uff09" + result_msg;
            }
        }
        return result;
    }

    private static String getDate(String doTime, int status) {
        String result = BLANK_CHAR;
        if (StringUtils.isEmpty((CharSequence)doTime)) {
            return result;
        }
        try {
            if (status == 0) {
                result = DateUtil.convertDateToString((Date)DateUtil.parseDate((String)doTime), (String)"yyyy-MM-dd");
            } else if (status == 1) {
                result = DateUtil.convertDateToString((Date)DateUtil.parseDate((String)doTime), (String)"yyyy-MM-dd");
                if (StringUtils.isNotEmpty((CharSequence)result)) {
                    result = result + " 00:00:00";
                }
            } else if (status == 2) {
                Date beT = DateUtil.parseDate((String)doTime);
                Calendar cDate = Calendar.getInstance();
                cDate.setTime(beT);
                cDate.set(5, cDate.get(5) - 1);
                result = DateUtil.convertDateToString((Date)beT, (String)"yyyy-MM-dd");
                if (StringUtils.isNotEmpty((CharSequence)result)) {
                    result = result + " 23:59:59";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static String getCityCodeByPro(String pro, String city) {
        if ("110000".equals(pro)) {
            return pro;
        }
        if ("120000".equals(pro)) {
            return pro;
        }
        if ("500000".equals(pro)) {
            return pro;
        }
        if ("310000".equals(pro)) {
            return pro;
        }
        if ("710000".equals(pro)) {
            return pro;
        }
        if ("810000".equals(pro)) {
            return pro;
        }
        if ("820000".equals(pro)) {
            return pro;
        }
        return city;
    }

    private static String getCOMBOID(String product_code) {
        if (!StringUtils.isEmpty((CharSequence)product_code) && "TYX-TK-1".equals(product_code)) {
            return "1301A00305";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "TYX-TK-2".equals(product_code)) {
            return "1301A00306";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "TYX-TK-3".equals(product_code)) {
            return "1301A00301";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "TYX-TK-4".equals(product_code)) {
            return "1301A00302";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "TYX-TK-5".equals(product_code)) {
            return "1301A00303";
        }
        if (!StringUtils.isEmpty((CharSequence)product_code) && "TYX-TK-6".equals(product_code)) {
            return "1301A00304";
        }
        return BLANK_CHAR;
    }

    public static void main(String[] args) {
    }
}

