/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.third.tyx.pingan.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class Base64Utils {
    private static final int CACHE_SIZE = 1024;

    public static byte[] decode(String base64) throws IOException {
        return new BASE64Decoder().decodeBuffer(base64);
    }

    public static String encode(byte[] bytes) {
        return new String(new BASE64Encoder().encode(bytes));
    }

    public static String encodeFile(String filePath) throws IOException {
        byte[] bytes = Base64Utils.fileToByte(filePath);
        return Base64Utils.encode(bytes);
    }

    public static void decodeToFile(String filePath, String base64) throws IOException {
        byte[] bytes = Base64Utils.decode(base64);
        Base64Utils.byteArrayToFile(bytes, filePath);
    }

    public static byte[] fileToByte(String filePath) throws IOException {
        byte[] data = new byte[]{};
        File file = new File(filePath);
        if (file.exists()) {
            try (FileInputStream in = new FileInputStream(file);
                 ByteArrayOutputStream out = new ByteArrayOutputStream(2048);){
                byte[] cache = new byte[1024];
                int nRead = 0;
                while ((nRead = in.read(cache)) != -1) {
                    out.write(cache, 0, nRead);
                    out.flush();
                }
                data = out.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return data;
    }

    public static void byteArrayToFile(byte[] bytes, String filePath) throws IOException {
        File destFile = new File(filePath);
        if (!destFile.getParentFile().exists()) {
            destFile.getParentFile().mkdirs();
        }
        destFile.createNewFile();
        try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);
             FileOutputStream out = new FileOutputStream(destFile);){
            byte[] cache = new byte[1024];
            int nRead = 0;
            while ((nRead = in.read(cache)) != -1) {
                ((OutputStream)out).write(cache, 0, nRead);
                out.flush();
            }
        }
    }
}

