/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.third.gzzrx.zhonghua.util;

import com.bcxin.ins.third.gzzrx.zhonghua.security.codec.Base64;
import com.bcxin.ins.third.gzzrx.zhonghua.util.StreamUtils;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;

public class RSAUtils {
    private static String ZH_PUBLIC_KEY = "";
    private static String PUBLIC_KEY = "";
    private static String PRIVATE_KEY = "";

    public static void setKeys(boolean isTest) {
        if (isTest) {
            ZH_PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCLiqOx+fIsiSHiElgFR7MhDBELTY38g/totoPqOOJECV9BE64dmfPmr/3chZbwiFJ/ick0XMqkjmZt6iNsTFQoalBjLCe8H8T0zs7+gKPMGmsYAVVVUixnMxBzi8nruXcklCmEt/vhVsVhZW5eqj3U529P7PqCg/ztMvg9ap6nhQIDAQAB";
            PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCDpx0Ed6ZBObuFQSpWjANtu+/7SScdUYs+Bai5YTYlcmWMqzZhgi/5BgsNRdl9nDg7HuJ8tlgKGAveInLqrXOh/wluLDDHUDsCxT7x9EKnSNDo6r2vD4AwkdbNdDkAmAG6ji45PFmq4jswfBLTPTrH9ie0NrmhBbkjpx2qnGP+vwIDAQAB";
            PRIVATE_KEY = "MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBAIOnHQR3pkE5u4VBKlaMA2277/tJJx1Riz4FqLlhNiVyZYyrNmGCL/kGCw1F2X2cODse4ny2WAoYC94icuqtc6H/CW4sMMdQOwLFPvH0QqdI0Ojqva8PgDCR1s10OQCYAbqOLjk8WariOzB8EtM9Osf2J7Q2uaEFuSOnHaqcY/6/AgMBAAECgYBfM1YBaAA6RGQ8nP3frcnA7VlBTgnR4qidBfyXaRt9gra6PQjLBBhqrBsL0wnOEkx7O/8tjbImQnM6g5Cz8Q+e9p/OkznOkk5XF3hhTmjwCMHAcKMv4AZMCa+8uyZu2dLLUwNFj0DhYcxMgb2elt7fK4qRjR9TA/B8fcEwbIbCcQJBANCTcwo4snMbwNPEVdoSk7+Ft5EYI9wGVM9/aBJTc6leBqJJyCwzYDdIHlTp8txcmOLsDSaqCqfprldzeKza7VkCQQChljUcXCAOSlc7qmmBDeVy/vdHKdlWhbyfc7G0vohmDLmkoK7TQeAmaTPnVJu1CY+IuZ+p8dKDzIy6HEKNqdHXAkAIZHZzidZ8VTiMDNFbhfXV9f5t4yfGOab99mVsn1j/Dp57tzZLuQF9F/TIe+VewocQUmkxDhSBryBpuma3pdN5AkAtXJugUIR3PotqppZjsmD9fXIxuh/XWEfxg2sZ0Hs+Gshq3Oj3SYEBh3sYr/neQsbWnTWjYc21TlEbVh+g4VGVAkAOu9i7UUnQfQfO4hOsJbrOxs4iUCVmNfXv6XrFMbkwWNzzz+hkEEfj7R/YBwRy/auEtxJZjFxyAj9mUEtbJFFz";
        } else {
            ZH_PUBLIC_KEY = "";
            PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCLiqOx+fIsiSHiElgFR7MhDBELTY38g/totoPqOOJECV9BE64dmfPmr/3chZbwiFJ/ick0XMqkjmZt6iNsTFQoalBjLCe8H8T0zs7+gKPMGmsYAVVVUixnMxBzi8nruXcklCmEt/vhVsVhZW5eqj3U529P7PqCg/ztMvg9ap6nhQIDAQAB";
            PRIVATE_KEY = "MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBAIuKo7H58iyJIeISWAVHsyEMEQtNjfyD+2i2g+o44kQJX0ETrh2Z8+av/dyFlvCIUn+JyTRcyqSOZm3qI2xMVChqUGMsJ7wfxPTOzv6Ao8waaxgBVVVSLGczEHOLyeu5dySUKYS3++FWxWFlbl6qPdTnb0/s+oKD/O0y+D1qnqeFAgMBAAECgYBBQx8aLxb3g09oh0HJfmYlz5ntGmGMt0GPEMWTdvVD8sotCoJFb+pleuwVBhm491j2Mz/6EGfqHHuFbpsQnIZDB3JR6N+R/lXQ9ytB3kKm9uPbTBApP7YGV9SynBQbsDg//Ti7KaYd1iwSepkBJphRr1TncMeFpFujAwdITqDPYQJBAOxfUB/icTahlQy/swZKMNwkYTe5R/74Yqji3AOCIo8LDYUb5sLHmseJzaDDKJ7oQtH1xAJYpQ1/pyo0umFmk1kCQQCXIPIUoq2xEnmqlqgqRi+Y0qBwITk7qAchTxJgdcH2pesQe9YdN3y0JlUYzcHpaZi8LXpDSkGn0qVEgPfKaQwNAkAs3+N8SicoMgD0DKjWNtuTz6xNQfWzKEDCw171o40gDv8gGC31KKPv4e+R57scgAe/iKMPtviO2X9I+f2wZCLxAkBq8hR9R9WULdfNQQnFyJ8cDUkdsFUZA0Hwb00413wn96fNpWSSjlaAAXRMtiZX77L2z1Pq1Fx7z1PGk2FGamntAkAdEIEzw0YbJbyD+Un2ToDW5cuntiKeb2K6vFCXwsMbe0de+vFwa98COf5Kc9fhCKjPA4eFGB4jX9zUYW6eFzm6";
        }
    }

    public static Map<String, String> es(String xml) {
        try {
            if (StringUtils.isEmpty((CharSequence)ZH_PUBLIC_KEY)) {
                RSAUtils.setKeys(GlobalResources.IS_TEST_ENVI);
            }
            return RSAUtils.encryptAndSign(xml, ZH_PUBLIC_KEY, PRIVATE_KEY, "UTF-8", true, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String cd(String content, String sign) {
        try {
            return RSAUtils.checkSignAndDecrypt(content, sign, ZH_PUBLIC_KEY, PRIVATE_KEY, "UTF-8", true, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static Map<String, String> encryptAndSign(String bizContent, String publicKey, String privateKey, String charset, boolean isEncrypt, boolean isSign) throws Exception {
        if (RSAUtils.isEmpty(charset)) {
            charset = "UTF-8";
        }
        bizContent = URLEncoder.encode(bizContent, "UTF-8");
        HashMap<String, String> map = new HashMap<String, String>();
        if (isEncrypt) {
            String encrypted = RSAUtils.rsaEncrypt(bizContent, publicKey, charset);
            map.put("CONTENT", encrypted);
            if (isSign) {
                String sign = RSAUtils.rsaSign(encrypted, privateKey, charset);
                map.put("GW_CH_SIGN", sign);
            }
        } else if (isSign) {
            map.put("CONTENT", bizContent);
            String sign = RSAUtils.rsaSign(bizContent, privateKey, charset);
            map.put("GW_CH_SIGN", sign);
        }
        return map;
    }

    public static String checkSignAndDecrypt(String content, String sign, String publicKey, String privateKey, String charset, boolean isDecrypt, boolean isCheckSign) throws Exception {
        if (RSAUtils.isEmpty(charset)) {
            charset = "UTF-8";
        }
        if (isCheckSign) {
            RSAUtils.checkRSASign(sign, content, publicKey, charset);
        }
        if (isDecrypt) {
            return URLDecoder.decode(RSAUtils.rsaDecrypt(content, privateKey, charset), "UTF-8");
        }
        return content;
    }

    public static String rsaEncrypt(String content, String publicKey, String charset) throws Exception {
        PublicKey pubKey = RSAUtils.getPublicKeyFromX509("RSA", new ByteArrayInputStream(publicKey.getBytes()));
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, pubKey);
        byte[] data = RSAUtils.isEmpty(charset) ? content.getBytes() : content.getBytes(charset);
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 117;
        }
        byte[] encryptedData = Base64.encodeBase64(out.toByteArray());
        out.close();
        return RSAUtils.isEmpty(charset) ? new String(encryptedData) : new String(encryptedData, charset);
    }

    public static String rsaDecrypt(String content, String privateKey, String charset) throws Exception {
        try {
            PrivateKey priKey = RSAUtils.getPrivateKeyFromPKCS8("RSA", new ByteArrayInputStream(privateKey.getBytes()));
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, priKey);
            byte[] encryptedData = RSAUtils.isEmpty(charset) ? Base64.decodeBase64(content.getBytes()) : Base64.decodeBase64(content.getBytes(charset));
            int inputLen = encryptedData.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(encryptedData, offSet, 128) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 128;
            }
            byte[] decryptedData = out.toByteArray();
            out.close();
            return RSAUtils.isEmpty(charset) ? new String(decryptedData) : new String(decryptedData, charset);
        }
        catch (Exception e) {
            throw new Exception("EncodeContent = " + content + ",charset = " + charset, e);
        }
    }

    public static String rsaSign(String content, String privateKey, String charset) throws Exception {
        try {
            PrivateKey priKey = RSAUtils.getPrivateKeyFromPKCS8("RSA", new ByteArrayInputStream(privateKey.getBytes()));
            Signature signature = Signature.getInstance("SHA1WithRSA");
            signature.initSign(priKey);
            if (RSAUtils.isEmpty(charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            byte[] signed = signature.sign();
            return new String(Base64.encodeBase64(signed));
        }
        catch (Exception e) {
            throw new Exception("RSAcontent = " + content + "; charset = " + charset, e);
        }
    }

    public static void checkRSASign(String sign, String content, String publicKey, String charset) throws Exception {
        if (!RSAUtils.rsaCheckContent(content, sign, publicKey, charset)) {
            throw new Exception("rsaCheck failure: sign=" + sign + ", content=" + content + ", charset=" + charset);
        }
    }

    public static PrivateKey getPrivateKeyFromPKCS8(String algorithm, InputStream ins) throws Exception {
        if (ins == null || RSAUtils.isEmpty(algorithm)) {
            return null;
        }
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        byte[] encodedKey = StreamUtils.readText(ins).getBytes();
        encodedKey = Base64.decodeBase64(encodedKey);
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
    }

    public static boolean rsaCheckContent(String content, String sign, String publicKey, String charset) throws Exception {
        try {
            PublicKey pubKey = RSAUtils.getPublicKeyFromX509("RSA", new ByteArrayInputStream(publicKey.getBytes()));
            Signature signature = Signature.getInstance("SHA1WithRSA");
            signature.initVerify(pubKey);
            if (RSAUtils.isEmpty(charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            return signature.verify(Base64.decodeBase64(sign.getBytes()));
        }
        catch (Exception e) {
            throw new Exception("RSAcontent=" + content + ",sign=" + sign + ",charset=" + charset, e);
        }
    }

    public static PublicKey getPublicKeyFromX509(String algorithm, InputStream ins) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        StringWriter writer = new StringWriter();
        StreamUtils.io(new InputStreamReader(ins), writer);
        byte[] encodedKey = writer.toString().getBytes();
        encodedKey = Base64.decodeBase64(encodedKey);
        return keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
    }

    public static boolean isEmpty(String value) {
        return null == value || value.trim().equals("");
    }
}

