/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.third.gzzrx.taibao;

import com.alibaba.fastjson.JSON;
import com.bcxin.ins.entity.common.LogBusinessrequest;
import com.bcxin.ins.entity.policy_core.InsOrderReconciliation;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.service.order.LogBusinessrequestService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.third.gzzrx.taibao.GZZRX_PackageMessageTaiBao;
import com.bcxin.ins.third.gzzrx.taibao.util.AESUtilsn;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.vo.InsPreservationRecordVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.SpecialHirelingVo;
import com.bcxin.ins.vo.report_pac.InsCommonReportVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="gZZRX_TBRequestService")
@Transactional
public class GZZRX_TBRequestService {
    private Logger communicatorLog = LoggerFactory.getLogger(GZZRX_TBRequestService.class);
    @Autowired
    private PolicyService policyService;
    @Autowired
    private LogBusinessrequestService logBusinessrequestService;
    private static String messageRouter = "7";
    private static String partnerCode = "ELME";
    private static String documentProtocol = "CPIC_ECOM";

    private String sentHttpPostRequest(String requestMsg) throws Exception {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        int timeout = 60000;
        HttpConnectionParams.setSoTimeout((HttpParams)httpclient.getParams(), (int)timeout);
        HttpPost httppost = new HttpPost(GlobalResources.TB_GZ_API_URL);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("messageRouter", messageRouter));
        params.add(new BasicNameValuePair("tradingPartner", partnerCode));
        params.add(new BasicNameValuePair("documentProtocol", documentProtocol));
        params.add(new BasicNameValuePair("requestMessage", requestMsg));
        UrlEncodedFormEntity request = new UrlEncodedFormEntity(params, "UTF-8");
        httppost.setEntity((HttpEntity)request);
        HttpResponse httpResponse = httpclient.execute((HttpUriRequest)httppost);
        HttpEntity entity = httpResponse.getEntity();
        String result = null;
        if (entity != null) {
            result = EntityUtils.toString((HttpEntity)entity);
        }
        return result;
    }

    public String request_tb_gzzrx(Long order_id, String transType, InsPreservationRecordVo rvo) throws Exception {
        String result;
        block2: {
            this.communicatorLog.info("request_tb_gzzrx\uff1astar-----------------------");
            this.communicatorLog.info("request_tb_gzzrx\uff1a\u63a5\u53e3\u7f16\u7801-" + transType + ",\u8ba2\u5355id-" + order_id + ",RecordVo-" + (rvo != null ? JSON.toJSONString((Object)rvo) : "null"));
            OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
            SpecialHirelingVo vo = this.policyService.accordingToOrderIDToGetSpecialHirelingVo(Long.parseLong(dto.getOid()));
            result = "300#\uff08APP-TB-GZZRX-001\uff09\u7f51\u7edc\u4e0d\u7a33\u5b9a\uff0c\u8bf7\u91cd\u65b0\u8bf7\u6c42\uff01";
            LogBusinessrequest lb = null;
            try {
                String jsonOrig = GZZRX_PackageMessageTaiBao.marshal(vo, dto, transType, rvo);
                this.communicatorLog.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + jsonOrig);
                String json = AESUtilsn.encrypt(jsonOrig, GlobalResources.TB_GZ_SECRET_KEY);
                this.communicatorLog.info("\u8bf7\u6c42\u62a5\u6587(\u52a0\u5bc6)\uff1a" + json);
                this.communicatorLog.info("\u8bf7\u6c42\u5730\u5740\uff1a" + GlobalResources.TB_GZ_API_URL);
                Date bTime = new Date();
                String ret = this.sentHttpPostRequest(json);
                this.communicatorLog.info("\u8fd4\u56de\u62a5\u6587(\u52a0\u5bc6)\uff1a" + ret);
                lb = this.logBusinessrequestService.initLogBusinessrequest(String.valueOf(order_id), transType, GlobalResources.TB_GZ_API_URL, jsonOrig, ret, bTime, new Date(), TransTypeEnum.getAlias((String)transType));
                ret = AESUtilsn.decrypt(ret, GlobalResources.TB_GZ_SECRET_KEY);
                this.communicatorLog.info("\u8fd4\u56de\u62a5\u6587\uff1a" + ret);
                lb.setResponse_message(ret);
                GZZRX_PackageMessageTaiBao gpm = new GZZRX_PackageMessageTaiBao();
                result = GZZRX_PackageMessageTaiBao.returnAnalysisJson(ret, transType);
                this.communicatorLog.info("\u8fd4\u56de\u62a5\u6587\u5904\u7406\uff1a" + result);
                this.logBusinessrequestService.supplementDecAndSave(lb, result.startsWith("300") ? 1 : 0, "");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (lb == null) break block2;
                this.logBusinessrequestService.supplementDecAndSave(lb, 2, ex.getMessage());
            }
        }
        this.communicatorLog.info("request_tb_gzzrx\uff1aend-----------------------");
        return result;
    }

    public String requestReport(Long order_id, InsCommonReportVo vo, String reportDetail, String transType) {
        this.communicatorLog.info("requestReportTB-GZZRX\uff1astar-----------------------");
        this.communicatorLog.info("requestReportTB-GZZRX\uff1a\u63a5\u53e3\u7f16\u7801-" + transType + ",\u8ba2\u5355id-" + order_id);
        SpecialHirelingVo shVo = this.policyService.accordingToOrderIDToGetSpecialHirelingVo(order_id);
        OrderFormVo orderFormVo = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
        String result = "300#\uff08APP-TB-GZZRX-REPORT-001\uff09\u7f51\u7edc\u4e0d\u7a33\u5b9a\uff0c\u8bf7\u91cd\u65b0\u8bf7\u6c42\uff01";
        LogBusinessrequest lb = null;
        try {
            String jsonOrig = GZZRX_PackageMessageTaiBao.marshalReportJson(shVo, reportDetail, vo, transType, orderFormVo);
            this.communicatorLog.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + jsonOrig);
            String json = AESUtilsn.encrypt(jsonOrig, GlobalResources.TB_GZ_SECRET_KEY);
            this.communicatorLog.info("\u8bf7\u6c42\u5730\u5740\uff1a" + GlobalResources.TB_GZ_API_URL);
            Date bTime = new Date();
            String ret = this.sentHttpPostRequest(json);
            lb = this.logBusinessrequestService.initLogBusinessrequest(String.valueOf(order_id), transType, GlobalResources.TB_GZ_API_URL, jsonOrig, ret, bTime, new Date(), TransTypeEnum.getAlias((String)transType));
            this.communicatorLog.info("\u8fd4\u56de\u62a5\u6587(\u52a0\u5bc6)\uff1a" + ret);
            ret = AESUtilsn.decrypt(ret, GlobalResources.TB_GZ_SECRET_KEY);
            this.communicatorLog.info("\u8fd4\u56de\u62a5\u6587\uff1a" + ret);
            GZZRX_PackageMessageTaiBao gpm = new GZZRX_PackageMessageTaiBao();
            result = gpm.returnAnalysisReportJson(ret, transType);
            this.communicatorLog.info("\u8fd4\u56de\u62a5\u6587\u5904\u7406\uff1a" + result);
            this.logBusinessrequestService.supplementDecAndSave(lb, result.startsWith("300") ? 1 : 0, "");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logBusinessrequestService.supplementDecAndSave(lb, 2, ex.getMessage());
        }
        this.communicatorLog.info("requestReportTB-GZZRX\uff1aend-----------------------");
        return result;
    }

    public static List<InsOrderReconciliation> loadReconciliation(String data) throws Exception {
        ArrayList list = Lists.newArrayList();
        DefaultHttpClient httpclient = new DefaultHttpClient();
        int timeout = 60000;
        HttpConnectionParams.setSoTimeout((HttpParams)httpclient.getParams(), (int)timeout);
        HttpPost httppost = new HttpPost("http://jttpitxsit.cpic.com.cn/jttpitx/externalpartner/un/BCX_loadpolicy?CPIC_P_" + data + ".txt");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("messageRouter", messageRouter));
        params.add(new BasicNameValuePair("tradingPartner", partnerCode));
        params.add(new BasicNameValuePair("documentProtocol", documentProtocol));
        params.add(new BasicNameValuePair("requestMessage", ""));
        UrlEncodedFormEntity request = new UrlEncodedFormEntity(params, "UTF-8");
        httppost.setEntity((HttpEntity)request);
        HttpResponse httpResponse = httpclient.execute((HttpUriRequest)httppost);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent(), StandardCharsets.UTF_8));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (!StringUtils.isNotEmpty((CharSequence)line)) continue;
                String[] arr = line.split("||");
                list.add(new InsOrderReconciliation("TB", arr[1], arr[2], Integer.parseInt(arr[3]), Integer.parseInt(arr[4]), arr[5], arr[6], Integer.parseInt(arr[7]), new BigDecimal(arr[8])));
            }
        }
        return list;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(GZZRX_TBRequestService.loadReconciliation("20240405"));
    }

    public String requestReportTB(Long order_id, InsCommonReportVo vo, String reportDetail, String transType) {
        this.communicatorLog.info("requestReportTB-GZZRX\uff1astar-----------------------");
        this.communicatorLog.info("requestReportTB-GZZRX\uff1a\u63a5\u53e3\u7f16\u7801-" + transType + ",\u8ba2\u5355id-" + vo.getIns_common_report_id());
        SpecialHirelingVo shVo = this.policyService.accordingToOrderIDToGetSpecialHirelingVo(order_id);
        String result = "300#\uff08APP-TB-GZZRX-REPORT-001\uff09\u7f51\u7edc\u4e0d\u7a33\u5b9a\uff0c\u8bf7\u91cd\u65b0\u8bf7\u6c42\uff01";
        LogBusinessrequest lb = null;
        try {
            String xml = GZZRX_PackageMessageTaiBao.marshalReport(shVo, reportDetail, vo, transType);
            this.communicatorLog.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + xml);
            this.communicatorLog.info("\u8bf7\u6c42\u5730\u5740\uff1a" + GlobalResources.TB_GZ_API_URL);
            Date bTime = new Date();
            String ret = this.sentHttpPostRequest(xml);
            lb = this.logBusinessrequestService.initLogBusinessrequest(String.valueOf(vo.getIns_common_report_id()), transType, GlobalResources.TB_GZ_API_URL, xml, ret, bTime, new Date(), TransTypeEnum.getAlias((String)transType));
            this.communicatorLog.info("\u8fd4\u56de\u62a5\u6587\uff1a" + ret);
            GZZRX_PackageMessageTaiBao gpm = new GZZRX_PackageMessageTaiBao();
            result = GZZRX_PackageMessageTaiBao.returnAnalysisXml_LP(ret, transType);
            this.communicatorLog.info("\u8fd4\u56de\u62a5\u6587\u5904\u7406\uff1a" + result);
            this.logBusinessrequestService.supplementDecAndSave(lb, result.startsWith("300") ? 1 : 0, "");
        }
        catch (Exception ex) {
            this.logBusinessrequestService.supplementDecAndSave(lb, 2, ex.getMessage());
            ex.printStackTrace();
        }
        this.communicatorLog.info("requestReportTB-GZZRX\uff1aend-----------------------");
        return result;
    }
}

