/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.product.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.ins.dao.product.InsProductResponsibilityAPIDao;
import com.bcxin.ins.entity.product_core.ProResponsibility;
import com.bcxin.ins.service.product.InsProductResponsibilityAPIService;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.ResponsibilityVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InsProductResponsibilityAPIServiceImpl
extends ServiceImpl<InsProductResponsibilityAPIDao, ProResponsibility>
implements InsProductResponsibilityAPIService {
    @Autowired
    private InsProductResponsibilityAPIDao dao;

    @Override
    public List<ResponsibilityVo> getResponsibilityVoListByProductID(Long product_id) {
        return this.dao.getResponsibilityVoListByProductID(product_id);
    }

    @Override
    public List<ResponsibilityVo> findResponsibilityVoList(String pro_primary_id) {
        List<ResponsibilityVo> voList;
        String key = "BLB:CACHE:PRODUCT-RESPONSIBILITY-" + pro_primary_id;
        if (JedisUtils.exists((String)key)) {
            voList = JSON.parseArray((String)JedisUtils.get((String)key), ResponsibilityVo.class);
        } else {
            voList = this.dao.getResponsibilityVoListByProductID(Long.parseLong(pro_primary_id));
            JedisUtils.set((String)key, (String)JSON.toJSONString(voList), (int)ConstProp.ONE_MONTH_TIMEOUT_SECONDS);
        }
        return voList;
    }

    @Override
    public String findResponsibilityIdsByProductID(String pro_primary_id, String is_contain_repo) {
        String str = this.dao.findResponsibilityIdsByProductID(Long.parseLong(pro_primary_id), is_contain_repo);
        return str.endsWith(",") ? str.substring(0, str.length() - 1) : str;
    }

    @Override
    public List<ResponsibilityVo> findResponsibilityVoListByResponsibilityIds(String pro_primary_id, String responsibilityIds) {
        if (StringUtils.isEmpty((CharSequence)responsibilityIds) && StringUtils.isEmpty((CharSequence)pro_primary_id)) {
            return new ArrayList<ResponsibilityVo>();
        }
        if (StringUtils.isEmpty((CharSequence)responsibilityIds)) {
            return this.findResponsibilityVoList(pro_primary_id);
        }
        return this.dao.getResponsibilityVoListByResponsibilityIds(responsibilityIds.split(","));
    }
}

