/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.preservation.impl;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.dao.preservation.InsPreservationRecordAPIDao;
import com.bcxin.ins.entity.policy_core.InsPreservationRecord;
import com.bcxin.ins.service.order.ComTaskResidualAPIService;
import com.bcxin.ins.service.preservation.RecordUpdateStrategy;
import com.bcxin.ins.spring.executor.MyAsyncExecutor;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.vo.OrderFormVo;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RbRecordUpdateStrategy
implements RecordUpdateStrategy {
    private Logger log = LoggerFactory.getLogger(RbRecordUpdateStrategy.class);
    @Autowired
    private ComTaskResidualAPIService comTaskResidualAPIService;
    @Autowired
    private InsPreservationRecordAPIDao insPreservationRecordAPIDao;
    @Autowired
    private MyAsyncExecutor myAsyncExecutor;

    private void updateCommonRecordFields(Map<String, String> map, InsPreservationRecord record) {
        if (map.containsKey("batchNumber")) {
            record.setRevise_serial_num_ins(map.get("batchNumber"));
        }
        if (StringUtils.isNotEmpty((String)map.get("premium"))) {
            record.setTotal_premium(BigDecimal.valueOf(Double.parseDouble(map.get("premium"))));
        }
        if (map.get("eurl") != null) {
            record.setRevise_path(map.get("eurl"));
        }
    }

    @Override
    public int handleRenbaoUpdate(Map<String, String> map, InsPreservationRecord record, OrderFormVo vo, int sign) {
        if (map.get("batchNumber").contains("\u672a\u67e5\u8be2\u5230\u8be5\u6279\u5355\u7533\u8bf7\u53f7")) {
            String batch_number = map.get("batchNumber").replace("\u672a\u67e5\u8be2\u5230\u8be5\u6279\u5355\u7533\u8bf7\u53f7", "").replace("\u7684\u6279\u5355\u53f7\uff01", "");
            this.myAsyncExecutor.execute(() -> {
                HashMap parems = Maps.newHashMap();
                parems.put("record_id", String.valueOf(record.getIns_preservation_record_id()));
                parems.put("batch_number", batch_number);
                this.comTaskResidualAPIService.saveComTaskResidual("updateBatchNumber", "\u4fee\u6539\u4eba\u4fdd\u4fdd\u5168\u6279\u5355\u53f7", "com.bcxin.ins.service.preservation.InsPreservationRecordAPIService", 1, "String", JSONObject.toJSONString((Object)parems));
            });
        }
        this.updateCommonRecordFields(map, record);
        sign = 1;
        return sign;
    }

    @Override
    public int handlePingAnCaiUpdate(Map<String, String> map, InsPreservationRecord record, OrderFormVo vo, int sign) {
        if (map.get("batchNumber").contains("\u672a\u67e5\u8be2\u5230\u8be5\u6279\u5355\u7533\u8bf7\u53f7")) {
            String batch_number = map.get("batchNumber").replace("\u672a\u67e5\u8be2\u5230\u8be5\u6279\u5355\u7533\u8bf7\u53f7", "").replace("\u7684\u6279\u5355\u53f7\uff01", "");
            this.myAsyncExecutor.execute(() -> {
                HashMap parems = Maps.newHashMap();
                parems.put("record_id", String.valueOf(record.getIns_preservation_record_id()));
                parems.put("batch_number", batch_number);
                this.comTaskResidualAPIService.saveComTaskResidual("updateBatchNumber", "\u4fee\u6539\u4eba\u4fdd\u4fdd\u5168\u6279\u5355\u53f7", "com.bcxin.ins.service.preservation.InsPreservationRecordAPIService", 1, "String", JSONObject.toJSONString((Object)parems));
            });
        }
        this.updateCommonRecordFields(map, record);
        sign = 1;
        return sign;
    }

    @Override
    public int handleHuataiUpdate(Map<String, String> map, InsPreservationRecord record, int sign) {
        this.updateCommonRecordFields(map, record);
        record.setRevise_status("2");
        this.insPreservationRecordAPIDao.updateById(record);
        return sign;
    }

    @Override
    public int handleZhonghuaUpdate(Map<String, String> map, InsPreservationRecord record, int sign) {
        this.updateCommonRecordFields(map, record);
        if (StringUtils.isNotEmpty((String)map.get("tbsxsj"))) {
            record.setInception_date(DateUtil.parseDate((String)map.get("tbsxsj")));
        }
        sign = 1;
        return sign;
    }

    @Override
    public int handleTaipingyangUpdate(Map<String, String> map, InsPreservationRecord record, int sign) {
        if (StringUtils.isEmpty((String)map.get("batchNumber")) && "1".equals(record.getRevise_type())) {
            record.setRevise_pay(map.get("payurl"));
            if (StringUtils.isNotEmpty((String)map.get("batchApplyNumber")) && !map.get("batchApplyNumber").equals(record.getRevise_serial_number())) {
                record.setRevise_serial_number(map.get("batchApplyNumber"));
            }
            record.setRevise_status("2");
        } else {
            this.updateCommonRecordFields(map, record);
            sign = 1;
        }
        this.insPreservationRecordAPIDao.updateById(record);
        return sign;
    }

    @Override
    public int handleChanganUpdate(Map<String, String> map, InsPreservationRecord record, String productCode, int sign) {
        this.updateCommonRecordFields(map, record);
        if (productCode.contains("GZZRX-CA")) {
            this.insPreservationRecordAPIDao.updateById(record);
        } else if (productCode.contains("TYX-CA")) {
            sign = 1;
        }
        return sign;
    }

    @Override
    public int handleQianhaiUpdate(Map<String, String> map, InsPreservationRecord record, int sign) {
        this.updateCommonRecordFields(map, record);
        sign = 1;
        return sign;
    }
}

