/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.dao.order.InsCaseScheduleAPIDao;
import com.bcxin.ins.entity.policy_report.InsCaseSchedule;
import com.bcxin.ins.service.order.InsCaseScheduleAPIService;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.report_pac.InsCaseScheduleVo;
import com.bcxin.ins.vo.report_pac.InsCommonReportVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
@Transactional
public class InsCaseScheduleAPIServiceImpl
extends ServiceImpl<InsCaseScheduleAPIDao, InsCaseSchedule>
implements InsCaseScheduleAPIService {
    @Autowired
    private InsCaseScheduleAPIDao dao;

    @Override
    public void accordingToTheInsCommonReportVoSetUpInsCaseSchedule(InsCommonReportVo vo, Long report_id) {
        List hvoList = vo.getCaseScheduleVoList();
        InsCaseSchedule icf = null;
        ArrayList ahs = Lists.newArrayList();
        ArrayList uhs = Lists.newArrayList();
        try {
            IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
            for (InsCaseScheduleVo hvo : hvoList) {
                if (hvo.isNull()) continue;
                if (StringUtils.isNotEmpty((CharSequence)hvo.getIns_case_schedule_id())) {
                    icf = new InsCaseSchedule();
                    icf.setIns_case_schedule_id(Long.valueOf(Long.parseLong(hvo.getIns_case_schedule_id())));
                    icf.setIns_common_report_id(report_id);
                    try {
                        MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)hvo), (Object)icf);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    uhs.add(icf);
                    continue;
                }
                icf = new InsCaseSchedule();
                icf.setIns_case_schedule_id(Long.valueOf(idWorker.nextId()));
                try {
                    MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)hvo), (Object)icf);
                    icf.setIns_common_report_id(report_id);
                    icf.setCreate_time(new Date());
                    icf.setCreate_by(new SysUser(Long.valueOf(Long.parseLong(vo.getRegister_user_id()))));
                    icf.setStatus(Integer.valueOf(0));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ahs.add(icf);
            }
            if (ahs.size() > 0) {
                this.dao.batchInsert(ahs);
            }
            if (uhs.size() > 0) {
                this.dao.batchUpdate(uhs);
            }
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            e.printStackTrace();
        }
    }

    @Override
    public void getInsCommonReportVoByReportID(InsCommonReportVo vo, Long report_id) {
        List<InsCaseScheduleVo> list = this.dao.selectInsCaseScheduleVoByReportId(report_id);
        int count = 0;
        if (list != null) {
            count = list.size() < 3 ? list.size() : 100;
        }
        if (count == 100) {
            for (int i = count; i < 3; ++i) {
                list.add(new InsCaseScheduleVo());
            }
        }
        vo.setCaseScheduleVoList(list);
    }

    @Override
    public boolean delectInsCaseScheduleByOid(Long oid) {
        try {
            this.dao.deleteById(oid);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean delectAllInsCaseSchedule(Long oid) {
        try {
            HashMap map = Maps.newHashMap();
            map.put("ins_common_report_id", oid);
            this.dao.deleteByMap(map);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

