/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.dao.order.InsCaseInfoAPIDao;
import com.bcxin.ins.entity.policy_report.InsCaseInfo;
import com.bcxin.ins.service.order.InsCaseInfoAPIService;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.report_pac.InsCaseInfoVo;
import com.bcxin.ins.vo.report_pac.InsCommonReportVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
@Transactional
public class InsCaseInfoAPIServiceImpl
extends ServiceImpl<InsCaseInfoAPIDao, InsCaseInfo>
implements InsCaseInfoAPIService {
    @Autowired
    private InsCaseInfoAPIDao dao;

    @Override
    public InsCaseInfo initInsCaseInfo(Long user_id, Long report_id) {
        InsCaseInfo insCaseInfo = new InsCaseInfo();
        insCaseInfo.setIns_common_report_id(report_id);
        insCaseInfo.setCreate_time(new Date());
        insCaseInfo.setCreate_by(new SysUser(user_id));
        this.dao.insert(insCaseInfo);
        return insCaseInfo;
    }

    @Override
    public void accordingToTheInsCommonReportVoSetUpInsCaseInfo(InsCommonReportVo vo, Long report_id) {
        List hvoList = vo.getCaseInfoVoList();
        InsCaseInfo icf = null;
        ArrayList ahs = Lists.newArrayList();
        ArrayList uhs = Lists.newArrayList();
        try {
            IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
            for (InsCaseInfoVo hvo : hvoList) {
                if (hvo.isNull()) continue;
                if (StringUtils.isNotEmpty((CharSequence)hvo.getIns_case_info_id())) {
                    icf = new InsCaseInfo();
                    icf.setIns_case_info_id(Long.valueOf(Long.parseLong(hvo.getIns_case_info_id())));
                    icf.setIns_common_report_id(report_id);
                    try {
                        MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)hvo), (Object)icf);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    uhs.add(icf);
                    continue;
                }
                icf = new InsCaseInfo();
                icf.setIns_case_info_id(Long.valueOf(idWorker.nextId()));
                try {
                    MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)hvo), (Object)icf);
                    icf.setIns_common_report_id(report_id);
                    icf.setCreate_time(new Date());
                    icf.setCreate_by(new SysUser(Long.valueOf(Long.parseLong(vo.getRegister_user_id()))));
                    icf.setStatus(Integer.valueOf(0));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ahs.add(icf);
            }
            if (ahs.size() > 0) {
                this.dao.batchInsert(ahs);
            }
            if (uhs.size() > 0) {
                this.dao.batchUpdate(uhs);
            }
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            e.printStackTrace();
        }
    }

    @Override
    public void getInsCommonReportVoByReportID(InsCommonReportVo vo, Long report_id) {
        List<InsCaseInfoVo> list = this.dao.selectInsCaseInfoVoByReportId(report_id);
        int count = 0;
        if (list != null) {
            count = list.size() < 3 ? list.size() : 100;
        }
        if (count == 100) {
            for (int i = count; i < 3; ++i) {
                list.add(new InsCaseInfoVo());
            }
        }
        vo.setCaseInfoVoList(list);
    }

    @Override
    public boolean delectInsCaseInfoByOid(Long oid) {
        try {
            this.dao.deleteById(oid);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean delectAllInsCaseInfo(Long oid) {
        try {
            HashMap map = Maps.newHashMap();
            map.put("ins_common_report_id", oid);
            this.dao.deleteByMap(map);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

