/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.HirelingAPIDao;
import com.bcxin.ins.entity.policy_special.Hireling;
import com.bcxin.ins.service.order.HirelingAPIService;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.HirelingVo;
import com.bcxin.ins.vo.SpecialHirelingVo;
import com.bcxin.ins.vo.excel.ResultSetExcelVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
@Transactional
public class HirelingAPIServiceImpl
extends ServiceImpl<HirelingAPIDao, Hireling>
implements HirelingAPIService {
    @Autowired
    private HirelingAPIDao dao;

    @Override
    public void accordingToTheHirelingVoSetUpHireling(SpecialHirelingVo vo, Long order_id) {
        List hvoList = vo.getHirelingVoList();
        Hireling hireling = null;
        ArrayList ahs = Lists.newArrayList();
        ArrayList uhs = Lists.newArrayList();
        try {
            IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
            for (HirelingVo hvo : hvoList) {
                if (hvo.isNull()) continue;
                if (StringUtils.isNotEmpty((CharSequence)hvo.getOid())) {
                    hireling = new Hireling();
                    hireling.setHireling_id(Long.valueOf(Long.parseLong(hvo.getOid())));
                    hireling.setIns_insurance_slip_id(order_id);
                    try {
                        MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)hvo), (Object)hireling);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    uhs.add(hireling);
                    continue;
                }
                hireling = new Hireling();
                hireling.setHireling_id(Long.valueOf(idWorker.nextId()));
                try {
                    MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)hvo), (Object)hireling);
                    hireling.setIns_insurance_slip_id(order_id);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ahs.add(hireling);
            }
            if (ahs.size() > 0) {
                this.dao.batchInsert(ahs);
            }
            if (uhs.size() > 0) {
                this.dao.batchUpdate(uhs);
            }
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            e.printStackTrace();
        }
    }

    @Override
    public void getSpecialHirelingVoByOrderID(SpecialHirelingVo vo, Long order_id) {
        List<HirelingVo> list = this.dao.selectHirelingVoByOrderId(order_id);
        int count = 0;
        if (list != null) {
            count = list.size() < 3 ? list.size() : 100;
        }
        if (count == 100) {
            for (int i = count; i < 3; ++i) {
                list.add(new HirelingVo());
            }
        }
        vo.setHirelingVoList(list);
    }

    @Override
    public boolean delectHirelingByOid(Long oid) {
        try {
            this.dao.deleteById(oid);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean delectAllHireling(Long oid) {
        try {
            HashMap map = Maps.newHashMap();
            map.put("ins_insurance_slip_id", oid);
            this.dao.deleteByMap(map);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public List<ResultSetExcelVo> selectHirelingListByOrderID(Long order_id) {
        return this.dao.selectHirelingListByOrderID(order_id);
    }
}

