/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.order.impl;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.dao.order.ComTaskResidualAPIDao;
import com.bcxin.ins.entity.common.ComTaskResidual;
import com.bcxin.ins.service.order.ComTaskResidualAPIService;
import com.bcxin.ins.spring.executor.MyAsyncExecutor;
import com.bcxin.ins.spring.util.SpringContextHolder;
import com.bcxin.ins.vo.shop.ImportInsuranceOrderRequest;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ComTaskResidualAPIServiceImpl
extends ServiceImpl<ComTaskResidualAPIDao, ComTaskResidual>
implements ComTaskResidualAPIService {
    @Autowired
    private ComTaskResidualAPIDao dao;
    @Autowired
    private MyAsyncExecutor myAsyncExecutor;
    private Logger log = LoggerFactory.getLogger(ComTaskResidualAPIServiceImpl.class);

    @Override
    public void disposeComTaskResidualList(String is_nightly_run) {
        HashMap columnMap = Maps.newHashMap();
        if (StringUtils.isNotEmpty((CharSequence)is_nightly_run)) {
            columnMap.put("is_nightly_run", is_nightly_run);
        }
        List ctrList = this.dao.selectByMap(columnMap);
        for (ComTaskResidual ctr : ctrList) {
            try {
                Thread.sleep(300L);
                this.myAsyncExecutor.execute(() -> this.applyReturnBooleanOfClassReflect(ctr));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void applyReturnBooleanOfClassReflect(ComTaskResidual ctr) {
        ClassLoader cls = Thread.currentThread().getContextClassLoader();
        String errEsg = "";
        try {
            Class<?> c = cls.loadClass(ctr.getClass_name());
            String[] tArr = ctr.getParam_type_arr().split(",");
            String[] vArr = ctr.getParam_value_arr().split(",", -1);
            Class[] csArr = new Class[ctr.getParam_num()];
            Object[] otArr = new Object[ctr.getParam_num()];
            for (int i = 0; i < ctr.getParam_num(); ++i) {
                String tp = tArr[i];
                if ("String".equals(tp)) {
                    csArr[i] = String.class;
                    otArr[i] = String.valueOf(vArr[i]);
                    continue;
                }
                if ("int".equals(tp)) {
                    csArr[i] = Integer.TYPE;
                    otArr[i] = Integer.parseInt(vArr[i]);
                    continue;
                }
                if ("BigDecimal".equals(tp)) {
                    csArr[i] = BigDecimal.class;
                    otArr[i] = new BigDecimal(vArr[i]);
                    continue;
                }
                if ("Long".equals(tp)) {
                    csArr[i] = Long.class;
                    otArr[i] = Long.parseLong(vArr[i]);
                    continue;
                }
                if ("com.bcxin.ins.vo.shop.ImportInsuranceOrderRequest".equals(tp)) {
                    csArr[i] = ImportInsuranceOrderRequest.class;
                    otArr[i] = JSONObject.parseObject((String)ctr.getParam_value_arr(), Class.forName(ctr.getParam_type_arr()));
                    continue;
                }
                csArr[i] = Object.class;
                otArr[i] = JSONObject.parseObject((String)ctr.getParam_value_arr(), Class.forName(ctr.getParam_type_arr()));
            }
            Object o = SpringContextHolder.getBean(c);
            Method method = o.getClass().getDeclaredMethod(ctr.getMethod_name(), csArr);
            method.setAccessible(true);
            Object r = method.invoke(o, otArr);
            boolean ret = false;
            if (r != null && r.getClass().equals(Boolean.class)) {
                ret = (Boolean)r;
            } else if (r != null && r.getClass().equals(String.class)) {
                ret = true;
            }
            if (ret) {
                this.dao.deleteById(ctr.getCom_task_residual_id());
            } else {
                errEsg = "Apply Method Fail!!--------------------------";
            }
        }
        catch (ClassNotFoundException e) {
            errEsg = e.getMessage();
        }
        catch (IllegalAccessException e) {
            errEsg = e.getMessage();
        }
        catch (NoSuchMethodException e) {
            errEsg = e.getMessage();
        }
        catch (SecurityException e) {
            errEsg = e.getMessage();
        }
        catch (IllegalArgumentException e) {
            errEsg = e.getMessage();
        }
        catch (InvocationTargetException e) {
            errEsg = e.getMessage();
        }
        if (StringUtils.isNotEmpty((CharSequence)errEsg)) {
            this.log.info("----------ComTaskResidual\u672a\u6210\u529f\u4efb\u52a1\u53cd\u5c04\u6267\u884c\uff08" + ctr.getAnnotation() + "\uff09,ExceptionMessage\uff1a" + errEsg);
        }
    }

    @Override
    public void saveComTaskResidual(String method_name, String annotation, String class_name, int param_num, String param_type_arr, String param_value_arr) {
        List list = this.dao.selectList(new EntityWrapper().addFilter("method_name = {0} and param_value_arr = {1}", new Object[]{method_name, param_value_arr}));
        if (list.size() > 0) {
            System.out.println("=======> \u6253\u56de\u6253\u56de");
            return;
        }
        ComTaskResidual ctr = new ComTaskResidual(method_name, annotation, class_name, param_num, param_type_arr, param_value_arr, "0");
        this.myAsyncExecutor.execute(() -> this.dao.insert(ctr));
    }

    @Override
    public void saveComTaskResidual2(String method_name, String annotation, String class_name, int param_num, String param_type_arr, String param_value_arr) {
        ComTaskResidual ctr = new ComTaskResidual(method_name, annotation, class_name, param_num, param_type_arr, param_value_arr, "1");
        this.myAsyncExecutor.execute(() -> this.dao.insert(ctr));
    }

    public static void main(String[] args) {
        ComTaskResidualAPIServiceImpl c = new ComTaskResidualAPIServiceImpl();
        ComTaskResidual ctr = (ComTaskResidual)c.selectById(Long.valueOf(1026392461119287297L));
        c.applyReturnBooleanOfClassReflect(ctr);
    }
}

