/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.oauth;

import com.alibaba.fastjson.JSON;
import com.bcxin.ins.dto.Result;
import com.bcxin.ins.dto.oauth.AccessToken;
import com.bcxin.ins.dto.oauth.OAuthTokenxRequest;
import com.bcxin.ins.service.oauth.OAuthService;
import com.bcxin.ins.service.user.ClientUserService;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.util.AESUtil;
import com.bcxin.ins.util.MathUtil;
import com.bcxin.ins.vo.ClientUserVo;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.oltu.oauth2.as.issuer.MD5Generator;
import org.apache.oltu.oauth2.as.issuer.OAuthIssuerImpl;
import org.apache.oltu.oauth2.as.issuer.ValueGenerator;
import org.apache.oltu.oauth2.as.response.OAuthASResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.OAuthResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OAuthServiceImpl
implements OAuthService {
    private static Logger logger = LoggerFactory.getLogger(OAuthServiceImpl.class);
    @Autowired
    private ClientUserService userService;

    @Override
    public Result saveDispatch(HttpServletRequest request, HttpServletResponse response, String clientType) throws Exception {
        OAuthTokenxRequest oauthRequest = new OAuthTokenxRequest(request);
        Map<Boolean, OAuthResponse> handleResult = this.handle(oauthRequest, clientType);
        if (handleResult.containsKey(true)) {
            return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", handleResult.get(true) == null ? null : JSON.parse((String)handleResult.get(true).getBody()));
        }
        return Result.fail((String)(handleResult.get(false) == null ? "\u53c2\u6570\u9519\u8bef\uff01" : JSON.parseObject((String)handleResult.get(false).getBody()).getString("error_description")));
    }

    private Map<Boolean, OAuthResponse> handle(OAuthTokenxRequest oauthRequest, String clientType) throws OAuthProblemException, OAuthSystemException {
        HashMap<Boolean, OAuthResponse> result = new HashMap<Boolean, OAuthResponse>();
        OAuthResponse validateResponse = null;
        String userName = oauthRequest.getUsername();
        String passWord = oauthRequest.getPassword();
        String publicKey = oauthRequest.getPublicKey();
        if (StringUtils.isEmpty((CharSequence)userName) || StringUtils.isEmpty((CharSequence)passWord) || StringUtils.isEmpty((CharSequence)publicKey)) {
            validateResponse = OAuthResponse.errorResponse((int)400).setError("invalid_grant").setErrorDescription("\u53c2\u6570\u9519\u8bef").buildJSONMessage();
            result.put(false, validateResponse);
            return result;
        }
        try {
            byte[] bytes = publicKey.getBytes();
            byte[] data = Hex.decodeHex((char[])passWord.toCharArray());
            byte[] s = new byte[]{};
            s = AESUtil.AES_CBC_Decrypt((byte[])data, (byte[])bytes, (byte[])bytes);
            passWord = new String(s);
            if (!userName.equals(passWord)) {
                validateResponse = OAuthResponse.errorResponse((int)400).setError("invalid_grant").setErrorDescription("\u7528\u6237\u6216\u8005\u5bc6\u7801\u9519\u8bef").buildJSONMessage();
                result.put(false, validateResponse);
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ClientUserVo userVo = this.userService.getClientUserVo(userName, MathUtil.getType((String)userName));
        if (userVo == null) {
            validateResponse = OAuthResponse.errorResponse((int)400).setError("invalid_grant").setErrorDescription("\u7528\u6237\u4e0d\u5b58\u5728").buildJSONMessage();
            result.put(false, validateResponse);
            return result;
        }
        OAuthResponse oAuthResponse = this.handleAfterValidation(oauthRequest.getRedirectURI(), clientType, userVo);
        result.put(true, oAuthResponse);
        return result;
    }

    private OAuthResponse handleAfterValidation(String redirectURI, String clientType, ClientUserVo userVo) throws OAuthProblemException, OAuthSystemException {
        AccessToken accessToken = this.retrieveAccessToken(clientType, userVo);
        OAuthResponse tokenResponse = this.createTokenResponse(redirectURI, accessToken);
        return tokenResponse;
    }

    private OAuthResponse createTokenResponse(String redirectURI, AccessToken accessToken) throws OAuthSystemException {
        OAuthASResponse.OAuthTokenResponseBuilder builder = OAuthASResponse.tokenResponse((int)200).location(redirectURI).setAccessToken(accessToken.getTokenId()).setExpiresIn(String.valueOf(accessToken.currentTokenExpiredSeconds())).setTokenType(accessToken.getTokenType());
        String refreshToken = accessToken.getRefreshToken();
        if (StringUtils.isNotEmpty((CharSequence)refreshToken)) {
            builder.setRefreshToken(refreshToken);
        }
        if (StringUtils.isNotEmpty((CharSequence)redirectURI)) {
            builder.setParam("redirect_uri", redirectURI);
        }
        return builder.buildJSONMessage();
    }

    @Override
    public AccessToken getAccessToken(String clientType, ClientUserVo userVo, String tokenId) throws OAuthSystemException {
        String loginId = userVo.getOid();
        AccessToken accessToken = null;
        String value = JedisUtils.get((String)("BLB:CACHE:UIP-" + loginId));
        if (StringUtils.isNotEmpty((CharSequence)value) && (accessToken = (AccessToken)JedisUtils.getObject((String)("BLB:CACHE:BLB-REQ-TOKEN-" + value))) != null) {
            return accessToken;
        }
        accessToken = this.createAccessToken(userVo, clientType, tokenId);
        return accessToken;
    }

    private AccessToken retrieveAccessToken(String clientType, ClientUserVo userVo) throws OAuthSystemException {
        String loginId = userVo.getOid();
        AccessToken accessToken = null;
        String value = JedisUtils.get((String)("BLB:CACHE:UIP-" + loginId));
        if (StringUtils.isNotEmpty((CharSequence)value) && (accessToken = (AccessToken)JedisUtils.getObject((String)("BLB:CACHE:BLB-REQ-TOKEN-" + value))) != null) {
            JedisUtils.del((String)loginId);
            JedisUtils.delObject((String)("BLB:CACHE:BLB-REQ-TOKEN-" + accessToken.getTokenId()));
        }
        accessToken = this.createAccessToken(userVo, clientType, "");
        return accessToken;
    }

    private AccessToken createAccessToken(ClientUserVo userVo, String clientType, String tokenId) throws OAuthSystemException {
        OAuthIssuerImpl oauthIssuer = new OAuthIssuerImpl((ValueGenerator)new MD5Generator());
        String accessTokenString = oauthIssuer.accessToken();
        if (StringUtils.isNotEmpty((CharSequence)tokenId)) {
            accessTokenString = tokenId;
        }
        AccessToken accessToken = null;
        int seconds = 0;
        seconds = 86400;
        accessToken = new AccessToken();
        accessToken.setWebId(userVo.getWeb_id());
        accessToken.setWebType(userVo.getWeb_type());
        accessToken.setUserId(userVo.getOid());
        accessToken.setName(userVo.getReal_name());
        accessToken.setLoginName(userVo.getLogin_name());
        accessToken.setTokenId(accessTokenString);
        accessToken.setTokenExpiredSeconds(seconds);
        accessToken.setRefreshToken(oauthIssuer.refreshToken());
        accessToken.setUserVo(userVo);
        JedisUtils.set((String)("BLB:CACHE:UIP-" + userVo.getOid()), (String)accessTokenString, (int)seconds);
        JedisUtils.setObject((String)("BLB:CACHE:BLB-REQ-TOKEN-" + accessTokenString), (Object)accessToken, (int)seconds);
        return accessToken;
    }

    @Override
    public AccessToken getAccessToken(String access_token) {
        AccessToken accessToken = (AccessToken)JedisUtils.getObject((String)("BLB:CACHE:BLB-REQ-TOKEN-" + access_token));
        if (accessToken != null && accessToken.tokenExpired()) {
            accessToken = null;
        }
        return accessToken;
    }

    public static void main(String[] args) throws Exception {
        String userName = "15601000000";
        String passWord = "86b955d41be7a1ce4b8db67da688103e";
        String publicKey = "wdMFAbNpSmRJEmOl";
        if (StringUtils.isNotEmpty((CharSequence)publicKey)) {
            byte[] bytes = publicKey.getBytes();
            byte[] data = Hex.decodeHex((char[])passWord.toCharArray());
            byte[] s = AESUtil.AES_CBC_Decrypt((byte[])data, (byte[])bytes, (byte[])bytes);
            passWord = new String(s);
            System.out.println(passWord);
        }
    }
}

