/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.preservation.impl;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.dao.preservation.InsPreservationDetailAPIDao;
import com.bcxin.ins.entity.policy_core.InsPreservationDetail;
import com.bcxin.ins.entity.policy_core.InsPreservationRecord;
import com.bcxin.ins.entity.policy_core.InsPreservationResultSet;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.preservation.InsPreservationDetailAPIService;
import com.bcxin.ins.service.preservation.InsPreservationRecordAPIService;
import com.bcxin.ins.service.preservation.InsPreservationResultSetAPIService;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.IdCardVerify;
import com.bcxin.ins.util.IdNumberValidator;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.ValidatorUtil;
import com.bcxin.ins.util.excel.ExcelUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.InsPreservationDetailVo;
import com.bcxin.ins.vo.InsPreservationRecordVo;
import com.bcxin.ins.vo.InsPreservationResultSetVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.excel.RecordDetailExcelVo;
import com.bcxin.ins.vo.excel.ResultSetExcelVo;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional
public class InsPreservationDetailAPIServiceImpl
extends ServiceImpl<InsPreservationDetailAPIDao, InsPreservationDetail>
implements InsPreservationDetailAPIService {
    private Logger log = LoggerFactory.getLogger(InsPreservationDetailAPIServiceImpl.class);
    @Autowired
    private InsPreservationDetailAPIDao insPreservationDetailAPIDao;
    @Autowired
    private InsPreservationRecordAPIService insPreservationRecordAPIService;
    @Autowired
    private InsPreservationResultSetAPIService insPreservationResultSetAPIService;
    @Autowired
    private PolicyService policyService;

    @Override
    public List<InsPreservationDetail> findInsPreservationDetailByKeyword(DwzPage page, Long preservationId, String keyword) {
        List<InsPreservationDetail> list = null;
        if (page != null) {
            Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
            list = this.insPreservationDetailAPIDao.findInsPreservationDetailByKeyword((Page<InsPreservationDetail>)pageHelper, preservationId, keyword);
            page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
        } else {
            list = this.insPreservationDetailAPIDao.findInsPreservationDetailByKeyword(preservationId, keyword);
        }
        return list;
    }

    @Override
    public List<InsPreservationDetailVo> findInsPreservationDetailVoByKeyword(DwzPage page, Long preservationId, String keyword) {
        List<InsPreservationDetailVo> list = null;
        if (page != null) {
            Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
            list = this.insPreservationDetailAPIDao.findInsPreservationDetailVoByKeyword((Page<InsPreservationDetailVo>)pageHelper, preservationId, keyword);
            page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
        } else {
            list = this.insPreservationDetailAPIDao.findInsPreservationDetailVoByKeyword(preservationId, keyword);
        }
        return list;
    }

    @Override
    public List<InsPreservationDetailVo> findInsPreservationDetailVoByPreservationId(String sign, Long preservationId) {
        return this.insPreservationDetailAPIDao.findInsPreservationDetailVoByPreservationId(sign, preservationId);
    }

    @Override
    public boolean deleteInsPreservationDetail(Long oid) {
        boolean flag = true;
        InsPreservationDetail ipd = (InsPreservationDetail)this.selectById(oid);
        if (ipd != null) {
            ipd.setStatus(ConstProp.INT_NUMBER_TWO.intValue());
            try {
                this.updateById(ipd);
            }
            catch (Exception e) {
                this.log.error("\u4fdd\u5168\u4eba\u5458\u5220\u9664\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            }
        } else {
            flag = false;
        }
        return flag;
    }

    @Override
    public boolean saveOrUpdateInsPreservationDetail(String revise_type, Long iprID, List<InsPreservationDetailVo> ipdVoList) {
        try {
            if (ipdVoList == null || ipdVoList.isEmpty()) {
                return true;
            }
            ArrayList apd = Lists.newArrayList();
            ArrayList upd = Lists.newArrayList();
            InsPreservationDetail ipd = null;
            InsPreservationRecord record = (InsPreservationRecord)this.insPreservationRecordAPIService.selectById(iprID);
            for (InsPreservationDetailVo ipdVo : ipdVoList) {
                ipd = new InsPreservationDetail();
                MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)ipdVo), (Object)ipd);
                ipd.setIns_preservation_record_id(iprID);
                if (StringUtils.isNotEmpty((String)ipdVo.getBusiness_id())) {
                    ipd.setBusiness_id(Long.valueOf(Long.parseLong(ipdVo.getBusiness_id())));
                } else if ("2".equals(revise_type)) {
                    ipd.setBusiness_id(this.insPreservationResultSetAPIService.getIdByIdCardAndOrderId(ipdVo.getId_card(), record.getIns_insurance_slip_id()));
                    ipd.setBusiness_type("PRESERVE");
                }
                if (StringUtils.isNotEmpty((String)ipdVo.getPrev_record_id())) {
                    ipd.setPrev_record_id(Long.valueOf(Long.parseLong(ipdVo.getPrev_record_id())));
                }
                ipd.setStatus(0);
                ipd.setRevise_time(new Date());
                if (StringUtils.isBlank((String)ipdVo.getOid())) {
                    ipd.setIns_preservation_detail_id(Long.valueOf(IdWorker.getId()));
                    apd.add(ipd);
                    continue;
                }
                ipd.setIns_preservation_detail_id(Long.valueOf(Long.parseLong(ipdVo.getOid())));
                ipd.setPrev_card(ipdVo.getPrev_card());
                upd.add(ipd);
            }
            if (apd.size() > 0) {
                this.insPreservationDetailAPIDao.batchInsert(apd);
            }
            if (upd.size() > 0) {
                this.insPreservationDetailAPIDao.batchUpdate(upd);
            }
            return true;
        }
        catch (Exception e) {
            this.log.error("\u4fdd\u5168\u4eba\u5458\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String isDuplicateIdCardNoToPreservationDetail(String order_id, List<InsPreservationDetailVo> list) {
        String[] idcards = new String[list.size()];
        int count = 0;
        for (InsPreservationDetailVo pvo : list) {
            idcards[count] = pvo.getId_card();
            ++count;
        }
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(order_id));
        String str = this.insPreservationResultSetAPIService.findDuplicateIdCardNo(dto.getApplicant_name(), dto.getProduct_code().split("-")[0], idcards);
        if (StringUtils.isNotEmpty((String)str)) {
            return "300#\u90e8\u5206\u8bc1\u4ef6\u53f7\u5df2\u5728\u4fdd\uff0c\u65e0\u6cd5\u91cd\u590d\u6295\u4fdd\uff1a" + str;
        }
        return "200#\u8be5\u8bb0\u5f55\u6821\u9a8c\u901a\u8fc7\u3002";
    }

    @Override
    public String notUnderWarrantyIdCardNo(String order_id, List<InsPreservationDetailVo> list) {
        String[] idcards = new String[list.size()];
        int count = 0;
        for (InsPreservationDetailVo pvo : list) {
            idcards[count] = pvo.getId_card();
            ++count;
        }
        String str = this.insPreservationResultSetAPIService.findNotUnderWarrantyIdCardNo(order_id, idcards);
        if (StringUtils.isNotEmpty((String)str)) {
            return "300#\u90e8\u5206\u4eba\u5458\u5df2\u4e0d\u5728\u4fdd\uff0c\u4e0d\u80fd\u91cd\u590d\u51cf\u5458\u64cd\u4f5c\uff1a" + str;
        }
        return "200#\u8be5\u8bb0\u5f55\u6821\u9a8c\u901a\u8fc7\u3002";
    }

    @Override
    public String personnelToCheck(InsPreservationDetailVo vo, String revise_type) {
        if (StringUtils.isBlank((String)vo.getName()) || StringUtils.isBlank((String)vo.getBirthday()) || StringUtils.isBlank((String)vo.getCareer()) || StringUtils.isBlank((String)vo.getId_card()) || StringUtils.isBlank((String)vo.getId_type()) || StringUtils.isBlank((String)vo.getSex())) {
            return "300#\u4eba\u5458\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002";
        }
        if ("0".equals(vo.getId_type())) {
            if (!IdCardVerify.isValidatedAllIdcard((String)vo.getId_card())) {
                return "300#\u8bc1\u4ef6\u53f7\u7801\u4e3a\uff1a" + vo.getId_card() + "\u4eba\u5458\u7684\u8bc1\u4ef6\u53f7\u7801\u4e0d\u662f\u6709\u6548\u8bc1\u4ef6\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u3002";
            }
            if (!IdNumberValidator.verifyB((String)vo.getId_card(), (Date)DateUtil.convertStringToDate((String)vo.getBirthday()))) {
                return "300#\u8bc1\u4ef6\u53f7\u7801\u4e3a\uff1a" + vo.getId_card() + "\u4eba\u5458\u7684\u51fa\u751f\u65e5\u671f\u4e0d\u5339\u914d\u3002";
            }
            if (!(StringUtils.isNotEmpty((String)revise_type) && "2".equals(revise_type) || IdNumberValidator.getAgeFromCard((String)vo.getId_card()) <= 65 && IdNumberValidator.getAgeFromCard((String)vo.getId_card()) >= 16)) {
                return "300#\u8bc1\u4ef6\u53f7\u7801\u4e3a\uff1a" + vo.getId_card() + "\u4eba\u5458\u7684\u5e74\u9f84\u8d85\u51fa\u9650\u5236\uff08\u533a\u95f4\uff1a16-60\u5468\u5c81\uff09\u3002";
            }
            if (!IdNumberValidator.verifyG((String)vo.getId_card(), (String)vo.getSex())) {
                return "300#\u8bc1\u4ef6\u53f7\u7801\u4e3a\uff1a" + vo.getId_card() + "\u4eba\u5458\u7684\u6027\u522b\u4e0d\u5339\u914d\u3002";
            }
        } else if (!"0".equals(vo.getId_type())) {
            if (!(StringUtils.isNotEmpty((String)revise_type) && "2".equals(revise_type) || IdNumberValidator.getAgeFromBirthday((String)vo.getBirthday()) <= 65 && IdNumberValidator.getAgeFromBirthday((String)vo.getBirthday()) >= 16)) {
                return "300#\u8bc1\u4ef6\u53f7\u7801\u4e3a\uff1a" + vo.getId_card() + "\u4eba\u5458\u7684\u5e74\u9f84\u8d85\u51fa\u9650\u5236\uff08\u533a\u95f4\uff1a16-60\u5468\u5c81\uff09\u3002";
            }
        } else if (!ValidatorUtil.validatePhone((String)vo.getTel())) {
            return "300#\u8bc1\u4ef6\u53f7\u7801\u4e3a\uff1a" + vo.getId_card() + "\u4eba\u5458\u7684\u624b\u673a\u53f7\u7801\u683c\u5f0f\u6709\u8bef\u3002";
        }
        return "200#\u8be5\u8bb0\u5f55\u6821\u9a8c\u901a\u8fc7\u3002";
    }

    @Override
    public String detailSortAndValidator(InsPreservationRecordVo vo) {
        String res;
        boolean bool;
        OrderFormVo order = this.policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(vo.getIns_insurance_slip_id()));
        if (order.getProduct_code().contains("GZZRX-QH") && "2".equals(order.getInception_type()) && "2".equals(vo.getRevise_type())) {
            return "300#\u524d\u6d77\u96c7\u4e3b\u8d23\u4efb\u9669\uff08\u6708\u5ea6\uff09\u4ea7\u54c1\u4e0d\u652f\u6301\u51cf\u5458\u4e1a\u52a1\uff01";
        }
        if (order.getProduct_code().contains("GZZRX-CA-DQ") && "2".equals(vo.getRevise_type())) {
            return "300#\u957f\u5b89\uff08\u77ed\u671f\uff09\u96c7\u4e3b\u8d23\u4efb\u9669\u4ea7\u54c1\u4e0d\u652f\u6301\u51cf\u5458\u4e1a\u52a1\uff01";
        }
        if (DateUtil.getCurrentDate().equals(order.getPlanned_end_date())) {
            return "300#\u4fdd\u5355\u5373\u5c06\u5230\u671f\u4e0d\u652f\u6301\u6279\u6539\u64cd\u4f5c\uff01";
        }
        if ("16".equals(order.getPolicy_status())) {
            return "300#\u8ba2\u5355\u672a\u5b8c\u6210\u652f\u4ed8\uff01";
        }
        List ipdVoList = vo.getInsPreservationDetailVoList();
        if (vo.getInsPreservationDetailVoList() == null) {
            return "300#\u672a\u83b7\u53d6\u5230\u4eba\u5458\u4fe1\u606f\uff01";
        }
        Long endDate = DateUtil.parseDate((String)order.getPlanned_end_date()).getTime();
        Long startDate = DateUtil.parseDate((String)vo.getInception_date()).getTime();
        if (startDate - endDate > 0L) {
            return "300#\u4fdd\u969c\u751f\u6548\u65f6\u95f4\u4e0d\u5728\u6709\u6548\u671f\u5185\uff01";
        }
        if (StringUtils.isNotEmpty((String)order.getProduct_code()) && order.getProduct_code().contains("GZZRX-CA") && (bool = this.insPreservationRecordAPIService.countDSHByPolicyNo(order.getExternal_reference()))) {
            return "300#\u5b58\u5728\u672a\u5b8c\u6210\u5ba1\u6279\u7684\u6279\u6539\u8bb0\u5f55\uff0c\u8bf7\u7b49\u5f85\u5ba1\u6279\u901a\u8fc7\u540e\u7ee7\u7eed\u64cd\u4f5c\uff0c\u5982\u8d851\u5c0f\u65f6\u672a\u5b8c\u6210\u5ba1\u6279\u8bf7\u4e0e\u5ba2\u670d\u8054\u7cfb\uff01";
        }
        if ("2".equals(vo.getRevise_type()) && (res = this.empConfine(vo, ConstProp.INT_NUMBER_THREE)).contains("300")) {
            return res;
        }
        List<InsPreservationDetail> doList = this.findDetailByPolicyId(Long.parseLong(vo.getIns_insurance_slip_id()));
        List<InsPreservationResultSet> rsaList = null;
        if (!"2".equals(vo.getRevise_type())) {
            rsaList = this.insPreservationResultSetAPIService.findZBByPolicyId(Long.parseLong(vo.getIns_insurance_slip_id()), order.getProduct_code());
        }
        for (InsPreservationDetailVo ipdVo : ipdVoList) {
            String result;
            if (!"2".equals(vo.getRevise_type()) && "300".equals((result = this.personnelToCheck(ipdVo, vo.getRevise_type())).split("#")[0])) {
                return result;
            }
            if (StringUtils.isEmpty((String)ipdVo.getOid())) {
                ipdVo.setRevise_type(vo.getRevise_type());
            }
            if (rsaList != null && rsaList.size() > 0) {
                for (InsPreservationResultSet ipr : rsaList) {
                    if (!ipdVo.getId_card().equals(ipr.getId_card())) continue;
                    return "300#\u8bc1\u4ef6\u53f7\u7801\u4e3a\uff1a" + ipdVo.getId_card() + "\u4eba\u5458\u5df2\u5728\u4fdd\uff01";
                }
            }
            for (InsPreservationDetail ipd : doList) {
                if (ipdVo.getId_card().equals(ipd.getId_card())) {
                    return "300#\u8bc1\u4ef6\u53f7\u7801\u4e3a\uff1a" + ipdVo.getId_card() + "\u4eba\u5458\u5df2\u5728\u5f85\u5ba1\u6838\u7684\u4fdd\u5168\u5355\u4e2d\uff0c\u65e0\u6cd5\u91cd\u590d\u64cd\u4f5c\uff01";
                }
                if ("3".equals(vo.getRevise_type()) && ipdVo.getBusiness_id().equals(String.valueOf(ipd.getBusiness_id()))) {
                    return "300#\u8bc1\u4ef6\u53f7\u7801\u4e3a\uff1a" + ipdVo.getId_card() + "\u4eba\u5458\u6240\u8981\u66ff\u6362\u7684\u5bf9\u8c61\u5df2\u5728\u5f85\u5ba1\u6838\u7684\u4fdd\u5168\u5355\u4e2d\uff0c\u65e0\u6cd5\u91cd\u590d\u64cd\u4f5c\uff01";
                }
                if (!"2".equals(vo.getRevise_type())) continue;
                if ("3".equals(ipd.getRevise_type()) && String.valueOf(ipd.getBusiness_id()).equals(ipdVo.getBusiness_id())) {
                    return "300#\u8bc1\u4ef6\u53f7\u7801\u4e3a\uff1a" + ipdVo.getId_card() + "\u4eba\u5458\u6240\u8981\u51cf\u5458\u7684\u5bf9\u8c61\u5df2\u5728\u5f85\u5ba1\u6838\u7684\u4fdd\u5168\u5355\u4e2d\uff0c\u65e0\u6cd5\u91cd\u590d\u64cd\u4f5c\uff01";
                }
                if (!"2".equals(ipd.getRevise_type()) || !StringUtils.isNotEmpty((String)ipdVo.getBusiness_id()) || !ipdVo.getBusiness_id().equals(String.valueOf(ipd.getBusiness_id()))) continue;
                return "300#\u8bc1\u4ef6\u53f7\u7801\u4e3a\uff1a" + ipdVo.getId_card() + "\u4eba\u5458\u5df2\u63d0\u4ea4\u51cf\u5458\u4fdd\u5168\u7533\u8bf7\u5355\uff0c\u65e0\u6cd5\u91cd\u590d\u64cd\u4f5c\uff01";
            }
        }
        vo.setInsPreservationDetailVoList(ipdVoList);
        return "200#\u6821\u9a8c\u901a\u8fc7\u3002";
    }

    @Override
    public String batchDetailSortAndValidator(InsPreservationRecordVo vo) {
        String res;
        boolean bool;
        List ipdVoList = vo.getInsPreservationDetailVoList();
        if (vo.getInsPreservationDetailVoList() == null) {
            return "300#\u672a\u83b7\u53d6\u5230\u4eba\u5458\u4fe1\u606f\uff01";
        }
        OrderFormVo order = this.policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(vo.getIns_insurance_slip_id()));
        if (order.getProduct_code().contains("GZZRX-QH") && "2".equals(order.getInception_type()) && "2".equals(vo.getRevise_type())) {
            return "300#\u524d\u6d77\u96c7\u4e3b\u8d23\u4efb\u9669\uff08\u6708\u5ea6\uff09\u4ea7\u54c1\u4e0d\u652f\u6301\u51cf\u5458\u4e1a\u52a1\uff01";
        }
        if (order.getProduct_code().contains("GZZRX-CA-DQ") && "2".equals(vo.getRevise_type())) {
            return "300#\u957f\u5b89\uff08\u77ed\u671f\uff09\u96c7\u4e3b\u8d23\u4efb\u9669\u4ea7\u54c1\u4e0d\u652f\u6301\u51cf\u5458\u4e1a\u52a1\uff01";
        }
        Long endDate = DateUtil.parseDate((String)order.getPlanned_end_date()).getTime();
        Long oStartDate = DateUtil.parseDate((String)order.getInception_date()).getTime();
        Long startDate = DateUtil.parseDate((String)vo.getInception_date()).getTime();
        if (oStartDate > startDate) {
            return "300#\u6279\u5355\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4fdd\u5355\u8d77\u4fdd\u65e5\u671f\uff01";
        }
        if (startDate - endDate > 0L) {
            return "300#\u4fdd\u969c\u751f\u6548\u65f6\u95f4\u4e0d\u5728\u6709\u6548\u671f\u5185\uff01";
        }
        if (StringUtils.isNotEmpty((String)order.getProduct_code()) && order.getProduct_code().contains("GZZRX-CA") && (bool = this.insPreservationRecordAPIService.countDSHByPolicyNo(order.getExternal_reference()))) {
            return "300#\u5b58\u5728\u672a\u5b8c\u6210\u5ba1\u6279\u7684\u6279\u6539\u8bb0\u5f55\uff0c\u8bf7\u7b49\u5f85\u5ba1\u6279\u901a\u8fc7\u540e\u7ee7\u7eed\u64cd\u4f5c\uff0c\u5982\u8d851\u5c0f\u65f6\u672a\u5b8c\u6210\u5ba1\u6279\u8bf7\u4e0e\u5ba2\u670d\u8054\u7cfb\uff01";
        }
        if ("2".equals(vo.getRevise_type()) && (res = this.empConfine(vo, ConstProp.INT_NUMBER_THREE)).contains("300")) {
            return res;
        }
        List<InsPreservationDetail> doList = this.findDetailByPolicyId(Long.parseLong(vo.getIns_insurance_slip_id()));
        List<InsPreservationResultSet> rsaList = null;
        if (!"2".equals(vo.getRevise_type())) {
            rsaList = this.insPreservationResultSetAPIService.findZBByPolicyId(Long.parseLong(vo.getIns_insurance_slip_id()), order.getProduct_code());
        }
        String errMsg = "";
        block0: for (InsPreservationDetailVo ipdVo : ipdVoList) {
            String result;
            if (!"2".equals(vo.getRevise_type()) && "300".equals((result = this.personnelToCheck(ipdVo, vo.getRevise_type())).split("#")[0])) {
                return result;
            }
            if (StringUtils.isEmpty((String)ipdVo.getOid())) {
                ipdVo.setRevise_type(vo.getRevise_type());
            }
            if (rsaList != null && rsaList.size() > 0) {
                boolean _sg_1 = false;
                for (InsPreservationResultSet ipr : rsaList) {
                    if (!ipdVo.getId_card().equals(ipr.getId_card())) continue;
                    errMsg = errMsg + "\u4eba\u5458\u3010" + ipdVo.getName() + " " + ipdVo.getId_card() + "\u3011\u5df2\u5728\u4fdd\uff1b\n";
                    _sg_1 = true;
                    break;
                }
                if (_sg_1) continue;
            }
            for (InsPreservationDetail ipd : doList) {
                if (ipdVo.getId_card().equals(ipd.getId_card())) {
                    errMsg = errMsg + "\u4eba\u5458\u3010" + ipdVo.getName() + " " + ipdVo.getId_card() + "\u3011\u5df2\u5728\u5f85\u5ba1\u6838\u7684\u4fdd\u5168\u5355\u4e2d\uff1b\n";
                    continue block0;
                }
                if ("3".equals(vo.getRevise_type()) && ipdVo.getBusiness_id().equals(String.valueOf(ipd.getBusiness_id()))) {
                    errMsg = errMsg + "\u4eba\u5458\u3010" + ipdVo.getName() + " " + ipdVo.getId_card() + "\u3011\u6240\u8981\u66ff\u6362\u7684\u5bf9\u8c61\u5df2\u5728\u5f85\u5ba1\u6838\u7684\u4fdd\u5168\u5355\u4e2d\uff1b\n";
                    continue block0;
                }
                if (!"2".equals(vo.getRevise_type())) continue;
                if ("3".equals(ipd.getRevise_type()) && String.valueOf(ipd.getBusiness_id()).equals(ipdVo.getBusiness_id())) {
                    errMsg = errMsg + "\u4eba\u5458\u3010" + ipdVo.getName() + " " + ipdVo.getId_card() + "\u3011\u6240\u8981\u51cf\u5458\u7684\u5bf9\u8c61\u5df2\u5728\u5f85\u5ba1\u6838\u7684\u4fdd\u5168\u5355\u4e2d\uff1b\n";
                    continue block0;
                }
                if (!"2".equals(ipd.getRevise_type()) || !StringUtils.isNotEmpty((String)ipdVo.getBusiness_id()) || !ipdVo.getBusiness_id().equals(String.valueOf(ipd.getBusiness_id()))) continue;
                errMsg = errMsg + "\u4eba\u5458\u3010" + ipdVo.getName() + " " + ipdVo.getId_card() + "\u3011\u5df2\u63d0\u4ea4\u51cf\u5458\u4fdd\u5168\u7533\u8bf7\u5355\uff1b\n";
                continue block0;
            }
        }
        if (StringUtils.isNotEmpty((String)errMsg)) {
            return "300#" + errMsg;
        }
        vo.setInsPreservationDetailVoList(ipdVoList);
        return "200#\u6821\u9a8c\u901a\u8fc7\u3002";
    }

    @Override
    public String empConfine(InsPreservationRecordVo vo, int perNum) {
        int num = this.insPreservationResultSetAPIService.findZBNumber(vo.getInsPreservationDetailVoList().size(), Long.parseLong(vo.getIns_insurance_slip_id()));
        if (num < perNum) {
            return "300#\u56e2\u4f53\u610f\u5916\u9669\u6700\u5c11\u4fdd\u969c\u4eba\u5458\u4e0d\u5f97\u5c11\u4e8e" + perNum + "\u4eba\uff01";
        }
        return "200#\u6821\u9a8c\u901a\u8fc7\u3002";
    }

    @Override
    public List<InsPreservationDetail> selectDetailByRecordIdList(Long policyId, String status, String resType) {
        List<InsPreservationDetail> list = this.insPreservationDetailAPIDao.findInsPreservationDetail(policyId, status, resType);
        return list;
    }

    private List<InsPreservationDetail> findDetailByPolicyId(Long policyId) {
        return this.insPreservationDetailAPIDao.findDetailByPolicyId(policyId);
    }

    @Override
    public InsPreservationDetailVo detailConvertToResultSet(InsPreservationResultSetVo resultSet) {
        InsPreservationDetailVo vo = new InsPreservationDetailVo();
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)resultSet), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return vo;
    }

    @Override
    public JSONObject readIPDExcel(MultipartFile mFile) throws Exception {
        JSONObject jo = new JSONObject();
        ArrayList list = null;
        String msg = "";
        boolean cum = false;
        String cds = "";
        String[] arrStr = new String[]{"name", "id_type", "id_card", "birthday", "sex", "tel", "career"};
        list = Lists.newArrayList();
        try {
            InputStream is = mFile.getInputStream();
            HSSFWorkbook hssfWorkbook = new HSSFWorkbook(is);
            block6: for (int numSheet = 0; numSheet < hssfWorkbook.getNumberOfSheets(); ++numSheet) {
                HSSFSheet hssfSheet = hssfWorkbook.getSheetAt(numSheet);
                if (hssfSheet == null) continue;
                InsPreservationDetailVo ipdVo = null;
                for (int rowNum = 6; rowNum <= hssfSheet.getLastRowNum(); ++rowNum) {
                    HSSFRow hssfRow = hssfSheet.getRow(rowNum);
                    int hh = rowNum + 1;
                    if (hssfRow == null) continue;
                    if (StringUtils.isEmpty((String)String.valueOf(hssfRow.getCell(1)).trim()) && StringUtils.isEmpty((String)String.valueOf(hssfRow.getCell(2)).trim()) && StringUtils.isEmpty((String)String.valueOf(hssfRow.getCell(3)).trim()) && StringUtils.isEmpty((String)String.valueOf(hssfRow.getCell(6)).trim()) && StringUtils.isEmpty((String)String.valueOf(hssfRow.getCell(7)).trim()) && StringUtils.isEmpty((String)String.valueOf(hssfRow.getCell(8)).trim())) continue block6;
                    HSSFCell cell = null;
                    ipdVo = new InsPreservationDetailVo();
                    HashMap map = Maps.newHashMap();
                    String cd = "";
                    for (int i = 1; i < 8; ++i) {
                        String _value;
                        block24: {
                            block29: {
                                block30: {
                                    block25: {
                                        block28: {
                                            block27: {
                                                block26: {
                                                    block23: {
                                                        cell = hssfRow.getCell(i);
                                                        _value = InsPreservationDetailAPIServiceImpl.getValue(cell).trim();
                                                        if (StringUtils.isEmpty((String)_value)) {
                                                            String n = i == 1 ? "\u59d3\u540d" : (i == 2 ? "\u8bc1\u4ef6\u7c7b\u578b" : (i == 3 ? "\u8bc1\u4ef6\u53f7" : (i == 4 ? "\u51fa\u751f\u65e5\u671f" : (i == 5 ? "\u6027\u522b" : (i == 6 ? "\u624b\u673a" : "\u804c\u4e1a")))));
                                                            msg = msg + "\u7b2c " + hh + " \u884c\uff1a" + n + "\u4e0d\u80fd\u4e3a\u7a7a;";
                                                            cum = true;
                                                            continue;
                                                        }
                                                        if (!"name".equals(arrStr[i - 1])) break block23;
                                                        if (StringUtils.isNotEmpty((String)_value)) {
                                                            _value = _value.replace(" ", "");
                                                        }
                                                        break block24;
                                                    }
                                                    if (!"id_type".equals(arrStr[i - 1])) break block25;
                                                    if (!"\u5c45\u6c11\u8eab\u4efd\u8bc1".equals(_value)) break block26;
                                                    _value = "0";
                                                    break block24;
                                                }
                                                if (!"\u62a4\u7167".equals(_value)) break block27;
                                                _value = "3";
                                                break block24;
                                            }
                                            if (!"\u53f0\u80de\u8bc1".equals(_value)) break block28;
                                            _value = "4";
                                            break block24;
                                        }
                                        if (!"\u56de\u4e61\u8bc1".equals(_value)) break block24;
                                        _value = "5";
                                        break block24;
                                    }
                                    if (!"sex".equals(arrStr[i - 1])) break block29;
                                    if (!"\u7537".equals(_value)) break block30;
                                    _value = "1";
                                    break block24;
                                }
                                if (!"\u5973".equals(_value)) break block24;
                                _value = "2";
                                break block24;
                            }
                            if ("birthday".equals(arrStr[i - 1])) {
                                block22: {
                                    try {
                                        if (_value.contains("-")) {
                                            DateUtil.parseDate((String)_value);
                                            break block22;
                                        }
                                        if (!HSSFDateUtil.isCellDateFormatted((Cell)cell)) break block22;
                                        Date d = cell.getDateCellValue();
                                        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd");
                                        _value = formater.format(d);
                                    }
                                    catch (Exception e) {
                                        msg = msg + "\u7b2c " + hh + " \u884c\uff1a\u51fa\u751f\u65e5\u671f\u6709\u8bef;";
                                        cum = true;
                                        break;
                                    }
                                }
                                if (IdNumberValidator.getAgeFromBirthday((String)_value) > 65 || IdNumberValidator.getAgeFromBirthday((String)_value) < 16) {
                                    msg = msg + "\u7b2c " + hh + " \u884c\uff1a\u4eba\u5458\u7684\u5e74\u9f84\u8d85\u51fa\u9650\u5236\uff08\u533a\u95f4\uff1a16-60\u5468\u5c81\uff09;";
                                    cum = true;
                                    break;
                                }
                            } else if ("id_card".equals(arrStr[i - 1])) {
                                if (!IdCardVerify.isValidatedAllIdcard((String)(_value = _value.toUpperCase()))) {
                                    msg = msg + "\u7b2c " + hh + " \u884c\uff1a\u8bc1\u4ef6\u53f7\u7801\u4e0d\u662f\u6709\u6548\u8bc1\u4ef6\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d;";
                                    cum = true;
                                    break;
                                }
                                cd = _value;
                            } else if ("tel".equals(arrStr[i - 1])) {
                                if (_value.contains("E")) {
                                    try {
                                        DecimalFormat df = new DecimalFormat("#");
                                        _value = df.format(cell.getNumericCellValue());
                                    }
                                    catch (Exception e) {
                                        msg = msg + "\u7b2c " + hh + " \u884c\uff1a\u624b\u673a\u53f7\u7801\u683c\u5f0f\u6709\u8bef;";
                                        cum = true;
                                        break;
                                    }
                                }
                                if (!ValidatorUtil.validatePhone((String)_value)) {
                                    msg = msg + "\u7b2c " + hh + " \u884c\uff1a\u624b\u673a\u53f7\u7801\u683c\u5f0f\u6709\u8bef;";
                                    cum = true;
                                    break;
                                }
                            }
                        }
                        map.put(arrStr[i - 1], _value);
                    }
                    if (StringUtils.isNotEmpty((String)cd) && cds.contains(cd)) {
                        msg = msg + "\u7b2c " + hh + " \u884c\uff1a\u8be5\u8bc1\u4ef6\u53f7\u5df2\u5728\u672c\u6e05\u5355\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u5f55\u5165;";
                        cum = true;
                    }
                    cds = cds + cd + ";";
                    if (ipdVo == null || map.size() <= 0) continue;
                    MyConverUtil.map2PO((Map)map, (Object)ipdVo);
                    list.add(ipdVo);
                    ipdVo = null;
                }
            }
        }
        catch (Exception e) {
            cum = true;
            msg = "Excel\u6e05\u5355\u6a21\u677f\u6587\u4ef6\u6570\u636e\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u4f7f\u7528\u6807\u51c6\u7684Excel\u6e05\u5355\u6a21\u677f\u4e0a\u4f20\uff01\n\u53ef\u80fd\u539f\u56e0\uff1a\n1.\u6a21\u677f\u6587\u4ef6\u5934\u90e8\u5185\u5bb9\u88ab\u5220\u9664\u6216\u6574\u4f53\u6837\u5f0f\u88ab\u6539\u53d8\uff1b\n2.\u76f4\u63a5\u5b83\u5904\u590d\u5236\u7684\u4eba\u5458\u4fe1\u606f\u9644\u5e26\u683c\u5f0f\u3002";
        }
        jo.put("ret", (Object)(cum ? "300" : "200"));
        jo.put("msg", (Object)msg);
        jo.put("list", (Object)list);
        return jo;
    }

    private static String getValue(HSSFCell hssfRow) {
        if (hssfRow.getCellType() == 4) {
            return String.valueOf(hssfRow.getBooleanCellValue());
        }
        if (hssfRow.getCellType() == 0) {
            return String.valueOf(hssfRow.getNumericCellValue());
        }
        return String.valueOf(hssfRow.getStringCellValue());
    }

    @Override
    public List<Map<Object, Object>> queryDetail(Map<Object, Object> p) {
        return this.insPreservationDetailAPIDao.queryDetail(p);
    }

    @Override
    public void downPreservationDetail(Long preservationId, HttpServletResponse response) {
        InsPreservationRecord record = (InsPreservationRecord)this.insPreservationRecordAPIService.selectById(preservationId);
        String bm = StringUtils.isNotEmpty((String)record.getRevise_serial_num_ins()) ? record.getRevise_serial_num_ins() : record.getRevise_serial_number();
        String fileName = bm + "-\u6279\u6539\u4eba\u5458\u6e05\u5355.xls";
        try {
            fileName = new String(fileName.getBytes("gb2312"), "ISO8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ExcelUtil util = new ExcelUtil(ResultSetExcelVo.class);
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;fileName=" + fileName);
        try (ServletOutputStream os = response.getOutputStream();){
            List<ResultSetExcelVo> voList = this.listDetail(record);
            util.exportExcel(voList, bm + "\u6279\u6539\u4eba\u5458\u6e05\u5355", 65535, (OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void downPreservationList(String userId, String keyword, String name, String start_time, String end_time, HttpServletResponse response) {
        String fileName = "\u6279\u5355\u4fe1\u606f.xls";
        try {
            fileName = new String(fileName.getBytes("gb2312"), "ISO8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ExcelUtil util = new ExcelUtil(RecordDetailExcelVo.class);
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;fileName=" + fileName);
        try (ServletOutputStream os = response.getOutputStream();){
            List<RecordDetailExcelVo> listMap = this.insPreservationDetailAPIDao.downPreservationList(userId, keyword, name, start_time, end_time);
            ArrayList addMap = Lists.newArrayList();
            for (RecordDetailExcelVo vo : listMap) {
                if (!StringUtils.isNotEmpty((String)vo.getTjData())) continue;
                RecordDetailExcelVo addVo = (RecordDetailExcelVo)MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)new RecordDetailExcelVo());
                String[] arr = vo.getTjData().split("#");
                addVo.setName(arr[0]);
                addVo.setId_card(arr[1]);
                addVo.setTel(arr[2]);
                addVo.setRevise_type("\u51cf\u5458");
                addMap.add(addVo);
            }
            if (addMap.size() > 0) {
                listMap.addAll(addMap);
            }
            util.exportExcel(listMap, "\u6279\u5355\u4fe1\u606f", 65535, (OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<ResultSetExcelVo> listDetail(InsPreservationRecord record) {
        ArrayList voList = Lists.newArrayList();
        List<InsPreservationDetailVo> ipdVolist = this.findInsPreservationDetailVoByKeyword(null, record.getIns_preservation_record_id(), "");
        try {
            for (InsPreservationDetailVo ipdVo : ipdVolist) {
                ipdVo.setRevise_type("1".equals(record.getRevise_type()) ? "\u589e\u5458" : ("2".equals(record.getRevise_type()) ? "\u51cf\u5458" : "\u589e\u5458"));
                ipdVo.setSex("1".equals(ipdVo.getSex()) ? "\u7537" : ("2".equals(ipdVo.getSex()) ? "\u5973" : "-"));
                ipdVo.setCareer("1".equals(ipdVo.getCareer()) ? "\u5185\u52e4\u4eba\u5458" : ("2".equals(ipdVo.getCareer()) ? "\u4fdd\u5b89\u4eba\u5458" : ("4".equals(ipdVo.getCareer()) ? "\u4fdd\u6d01\u4eba\u5458" : "\u6b66\u88c5\u62bc\u8fd0\u4eba\u5458")));
                ResultSetExcelVo rsvo = new ResultSetExcelVo();
                MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)ipdVo), (Object)rsvo);
                voList.add(rsvo);
                if (!"3".equals(record.getRevise_type()) || !StringUtils.isNotBlank((String)ipdVo.getBusiness_id()) || !StringUtils.isNotBlank((String)ipdVo.getBusiness_type())) continue;
                InsPreservationResultSetVo resultSet = this.insPreservationResultSetAPIService.getInsPreservationResultSetVoByOidAndSign(ipdVo.getBusiness_id(), "");
                InsPreservationDetailVo bvo = this.detailConvertToResultSet(resultSet);
                bvo.setRevise_type("\u51cf\u5458");
                bvo.setSex("1".equals(bvo.getSex()) ? "\u7537" : ("2".equals(bvo.getSex()) ? "\u5973" : "-"));
                bvo.setCareer("1".equals(bvo.getCareer()) ? "\u5185\u52e4\u4eba\u5458" : ("2".equals(bvo.getCareer()) ? "\u4fdd\u5b89\u4eba\u5458" : ("4".equals(bvo.getCareer()) ? "\u4fdd\u6d01\u4eba\u5458" : "\u6b66\u88c5\u62bc\u8fd0\u4eba\u5458")));
                rsvo = new ResultSetExcelVo();
                MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)bvo), (Object)rsvo);
                voList.add(rsvo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return voList;
    }
}

