/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.order.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.ins.core.util.SysDictUtils;
import com.bcxin.ins.dao.order.InsInsuranceSlipAPIDao;
import com.bcxin.ins.entity.policy_core.InsAgreement;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsRoleInpolicy;
import com.bcxin.ins.entity.policy_core.InsUnderwrite;
import com.bcxin.ins.entity.policy_special.SpecialBid;
import com.bcxin.ins.entity.policy_special.SpecialCreditMicro;
import com.bcxin.ins.entity.policy_special.SpecialCreditSt;
import com.bcxin.ins.entity.policy_special.SpecialExhibition;
import com.bcxin.ins.entity.policy_special.SpecialLitigation;
import com.bcxin.ins.entity.policy_special.SpecialPerformance;
import com.bcxin.ins.entity.policy_special.SpecialPublicDuty;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.ComTaskResidualAPIService;
import com.bcxin.ins.service.order.InsAgreementAPIService;
import com.bcxin.ins.service.order.InsCommonExportAPIService;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.service.order.InsMailPolicyAPIService;
import com.bcxin.ins.service.order.InsMicroExportAPIService;
import com.bcxin.ins.service.order.InsRiskDutyAPIService;
import com.bcxin.ins.service.order.InsRoleInpolicyAPIService;
import com.bcxin.ins.service.order.InsTransactionAPIService;
import com.bcxin.ins.service.order.InsUnderwriteAPIService;
import com.bcxin.ins.service.order.SpecialBidAPIService;
import com.bcxin.ins.service.order.SpecialExhibitionAPIService;
import com.bcxin.ins.service.order.SpecialLitigationAPIService;
import com.bcxin.ins.service.order.SpecialPerformanceAPIService;
import com.bcxin.ins.service.order.SpecialPublicDutyAPIService;
import com.bcxin.ins.service.product.InsProductAPIService;
import com.bcxin.ins.service.product.InsProductResponsibilityAPIService;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.AdviceNoteVo;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.InsOrderSearchVo;
import com.bcxin.ins.vo.InsurePolicyVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.OrderStatusCountVo;
import com.bcxin.ins.vo.ResponsibilityVo;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class InsInsuranceSlipAPIServiceImpl
extends ServiceImpl<InsInsuranceSlipAPIDao, InsInsuranceSlip>
implements InsInsuranceSlipAPIService {
    @Autowired
    private InsCommonExportAPIService insCommonExportService;
    @Autowired
    private InsMicroExportAPIService insMicroExportService;
    @Autowired
    private InsRoleInpolicyAPIService insRoleInpolicyService;
    @Autowired
    private InsProductAPIService insProductService;
    @Autowired
    private InsUnderwriteAPIService insUnderwriteService;
    @Autowired
    private InsMailPolicyAPIService insMailPolicyService;
    @Autowired
    private InsInsuranceSlipAPIDao dao;
    @Autowired
    private InsTransactionAPIService insTransactionService;
    @Autowired
    private InsAgreementAPIService insAgreementService;
    @Autowired
    private InsRiskDutyAPIService insRiskDutyService;
    @Autowired
    private InsProductResponsibilityAPIService insProductResponsibilityService;
    @Autowired
    private SpecialLitigationAPIService specialLitigationService;
    @Autowired
    private SpecialBidAPIService specialBidService;
    @Autowired
    private SpecialPerformanceAPIService specialPerformanceService;
    @Autowired
    private SpecialPublicDutyAPIService specialPublicDutyService;
    @Autowired
    private SpecialExhibitionAPIService specialExhibitionAPIService;
    @Autowired
    private ComTaskResidualAPIService comTaskResidualAPIService;

    @Override
    public InsInsuranceSlip selectById(Long oid) {
        InsInsuranceSlip insInsuranceSlip = this.dao.selectById(oid);
        if (insInsuranceSlip != null) {
            this.insMailPolicyService.throughTheInsInsuranceSlipForInsMailPolicySetUpInsInsuranceSlip(insInsuranceSlip);
            this.insUnderwriteService.throughTheInsInsuranceSlipForInsUnderwriteSetUpInsInsuranceSlip(insInsuranceSlip);
            insInsuranceSlip.setInsTransaction(this.insTransactionService.selectInsTransactionByInsOrderForm(oid));
        }
        return insInsuranceSlip;
    }

    @Override
    public InsInsuranceSlip packagingInsInsuranceSlip(Long oid) {
        SpecialExhibition specialExhibition;
        InsInsuranceSlip insInsuranceSlip = this.selectById(oid);
        if (insInsuranceSlip == null) {
            return insInsuranceSlip;
        }
        insInsuranceSlip.setRoles(this.insRoleInpolicyService.selectInsRoleInpolicyByInsInsuranceSlip(insInsuranceSlip.getIns_insurance_slip_id()));
        ProPrimary insProduct = (ProPrimary)this.insProductService.selectById(insInsuranceSlip.getPro_primary().getPro_primary_id());
        insInsuranceSlip.setPro_primary(insProduct);
        if (StringUtils.isEmpty((CharSequence)insProduct.getProduct_code())) {
            return insInsuranceSlip;
        }
        if ("XYX-XWCK".equals(insProduct.getProduct_code())) {
            SpecialCreditMicro insMicroExport = (SpecialCreditMicro)this.insMicroExportService.selectById(insInsuranceSlip.getSpecial_id());
            if (insMicroExport != null && insMicroExport.getSpecial_credit_micro_id() != null) {
                insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), insMicroExport);
                insInsuranceSlip.setSpecial_id(insMicroExport.getSpecial_credit_micro_id());
            }
        } else if ("XYX-DQCK".equals(insProduct.getProduct_code())) {
            SpecialCreditSt insCommonExport = this.insCommonExportService.getInsCommonExportBusiness(insInsuranceSlip.getSpecial_id());
            if (insCommonExport != null && insCommonExport.getSpecial_credit_st_id() != null) {
                insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), insCommonExport);
                insInsuranceSlip.setSpecial_id(insCommonExport.getSpecial_credit_st_id());
            }
        } else if ("BZX-TB-GCTB".equals(insProduct.getProduct_code()) || "BZX-YG-GCTB".equals(insProduct.getProduct_code()) || "BZX-DB-GCTB".equals(insProduct.getProduct_code())) {
            SpecialBid specialBid = (SpecialBid)this.specialBidService.selectById(insInsuranceSlip.getSpecial_id());
            if (specialBid != null && specialBid.getSpecial_bid_id() != null) {
                insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialBid);
                insInsuranceSlip.setSpecial_id(specialBid.getSpecial_bid_id());
            }
        } else if ("BZX-GCLY".equals(insProduct.getProduct_code())) {
            SpecialPerformance specialPerformance = (SpecialPerformance)this.specialPerformanceService.selectById(insInsuranceSlip.getSpecial_id());
            if (specialPerformance != null && specialPerformance.getSpecial_performance_id() != null) {
                insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialPerformance);
                insInsuranceSlip.setSpecial_id(specialPerformance.getSpecial_performance_id());
            }
        } else if ("BZX-SSBQ".equals(insProduct.getProduct_code())) {
            SpecialLitigation specialLitigation = this.specialLitigationService.getSpecialLitigationBusiness(insInsuranceSlip.getSpecial_id());
            if (specialLitigation != null && specialLitigation.getSpecial_litigation_id() != null) {
                insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialLitigation);
                insInsuranceSlip.setSpecial_id(specialLitigation.getSpecial_litigation_id());
            }
        } else if ("GZX".equals(insProduct.getProduct_code().split("-")[0])) {
            SpecialPublicDuty specialPublicDuty = (SpecialPublicDuty)this.specialPublicDutyService.selectById(insInsuranceSlip.getSpecial_id());
            if (specialPublicDuty != null && specialPublicDuty.getSpecial_public_duty_id() != null) {
                insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialPublicDuty);
                insInsuranceSlip.setSpecial_id(specialPublicDuty.getSpecial_public_duty_id());
            }
        } else if ("ZZX".equals(insProduct.getProduct_code().split("-")[0]) && (specialExhibition = (SpecialExhibition)this.specialExhibitionAPIService.selectById(insInsuranceSlip.getSpecial_id())) != null && specialExhibition.getSpecial_exhibition_id() != null) {
            insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialExhibition);
            insInsuranceSlip.setSpecial_id(specialExhibition.getSpecial_exhibition_id());
        }
        return insInsuranceSlip;
    }

    @Override
    public InsInsuranceSlip initOrderForm(Long poductID, Long user_id, String recommendCode, String trade_serial_number) {
        InsInsuranceSlip insInsuranceSlip = new InsInsuranceSlip();
        IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
        if (StringUtils.isEmpty((CharSequence)trade_serial_number)) {
            trade_serial_number = String.valueOf(idWorker.nextId());
        }
        insInsuranceSlip.setTrade_serial_number(trade_serial_number);
        insInsuranceSlip.setStart_time((Date)com.bcxin.ins.util.toolbox.DateUtil.getTimestamp());
        insInsuranceSlip.setSigned_date((Date)com.bcxin.ins.util.toolbox.DateUtil.getTimestamp());
        insInsuranceSlip.setRegister_user_id(user_id);
        insInsuranceSlip.setRecommend_code(recommendCode);
        insInsuranceSlip.setUnderwrite(this.insUnderwriteService.initInsUnderwrite());
        insInsuranceSlip.setMailPolicy(this.insMailPolicyService.initInsMailPolicy());
        insInsuranceSlip.setOrder_status("1");
        ProPrimary insProduct = (ProPrimary)this.insProductService.selectById(poductID);
        insInsuranceSlip.setPro_primary(insProduct);
        if (StringUtils.isEmpty((CharSequence)insProduct.getProduct_code())) {
            this.dao.insert(insInsuranceSlip);
            return insInsuranceSlip;
        }
        if ("XYX-XWCK".equals(insProduct.getProduct_code())) {
            SpecialCreditMicro insMicroExport = this.insMicroExportService.initInsMicroExport();
            insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), insMicroExport);
            insInsuranceSlip.setSpecial_id(insMicroExport.getSpecial_credit_micro_id());
        } else if ("XYX-DQCK".equals(insProduct.getProduct_code())) {
            SpecialCreditSt insCommonExport = this.insCommonExportService.initInsCommonExport();
            insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), insCommonExport);
            insInsuranceSlip.setSpecial_id(insCommonExport.getSpecial_credit_st_id());
        } else if ("BZX-TB-GCTB".equals(insProduct.getProduct_code()) || "BZX-YG-GCTB".equals(insProduct.getProduct_code()) || "BZX-DB-GCTB".equals(insProduct.getProduct_code())) {
            SpecialBid specialBid = this.specialBidService.initInsSpecialBid();
            insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialBid);
            insInsuranceSlip.setSpecial_id(specialBid.getSpecial_bid_id());
        } else if ("BZX-GCLY".equals(insProduct.getProduct_code())) {
            SpecialPerformance specialPerformance = this.specialPerformanceService.initInsSpecialPerformance();
            insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialPerformance);
            insInsuranceSlip.setSpecial_id(specialPerformance.getSpecial_performance_id());
        } else if ("BZX-SSBQ".equals(insProduct.getProduct_code())) {
            SpecialLitigation specialLitigation = this.specialLitigationService.initSpecialLitigation();
            insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialLitigation);
            insInsuranceSlip.setSpecial_id(specialLitigation.getSpecial_litigation_id());
        } else if ("GZX".equals(insProduct.getProduct_code().split("-")[0])) {
            SpecialPublicDuty specialPublicDuty = this.specialPublicDutyService.initSpecialPublicDuty();
            insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialPublicDuty);
            insInsuranceSlip.setSpecial_id(specialPublicDuty.getSpecial_public_duty_id());
        } else if ("ZZX".equals(insProduct.getProduct_code().split("-")[0])) {
            SpecialExhibition specialExhibition = this.specialExhibitionAPIService.initSpecialExhibition();
            insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialExhibition);
            insInsuranceSlip.setSpecial_id(specialExhibition.getSpecial_exhibition_id());
        } else if ("TYX".equals(insProduct.getProduct_code().split("-")[0])) {
            SpecialExhibition specialExhibition = this.specialExhibitionAPIService.initSpecialExhibition();
            insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialExhibition);
            insInsuranceSlip.setSpecial_id(specialExhibition.getSpecial_exhibition_id());
        }
        this.dao.insert(insInsuranceSlip);
        return insInsuranceSlip;
    }

    @Override
    public InsurePolicyVo willInsInsuranceSlipChangeIntoInsurePolicyVo(Long insInsuranceSlip_id) {
        InsurePolicyVo vo = new InsurePolicyVo();
        InsInsuranceSlip insInsuranceSlip = this.packagingInsInsuranceSlip(insInsuranceSlip_id);
        if (insInsuranceSlip != null) {
            try {
                MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insInsuranceSlip), (Object)vo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
            vo.setMailPolicy_id(String.valueOf(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id()));
            if (insInsuranceSlip.getUnderwrite() != null) {
                vo.setUnderwrite_id(String.valueOf(insInsuranceSlip.getUnderwrite().getUnderwrite_id()));
            }
            vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        }
        return vo;
    }

    @Override
    public void getInsuredAmountSetToInsInsuranceSlip(BigDecimal insuredAmount, InsInsuranceSlip iis) {
        iis.setInsured_amount(insuredAmount);
        this.dao.updateById(iis);
    }

    @Override
    public void accordingToOrderIDCreatePolicySerialNumber(InsInsuranceSlip insInsuranceSlip) {
        IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
        insInsuranceSlip.setPolicy_serial_number("BCX-" + String.valueOf(idWorker.nextId()) + "A");
        this.dao.updateById(insInsuranceSlip);
    }

    @Override
    public InsInsuranceSlip getInsOrderForm(Long oid) {
        InsInsuranceSlip insOrderForm = this.dao.selectById(oid);
        if (insOrderForm != null) {
            insOrderForm.setInsTransaction(this.insTransactionService.selectInsTransactionByInsOrderForm(insOrderForm.getIns_insurance_slip_id()));
        }
        return insOrderForm;
    }

    @Override
    public InsInsuranceSlip getInsOrderForm(String tradeSerialNumber) {
        InsInsuranceSlip insOrderForm = this.dao.selectByTradeSerialNumber(tradeSerialNumber);
        if (insOrderForm != null) {
            insOrderForm.setInsTransaction(this.insTransactionService.selectInsTransactionByInsOrderForm(insOrderForm.getIns_insurance_slip_id()));
        }
        return insOrderForm;
    }

    @Override
    public InsInsuranceSlip packagingInsOrderForm(Long oid) {
        return this.packagingInsInsuranceSlip(oid);
    }

    @Override
    public List<InsInsuranceSlip> selectInsOrderFormByUserIDAndStatus(Long user_id, String status, DwzPage page) {
        Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
        ArrayList<InsInsuranceSlip> list = new ArrayList<InsInsuranceSlip>();
        List<InsInsuranceSlip> insOrderFormList = this.dao.selectInsOrderFormByUserIDAndStatus((Page<InsInsuranceSlip>)pageHelper, user_id, status);
        for (InsInsuranceSlip order : insOrderFormList) {
            list.add(this.packagingInsOrderForm(order.getIns_insurance_slip_id()));
        }
        page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
        return list;
    }

    @Override
    public List<OrderFormVo> selectInsOrderFormByUserIDAndStatusSetUpOrderFormVo(InsOrderSearchVo search) {
        List<OrderFormVo> voList = null;
        if (search.getPage() != null) {
            Page pageHelper = new Page(search.getPage().getPageNum(), search.getPage().getNumPerPage());
            voList = this.dao.findOrderFormVoByID((Page<OrderFormVo>)pageHelper, null, search.getUserId(), null, search.getPType(), search.getPolicyStatus(), search.getKeyword(), search.getStarDate(), search.getEndDate(), search.getBusinessType());
            search.getPage().setTotalCount(new Long(pageHelper.getTotal()).intValue());
            for (OrderFormVo vo : voList) {
                this.replenishOrderFormVo(vo);
            }
        } else {
            voList = this.dao.findOrderFormVoByID(null, search.getUserId(), null, search.getPType(), search.getPolicyStatus(), search.getKeyword(), search.getStarDate(), search.getEndDate(), search.getBusinessType());
            for (OrderFormVo vo : voList) {
                this.replenishOrderFormVo(vo);
            }
        }
        return voList;
    }

    @Override
    public List<OrderFormVo> listOrderFormVoByDzbdIsNot(String productCode) {
        List<OrderFormVo> voList = this.dao.listOrderFormVoByDzbdIsNot(productCode);
        for (OrderFormVo vo : voList) {
            this.replenishOrderFormVo(vo);
        }
        return voList;
    }

    @Override
    public List<OrderFormVo> selectInsOrderFormByStatusAndProductCode(String status, String productCode) {
        List<OrderFormVo> voList = this.dao.selectInsOrderFormByStatusAndProductCode(status, productCode);
        for (OrderFormVo vo : voList) {
            this.replenishOrderFormVo(vo);
        }
        return voList;
    }

    @Override
    public List<InsInsuranceSlip> selectInsOrderFormByUserIDAndStatusList(Long user_id, List<String> statusList, DwzPage page) {
        Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
        ArrayList<InsInsuranceSlip> list = new ArrayList<InsInsuranceSlip>();
        List<InsInsuranceSlip> insOrderFormList = this.dao.selectInsOrderFormByUserIDAndStatusList((Page<InsInsuranceSlip>)pageHelper, user_id, statusList);
        for (InsInsuranceSlip order : insOrderFormList) {
            list.add(this.packagingInsOrderForm(order.getIns_insurance_slip_id()));
        }
        page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
        return list;
    }

    @Override
    public List<OrderFormVo> selectInsOrderFormByUserIDAndStatusSetUpOrderFormVo(Long user_id, String status, DwzPage page) {
        ArrayList<OrderFormVo> voList = new ArrayList<OrderFormVo>();
        List<InsInsuranceSlip> orderList = this.selectInsOrderFormByUserIDAndStatus(user_id, status, page);
        for (InsInsuranceSlip order : orderList) {
            voList.add(this.willInsOrderFormSetUpOrderFormVo(order));
        }
        return voList;
    }

    @Override
    public List<OrderFormVo> selectInsOrderFormByUserIDAndStatusListSetUpOrderFormVo(Long user_id, List<String> statusList, String productType, String keyword, String starDate, String endDate, DwzPage page) {
        List<OrderFormVo> voList = null;
        if (page != null) {
            Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
            voList = this.dao.findOrderFormVoByID((Page<OrderFormVo>)pageHelper, null, user_id, statusList, productType, null, keyword, starDate, endDate, "");
            page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
            for (OrderFormVo vo : voList) {
                this.replenishOrderFormVo(vo);
            }
        } else {
            voList = this.dao.findOrderFormVoByID(null, user_id, statusList, productType, null, keyword, starDate, endDate, "");
            for (OrderFormVo vo : voList) {
                this.replenishOrderFormVo(vo);
            }
        }
        return voList;
    }

    @Override
    public OrderFormVo willInsOrderFormSetUpOrderFormVo(InsInsuranceSlip insInsuranceSlip) {
        ProPrimary insProduct;
        List insurenceRoles;
        List applicantRoles;
        OrderFormVo vo = new OrderFormVo();
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setTrade_serial_number(insInsuranceSlip.getTrade_serial_number());
        ClientUserVo user = UserSupportUtil.getSessionUser();
        if (user != null) {
            vo.setLogin_name(user.getLogin_name());
        }
        if (insInsuranceSlip.getStart_time() != null) {
            vo.setStart_time(com.bcxin.ins.util.toolbox.DateUtil.formatDate((Date)insInsuranceSlip.getStart_time()));
        }
        if (!("1".equals(insInsuranceSlip.getOrder_status()) || "2".equals(insInsuranceSlip.getOrder_status()) || "3".equals(insInsuranceSlip.getOrder_status()))) {
            InsAgreement insAgreement = this.insAgreementService.selectInsAgreementByInsInsuranceSlip(insInsuranceSlip.getIns_insurance_slip_id());
            vo.setExternal_reference(insAgreement != null ? insAgreement.getExternal_reference() : "");
        }
        if (insInsuranceSlip.getPremium() != null) {
            vo.setGross_premium(String.valueOf(insInsuranceSlip.getPremium()));
            vo.setInsured_amount(String.valueOf(insInsuranceSlip.getInsured_amount()));
        }
        if (insInsuranceSlip.getPro_primary() != null) {
            vo.setProduct_oid(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        }
        if (insInsuranceSlip.getInception_date() != null) {
            vo.setInception_date(com.bcxin.ins.util.toolbox.DateUtil.formatDate((Date)insInsuranceSlip.getInception_date()));
        }
        if (insInsuranceSlip.getPlanned_end_date() != null) {
            vo.setPlanned_end_date(com.bcxin.ins.util.toolbox.DateUtil.formatDate((Date)insInsuranceSlip.getPlanned_end_date()));
        }
        if (StrUtil.isNotBlank((CharSequence)insInsuranceSlip.getPolicy_serial_number())) {
            vo.setPolicy_serial_number(insInsuranceSlip.getPolicy_serial_number());
        }
        if (StrUtil.isNotBlank((CharSequence)insInsuranceSlip.getOrder_status())) {
            vo.setPolicy_status(insInsuranceSlip.getOrder_status());
        }
        this.insProductService.accordingToProductIDToGetInsProductSetUpOrderFormVo(vo, insInsuranceSlip.getPro_primary().getPro_primary_id());
        this.insTransactionService.setOrderFormVoOfShowUrlByOrderID(vo, insInsuranceSlip.getIns_insurance_slip_id());
        if (insInsuranceSlip.getStart_time() != null) {
            vo.setStart_time(com.bcxin.ins.util.toolbox.DateUtil.formatDateTime((Date)insInsuranceSlip.getStart_time()));
        }
        if ((applicantRoles = insInsuranceSlip.getRolesOfKind("1")) != null) {
            vo.setApplicant_name(((InsRoleInpolicy)applicantRoles.get(0)).getName_cn());
        }
        if ((insurenceRoles = insInsuranceSlip.getRolesOfKind("2")) != null) {
            vo.setInsured_role(((InsRoleInpolicy)insurenceRoles.get(0)).getName_cn());
            vo.setBusiness_scope(((InsRoleInpolicy)insurenceRoles.get(0)).getBusiness_nature());
            vo.setPolicy_currency(SysDictUtils.getDictLabel((String)((InsRoleInpolicy)insurenceRoles.get(0)).getCurrency_required(), (String)"currencyRequired", (String)""));
        }
        if ((insProduct = (ProPrimary)this.insProductService.selectById(insInsuranceSlip.getPro_primary().getPro_primary_id())) != null && "XYX-XWCK".equals(insProduct.getProduct_code())) {
            SpecialCreditMicro micro = (SpecialCreditMicro)insInsuranceSlip.getMapSpecial().get(String.valueOf(insProduct.getPro_primary_id()));
            vo.setPolicy_currency(SysDictUtils.getDictLabel((String)micro.getAnnual_currency(), (String)"annualCurrency", (String)""));
        }
        return vo;
    }

    @Override
    public AdviceNoteVo willInsOrderFormSetUpAdviceNoteVo(InsInsuranceSlip insInsuranceSlip) {
        AdviceNoteVo vo = new AdviceNoteVo();
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        InsUnderwrite underwrite = (InsUnderwrite)this.insUnderwriteService.selectById(insInsuranceSlip.getUnderwrite().getUnderwrite_id());
        if (underwrite != null) {
            vo.setTotal_rate(String.valueOf(underwrite.getTotal_rate()));
            vo.setYear_premium(String.valueOf(underwrite.getYear_premium()));
            vo.setInitial_premium(String.valueOf(underwrite.getInitial_premium()));
            vo.setPay_methods(underwrite.getPayment_way());
        }
        if (insInsuranceSlip.getPremium() != null) {
            vo.setGross_premium(String.valueOf(insInsuranceSlip.getPremium()));
        }
        this.insProductService.accordingToProductIDToGetInsProductSetUpAdviceNoteVo(vo, insInsuranceSlip.getPro_primary().getPro_primary_id());
        return vo;
    }

    @Override
    public OrderStatusCountVo selectOrderStatusCountVoByUserID(InsOrderSearchVo searchVo) {
        return this.dao.selectOrderStatusCountVoByUserID(searchVo);
    }

    @Override
    public Map selectOrderByExAndName(String external_reference, String name) {
        return this.dao.selectOrderByExAndName(external_reference, name);
    }

    @Override
    public String updateOrderFormStatus(OrderFormVo vo) {
        InsInsuranceSlip insInsuranceSlip = this.dao.selectById(Long.parseLong(vo.getOid()));
        insInsuranceSlip.setOrder_status(vo.getPolicy_status());
        this.dao.updateById(insInsuranceSlip);
        return insInsuranceSlip.getIns_insurance_slip_id().toString();
    }

    @Override
    public List<InsInsuranceSlip> findAllInsOrderList(String sql) {
        return this.dao.findAllInsOrderList(sql);
    }

    @Override
    public void accordingToInsTopBuyersListGainInsRiskDuty(Long order_id) {
        InsInsuranceSlip insInsuranceSlip = this.packagingInsOrderForm(order_id);
        Long pid = insInsuranceSlip.getPro_primary().getPro_primary_id();
        ProPrimary product = this.insProductService.getProduct(pid);
        if (product != null && "XYX-DQCK".equals(product.getProduct_code())) {
            SpecialCreditSt insCommonExport = (SpecialCreditSt)insInsuranceSlip.getMapSpecial().get(String.valueOf(pid));
            List tbList = insCommonExport.getTopBuyers();
            Long underwrite_id = insInsuranceSlip.getUnderwrite().getUnderwrite_id();
            this.insRiskDutyService.accordingToInsTopBuyersListGainInsRiskDuty(tbList, underwrite_id, pid);
        }
    }

    @Override
    public void updateOrderUnderwriting(OrderFormVo vo) {
        InsInsuranceSlip insInsuranceSlip = this.packagingInsOrderForm(Long.parseLong(vo.getOid()));
        SimpleDateFormat DATE_FORMAT_6 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        try {
            insInsuranceSlip.setInception_date(DATE_FORMAT_6.parse(vo.getInception_date() + " 00:00:00"));
            insInsuranceSlip.setPlanned_end_date(DATE_FORMAT_6.parse(vo.getPlanned_end_date() + " 23:59:59"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        insInsuranceSlip.setPremium(new BigDecimal(vo.getGross_premium()));
        this.dao.updateById(insInsuranceSlip);
        this.insAgreementService.willInsurePolicyVoChangeIntoInsAgreement(insInsuranceSlip.getIns_insurance_slip_id(), vo.getExternal_reference());
    }

    @Override
    public OrderFormVo findOrderFormVoByID(Long orderId) {
        OrderFormVo vo = null;
        String key = "BLB:CACHE:POLICY-ID-" + String.valueOf(orderId);
        if (JedisUtils.exists((String)key)) {
            vo = (OrderFormVo)JSON.parseObject((String)JedisUtils.get((String)key), OrderFormVo.class);
        } else {
            OrderFormVo orderFormVo = this.dao.getOrderFormVoByID(orderId);
            if (orderFormVo != null) {
                vo = orderFormVo;
                this.replenishOrderFormVo(vo);
                if ("6".equals(vo.getPolicy_status()) && StringUtils.isNotEmpty((CharSequence)vo.getExternal_reference()) && StringUtils.isNotEmpty((CharSequence)vo.getInsure_path())) {
                    JedisUtils.set((String)key, (String)JSON.toJSONString((Object)vo), (int)ConstProp.THREE_HOURS_TIMEOUT_SECONDS);
                }
            }
        }
        return vo;
    }

    @Override
    public boolean getInsInsuranceSlipBySpecialId(Long special_id) {
        boolean flag = false;
        HashMap m = Maps.newHashMap();
        m.put("special_id", special_id);
        List list = this.dao.selectByMap(m);
        if (list.size() > 0) {
            for (InsInsuranceSlip iis : list) {
                if ("12".equals(iis.getOrder_status()) || "13".equals(iis.getOrder_status())) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    @Override
    public OrderFormVo getOrderFormVoByRcptNo(String rcptNo) {
        return this.dao.getOrderFormVoByRcptNo(rcptNo);
    }

    @Override
    public OrderFormVo getOrderFormVoByTradeSerialNumber(String tsNumber) {
        return this.dao.getOrderFormVoByTradeSerialNumber(tsNumber);
    }

    @Override
    public OrderFormVo getOrderFormVoByNoticeNo(String noticeNo) {
        return this.dao.getOrderFormVoByNoticeNo(noticeNo);
    }

    @Override
    public void replenishOrderFormVo(OrderFormVo vo) {
        this.insTransactionService.setOrderFormVoOfShowUrlByOrderID(vo, Long.parseLong(vo.getOid()));
        if (!StringUtils.isEmpty((CharSequence)vo.getProduct_code()) && "XYX-XWCK".equals(vo.getProduct_code())) {
            String ac = this.insMicroExportService.getAnnualCurrency(Long.parseLong(vo.getOid()));
            vo.setPolicy_currency(SysDictUtils.getDictLabel((String)ac, (String)"annualCurrency", (String)""));
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getProduct_oid())) {
            vo.setResponsibilityVoList(this.insProductResponsibilityService.findResponsibilityVoList(vo.getProduct_oid()));
        }
    }

    @Override
    public OrderFormVo findPolicyByExternalAndRoleName(String externalRefernce, String roleName) {
        OrderFormVo vo = this.dao.findPolicyByExternalAndRoleName(externalRefernce);
        if (vo != null && StringUtils.isNotEmpty((CharSequence)roleName) && !roleName.equals(vo.getInsured_role())) {
            vo = null;
        }
        return vo;
    }

    @Override
    public void setPremiumAndCoverageByOrderID(InsInsuranceSlip insInsuranceSlip) {
        List<ResponsibilityVo> irpVoList;
        if (insInsuranceSlip == null) {
            return;
        }
        int insuredCount = this.insRoleInpolicyService.countInsurancedByID(insInsuranceSlip.getIns_insurance_slip_id());
        if (insuredCount <= 0) {
            return;
        }
        if (insInsuranceSlip.getInception_date() == null) {
            return;
        }
        String insTime = com.bcxin.ins.util.toolbox.DateUtil.formatDate((Date)insInsuranceSlip.getInception_date()) + " 00:00:00";
        if (insInsuranceSlip.getPlanned_end_date() == null) {
            Calendar c = Calendar.getInstance();
            c.setTime(insInsuranceSlip.getInception_date());
            c.add(1, 1);
            c.set(5, c.get(5) - 1);
            String plaTime = com.bcxin.ins.util.toolbox.DateUtil.formatDate((Date)c.getTime()) + " 23:59:59";
            insInsuranceSlip.setPlanned_end_date(com.bcxin.ins.util.toolbox.DateUtil.parseDateTime((String)plaTime));
        }
        insInsuranceSlip.setInception_date(com.bcxin.ins.util.toolbox.DateUtil.parseDateTime((String)insTime));
        int day = DateUtil.getDistDates((Date)insInsuranceSlip.getInception_date(), (Date)insInsuranceSlip.getPlanned_end_date()) + 1;
        ProPrimary product = this.insProductService.getProduct(insInsuranceSlip.getPro_primary().getPro_primary_id());
        if (StringUtils.isEmpty((CharSequence)product.getProduct_code()) || !"TYX".equals(product.getProduct_code().split("-")[0])) {
            this.dao.updateById(insInsuranceSlip);
        }
        if (product.getPremium_min() == null) {
            this.dao.updateById(insInsuranceSlip);
        }
        if ((irpVoList = this.insProductResponsibilityService.findResponsibilityVoList(String.valueOf(product.getPro_primary_id()))).size() <= 0) {
            insInsuranceSlip.setPremium(this.getPremium(product.getPremium_min(), product.getProduct_code(), insInsuranceSlip.getIs_contain_repo(), day).multiply(new BigDecimal(insuredCount + "")));
            this.dao.updateById(insInsuranceSlip);
        }
        BigDecimal allAm = BigDecimal.ZERO;
        for (ResponsibilityVo vo : irpVoList) {
            if (StringUtils.isEmpty((CharSequence)vo.getFcy())) continue;
            if (StringUtils.isNotEmpty((CharSequence)vo.getCompensation_days())) {
                allAm = allAm.add(BigDecimal.valueOf(Double.parseDouble(vo.getFcy())).multiply(BigDecimal.valueOf(Double.parseDouble(vo.getCompensation_days()))));
                continue;
            }
            allAm = allAm.add(BigDecimal.valueOf(Double.parseDouble(vo.getFcy())));
        }
        if (allAm.compareTo(BigDecimal.ZERO) >= 0) {
            insInsuranceSlip.setInsured_amount(allAm.multiply(BigDecimal.valueOf(Double.parseDouble(insuredCount + ""))));
        }
        insInsuranceSlip.setPremium(this.getPremium(product.getPremium_min(), product.getProduct_code(), insInsuranceSlip.getIs_contain_repo(), day).multiply(BigDecimal.valueOf(Double.parseDouble(insuredCount + ""))));
        this.dao.updateById(insInsuranceSlip);
    }

    private BigDecimal getPremium(BigDecimal pm, String pCode, String _t, int sDay) {
        int p1;
        if (pCode.contains("TYX-QH")) {
            int allPr = 0;
            String _code = pCode;
            if (_code.equals("TYX-QH-DQ-1")) {
                if (sDay < 2) {
                    allPr = 8;
                } else if (sDay > 1 && sDay < 4) {
                    allPr = 10;
                } else if (sDay > 3 && sDay < 8) {
                    allPr = 13;
                } else if (sDay > 7 && sDay < 16) {
                    allPr = 18;
                } else if (sDay > 15 && sDay < 31) {
                    allPr = 25;
                }
            } else if (_code.equals("TYX-QH-DQ-2")) {
                if (sDay < 2) {
                    allPr = 10;
                } else if (sDay > 1 && sDay < 4) {
                    allPr = 12;
                } else if (sDay > 3 && sDay < 8) {
                    allPr = 15;
                } else if (sDay > 7 && sDay < 16) {
                    allPr = 20;
                } else if (sDay > 15 && sDay < 31) {
                    allPr = 28;
                }
            } else if (_code.equals("TYX-QH-DQ-3")) {
                if (sDay < 2) {
                    allPr = 12;
                } else if (sDay > 1 && sDay < 4) {
                    allPr = 14;
                } else if (sDay > 3 && sDay < 8) {
                    allPr = 17;
                } else if (sDay > 7 && sDay < 16) {
                    allPr = 23;
                } else if (sDay > 15 && sDay < 31) {
                    allPr = 30;
                }
            } else if (_code.equals("TYX-QH-DQ-4")) {
                if (sDay < 2) {
                    allPr = 14;
                } else if (sDay > 1 && sDay < 4) {
                    allPr = 16;
                } else if (sDay > 3 && sDay < 8) {
                    allPr = 20;
                } else if (sDay > 7 && sDay < 16) {
                    allPr = 28;
                } else if (sDay > 15 && sDay < 31) {
                    allPr = 40;
                }
            } else if (_code.equals("TYX-QH-DQ-5")) {
                if (sDay < 2) {
                    allPr = 15;
                } else if (sDay > 1 && sDay < 4) {
                    allPr = 18;
                } else if (sDay > 3 && sDay < 8) {
                    allPr = 23;
                } else if (sDay > 7 && sDay < 16) {
                    allPr = 35;
                } else if (sDay > 15 && sDay < 31) {
                    allPr = 50;
                }
            }
            return new BigDecimal(allPr + "");
        }
        if (pCode.contains("TYX-HT")) {
            int allPr = 0;
            String _code = pCode;
            if (_code.equals("TYX-HT-DQ-1")) {
                if (sDay < 2) {
                    allPr = 4;
                } else if (sDay > 1 && sDay < 4) {
                    allPr = 9;
                } else if (sDay > 3 && sDay < 8) {
                    allPr = 11;
                } else if (sDay > 7 && sDay < 16) {
                    allPr = 15;
                } else if (sDay > 15 && sDay < 31) {
                    allPr = 24;
                }
            } else if (_code.equals("TYX-HT-DQ-2")) {
                if (sDay < 2) {
                    allPr = 6;
                } else if (sDay > 1 && sDay < 4) {
                    allPr = 11;
                } else if (sDay > 3 && sDay < 8) {
                    allPr = 13;
                } else if (sDay > 7 && sDay < 16) {
                    allPr = 20;
                } else if (sDay > 15 && sDay < 31) {
                    allPr = 28;
                }
            } else if (_code.equals("TYX-HT-DQ-3")) {
                if (sDay < 2) {
                    allPr = 8;
                } else if (sDay > 1 && sDay < 4) {
                    allPr = 12;
                } else if (sDay > 3 && sDay < 8) {
                    allPr = 14;
                } else if (sDay > 7 && sDay < 16) {
                    allPr = 23;
                } else if (sDay > 15 && sDay < 31) {
                    allPr = 35;
                }
            } else if (_code.equals("TYX-HT-DQ-4")) {
                if (sDay < 2) {
                    allPr = 9;
                } else if (sDay > 1 && sDay < 4) {
                    allPr = 14;
                } else if (sDay > 3 && sDay < 8) {
                    allPr = 16;
                } else if (sDay > 7 && sDay < 16) {
                    allPr = 28;
                } else if (sDay > 15 && sDay < 31) {
                    allPr = 45;
                }
            } else if (_code.equals("TYX-HT-DQ-5")) {
                if (sDay < 2) {
                    allPr = 11;
                } else if (sDay > 1 && sDay < 4) {
                    allPr = 16;
                } else if (sDay > 3 && sDay < 8) {
                    allPr = 18;
                } else if (sDay > 7 && sDay < 16) {
                    allPr = 35;
                } else if (sDay > 15 && sDay < 31) {
                    allPr = 55;
                }
            }
            return new BigDecimal(allPr + "");
        }
        int n = "TYX-RB-3".equals(pCode) ? 30 : ("TYX-RB-4".equals(pCode) ? 40 : ("TYX-RB-5".equals(pCode) ? 50 : (p1 = "TYX-RB-6".equals(pCode) ? 60 : 0)));
        int p2 = "TYX-RB-3".equals(pCode) ? 260 : ("TYX-RB-4".equals(pCode) ? 350 : ("TYX-RB-5".equals(pCode) ? 430 : ("TYX-RB-6".equals(pCode) ? 530 : 0)));
        int plusP = 0;
        if ("1".equals(_t)) {
            plusP = p1;
        } else if ("2".equals(_t)) {
            plusP = p2;
        } else if ("3".equals(_t)) {
            plusP = p1 + p2;
        }
        return pm.add(BigDecimal.valueOf(Double.parseDouble(plusP + "")));
    }

    @Override
    public boolean updateIsSendYX(Long order_id) {
        int count = this.dao.updateIsSendYX(1, order_id);
        return true;
    }

    @Override
    public boolean updateIsPolicyBeforePayFee(int isPayFee, Long order_id) {
        this.dao.updateIsPolicyBeforePayFee(isPayFee, order_id);
        return true;
    }

    @Override
    public boolean addRemarksByOrder(String remarks, Long order_id) {
        this.dao.addRemarksByOrder(remarks, order_id);
        return true;
    }

    @Override
    public String getProductCode(Long order_id) {
        return this.dao.getProductCode(order_id);
    }

    @Override
    public List<String> selectOrderIdByProductCode(String product_code) {
        if (StringUtils.isEmpty((CharSequence)product_code)) {
            return null;
        }
        return this.dao.selectOrderIdByProductCode(product_code);
    }

    @Override
    public List<Map<String, Object>> findMaturingPolicy(String aDay, String bDay, String cDay) {
        if (StringUtils.isEmpty((CharSequence)aDay)) {
            return null;
        }
        return this.dao.findMaturingPolicy(aDay, bDay, cDay);
    }

    @Override
    public List<Map<String, String>> findZBNumByPolicyNos(String policyNos) {
        if (StringUtils.isEmpty((CharSequence)policyNos)) {
            return null;
        }
        return this.dao.findZBNumByPolicyNos(policyNos.split(","));
    }

    @Override
    public List<String> findPolicyNosByPACGZZRX(Long userId) {
        return this.dao.findPolicyNosByPACGZZRX(userId);
    }

    @Override
    public List<String> findPolicyNosByCAGZZRX(Long userId) {
        return this.dao.findPolicyNosByCAGZZRX(userId);
    }

    @Override
    public Long getIdByPolicyNo(String policyNo) {
        return this.dao.getIdByPolicyNo(policyNo);
    }

    @Override
    public List<Map<String, Object>> orderList(String idCardNo) {
        List<Map<String, Object>> mapList = this.dao.findPolicyByIdCard(idCardNo);
        for (Map<String, Object> map : mapList) {
            String proClauses;
            String productId = map.get("productId") != null ? String.valueOf(map.get("productId")) : "";
            if (!StringUtils.isNotEmpty((CharSequence)productId)) continue;
            String bz = this.dao.getBZContentJsonByProductId(productId);
            if (StringUtils.isNotEmpty((CharSequence)bz)) {
                map.put("zrJsonArr", bz);
            }
            if (!StringUtils.isNotEmpty((CharSequence)(proClauses = this.dao.getClausesJsonByProductId(productId)))) continue;
            map.put("proClauses", proClauses);
        }
        return mapList;
    }

    @Override
    public int isDueToByPolicy(Long orderId, String inception_date) {
        return this.dao.isDueToByPolicy(orderId, inception_date);
    }

    @Override
    public List<Map<String, String>> findOperationRecordByExNo(String exNo) {
        return this.dao.findOperationRecordByExNo(exNo);
    }

    @Override
    public int saveInsOperationRecord(String order_id, Date create_time, String sig_id, String operation_type, String path) {
        return this.dao.saveInsOperationRecord(IdWorker.getId(), create_time, order_id, sig_id, operation_type, path);
    }

    @Override
    public int updateOrderIdBySigId(String order_id, String sig_id) {
        return this.dao.updateOrderIdBySigId(order_id, sig_id);
    }

    @Override
    public int updateWebTypeByEx(String policyNo, String webType) {
        Long orderId = this.dao.getIdByPolicyNo(policyNo);
        this.comTaskResidualAPIService.saveComTaskResidual("pushOfflineOrderPerson", "\u56e2\u610f\u9669/\u96c7\u4e3b\u8d23\u4efb\u9669\u5728\u4fdd\u4eba\u5458\u63a8\u7ed9PASP\u5e73\u53f0(\u7ebf\u4e0b\u5355\u5173\u8054)", "com.bcxin.ins.service.order.PolicyService", 1, "String", String.valueOf(orderId));
        return this.dao.updateWebTypeByEx(policyNo, webType);
    }
}

