/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.order.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.aspose.words.Document;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.FieldMergingArgs;
import com.aspose.words.FolderFontSource;
import com.aspose.words.FontSettings;
import com.aspose.words.FontSourceBase;
import com.aspose.words.IFieldMergingCallback;
import com.aspose.words.ImageFieldMergingArgs;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.License;
import com.aspose.words.SaveOptions;
import com.bcxin.ins.core.entity.ME;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.dao.order.InsCommonReportAPIDao;
import com.bcxin.ins.entity.policy_report.InsCaseInfo;
import com.bcxin.ins.entity.policy_report.InsClaimInformation;
import com.bcxin.ins.entity.policy_report.InsCommonReport;
import com.bcxin.ins.entity.policy_report.InsPaymentInfo;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.ComTaskResidualAPIService;
import com.bcxin.ins.service.order.InsCaseInfoAPIService;
import com.bcxin.ins.service.order.InsCaseScheduleAPIService;
import com.bcxin.ins.service.order.InsClaimInformationAPIService;
import com.bcxin.ins.service.order.InsCommonReportAPIService;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.service.order.InsPaymentInfoAPIService;
import com.bcxin.ins.service.order.InsRoleInpolicyAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.user.ClientUserService;
import com.bcxin.ins.spring.executor.MyAsyncExecutor;
import com.bcxin.ins.third.gzzrx.changan.GZZRX_CARequestService;
import com.bcxin.ins.third.gzzrx.pingancai.GZZRX_PACRequestService;
import com.bcxin.ins.third.gzzrx.taibao.GZZRX_TBRequestService;
import com.bcxin.ins.third.gzzrx.taibao.util.TransType;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.FileHelp;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.OSSFileUtil;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.ins.vo.report_pac.InsCaseInfoVo;
import com.bcxin.ins.vo.report_pac.InsCaseScheduleVo;
import com.bcxin.ins.vo.report_pac.InsClaimInformationVo;
import com.bcxin.ins.vo.report_pac.InsCommonReportVo;
import com.bcxin.ins.vo.report_pac.InsPaymentInfoVo;
import com.bcxin.ins.vo.report_pac.ReportCodeVo;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
@Transactional
public class InsCommonReportAPIServiceImpl
extends ServiceImpl<InsCommonReportAPIDao, InsCommonReport>
implements InsCommonReportAPIService {
    private static Logger log = LoggerFactory.getLogger(InsCommonReportAPIServiceImpl.class);
    @Autowired
    private InsCommonReportAPIDao dao;
    @Autowired
    private InsPaymentInfoAPIService insPaymentInfoAPIService;
    @Autowired
    private InsClaimInformationAPIService insClaimInformationAPIService;
    @Autowired
    private InsCaseScheduleAPIService insCaseScheduleAPIService;
    @Autowired
    private InsCaseInfoAPIService insCaseInfoAPIService;
    @Autowired
    private GZZRX_PACRequestService gZZRX_PACRequestService;
    @Autowired
    private GZZRX_CARequestService gZZRX_CARequestService;
    @Autowired
    private GZZRX_TBRequestService gZZRX_TBRequestService;
    @Autowired
    private InsInsuranceSlipAPIService insInsuranceSlipAPIService;
    @Autowired
    private InsRoleInpolicyAPIService insRoleInpolicyAPIService;
    @Autowired
    private ComTaskResidualAPIService comTaskResidualAPIService;
    @Autowired
    private PolicyService policyService;
    @Autowired
    private ClientUserService userService;
    @Autowired
    private MyAsyncExecutor myAsyncExecutor;

    private InsCommonReport initInsCommonReport(Long user_id, Long order_id) {
        InsCommonReport insCommonReport = new InsCommonReport();
        InsPaymentInfo insPaymentInfo = this.insPaymentInfoAPIService.initInsPaymentInfo(user_id);
        insCommonReport.setIns_payment_info_id(insPaymentInfo.getIns_payment_info_id());
        insCommonReport.setCreate_time(new Date());
        insCommonReport.setCreate_by(new SysUser(user_id));
        insCommonReport.setRegister_user_id(user_id);
        insCommonReport.setIns_insurance_slip_id(order_id);
        this.dao.insert(insCommonReport);
        return insCommonReport;
    }

    private InsClaimInformationVo activateFileId(String ossPath) {
        String fileId = UUID.randomUUID().toString();
        try {
            String key = ossPath.split(".com/")[1];
            String[] arr = key.split("/");
            String fileName = arr[arr.length - 1];
            InputStream is = OSSFileUtil.getInputStreamByUrl((String)ossPath);
            if (this.gZZRX_PACRequestService.isUploadPA(is, fileId, fileName)) {
                InsClaimInformationVo vo = new InsClaimInformationVo();
                vo.setFile_key(fileId);
                vo.setFile_name(fileName);
                vo.setFile_path(ossPath);
                vo.setShort_group_code("006004");
                return vo;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String saasActivateFileId(String hwPath, String sign) {
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isEmpty((CharSequence)hwPath)) {
            return "";
        }
        InputStream is = null;
        try {
            String fileName;
            String fileId = sign + "-" + UUID.randomUUID().toString();
            URL url = new URL(hwPath);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            is = conn.getInputStream();
            String string = fileName = hwPath.contains("%2F") ? hwPath.split("%2F")[2] : hwPath.split("/")[5];
            if (this.gZZRX_PACRequestService.isUploadPA(is, fileId, fileName)) {
                String string2 = fileId;
                return string2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return "";
    }

    @Override
    public String getFileIdByPath(String path, String sign) {
        return this.saasActivateFileId(path, sign);
    }

    @Override
    public ResultDto saveInsCommonReportByApp(InsCommonReportVo vo, Long user_id) {
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isEmpty((CharSequence)vo.getPolicy_no())) {
            return new ResultDto("\u4fdd\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", "300", "", "", "");
        }
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)vo.getIns_insurance_slip_id())) {
            return this.saveInsCommonReport(vo, user_id);
        }
        OrderFormVo order = this.insInsuranceSlipAPIService.findPolicyByExternalAndRoleName(vo.getPolicy_no(), "");
        if (order == null) {
            return new ResultDto("\u4fdd\u5355\u4e0d\u5b58\u5728\uff01", "300", "", "", "");
        }
        if (!"0".equals(vo.getStatus())) {
            Date inc = DateUtil.parseDate((String)order.getInception_date());
            Date acc = DateUtil.convertString2Date((String)vo.getAccident_date());
            if (acc.getTime() - inc.getTime() < 0L) {
                return new ResultDto("\u51fa\u9669\u65f6\u95f4\u4e0d\u80fd\u5728\u751f\u6548\u65e5\u671f\u4e4b\u524d\uff01", "300", "", "", "");
            }
        }
        vo.setIns_insurance_slip_id(order.getOid());
        return this.saveInsCommonReport(vo, user_id);
    }

    @Override
    public ResultDto saveInsCommonReport(InsCommonReportVo vo, Long user_id) {
        try {
            vo.setRegister_user_id(String.valueOf(user_id));
            Map<String, Object> map = this.submitReportResult(vo);
            if (map.get("ResultDto") != null) {
                return (ResultDto)map.get("ResultDto");
            }
            String[] resultArr = (String[])map.get("resultArr");
            InsCommonReport insCommonReport = com.bcxin.mybatisplus.toolkit.StringUtils.isEmpty((CharSequence)vo.getIns_common_report_id()) ? this.initInsCommonReport(user_id, Long.parseLong(vo.getIns_insurance_slip_id())) : (InsCommonReport)this.dao.selectById(Long.valueOf(Long.parseLong(vo.getIns_common_report_id())));
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insCommonReport);
            insCommonReport.setIs_sync("0");
            this.dao.updateById(insCommonReport);
            vo.setRegister_user_id(String.valueOf(user_id));
            this.insClaimInformationAPIService.accordingToTheInsCommonReportVoSetUpInsClaimInformation(vo, insCommonReport.getIns_common_report_id());
            this.insPaymentInfoAPIService.saveInsPaymentInfo(vo.getInsPaymentInfoVo(), insCommonReport.getIns_payment_info_id());
            if (resultArr == null) {
                return new ResultDto("\u62a5\u6848\u4fe1\u606f\u5df2\u6210\u529f\u6682\u5b58!", "200", String.valueOf(insCommonReport.getIns_common_report_id()), "", "");
            }
            vo.setIns_common_report_id(String.valueOf(insCommonReport.getIns_common_report_id()));
            vo.setUpdate_by(String.valueOf(user_id));
            vo.setUpdate_time(DateUtil.getCurrentDateTime());
            vo.setReport_no(resultArr[1]);
            vo.setChannel_code(resultArr[2]);
            vo.setReport_date(resultArr[3]);
            vo.setStatus("1");
            this.dao.updateReportNo(vo);
            this.insClaimInformationAPIService.updateStatusByReportId(insCommonReport.getIns_common_report_id());
            if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)vo.getSignature_path()) && com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)vo.getSaas_com_id()) && com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)vo.getSaas_idcardno())) {
                this.draftWord(insCommonReport.getIns_common_report_id());
            }
            String msg = "\u62a5\u6848\u6210\u529f!";
            if (com.bcxin.mybatisplus.toolkit.StringUtils.isEmpty((CharSequence)resultArr[1])) {
                msg = "\u60a8\u7684\u7406\u8d54\u7533\u8bf7\u5df2\u63d0\u4ea4\uff0c\u4fdd\u9669\u516c\u53f8\u7406\u8d54\u4eba\u5458\u4f1a\u7b2c\u4e00\u65f6\u95f4\u4e0e\u60a8\u53d6\u5f97\u8054\u7cfb\uff0c\u544a\u77e5\u60a8\u51c6\u5907\u7406\u8d54\u6750\u6599\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\uff01";
            }
            return new ResultDto(msg, "200", "", "", "");
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            e.printStackTrace();
            return new ResultDto("\u9644\u4ef6\u8865\u4f20\u5f02\u5e38\uff1a" + e.getMessage(), "300", "", "", "");
        }
    }

    private Map<String, Object> submitReportResult(InsCommonReportVo vo) throws Exception {
        HashMap map = Maps.newHashMap();
        map.put("ResultDto", null);
        map.put("resultArr", null);
        if ("0".equals(vo.getStatus())) {
            return map;
        }
        String productCode = this.insInsuranceSlipAPIService.getProductCode(Long.parseLong(vo.getIns_insurance_slip_id()));
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isEmpty((CharSequence)productCode)) {
            map.put("resultArr", new String[]{"200", "", "", DateUtil.getCurrentDateTime()});
            return map;
        }
        if (productCode.contains("GZZRX-CA")) {
            vo.setReport_date(DateUtil.getCurrentDateTime());
            String result = this.gZZRX_CARequestService.requestReportCA(vo, TransTypeEnum.BASL.getValue());
            result = result + "##" + vo.getReport_date();
            String[] strs = result.split("#");
            if ("300".equals(strs[0])) {
                map.put("ResultDto", new ResultDto(strs[1], "300", "", "", ""));
            } else {
                map.put("resultArr", strs);
            }
        } else if (productCode.contains("GZZRX-TB")) {
            vo.setReport_date(DateUtil.getCurrentDateTime());
            String result = this.gZZRX_TBRequestService.requestReport(Long.parseLong(vo.getIns_insurance_slip_id()), vo, "", TransType.TB_BA.getValue());
            result = result + "##" + vo.getReport_date();
            String[] strs = result.split("#");
            if ("300".equals(strs[0])) {
                map.put("ResultDto", new ResultDto(strs[1], "300", "", "", ""));
            } else {
                map.put("resultArr", strs);
            }
        } else if (productCode.contains("GZZRX-PAC")) {
            String result;
            String[] strs;
            List clist = vo.getClaimInformationVoList();
            if (clist == null) {
                map.put("ResultDto", new ResultDto("\u65e0\u62a5\u6848\u8d44\u6599\u4e0a\u4f20\u4fe1\u606f\uff01", "300", "", "", ""));
                return map;
            }
            String ossPath = this.insRoleInpolicyAPIService.getOrgUrlByOrderID(Long.parseLong(vo.getIns_insurance_slip_id()));
            InsClaimInformationVo icifVo = this.activateFileId(ossPath);
            if (icifVo != null) {
                clist.add(icifVo);
                vo.setClaimInformationVoList(clist);
            }
            if ("300".equals((strs = (result = this.gZZRX_PACRequestService.submitReportPAC(vo, TransTypeEnum.BASL.getValue())).split("#"))[0])) {
                map.put("ResultDto", new ResultDto(strs[1], "300", "", "", ""));
            } else {
                map.put("resultArr", strs);
            }
        }
        return map;
    }

    @Override
    public void getCACaseById(InsCommonReportVo vo, Long report_id) {
        try {
            String result = this.gZZRX_CARequestService.requestXXReportCA("", vo.getReport_no(), 1, TransTypeEnum.AJCX.getValue());
            String[] strs = result.split("#");
            if (!"200".equals(strs[0])) {
                return;
            }
            List list = JSONArray.parseArray((String)strs[1], Map.class);
            if (list.size() < 1) {
                return;
            }
            Map map = (Map)list.get(0);
            this.setCACaseInfo(map, vo, report_id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setCACaseInfo(Map<String, String> caseInfo, InsCommonReportVo vo, Long report_id) {
        ArrayList caseInfoList = Lists.newArrayList();
        InsCaseInfoVo insCaseInfoVo = new InsCaseInfoVo();
        String caseStatus = caseInfo.get("CaseStatusCode");
        insCaseInfoVo.setCase_status(caseStatus);
        insCaseInfoVo.setCase_status_1(caseInfo.get("CaseStatusName"));
        caseInfoList.add(insCaseInfoVo);
        vo.setCaseInfoVoList((List)caseInfoList);
        this.dao.updateStatus("3".equals(caseStatus) ? "2" : "1", DateUtil.getCurrentDate(), report_id);
        this.insCaseInfoAPIService.delectAllInsCaseInfo(report_id);
        this.insCaseInfoAPIService.accordingToTheInsCommonReportVoSetUpInsCaseInfo(vo, report_id);
    }

    @Override
    public void getTBCaseById(InsCommonReportVo vo, Long report_id) {
        try {
            String result = this.gZZRX_TBRequestService.requestReportTB(Long.parseLong(vo.getIns_insurance_slip_id()), vo, "", TransType.EPIC_AJCX.getValue());
            String[] strs = result.split("#");
            if (!"200".equals(strs[0])) {
                return;
            }
            HashMap map = Maps.newHashMap();
            map.put("registerno", strs[1]);
            map.put("status", strs[2]);
            map.put("payamount", strs[3]);
            map.put("closeDate", strs[4]);
            map.put("explanation", strs[5]);
            this.setTBCaseInfo(map, vo, report_id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setTBCaseInfo(Map<String, String> caseInfo, InsCommonReportVo vo, Long report_id) {
        ArrayList caseInfoList = Lists.newArrayList();
        InsCaseInfoVo insCaseInfoVo = new InsCaseInfoVo();
        String caseStatus = caseInfo.get("status");
        String cStatus = "1".equals(caseStatus) ? "1" : ("2".equals(caseStatus) ? "0" : ("3".equals(caseStatus) ? "0" : ("4".equals(caseStatus) ? "6" : "0")));
        insCaseInfoVo.setCase_status(cStatus);
        String cStatus1 = "1".equals(caseStatus) ? "\u5904\u7406\u4e2d" : ("2".equals(caseStatus) ? "\u6ce8\u9500" : ("3".equals(caseStatus) ? "\u7ed3\u6848\u5f85\u652f\u4ed8" : ("4".equals(caseStatus) ? "\u7ed3\u6848\u5df2\u652f\u4ed8" : "")));
        insCaseInfoVo.setCase_status_1(cStatus1);
        insCaseInfoVo.setEnd_case_date(caseInfo.get("closeDate"));
        insCaseInfoVo.setEnd_case_amount_sum(caseInfo.get("payamount"));
        insCaseInfoVo.setWithdraw_reason(caseInfo.get("payamount"));
        String audit_status = "";
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)caseInfo.get("payamount")) && Double.parseDouble(caseInfo.get("payamount")) > 0.0 && "4".equals(caseStatus)) {
            audit_status = "1";
        } else if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)caseInfo.get("payamount")) && Double.parseDouble(caseInfo.get("payamount")) < 1.0 && "4".equals(caseStatus)) {
            audit_status = "0";
            insCaseInfoVo.setReject_notice_date(caseInfo.get("closeDate"));
        }
        insCaseInfoVo.setAudit_status(audit_status);
        caseInfoList.add(insCaseInfoVo);
        vo.setCaseInfoVoList((List)caseInfoList);
        this.dao.updateStatus("3".equals(caseStatus) ? "2" : ("4".equals(caseStatus) ? "2" : ("2".equals(caseStatus) ? "2" : "1")), DateUtil.getCurrentDate(), report_id);
        this.insCaseInfoAPIService.delectAllInsCaseInfo(report_id);
        this.insCaseInfoAPIService.accordingToTheInsCommonReportVoSetUpInsCaseInfo(vo, report_id);
    }

    @Override
    public void getCaseById(InsCommonReportVo vo, Long report_id) {
        try {
            Map detail;
            List details;
            String result = this.gZZRX_PACRequestService.requestReportPAC(report_id, TransTypeEnum.AJCX.getValue());
            String[] strs = result.split("#");
            if (!"200".equals(strs[0])) {
                return;
            }
            Map map = (Map)JSON.parseObject((String)strs[1], Map.class);
            if (map == null) {
                return;
            }
            List caseInfoList = JSONArray.parseArray((String)map.get("caseInfoList").toString(), Map.class);
            if (caseInfoList.size() > 0) {
                Map caseInfo = (Map)caseInfoList.get(0);
                this.setPaymentItem(caseInfo, vo, report_id);
                this.setCaseSchedule(caseInfo, vo, report_id);
                this.setCaseInfo(caseInfo, vo, report_id);
            }
            if ((details = JSONArray.parseArray((String)map.get("details").toString(), Map.class)).size() > 0 && (detail = (Map)details.get(0)) != null) {
                this.setDetail(detail, vo, report_id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setPaymentItem(Map<String, String> caseInfo, InsCommonReportVo vo, Long report_id) {
        Map paymentItem;
        String payDate;
        String pays = String.valueOf(caseInfo.get("paymentItemList"));
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isEmpty((CharSequence)pays)) {
            return;
        }
        List paymentItemList = JSONArray.parseArray((String)pays, Map.class);
        if (paymentItemList.size() > 0 && com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)(payDate = (String)(paymentItem = (Map)paymentItemList.get(0)).get("payDate")))) {
            vo.getInsPaymentInfoVo().setPay_date(payDate);
            this.insPaymentInfoAPIService.savePayDate(payDate, report_id);
        }
    }

    private void setCaseSchedule(Map<String, String> caseInfo, InsCommonReportVo vo, Long report_id) {
        String caseSchedules = String.valueOf(caseInfo.get("caseScheduleList"));
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isEmpty((CharSequence)caseSchedules)) {
            return;
        }
        List caseScheduleList = JSONArray.parseArray((String)caseSchedules, Map.class);
        if (caseScheduleList.size() <= 0) {
            return;
        }
        ArrayList caseScheduleVoList = Lists.newArrayList();
        for (Map map : caseScheduleList) {
            InsCaseScheduleVo csVo = new InsCaseScheduleVo();
            csVo.setClean_date((String)map.get("cleanDate"));
            csVo.setDuty_reason_name((String)map.get("dutyReasonName"));
            csVo.setDuty_reason_remark((String)map.get("dutyReasonRemark"));
            csVo.setReason_code_1((String)map.get("reasonCode1"));
            csVo.setReason_code_2((String)map.get("reasonCode2"));
            csVo.setReason_code_3((String)map.get("reasonCode3"));
            csVo.setClean_schedule((String)map.get("cleanSchedule"));
            csVo.setClean_schedule_remark((String)map.get("cleanScheduleRemark"));
            csVo.setInput_date((String)map.get("inputDate"));
            caseScheduleVoList.add(csVo);
        }
        if (caseScheduleVoList.size() > 0) {
            vo.setCaseScheduleVoList((List)caseScheduleVoList);
            this.insCaseScheduleAPIService.delectInsCaseScheduleByOid(report_id);
            this.insCaseScheduleAPIService.accordingToTheInsCommonReportVoSetUpInsCaseSchedule(vo, report_id);
        }
    }

    private void setCaseInfo(Map<String, String> caseInfo, InsCommonReportVo vo, Long report_id) {
        ArrayList caseInfoList = Lists.newArrayList();
        InsCaseInfoVo insCaseInfoVo = new InsCaseInfoVo();
        insCaseInfoVo.setCase_no(caseInfo.get("caseNo"));
        insCaseInfoVo.setAudit_status(caseInfo.get("auditStatus"));
        String caseStatus = caseInfo.get("caseStatus");
        insCaseInfoVo.setCase_status(caseStatus);
        insCaseInfoVo.setCase_status_1(caseInfo.get("caseStatus1"));
        insCaseInfoVo.setCase_status_2(caseInfo.get("caseStatus2"));
        insCaseInfoVo.setCase_times(caseInfo.get("caseTimes"));
        insCaseInfoVo.setClaim_name(caseInfo.get("claimName"));
        insCaseInfoVo.setClaim_no(caseInfo.get("claimNo"));
        insCaseInfoVo.setClaim_phone(caseInfo.get("claimPhone"));
        insCaseInfoVo.setEnd_case_amount_sum(caseInfo.get("endCaseAmountSum"));
        insCaseInfoVo.setIndemnity_conclusion(caseInfo.get("indemnityConclusion"));
        insCaseInfoVo.setEnd_case_date(caseInfo.get("endCaseDate"));
        insCaseInfoVo.setOrder_no(caseInfo.get("orderNo"));
        insCaseInfoVo.setWithdraw_reason(caseInfo.get("withdrawReason"));
        caseInfoList.add(insCaseInfoVo);
        vo.setCaseInfoVoList((List)caseInfoList);
        this.dao.updateStatus("0".equals(caseStatus) ? "2" : "1", caseInfo.get("endCaseDate"), report_id);
        this.insCaseInfoAPIService.delectAllInsCaseInfo(report_id);
        this.insCaseInfoAPIService.accordingToTheInsCommonReportVoSetUpInsCaseInfo(vo, report_id);
    }

    private void setDetail(Map<String, String> detail, InsCommonReportVo vo, Long report_id) {
        vo.setCheck_loss_sum(detail.get("checkLossSum"));
        vo.setAudit_status(detail.get("auditStatus"));
        vo.setClaim_no(detail.get("claimNo"));
        vo.setSuggestion_text(detail.get("suggestionText"));
        this.dao.updateResult(vo);
    }

    @Override
    public InsCommonReportVo getInsCommonReportVoById(Long oid) {
        return this.dao.getInsCommonReportVoById(oid);
    }

    @Override
    public InsCommonReportVo getInsCommonReportVoInfoById(Long oid, int sign) {
        InsCommonReportVo insCommonReportVo = this.getInsCommonReportVoById(oid);
        if (insCommonReportVo == null) {
            return insCommonReportVo;
        }
        OrderFormVo order = this.policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(insCommonReportVo.getIns_insurance_slip_id()));
        InsPaymentInfoVo insPaymentInfoVo = this.insPaymentInfoAPIService.getInsPaymentInfoVo(Long.parseLong(insCommonReportVo.getIns_payment_info_id()));
        insCommonReportVo.setInsPaymentInfoVo(insPaymentInfoVo);
        this.insClaimInformationAPIService.getInsCommonReportVoByReportID(insCommonReportVo, oid);
        if (sign == 0) {
            if ("1".equals(insCommonReportVo.getStatus())) {
                String productCode = this.insInsuranceSlipAPIService.getProductCode(Long.parseLong(insCommonReportVo.getIns_insurance_slip_id()));
                if (!productCode.contains("GZZRX-CA")) {
                    if (productCode.contains("GZZRX-TB")) {
                        this.getTBCaseById(insCommonReportVo, oid);
                    } else if (productCode.contains("GZZRX-PAC")) {
                        this.getCaseById(insCommonReportVo, oid);
                    }
                }
            } else if ("2".equals(insCommonReportVo.getStatus())) {
                this.insCaseInfoAPIService.getInsCommonReportVoByReportID(insCommonReportVo, oid);
                this.insCaseScheduleAPIService.getInsCommonReportVoByReportID(insCommonReportVo, oid);
            }
        } else {
            this.insCaseInfoAPIService.getInsCommonReportVoByReportID(insCommonReportVo, oid);
            this.insCaseScheduleAPIService.getInsCommonReportVoByReportID(insCommonReportVo, oid);
        }
        String accident_address = RegionUtils.getRegionNameByALLCode((String)insCommonReportVo.getAccident_province_code(), (String)insCommonReportVo.getAccident_city_code(), (String)insCommonReportVo.getAccident_county_code()) + insCommonReportVo.getAccident_place();
        insCommonReportVo.setAccident_address(accident_address);
        String sg = order == null ? "" : (order.getProduct_code().contains("GZZRX-CA") ? "CA" : "");
        ReportCodeVo rcvo = new ReportCodeVo(sg);
        if ("CA".equals(sg)) {
            insCommonReportVo.setAccident_cause_level(rcvo.getCxyyName(insCommonReportVo.getAccident_cause_level_1()));
        } else if ("0".equals(insCommonReportVo.getIs_sync())) {
            insCommonReportVo.setAccident_cause_level(rcvo.getCxyyName(insCommonReportVo.getAccident_cause_level_1()) + "\uff1a" + rcvo.getCxyyName(insCommonReportVo.getAccident_cause_level_2()));
        } else {
            insCommonReportVo.setAccident_cause_level(rcvo.getCxyyName(insCommonReportVo.getAccident_cause_level_2()));
        }
        insCommonReportVo.setInjured_detail_content(this.setInj(insCommonReportVo.getInjured_detail(), insCommonReportVo.getOutpatient_list(), insCommonReportVo.getMaim_list(), insCommonReportVo.getDemise_list()));
        return insCommonReportVo;
    }

    private String setInj(String injured_detail, String outpatient_list, String maim_list, String demise_list) {
        String[] injs;
        String content = "";
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isEmpty((CharSequence)injured_detail)) {
            return content;
        }
        for (String str : injs = injured_detail.split(",")) {
            if (str.equals("01")) {
                content = content + "\u95e8\u8bca\uff1a" + outpatient_list + "\uff1b";
                continue;
            }
            if (str.equals("02")) {
                content = content + "\u4f4f\u9662\u3001\u4f24\u6b8b\uff1a" + maim_list + "\uff1b";
                continue;
            }
            if (!str.equals("03")) continue;
            content = content + "\u6b7b\u4ea1\uff1a" + demise_list + "\uff1b";
        }
        return content;
    }

    @Override
    public ResultDto saveUploadFile(InsCommonReportVo vo) {
        try {
            Long report_id = Long.parseLong(vo.getIns_common_report_id());
            this.insClaimInformationAPIService.accordingToTheInsCommonReportVoSetUpInsClaimInformation(vo, report_id);
            String productCode = this.dao.getProductCodeByReportId(report_id);
            if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)productCode) && productCode.contains("GZZRX-CA")) {
                InsCommonReportVo icvo = this.getInsCommonReportVoInfoById(report_id, 1);
                String result = this.gZZRX_CARequestService.requestReportCA(icvo, TransTypeEnum.CLSC.getValue());
                String[] strs = result.split("#");
                if ("200".equals(strs[0])) {
                    this.insClaimInformationAPIService.updateStatusByReportId(report_id);
                    return new ResultDto("\u9644\u4ef6\u5f71\u50cf\u4fdd\u5b58\u6210\u529f", "200", "", "", "");
                }
                ArrayList ids = Lists.newArrayList();
                for (InsClaimInformationVo icfvo : icvo.getClaimInformationVoList()) {
                    if (!"0".equals(icfvo.getStatus())) continue;
                    int len = icfvo.getIns_claim_information_id().length();
                    String sign = icfvo.getIns_claim_information_id().substring(len - 3, len);
                    String index = icfvo.getShort_group_code() + sign;
                    if (strs[1].contains(index)) continue;
                    ids.add(icfvo.getIns_claim_information_id());
                }
                this.insClaimInformationAPIService.updateStatusByIds(ids);
                return new ResultDto(strs[2], "200", "", "", "");
            }
            if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)productCode) && productCode.contains("GZZRX-PAC")) {
                String result = this.gZZRX_PACRequestService.requestReportPAC(report_id, TransTypeEnum.CLSC.getValue());
                String[] strs = result.split("#");
                if ("200".equals(strs[0])) {
                    this.insClaimInformationAPIService.updateStatusByReportId(report_id);
                    return new ResultDto(strs[1], "200", "", "", "");
                }
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return new ResultDto(strs[1], "300", "", "", "");
            }
            if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)productCode) && productCode.contains("GZZRX-TB")) {
                String result = this.gZZRX_TBRequestService.requestReportTB(Long.parseLong(vo.getIns_insurance_slip_id()), vo, "", TransType.EPIC_YXSC.getValue());
                String[] strs = result.split("#");
                if ("200".equals(strs[0])) {
                    this.insClaimInformationAPIService.updateStatusByReportId(report_id);
                    return new ResultDto(strs[1], "200", "", "", "");
                }
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return new ResultDto(strs[1], "300", "", "", "");
            }
            return new ResultDto("\u9644\u4ef6\u5f71\u50cf\u4fdd\u5b58\u6210\u529f", "200", "", "", "");
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResultDto("\u9644\u4ef6\u8865\u4f20\u5f02\u5e38\uff1a" + e.getMessage(), "300", "", "", "");
        }
    }

    @Override
    public boolean delectInsCommonReportByOid(Long oid) {
        try {
            this.dao.updateStatusById(oid);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public List<InsCommonReportVo> selectInsCommonReportVoListByOrderID(String keyword, String status, String startDate, String endDate, Long user_id, DwzPage page) {
        Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
        List<InsCommonReportVo> voList = this.dao.selectInsCommonReportVoListByOrderID((Page<InsCommonReportVo>)pageHelper, keyword, status, startDate, endDate, user_id);
        page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
        return voList;
    }

    @Override
    public List<Map<String, String>> selectReportListByIdCardNo(String status, String saasIdCardNo) {
        return this.dao.selectReportListByIdCardNo(status, saasIdCardNo);
    }

    @Override
    public String sendApi(String oid) throws Exception {
        String result = this.gZZRX_PACRequestService.requestReportPAC(Long.parseLong(oid), "16");
        return result;
    }

    @Override
    public void findXXReportDetails() {
        ArrayList list;
        int count;
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (userdetail == null) {
            return;
        }
        Long userId = Long.parseLong(userdetail.getOid());
        List<String> policyNosPAC = this.insInsuranceSlipAPIService.findPolicyNosByPACGZZRX(userId);
        List<String> policyNosCA = this.insInsuranceSlipAPIService.findPolicyNosByCAGZZRX(userId);
        if (policyNosPAC.size() > 0) {
            count = 0;
            list = Lists.newArrayList();
            for (String policyNo : policyNosPAC) {
                list.add(policyNo);
                if (count == 49) {
                    this.loadAndSetXXReport(userId, String.join((CharSequence)",", list));
                    count = 0;
                    list = Lists.newArrayList();
                }
                ++count;
            }
            if (list.size() > 0) {
                this.loadAndSetXXReport(userId, String.join((CharSequence)",", list));
            }
        }
        if (policyNosCA.size() > 0) {
            count = 0;
            list = Lists.newArrayList();
            for (String policyNo : policyNosCA) {
                list.add(policyNo);
                if (count == 49) {
                    this.loadAndSetCAXXReport(userId, list);
                    count = 0;
                    list = Lists.newArrayList();
                }
                ++count;
            }
            if (list.size() > 0) {
                this.loadAndSetCAXXReport(userId, list);
            }
        }
    }

    private void loadAndSetCAXXReport(Long userId, List<String> policyNos) {
        this.myAsyncExecutor.execute(() -> {
            ArrayList arrMap = Lists.newArrayList();
            try {
                block2: for (String policyNo : policyNos) {
                    String result;
                    String[] arr;
                    int total = 0;
                    int totalPageNum = 1;
                    for (int i = 1; i <= totalPageNum && "200".equals((arr = (result = this.gZZRX_CARequestService.requestXXReportCA(policyNo, "", i, TransTypeEnum.AJCX.getValue())).split("#"))[0]); ++i) {
                        Map map = (Map)JSON.parseObject((String)arr[1], Map.class);
                        if (i == 1) {
                            totalPageNum = Integer.parseInt((String)map.get("TotalPage"));
                            total = Integer.parseInt((String)map.get("TotalCount"));
                            if (total > 100 && DateUtil.getHours() > 8 && DateUtil.getHours() < 23) {
                                this.comTaskResidualAPIService.saveComTaskResidual2("task_loadAndSetCAXXReport", "\u8bf7\u6c42\u63a5\u53e3\u83b7\u53d6\u62a5\u6848\u6570\u636e", "com.bcxin.ins.service.order.InsCommonReportAPIService", 2, "Long,String", String.valueOf(userId) + "," + policyNo);
                                continue block2;
                            }
                        }
                        if (total <= 0) continue;
                        arrMap.addAll(JSONArray.parseArray((String)((String)map.get("ReportInfo")), Map.class));
                    }
                }
                ArrayList icrList = Lists.newArrayList();
                ArrayList ipiList = Lists.newArrayList();
                ArrayList iciList = Lists.newArrayList();
                for (Map map : arrMap) {
                    this.setCAXXReport(map, userId, icrList, ipiList, iciList);
                }
                if (icrList.size() > 0) {
                    this.updateBatchById(icrList);
                    this.insPaymentInfoAPIService.updateBatchById(ipiList);
                    this.insCaseInfoAPIService.updateBatchById(iciList);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void loadAndSetXXReport(Long userId, String policyNos) {
        this.myAsyncExecutor.execute(() -> {
            try {
                String result;
                String[] arr;
                ArrayList arrMap = Lists.newArrayList();
                int total = 0;
                int pageSize = 100;
                int pageNum = 1;
                for (int i = 0; i < 10 && "200".equals((arr = (result = this.gZZRX_PACRequestService.requestXXReportPAC(policyNos, pageSize, pageNum, "18")).split("#"))[0]); ++i) {
                    if (pageNum == 1 && (total = Integer.parseInt(arr[1])) > 100 && DateUtil.getHours() > 8 && DateUtil.getHours() < 23) {
                        this.comTaskResidualAPIService.saveComTaskResidual2("task_loadAndSetXXReport", "\u8bf7\u6c42\u63a5\u53e3\u83b7\u53d6\u62a5\u6848\u6570\u636e", "com.bcxin.ins.service.order.InsCommonReportAPIService", 2, "Long,String", String.valueOf(userId) + "," + policyNos.replace(",", "#"));
                        break;
                    }
                    if (total > 0) {
                        String data = arr[3];
                        arrMap.addAll(JSONArray.parseArray((String)data, Map.class));
                    }
                    if (total - pageSize < 0) break;
                    total -= pageSize;
                    ++pageNum;
                }
                ArrayList icrList = Lists.newArrayList();
                ArrayList ipiList = Lists.newArrayList();
                ArrayList iciList = Lists.newArrayList();
                for (Map map : arrMap) {
                    this.setXXReport(map, userId, icrList, ipiList, iciList);
                }
                if (icrList.size() > 0) {
                    this.updateBatchById(icrList);
                    this.insPaymentInfoAPIService.updateBatchById(ipiList);
                    this.insCaseInfoAPIService.updateBatchById(iciList);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public boolean task_loadAndSetXXReport(Long userId, String policyNos) {
        try {
            String result;
            String[] arr;
            if (userId == null || com.bcxin.mybatisplus.toolkit.StringUtils.isEmpty((CharSequence)policyNos)) {
                return true;
            }
            policyNos = policyNos.replace("#", ",");
            ArrayList arrMap = Lists.newArrayList();
            int total = 0;
            int pageSize = 100;
            int pageNum = 1;
            for (int i = 0; i < 10 && "200".equals((arr = (result = this.gZZRX_PACRequestService.requestXXReportPAC(policyNos, pageSize, pageNum, "18")).split("#"))[0]); ++i) {
                if (pageNum == 1) {
                    total = Integer.parseInt(arr[1]);
                }
                if (total > 0) {
                    String data = arr[3];
                    arrMap.addAll(JSONArray.parseArray((String)data, Map.class));
                }
                if (total - pageSize < 0) break;
                total -= pageSize;
                ++pageNum;
            }
            ArrayList icrList = Lists.newArrayList();
            ArrayList ipiList = Lists.newArrayList();
            ArrayList iciList = Lists.newArrayList();
            for (Map map : arrMap) {
                this.setXXReport(map, userId, icrList, ipiList, iciList);
            }
            if (icrList.size() > 0) {
                this.updateBatchById(icrList);
                this.insPaymentInfoAPIService.updateBatchById(ipiList);
                this.insCaseInfoAPIService.updateBatchById(iciList);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean task_loadAndSetCAXXReport(Long userId, String policyNos) {
        ArrayList arrMap = Lists.newArrayList();
        try {
            String[] policyNoArr;
            if (userId == null || com.bcxin.mybatisplus.toolkit.StringUtils.isEmpty((CharSequence)policyNos)) {
                return true;
            }
            for (String policyNo : policyNoArr = policyNos.split("#")) {
                String result;
                String[] arr;
                int total = 0;
                int totalPageNum = 1;
                for (int i = 1; i <= totalPageNum && "200".equals((arr = (result = this.gZZRX_CARequestService.requestXXReportCA(policyNo, "", i, TransTypeEnum.AJCX.getValue())).split("#"))[0]); ++i) {
                    Map map = (Map)JSON.parseObject((String)arr[1], Map.class);
                    if (i == 1) {
                        totalPageNum = Integer.parseInt((String)map.get("TotalPage"));
                        total = Integer.parseInt((String)map.get("TotalCount"));
                    }
                    if (total <= 0) continue;
                    arrMap.addAll(JSONArray.parseArray((String)((String)map.get("ReportInfo")), Map.class));
                }
            }
            ArrayList icrList = Lists.newArrayList();
            ArrayList ipiList = Lists.newArrayList();
            ArrayList iciList = Lists.newArrayList();
            for (Map map : arrMap) {
                this.setCAXXReport(map, userId, icrList, ipiList, iciList);
            }
            if (icrList.size() > 0) {
                this.updateBatchById(icrList);
            }
            if (ipiList.size() > 0) {
                this.insPaymentInfoAPIService.updateBatchById(ipiList);
            }
            if (iciList.size() > 0) {
                this.insCaseInfoAPIService.updateBatchById(iciList);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void setXXReport(Map map, Long userId, List<InsCommonReport> icrList, List<InsPaymentInfo> ipiList, List<InsCaseInfo> iciList) throws Exception {
        String rejectNoticeUrl;
        InsCommonReport insCommonReport;
        Long order_id = this.insInsuranceSlipAPIService.getIdByPolicyNo(String.valueOf(map.get("policyNo")));
        List list = this.dao.selectByMap(new ME().put("report_no", (Object)String.valueOf(map.get("reportNo"))).getM());
        if (list.size() > 0) {
            insCommonReport = (InsCommonReport)list.get(0);
            if (insCommonReport.getStatus() == 2) {
                return;
            }
            insCommonReport.setUpdate_time(new Date());
        } else {
            insCommonReport = this.initInsCommonReport(userId, order_id);
            insCommonReport.setIs_sync("1");
        }
        List<String> zzList = this.dao.getZBRYByOrderId(order_id);
        String zz = "";
        if (zzList.size() > 0) {
            zz = StringUtils.join((Object[])zzList.toArray(), (String)",");
        }
        if ("1".equals(insCommonReport.getIs_sync())) {
            String demise;
            String maim;
            insCommonReport.setReporter_name(map.get("reporterName") == null ? "" : String.valueOf(map.get("reporterName")));
            insCommonReport.setReport_no(map.get("reportNo") == null ? "" : String.valueOf(map.get("reportNo")));
            insCommonReport.setPolicy_no(map.get("policyNo") == null ? "" : String.valueOf(map.get("policyNo")));
            insCommonReport.setReporter_tel(map.get("reporterCallNo") == null ? "" : String.valueOf(map.get("reporterCallNo")));
            insCommonReport.setReport_date(map.get("reportDate") == null ? null : DateUtil.convertStringToDate((String)String.valueOf(map.get("reportDate"))));
            insCommonReport.setAccident_date(map.get("accidentDate") == null ? null : DateUtil.convertStringToDate((String)String.valueOf(map.get("accidentDate"))));
            insCommonReport.setAccident_place(map.get("accidentPlace") == null ? "" : String.valueOf(map.get("accidentPlace")));
            insCommonReport.setAccident_process(map.get("accidentDetail") == null ? "" : String.valueOf(map.get("accidentDetail")));
            insCommonReport.setAccident_cause_level_2(map.get("accidentCause") == null ? "" : String.valueOf(map.get("accidentCause")));
            insCommonReport.setEnd_case_date(map.get("endCaseDate") == null ? null : DateUtil.convertStringToDate((String)String.valueOf(map.get("endCaseDate"))));
            insCommonReport.setCheck_loss_sum(map.get("payAmount") == null ? BigDecimal.ZERO : new BigDecimal(String.valueOf(map.get("payAmount"))));
            insCommonReport.setAudit_status("1");
            String treatment = map.get("treatment") == null ? "" : String.valueOf(map.get("treatment"));
            String personName = map.get("personName") == null ? "" : String.valueOf(map.get("personName"));
            String certificateNo = map.get("certificateNo") == null ? "" : String.valueOf(map.get("certificateNo"));
            insCommonReport.setInjured_detail(treatment);
            String outPatient = InsCommonReportAPIServiceImpl.setList(insCommonReport.getOutpatient_list(), treatment, personName, certificateNo, "01", zz);
            if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)outPatient)) {
                insCommonReport.setOutpatient_list(outPatient);
            }
            if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)(maim = InsCommonReportAPIServiceImpl.setList(insCommonReport.getMaim_list(), treatment, personName, certificateNo, "02", zz)))) {
                insCommonReport.setMaim_list(maim);
            }
            if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)(demise = InsCommonReportAPIServiceImpl.setList(insCommonReport.getDemise_list(), treatment, personName, certificateNo, "03", zz)))) {
                insCommonReport.setDemise_list(demise);
            }
        }
        insCommonReport.setStatus(Integer.valueOf("3".equals(String.valueOf(map.get("caseStatus"))) ? 2 : 1));
        icrList.add(insCommonReport);
        InsPaymentInfo insPaymentInfo = (InsPaymentInfo)this.insPaymentInfoAPIService.selectById(insCommonReport.getIns_payment_info_id());
        if ("1".equals(insCommonReport.getIs_sync())) {
            insPaymentInfo.setClient_name(map.get("clientName") == null ? "" : String.valueOf(map.get("clientName")));
            insPaymentInfo.setClient_bank_account(map.get("clientBankAccount") == null ? "" : String.valueOf(map.get("clientBankAccount")));
            insPaymentInfo.setClient_bank_name(map.get("clientBankName") == null ? "" : String.valueOf(map.get("clientBankName")));
        }
        insPaymentInfo.setPay_date(map.get("payDate") == null ? null : DateUtil.convertStringToDate((String)String.valueOf(map.get("payDate"))));
        insPaymentInfo.setUpdate_time(new Date());
        ipiList.add(insPaymentInfo);
        List ciList = this.insCaseInfoAPIService.selectByMap(new ME().put("ins_common_report_id", (Object)String.valueOf(insCommonReport.getIns_common_report_id())).getM());
        InsCaseInfo insCaseInfo = ciList.size() > 0 ? (InsCaseInfo)ciList.get(0) : this.insCaseInfoAPIService.initInsCaseInfo(userId, insCommonReport.getIns_common_report_id());
        insCaseInfo.setIns_common_report_id(insCommonReport.getIns_common_report_id());
        insCaseInfo.setCase_no(map.get("caseNo") == null ? "" : String.valueOf(map.get("caseNo")));
        insCaseInfo.setAudit_status(map.get("rejectNoticeDate") == null ? "1" : "0");
        String caseStatus = "3".equals(String.valueOf(map.get("caseStatus"))) ? "0" : String.valueOf(map.get("caseStatus"));
        insCaseInfo.setCase_status(caseStatus);
        insCaseInfo.setCase_times(map.get("caseTimes") == null ? null : Integer.valueOf(Integer.parseInt(String.valueOf(map.get("caseTimes")))));
        insCaseInfo.setClaim_name(map.get("claimName") == null ? "" : String.valueOf(map.get("claimName")));
        insCaseInfo.setEnd_case_amount_sum(map.get("payAmount") == null ? "" : String.valueOf(map.get("payAmount")));
        String ic = String.valueOf(map.get("indemnityConclusion"));
        String indemnity_conclusion = "1".equals(ic) ? "\u6b63\u5e38\u8d54\u4ed8" : ("2".equals(ic) ? "\u96f6\u7ed3" : ("3".equals(ic) ? "\u62d2\u8d54" : ("4".equals(ic) ? "\u7acb\u6848\u6ce8\u9500" : ("5".equals(ic) ? "\u62a5\u6848\u6ce8\u9500" : ""))));
        insCaseInfo.setIndemnity_conclusion(indemnity_conclusion);
        insCaseInfo.setReject_notice_date(map.get("rejectNoticeDate") == null ? null : DateUtil.convertStringToDate((String)String.valueOf(map.get("rejectNoticeDate"))));
        insCaseInfo.setEnd_case_date(map.get("endCaseDate") == null ? null : DateUtil.convertStringToDate((String)String.valueOf(map.get("endCaseDate"))));
        insCaseInfo.setWithdraw_reason(map.get("withdrawReason") == null ? "" : String.valueOf(map.get("withdrawReason")));
        String string = rejectNoticeUrl = map.get("rejectNoticeUrl") == null ? "" : String.valueOf(map.get("rejectNoticeUrl"));
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isEmpty((CharSequence)insCaseInfo.getReject_notice_url()) && com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)rejectNoticeUrl)) {
            String path = FileHelp.saveFile((String)rejectNoticeUrl);
            if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)path)) {
                rejectNoticeUrl = GlobalResources.WEB_URL + path;
            }
            insCaseInfo.setReject_notice_url(rejectNoticeUrl);
        }
        iciList.add(insCaseInfo);
    }

    private void setCAXXReport(Map map, Long userId, List<InsCommonReport> icrList, List<InsPaymentInfo> ipiList, List<InsCaseInfo> iciList) throws Exception {
        InsCommonReport insCommonReport;
        Long order_id = this.insInsuranceSlipAPIService.getIdByPolicyNo(String.valueOf(map.get("PolicyNo")));
        List list = this.dao.selectByMap(new ME().put("report_no", (Object)String.valueOf(map.get("RegistNo"))).getM());
        if (list.size() > 0) {
            insCommonReport = (InsCommonReport)list.get(0);
            if (insCommonReport.getStatus() == 2) {
                return;
            }
            insCommonReport.setUpdate_time(new Date());
        } else {
            insCommonReport = this.initInsCommonReport(userId, order_id);
            insCommonReport.setIs_sync("1");
        }
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isEmpty((CharSequence)insCommonReport.getReport_no())) {
            insCommonReport.setReport_no(map.get("RegistNo") == null ? "" : String.valueOf(map.get("RegistNo")));
        }
        if ("1".equals(insCommonReport.getIs_sync())) {
            insCommonReport.setReporter_name(map.get("ReportName") == null ? "" : String.valueOf(map.get("ReportName")));
            insCommonReport.setPolicy_no(map.get("PolicyNo") == null ? "" : String.valueOf(map.get("PolicyNo")));
            insCommonReport.setReporter_tel(map.get("PhoneNumber") == null ? "" : String.valueOf(map.get("PhoneNumber")));
            insCommonReport.setReport_date(map.get("ReportTime") == null ? null : DateUtil.convertStringToDate((String)String.valueOf(map.get("ReportTime"))));
            insCommonReport.setAccident_date(map.get("DamageTime") == null ? null : DateUtil.convertStringToDate((String)String.valueOf(map.get("DamageTime"))));
            insCommonReport.setAccident_place(map.get("DamageAddress") == null ? "" : String.valueOf(map.get("DamageAddress")));
            insCommonReport.setAccident_process(map.get("context") == null ? "" : String.valueOf(map.get("context")));
            insCommonReport.setAccident_cause_level_1(map.get("DamageCode") == null ? "" : String.valueOf(map.get("DamageCode")));
            insCommonReport.setCheck_loss_sum(BigDecimal.ZERO);
            insCommonReport.setAudit_status("1");
            if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)String.valueOf(map.get("rs")))) {
                String[] rsArr = String.valueOf(map.get("rs")).split(";");
                String outpatient_list = "";
                String demise_list = "";
                for (String rs : rsArr) {
                    String[] r = rs.split("|");
                    if ("1".equals(r[1])) {
                        outpatient_list = outpatient_list + r[0] + ",";
                    }
                    if (!"2".equals(r[1])) continue;
                    demise_list = demise_list + r[0] + ",";
                }
                String treatment = (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)outpatient_list) ? "01," : "") + (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)demise_list) ? "03" : "");
                insCommonReport.setInjured_detail(treatment);
                if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)outpatient_list)) {
                    insCommonReport.setOutpatient_list(outpatient_list);
                }
                if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)demise_list)) {
                    insCommonReport.setDemise_list(demise_list);
                }
            }
            if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)String.valueOf(map.get("pm")))) {
                String[] pmArr = String.valueOf(map.get("pm")).split(";");
                String[] pmInfo = pmArr[0].split("|");
                InsPaymentInfo insPaymentInfo = (InsPaymentInfo)this.insPaymentInfoAPIService.selectById(insCommonReport.getIns_payment_info_id());
                insPaymentInfo.setClient_name(pmInfo[0]);
                insPaymentInfo.setClient_certificate_no(pmInfo[1]);
                insPaymentInfo.setClient_certificate_type("1".equals(pmInfo[6]) ? "0" : "2");
                insPaymentInfo.setClient_bank_account(pmInfo[3]);
                insPaymentInfo.setClient_bank_name(pmInfo[2]);
                insPaymentInfo.setUpdate_time(new Date());
                insPaymentInfo.setProvince_code(pmInfo[4]);
                insPaymentInfo.setRegion_code(pmInfo[5]);
                insPaymentInfo.setBank_account_attribute("1".equals(pmInfo[6]) ? "1" : "0");
                ipiList.add(insPaymentInfo);
            }
        }
        insCommonReport.setStatus(Integer.valueOf("3".equals(String.valueOf(map.get("CaseStatusCode"))) ? 2 : 1));
        icrList.add(insCommonReport);
        List ciList = this.insCaseInfoAPIService.selectByMap(new ME().put("ins_common_report_id", (Object)String.valueOf(insCommonReport.getIns_common_report_id())).getM());
        InsCaseInfo insCaseInfo = ciList.size() > 0 ? (InsCaseInfo)ciList.get(0) : this.insCaseInfoAPIService.initInsCaseInfo(userId, insCommonReport.getIns_common_report_id());
        insCaseInfo.setCase_status(String.valueOf(map.get("CaseStatusCode")));
        insCaseInfo.setCase_status_1(String.valueOf(map.get("CaseStatusName")));
        iciList.add(insCaseInfo);
    }

    private static String setList(String oldName, String treatment, String personName, String certificateNo, String type, String zz) {
        ArrayList list = Lists.newArrayList();
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isEmpty((CharSequence)treatment)) {
            return list.size() > 0 ? String.join((CharSequence)",", list) : "";
        }
        String[] treatments = treatment.split(",");
        String[] personNames = com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)personName) ? personName.split(",") : null;
        String[] certificateNos = com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)certificateNo) ? certificateNo.split(",") : null;
        for (int i = 0; i < treatments.length; ++i) {
            if (!type.equals(treatments[i]) || personNames == null || personNames.length <= i) continue;
            String name = personNames[i];
            if (certificateNos == null || certificateNos.length <= i) {
                list.add(name);
                continue;
            }
            name = name + "(" + certificateNos[i] + ")";
            String cts = name.substring(0, 1) + "(" + certificateNos[i] + ");";
            if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)zz)) {
                if (zz.contains(cts)) {
                    try {
                        String zzR = zz.replace(cts, "&&");
                        name = zzR.split(cts)[1].split(",")[0];
                    }
                    catch (Exception exception) {}
                } else if (com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty((CharSequence)oldName) && oldName.contains("(") && oldName.contains(")")) {
                    name = oldName;
                }
            }
            list.add(name);
        }
        return list.size() > 0 ? String.join((CharSequence)",", list) : "";
    }

    @Override
    public String draftWord(Long reportId) {
        OrderFormVo orderVo;
        InsCommonReportVo vo = this.getInsCommonReportVoById(reportId);
        String path = this.draft(vo, orderVo = this.policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(vo.getIns_insurance_slip_id())));
        if (com.bcxin.mybatisplus.toolkit.StringUtils.isEmpty((CharSequence)path)) {
            return path;
        }
        path = GlobalResources.DONOW_PATH + path;
        String fileName = path.split("report/")[1];
        String fileId = UUID.randomUUID().toString();
        String sysPath = GlobalResources.COM_IMG_RE + path.split("path=")[1];
        InsCommonReportAPIServiceImpl.doc2pdf(sysPath);
        try (FileInputStream is = new FileInputStream(sysPath);){
            if (this.gZZRX_PACRequestService.isUploadPA(is, fileId, fileName)) {
                InsClaimInformation ic = new InsClaimInformation();
                ic.setFile_key(fileId);
                ic.setFile_name(fileName);
                ic.setFile_path(path);
                ic.setStatus(Integer.valueOf(1));
                ic.setShort_group_code("001000");
                ic.setIns_common_report_id(reportId);
                ic.setCreate_time(new Date());
                this.insClaimInformationAPIService.insert(ic);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String draft(InsCommonReportVo vo, OrderFormVo orderVo) {
        FileOutputStream fileOS = null;
        InputStream license = null;
        FileInputStream word = null;
        try {
            license = new PathMatchingResourcePatternResolver().getResource("/aspose/license.xml").getInputStream();
            License aposeLic = new License();
            aposeLic.setLicense(license);
            String classpath = this.getClass().getResource("/").getPath().replaceFirst("/", "");
            String webappRoot = classpath.replaceAll("WEB-INF/classes/", "");
            String filePath = "/" + webappRoot + "/static/coninsweb/public-resources/files/\u7d22\u8d54\u7533\u8bf7\u4e66\u793a\u4f8bAPP.doc";
            word = new FileInputStream(new File(filePath.replace("%20", " ")));
            Document docAll = new Document((InputStream)word);
            DocumentBuilder builder = new DocumentBuilder(docAll);
            HashMap map = Maps.newHashMap();
            map.put("comName", orderVo.getApplicant_name());
            map.put("productName", orderVo.getProduct_name());
            map.put("policyNo", orderVo.getExternal_reference());
            map.put("reportNo", vo.getReport_no());
            map.put("reportName", vo.getReporter_name());
            map.put("reportTel", vo.getReporter_tel());
            map.put("accidentDate", vo.getAccident_date());
            map.put("accidentPlace", vo.getAccident_place());
            map.put("accidentProcess", vo.getAccident_process());
            map.put("insName", vo.getSignature_path());
            map.put("year", DateUtil.getCurrentDate().split("-")[0]);
            map.put("month", DateUtil.getCurrentDate().split("-")[1]);
            map.put("day", DateUtil.getCurrentDate().split("-")[2]);
            if (map != null && !map.isEmpty()) {
                Set set = map.keySet();
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    String next = String.valueOf(it.next());
                    String s = String.valueOf(map.get(next));
                    if (next.equals("insName")) {
                        builder.moveToMergeField(next);
                        URL url = new URL(vo.getSignature_path());
                        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                        conn.setRequestMethod("GET");
                        conn.setConnectTimeout(5000);
                        license = conn.getInputStream();
                        builder.insertImage(license, 0, 65.0, 0, 11.0, 42.0, 25.0, 3);
                    }
                    if (!builder.moveToMergeField(next)) continue;
                    builder.write(String.valueOf(s));
                }
            }
            docAll.getMailMerge().setFieldMergingCallback((IFieldMergingCallback)new HandleMergeField());
            docAll.getMailMerge().deleteFields();
            String savePath = "/report/";
            String files = new Date().getTime() + RandomStringUtils.random((int)5, (char[])new char[]{'a', 'b', 'c', 'd', 'e', 'f'}) + ".doc";
            String result = savePath + files;
            String path = GlobalResources.COM_IMG_RE + savePath + files;
            fileOS = new FileOutputStream(new File(path));
            docAll.save((OutputStream)fileOS, 20);
            String string = "/getResource?path=" + result;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fileOS != null) {
                    fileOS.close();
                }
                if (license != null) {
                    license.close();
                }
                if (word != null) {
                    word.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public static void doc2pdf(String docRead) {
        String pdfPath = docRead.replace(".doc", ".png");
        String folderPath = "/usr/share/fonts/";
        try (InputStream license = new PathMatchingResourcePatternResolver().getResource("/aspose/license.xml").getInputStream();
             FileOutputStream fileOS = new FileOutputStream(new File(pdfPath));){
            License aposeLic = new License();
            aposeLic.setLicense(license);
            Document doc = new Document(docRead);
            ArrayList fontSources = Lists.newArrayList((Object[])FontSettings.getFontsSources());
            FolderFontSource folderFontSource = new FolderFontSource(folderPath, true);
            fontSources.add(folderFontSource);
            FontSourceBase[] updatedFontSources = new FontSourceBase[fontSources.size()];
            for (int i = 0; i < fontSources.size(); ++i) {
                updatedFontSources[i] = (FontSourceBase)fontSources.get(i);
            }
            FontSettings.setFontsSources((FontSourceBase[])updatedFontSources);
            ImageSaveOptions iso = new ImageSaveOptions(101);
            iso.setResolution(200.0f);
            doc.save((OutputStream)fileOS, (SaveOptions)iso);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class HandleMergeField
    implements IFieldMergingCallback {
        private DocumentBuilder mBuilder;

        private HandleMergeField() {
        }

        public void fieldMerging(FieldMergingArgs e) throws Exception {
        }

        public void imageFieldMerging(ImageFieldMergingArgs e) throws Exception {
            if (this.mBuilder == null) {
                this.mBuilder = new DocumentBuilder(e.getDocument());
            }
            if (e.getFieldValue() instanceof List) {
                this.mBuilder.moveToMergeField(e.getFieldName());
                for (Object o : (List)e.getFieldValue()) {
                    if (o instanceof byte[]) {
                        this.mBuilder.insertImage((byte[])o);
                        this.mBuilder.insertHtml("<br/>");
                        continue;
                    }
                    if (o instanceof String) {
                        this.mBuilder.insertImage((String)o, 60.0, 35.0);
                        continue;
                    }
                    if (!(o instanceof InputStream)) continue;
                    this.mBuilder.insertImage((InputStream)o, 60.0, 35.0);
                    this.mBuilder.insertHtml("<br/>");
                }
            }
        }
    }
}

