/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.dao.order.InsClaimInformationAPIDao;
import com.bcxin.ins.entity.policy_report.InsClaimInformation;
import com.bcxin.ins.service.order.InsClaimInformationAPIService;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.report_pac.InsClaimInformationVo;
import com.bcxin.ins.vo.report_pac.InsCommonReportVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
@Transactional
public class InsClaimInformationAPIServiceImpl
extends ServiceImpl<InsClaimInformationAPIDao, InsClaimInformation>
implements InsClaimInformationAPIService {
    private static Logger log = LoggerFactory.getLogger(InsClaimInformationAPIServiceImpl.class);
    @Autowired
    private InsClaimInformationAPIDao dao;

    @Override
    public void accordingToTheInsCommonReportVoSetUpInsClaimInformation(InsCommonReportVo vo, Long report_id) {
        List hvoList = vo.getClaimInformationVoList();
        if (hvoList == null || hvoList.size() == 0) {
            return;
        }
        ArrayList ahs = Lists.newArrayList();
        ArrayList uhs = Lists.newArrayList();
        try {
            this.delectAllInsClaimInformation(report_id);
            IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
            for (InsClaimInformationVo hvo : hvoList) {
                if (hvo.isNull() || StringUtils.isEmpty((CharSequence)hvo.getFile_key())) continue;
                this.setClaimInformationToList(vo, report_id, ahs, uhs, idWorker, hvo);
            }
            if (ahs.size() > 0) {
                this.dao.batchInsert(ahs);
            }
            if (uhs.size() > 0) {
                this.dao.batchUpdate(uhs);
            }
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            e.printStackTrace();
        }
    }

    private void setClaimInformationToList(InsCommonReportVo vo, Long report_id, List<InsClaimInformation> ahs, List<InsClaimInformation> uhs, IdWorker idWorker, InsClaimInformationVo hvo) {
        if (StringUtils.isNotEmpty((CharSequence)hvo.getIns_claim_information_id())) {
            InsClaimInformation icf = new InsClaimInformation();
            icf.setIns_claim_information_id(Long.valueOf(Long.parseLong(hvo.getIns_claim_information_id())));
            icf.setIns_common_report_id(report_id);
            icf.setCreate_time(new Date());
            try {
                MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)hvo), (Object)icf);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            uhs.add(icf);
        } else {
            InsClaimInformation icf = new InsClaimInformation();
            icf.setIns_claim_information_id(Long.valueOf(idWorker.nextId()));
            try {
                MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)hvo), (Object)icf);
                icf.setIns_common_report_id(report_id);
                icf.setCreate_time(new Date());
                icf.setCreate_by(new SysUser(Long.valueOf(Long.parseLong(vo.getRegister_user_id()))));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ahs.add(icf);
        }
    }

    @Override
    public void getInsCommonReportVoByReportID(InsCommonReportVo vo, Long report_id) {
        List<InsClaimInformationVo> list = this.dao.selectInsClaimInformationVoByReportId(report_id);
        int count = 0;
        if (list != null) {
            count = list.size() < 3 ? list.size() : 100;
        }
        if (count == 100) {
            for (int i = count; i < 3; ++i) {
                list.add(new InsClaimInformationVo());
            }
        }
        vo.setClaimInformationVoList(list);
    }

    @Override
    public boolean delectInsClaimInformationByOid(Long oid) {
        try {
            this.dao.deleteById(oid);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean delectAllInsClaimInformation(Long oid) {
        try {
            HashMap map = Maps.newHashMap();
            map.put("ins_common_report_id", oid);
            map.put("status", "0");
            this.dao.deleteByMap(map);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean updateStatusByReportId(Long report_id) {
        try {
            this.dao.updateStatusByReportId(report_id);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean updateStatusByIds(List<String> ids) {
        try {
            this.dao.updateStatusByIds(ids);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

