/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.util.HttpUtil;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.http.RequestUtil;
import com.bcxin.ins.vo.OrderFormVo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class OrderSupportUtil1 {
    private static final String URL = "http://120.76.218.179:9113/";
    private static final String ORDER_SYNCHRONIZATION = "/api/webOrderForm/receiveOrderFormData";
    private static final String TRAN_SYNCHRONIZATION = "/api/webOrderForm/receiveOrderPaymentData";
    private static final String ORDER_CANCELLATIONS = "/api/webOrderForm/cancellationOrder";

    public static String receiveOrderFormData(OrderFormVo orderVo, InsInsuranceSlip policy, InsTransaction itn) {
        String url = "http://120.76.218.179:9113//api/webOrderForm/receiveOrderFormData";
        HashMap<String, Object> orderMap = new HashMap<String, Object>();
        orderMap.put("sign", "BLB");
        orderMap.put("orderNumber", policy.getTrade_serial_number());
        orderMap.put("sign", "BLB");
        orderMap.put("orderDate", policy.getSigned_date() == null ? "" : DateUtil.convertDateToString((Date)policy.getSigned_date(), (String)"yyyy-MM-dd HH:mm:ss"));
        String paymentMethod = "";
        String stagesNumber = "";
        if (policy.getUnderwrite() != null) {
            paymentMethod = policy.getUnderwrite().getPayment_way();
            stagesNumber = "1".equals(paymentMethod) ? "1" : ("2".equals(paymentMethod) ? "4" : null);
        } else if (itn != null) {
            paymentMethod = itn.getPayment_method();
            stagesNumber = "1".equals(itn.getPayment_method()) ? "1" : ("2".equals(itn.getPayment_method()) ? "4" : null);
        }
        orderMap.put("paymentMethod", paymentMethod);
        orderMap.put("stagesNumber", stagesNumber);
        orderMap.put("currency", "CNY");
        orderMap.put("startDate", DateUtil.convertDateToString((Date)policy.getInception_date(), (String)"yyyy-MM-dd HH:mm:ss"));
        orderMap.put("endDate", DateUtil.convertDateToString((Date)policy.getPlanned_end_date(), (String)"yyyy-MM-dd HH:mm:ss"));
        orderMap.put("invoiceType", policy.getMailPolicy().getInvoice_type());
        orderMap.put("productId", String.valueOf(policy.getPro_primary().getPro_primary_id()));
        orderMap.put("webUserId", String.valueOf(policy.getRegister_user_id()));
        orderMap.put("province", policy.getProvince());
        orderMap.put("city", policy.getCity());
        orderMap.put("district", policy.getArea_code());
        orderMap.put("address", "");
        orderMap.put("distributorId", policy.getRecommend_code());
        orderMap.put("fcy", policy.getPremium());
        orderMap.put("webOrderFormId", orderVo.getOid());
        if (itn != null) {
            orderMap.put("orderPayment.paymentPeriod", "");
            orderMap.put("orderPayment.payDate", DateUtil.convertDateToString((Date)itn.getStart_time(), (String)"yyyy-MM-dd HH:mm:ss"));
            orderMap.put("orderPayment.payCode", itn.getPay_order_number());
            orderMap.put("orderPayment.paySerialNumber", itn.getTrade_serial_number());
            orderMap.put("orderPayment.paymentMethod", itn.getPayment_method());
            orderMap.put("orderPayment.remainingNumber", String.valueOf(policy.getInsTransaction().size()));
            orderMap.put("orderPayment.currentPayable", itn.getPay_amount());
            orderMap.put("orderPayment.actualPayment", itn.getPay_amount());
        } else {
            orderMap.put("orderPayment.paymentPeriod", "");
            orderMap.put("orderPayment.payDate", DateUtil.getCurrentDate());
            orderMap.put("orderPayment.payCode", "0");
            orderMap.put("orderPayment.paySerialNumber", "0");
            orderMap.put("orderPayment.paymentMethod", "");
            orderMap.put("orderPayment.remainingNumber", null);
            orderMap.put("orderPayment.currentPayable", String.valueOf(policy.getPremium().divide(new BigDecimal(stagesNumber))));
            orderMap.put("orderPayment.actualPayment", "0");
        }
        try {
            String result = HttpUtil.doPost((String)url, orderMap);
            JSONObject json = JSON.parseObject((String)result);
            if (json != null && json.get((Object)"success").toString().equals("true")) {
                return json.get((Object)"data").toString();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return "";
    }

    public static boolean receiveTrancetionData(InsInsuranceSlip policy, InsTransaction itn) {
        String url = "http://120.76.218.179:9113//api/webOrderForm/receiveOrderPaymentData";
        HashMap<String, Object> tranMap = new HashMap<String, Object>();
        tranMap.put("paymentPeriod", "");
        tranMap.put("payDate", DateUtil.convertDateToString((Date)itn.getStart_time(), (String)"yyyy-MM-dd HH:mm:ss"));
        tranMap.put("payCode", itn.getPay_order_number());
        tranMap.put("paySerialNumber", itn.getTrade_serial_number());
        tranMap.put("paymentMethod", itn.getPayment_method());
        tranMap.put("remainingNumber", String.valueOf(policy.getInsTransaction().size()));
        tranMap.put("currentPayable", itn.getPay_amount());
        tranMap.put("actualPayment", itn.getPay_amount());
        tranMap.put("orderFormId", policy.getOrder_zc_id());
        try {
            String result = HttpUtil.doPost((String)url, tranMap);
            JSONObject json = JSON.parseObject((String)result);
            if (json != null && json.get((Object)"success").toString().equals("true")) {
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public static boolean cancellationOrder(String tradeSerialNumber) {
        String url = "http://120.76.218.179:9113//api/webOrderForm/cancellationOrder";
        StringBuffer params = new StringBuffer("sign=BLB&webType=BLB");
        if (StringUtils.isNotEmpty((String)tradeSerialNumber)) {
            params.append("&data=" + tradeSerialNumber);
        }
        try {
            String s = RequestUtil.sendPost((String)url, (String)params.toString());
            JSONObject json = JSON.parseObject((String)s);
            if (json != null && json.get((Object)"success").toString().equals("true")) {
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public static HttpServletRequest getRequest() {
        if (RequestContextHolder.getRequestAttributes() != null) {
            return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        }
        return null;
    }

    public static void main(String[] args) {
    }
}

