package com.bcxin.ins.third.gzzrx.zhonghua.security;

import com.bcxin.ins.vo.ConstProp;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Iterator;

/**
 * <b>中华电子发票回调接口报文信息转换辅助表 </b>
 * 
 * @author zxf
 * @date 2017年1月19日 下午2:47:14
 * @注意事项 </b>
 * <b>
 */
public class ZHSendMailInfoVo {

	private static Logger logger = LoggerFactory.getLogger(ZHSendMailInfoVo.class);

	protected Document requestDocument;
	protected Element rootElement;

	private String transrno;//交易码
	private String partnercode;//合作伙伴代码
	private String partnersubcode;//合作伙伴子机构代码
	private String serialnumber;//交易流水号
	private String transdate;//交易时间

	private String fpsqbh;//发票申请编号
	private String fplx;//发票类型
	private String fpzt;//发票状态
	private String kprq;//开票日期
	private String fpdm;//发票代码
	private String fphm;//发票号码
	private String hjje;//合计金额
	private String hjse;//合计税额
	private String kjzt;//开具状态
	private String sbyy;//失败原因

	private String appno;//投保单号
	private String polno;//保单号
	private String einvoicedl;//电子发票地址

	public String getTransrno() {
		return transrno;
	}

	public void setTransrno(String transrno) {
		this.transrno = transrno;
	}

	public String getPartnercode() {
		return partnercode;
	}

	public void setPartnercode(String partnercode) {
		this.partnercode = partnercode;
	}

	public String getPartnersubcode() {
		return partnersubcode;
	}

	public void setPartnersubcode(String partnersubcode) {
		this.partnersubcode = partnersubcode;
	}

	public String getSerialnumber() {
		return serialnumber;
	}

	public void setSerialnumber(String serialnumber) {
		this.serialnumber = serialnumber;
	}

	public String getTransdate() {
		return transdate;
	}

	public void setTransdate(String transdate) {
		this.transdate = transdate;
	}

	public String getFpsqbh() {
		return fpsqbh;
	}

	public void setFpsqbh(String fpsqbh) {
		this.fpsqbh = fpsqbh;
	}

	public String getFplx() {
		return fplx;
	}

	public void setFplx(String fplx) {
		this.fplx = fplx;
	}

	public String getFpzt() {
		return fpzt;
	}

	public void setFpzt(String fpzt) {
		this.fpzt = fpzt;
	}

	public String getKprq() {
		return kprq;
	}

	public void setKprq(String kprq) {
		this.kprq = kprq;
	}

	public String getFpdm() {
		return fpdm;
	}

	public void setFpdm(String fpdm) {
		this.fpdm = fpdm;
	}

	public String getFphm() {
		return fphm;
	}

	public void setFphm(String fphm) {
		this.fphm = fphm;
	}

	public String getHjje() {
		return hjje;
	}

	public void setHjje(String hjje) {
		this.hjje = hjje;
	}

	public String getHjse() {
		return hjse;
	}

	public void setHjse(String hjse) {
		this.hjse = hjse;
	}

	public String getKjzt() {
		return kjzt;
	}

	public void setKjzt(String kjzt) {
		this.kjzt = kjzt;
	}

	public String getSbyy() {
		return sbyy;
	}

	public void setSbyy(String sbyy) {
		this.sbyy = sbyy;
	}

	public String getAppno() {
		return appno;
	}

	public void setAppno(String appno) {
		this.appno = appno;
	}

	public String getPolno() {
		return polno;
	}

	public void setPolno(String polno) {
		this.polno = polno;
	}

	public String getEinvoicedl() {
		return einvoicedl;
	}

	public void setEinvoicedl(String einvoicedl) {
		this.einvoicedl = einvoicedl;
	}

	/**
	 * 对请求的报文解析
	 * @param originalXML
	 */
	public void analysisXML(String originalXML) {
		try {
			requestDocument = DocumentHelper.parseText(originalXML);
			rootElement = requestDocument.getRootElement();
			for(Iterator i = rootElement.elementIterator(); i.hasNext();){
				Element node = (Element) i.next();
				if("HEAD".equals(node.getName())){
					for(Iterator n = node.elementIterator(); n.hasNext();) {
						Element node_n = (Element) n.next();
						if ("TRANSRNO".equals(node_n.getName())) {
							this.setTransrno(node_n.getText());
						}
						if ("PARTNERCODE".equals(node_n.getName())) {
							this.setPartnercode(node_n.getText());
						}
						if ("PARTNERSUBCODE".equals(node_n.getName())) {
							this.setPartnersubcode(node_n.getText());
						}
					}
				}
				if("MAIN".equals(node.getName())){
					for(Iterator n = node.elementIterator(); n.hasNext();){
						Element node_n = (Element) n.next();
						String name = node_n.getName();
						String value = node_n.getText();
						if(StringUtils.isNotEmpty(value)){
							value = value.replace("<![CDATA[",ConstProp.BLANK_CHAR).replace("]]>",ConstProp.BLANK_CHAR);
						}
						if("TRANSRNO".equals(name)){
							this.setTransrno(value);
						}
						if("SERIALNUMBER".equals(name)){
							this.setSerialnumber(value);
						}
						if("TRANSDATE".equals(name)){
							this.setTransdate(value);
						}
						if("POLNO".equals(name)){
							this.setPolno(value);
						}
						if("APPNO".equals(name)){
							this.setAppno(value);
						}
						if("fpsqbh".equals(name)){
							this.setFpsqbh(value);
						}
						if("fplx".equals(name)){
							this.setFplx(value);
						}
						if("fpzt".equals(name)){
							this.setFpzt(value);
						}
						if("kprq".equals(name)){
							this.setKprq(value);
						}
						if("fpdm".equals(name)){
							this.setFpdm(value);
						}
						if("fphm".equals(name)){
							this.setFphm(value);
						}
						if("hjje".equals(name)){
							this.setHjje(value);
						}
						if("hjse".equals(name)){
							this.setHjse(value);
						}
						if("kjzt".equals(name)){
							this.setKjzt(value);
						}
						if("sbyy".equals(name)){
							this.setSbyy(value);
						}
						if("EINVOICEDL".equals(name)){
							this.setEinvoicedl(value);
						}
					}
				}
			}
		}catch (Exception e){
			logger.info("analysisXML:"+e.getMessage());
		}
	}

	/**
	 * <b> 电子发票类型 </b>
	 * @author ZXF
	 * @create 2019/09/29 0029 10:54
	 * @version
	 * @注意事项 </b>
	 */
	public String fplxConvent(String fplx){
		if("004".equals(fplx)){
			return "专票";
		}else if("007".equals(fplx)){
			return "普票";
		}else{
			return "";
		}
	}

	/**
	 * <b> 电子发票状态 </b>
	 * @author ZXF
	 * @create 2019/09/29 0029 10:54
	 * @version
	 * @注意事项 </b>
	 */
	public String fpztConvent(String fpzt){
		if("1".equals(fpzt)){
			return "正常";
		}else if("2".equals(fpzt)){
			return "作废";
		}else if("3".equals(fpzt)){
			return "红冲";
		}else{
			return "";
		}
	}

	/**
	 * <b> 电子发票开具状态 </b>
	 * 1未申请、2待开具、3已开具、4待作废、5已作废、6作废失败、7已红冲、8开票失败 、9 申请已撤回
	 * @author ZXF
	 * @create 2019/09/29 0029 10:54
	 * @version
	 * @注意事项 </b>
	 */
	public String kjztConvent(String kjzt){
		if("1".equals(kjzt)){
			return "未申请";
		}else if("2".equals(kjzt)){
			return "待开具";
		}else if("3".equals(kjzt)){
			return "已开具";
		}else if("4".equals(kjzt)){
			return "待作废";
		}else if("5".equals(kjzt)){
			return "已作废";
		}else if("6".equals(kjzt)){
			return "作废失败";
		}else if("7".equals(kjzt)){
			return "已红冲";
		}else if("8".equals(kjzt)){
			return "开票失败";
		}else if("9".equals(kjzt)){
			return "申请已撤回";
		}else{
			return "";
		}
	}

	/**
	 * <b> 返回接收结果 </b>
	 * @author ZXF
	 * @create 2019/02/22 0022 13:48
	 * @version
	 * @注意事项 </b>
	 */
	public String returnResult(String resultcode, String errinfo){
		String result = "<?xml version=\"1.0\" encoding=\"GBK\"?>\n" +
				"<INSUREQRET>\n" +
				"\t<HEAD>\n" +
				"\t\t<TRANSRNO>1021</TRANSRNO>\n" +
				"\t\t<RESULTCODE>"+resultcode+"</RESULTCODE>\n" +
				"\t\t<ERRINFO>"+errinfo+"</ERRINFO>\n" +
				"\t</HEAD>\n" +
				"</INSUREQRET>";
		return result;
	}

}
