package com.bcxin.ins.third.gzzrx.qianhai.util;

import org.apache.commons.codec.digest.DigestUtils;

import java.io.UnsupportedEncodingException;


/**
 * md5加密工具类
 *
 */
public class Md5Util { 
	/**
	 * 默认按utf-8进行加密
	 * @param data
	 * @return
	 * @throws UnsupportedEncodingException
	 */
    public static String digestByMd5 (String data) throws UnsupportedEncodingException { 
        return DigestUtils.md5Hex(data.getBytes("UTF-8")); 
    } 
    
    /**
     * 盐值加密,统一用UTF-8
     ** @param data
     * @param charset
     * @return
     * @throws UnsupportedEncodingException
     */
    public static String digestByMd5 (String data ,String charset) throws UnsupportedEncodingException {
        data=data+charset;
        return DigestUtils.md5Hex(data.getBytes("UTF-8"));
    } 
    
    /**
     * 使用特定密钥对字符串进行MD5加密
     * @param param 待加密的字串
     * @param md5Key 密钥
     * @return	加密后的字串
     */
    @SuppressWarnings("static-access")
	public static String getMd5Value(String param,String md5Key){
		Md5 md5 = new Md5("");
		byte b[] = null;
		try {
			md5.hmac_Md5(param, md5Key.trim());
			b = md5.getDigest();
		
		} catch (Exception e) {
			e.printStackTrace();
		}
		return md5.stringify(b);
	}
    
    /**  
     * 加盐MD5  
     * @param data  待加密的字串
     * @param salt  盐
     * @return  加密后的字串
     * @throws UnsupportedEncodingException 
     */ 
    public static String generate(String data,String salt) throws UnsupportedEncodingException {         
        return digestByMd5(data + salt);
    }

}

