package com.bcxin.ins.third.gzzrx.changan.ca_enum;

import com.bcxin.mybatisplus.enums.Optimize;

/**
 * <b> 长安出险原因，结合平安页面原因选项匹配 </b>
 * @author ZXF
 * @create 2021/04/08 0008 10:56
 * @version
 * @注意事项 </b>
 */
public enum DamageInfo {

    D_1 ("309", "N0298", "其它人为因素风险"),
    D_2 ("213", "N0092", "其它意外事故"),
    D_3 ("213", "N0101", "其它意外事故"),
    D_4 ("213", "N0127", "其它意外事故"),
    D_5 ("213", "N0211", "其它意外事故"),
    D_6 ("213", "N0227", "其它意外事故"),
    D_7 ("309", "N0250", "其它人为因素风险"),
    D_8 ("213", "N0252", "其它意外事故"),
    D_9 ("213", "N0263", "其它意外事故"),
    D_10 ("309", "N0364", "其它人为因素风险"),
    D_11 ("213", "N0397", "其它意外事故"),
    D_12 ("213", "N0226", "其它意外事故"),
    D_13 ("213", "N0079", "其它意外事故"),
    D_14 ("213", "N0379", "其它意外事故"),
    D_15 ("213", "N0417", "其它意外事故");


    private final String code_ca;
    private final String code_pac;
    private final String name_ca;

    DamageInfo(final String code_ca, final String code_pac, final String name_ca){
        this.code_ca = code_ca;
        this.code_pac = code_pac;
        this.name_ca = name_ca;
    }

    public static DamageInfo getByCodePAC(String code_pac){
        for (DamageInfo damageInfo : DamageInfo.values()) {
            if (damageInfo.getCode_pac().equalsIgnoreCase(code_pac)) {
                return damageInfo;
            }
        }
        return null;
    }

    public String getCode_ca() {
        return code_ca;
    }

    public String getCode_pac() {
        return code_pac;
    }

    public String getName_ca() {
        return name_ca;
    }
}
