package com.bcxin.ins.third.gzx.huatai.util;

import java.util.ArrayList;
import java.util.List;


public enum Policy_ActivityType {

	
	EXHIBITION {public String getValue(){return "ZL";} public String getName(){return "展览展销类";}},
	
	LITERATURE {public String getValue(){return "WY";} public String getName(){return "文艺演出类";} },
	
	SPORTS {public String getValue(){return "TY";} public String getName(){return "体育赛事类";} },
	
	GARDENLANTERN {public String getValue(){return "QT1";} public String getName(){return "其他类活动（游园、灯会、庙会、花会、焰火晚会、人才招聘会、现场开奖的彩票销售等）";} },
	
	OTHER {public String getValue(){return "QT";} public String getName(){return "其他";} };
	
	
    public abstract String getValue();
    
    public abstract String getName();
    
    public static Policy_ActivityType calc(ActivityType type){
    	if ( ActivityType.EXHIBITION.equals(type) ) {
    		return EXHIBITION;
    	} else if ( ActivityType.LITERATURE.equals(type) ) {
    		return LITERATURE;
    	} else if ( ActivityType.SPORT.equals(type) ) {
    		return SPORTS;
    	} else if ( ActivityType.GARDENLANTERN.equals(type) ) {
    		return GARDENLANTERN;
    	}
    	return OTHER;
    }
    
    public static List<Policy_ActivityType> list(){
    	List<Policy_ActivityType> list = new ArrayList<Policy_ActivityType>();
    	list.add(EXHIBITION);
    	list.add(LITERATURE);
    	list.add(SPORTS);
    	list.add(GARDENLANTERN);
    	return list;
    }
    
    public static Policy_ActivityType convert_value(String value){
    	if ( "ZL".equals(value) ) {
    		return EXHIBITION;
    	} else if ( "WY".equals(value) ) {
    		return LITERATURE;
    	} else if ( "TY".equals(value) ) {
    		return SPORTS;
    	} else if ( "QT".equals(value) ) {
    		return GARDENLANTERN;
    	}
    	return OTHER;
    }
}
