package com.bcxin.ins.third.build.dubang;

import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.MD5Util;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.SpecialBidVo;
import com.google.common.collect.Maps;
import org.apache.axis.client.Call;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.xml.namespace.QName;
import java.util.Map;


/**
 *
 * <b>都邦-投标保证保险http接口请求业务</b>
 *
 * @author zxf
 * @date 2017年10月11日 上午10:29:46
 * @注意事项 </b>
 * <b>
 */
@Service("build_DBRequestService")
@Transactional
public class Build_DBRequestService {

	private Logger communicatorLog =  LoggerFactory.getLogger(Build_DBRequestService.class);

	@Autowired
	private PolicyService policyService;

	private static final QName SERVICE_NAME = new QName("http://webservice.web.agent.application.sinosoft.com", "CommServerWebService");
	/**
	 * 都邦接口请求方法
	 * 生产环境：
	 * 出单：59.151.126.64:5555
	 * 支付：ecar.dbic.com.cn
	 * 电子保单：ecar.dbic.com.cn
	 * 报文ip:47.94.176.255
	 * @return
	 */
	public String requestDB(Long order_id, String transType, Map<String,String> map) {
		communicatorLog.info("requestDB-Build：star-----------------------");
		communicatorLog.info("requestDB-Build：接口编码-"+transType+",订单id-"+order_id+",MAP-"+(map != null ? map.toString() : "null"));
		OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(order_id);
		SpecialBidVo vo = policyService.accordingToOrderIDToGetSpecialBidVo(Long.parseLong(dto.getOid()));
		String result = "300#（APP-DB-Build-001）网络不稳定，请重新请求！";
        try {
			Build_PackageMessageDuBang bpmdb = new Build_PackageMessageDuBang();
			String resXml = ConstProp.BLANK_CHAR;
			String httpUrl = getUrlByTransType(transType);
			communicatorLog.info("requestDB-接口transType："+transType+",请求地址："+httpUrl);
			if(ConstProp.DIGIT_ONE.equals(transType)){
				String appsvr = "generatePolicyService";//请求方法
				String returnMarshal = Build_PackageMessageDuBang.marshal(vo,dto);//请求数据
				//数据MD5加密
				String resultMD5 = MD5Util.md5(DBProp.PRIVATEKEY+returnMarshal.trim());
				Object[] objArray = new Object[2];
				objArray[0] = returnMarshal;
				objArray[1] = resultMD5;
				resXml = (String) Build_DBRequestService.call(objArray, appsvr, httpUrl);
				communicatorLog.info("requestDB-transType=1,返回报文："+resXml);
				result = bpmdb.returnAnalysisXML(resXml, transType);
			}else if(ConstProp.DIGIT_TWO.equals(transType)){
				String appsvr = "execute";//请求方法
				String returnMarshal = Build_PackageMessageDuBang.getPayOrder(vo,dto);//请求数据
				Object[] objArray = new Object[5];
				objArray[0] = DBProp.USERCODE;//userCode;
				objArray[1] = DBProp.COMCODE;//comCode;
				objArray[2] = DBProp.SYSTEMCODE;//systemCode;
				objArray[3] = DBProp.PORT_241;
				objArray[4] = returnMarshal;
				resXml = (String) Build_DBRequestService.call(objArray, appsvr, httpUrl);
				communicatorLog.info("requestDB-transType=2,返回报文："+resXml);
				result = bpmdb.returnPayAnalysisXML(resXml, transType);//这个resule得到了支付订单编号用于下一个接口获取支付二维码
				if(ConstProp.CODE_SUCCESS.equals(result.split(ConstProp.POUND_SIGN)[0])){
					Map<String,String> maps = Maps.newHashMap();
					maps.put("ORDERNO",result.split(ConstProp.POUND_SIGN)[1]);
					result = requestDB(order_id, ConstProp.DIGIT_THREE, maps);//调用支付接口一的时候包含支付接口2的获取二维码流(这个result是支付二维码)
				}
			}else if(ConstProp.DIGIT_THREE.equals(transType)){
				String appsvr = "execute";//请求方法
				String returnMarshal = Build_PackageMessageDuBang.getPayQRCode(vo,dto,map);//请求数据
				Object[] objArray = new Object[5];
				objArray[0] = DBProp.USERCODE;//userCode;
				objArray[1] = DBProp.COMCODE;//comCode;
				objArray[2] = DBProp.SYSTEMCODE;//systemCode;
				objArray[3] = DBProp.PORT_243;
				objArray[4] = returnMarshal;
				resXml = (String) Build_DBRequestService.call(objArray, appsvr, httpUrl);
				communicatorLog.info("requestDB-transType=3,返回报文："+resXml);
				result = bpmdb.returnPayAnalysisXML(resXml, transType);
			}else if(ConstProp.DIGIT_FOUR.equals(transType)){//获取电子保单下载地址
				String sign= MD5Util.md5(DBProp.PRIVATEKEY+dto.getExternal_reference());//加密
				String uploadPath = GlobalResources.DB_DOW_URL+"/servlet/ElectricPolicyServiceServlet?policyNo="+dto.getExternal_reference()+"&md5="+sign;//请求方法
				result = "200#"+uploadPath;
			}
		}catch (Exception ex){
			communicatorLog.info("requestDB-Build：ERROR："+ex);
			ex.printStackTrace();
		}
        communicatorLog.info("requestDB-Build：end-----------------------");
		return result;
	}

	public static Object call(Object[] parameters, String methodName, String address) {
		org.apache.axis.client.Service service = null;
		Call call = null;
		Object returnObj = new Object();
		try
		{
			service = new org.apache.axis.client.Service();
			call = (Call) service.createCall();
			call.setTargetEndpointAddress(address);
			call.setOperationName(methodName);

			// 调用外部服务器
			returnObj = call.invoke(parameters);
		}
		catch (Exception e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return returnObj;

	}

	private String getUrlByTransType(String transType){
		if(ConstProp.DIGIT_ONE.equals(transType)){
			return GlobalResources.DB_INS_URL+"/eies/CommServerWebService.ws";
		}else if(ConstProp.DIGIT_TWO.equals(transType)){
			return GlobalResources.DB_PAY_URL+"/services/ECarCommonService";
		}else if(ConstProp.DIGIT_THREE.equals(transType)){
			return GlobalResources.DB_PAY_URL+"/services/ECarCommonService";
		}
		return "";
	}

}
