package com.bcxin.ins.service.product.impl;

import com.bcxin.ins.dao.product.ProExpCustomsCompaniesAPIDao;
import com.bcxin.ins.service.product.ProExpCustomsCompaniesAPIService;
import com.bcxin.ins.entity.product_core.ProExpCustomsCompanies;
import com.bcxin.ins.vo.ProExpCustomsCompaniesVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
@Transactional
public class ProExpCustomsCompaniesAPIServiceImpl  extends ServiceImpl<ProExpCustomsCompaniesAPIDao,ProExpCustomsCompanies> implements ProExpCustomsCompaniesAPIService {

	@Autowired
	private ProExpCustomsCompaniesAPIDao dao;

	private Logger log =  LoggerFactory.getLogger(ProExpCustomsCompaniesAPIServiceImpl.class);

	@Override
	public ProExpCustomsCompaniesVo findIdentity(ProExpCustomsCompaniesVo vo) {
		ProExpCustomsCompaniesVo bd = null;
		int i = 0;
		if(vo != null){
			if(StringUtils.isEmpty(vo.getCompany_name())) {
				i++;
			}
			if(StringUtils.isEmpty(vo.getCustoms_code())) {
				i++;
			}
		}else{
			i++;
		}
		if(i == 0){
			List<ProExpCustomsCompaniesVo> list = dao.findIdentity(vo.getCustoms_code(), vo.getCompany_name());
			if(list.size()>0){
				bd = list.get(0);
			}
		}
		return bd;
	}
}
