package com.bcxin.ins.service.preservation;


import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.dto.Result;
import com.bcxin.ins.entity.policy_core.InsPreservationPay;
import com.bcxin.ins.entity.policy_core.InsPreservationRecord;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.InsPreservationPayVo;
import com.bcxin.mybatisplus.service.IService;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.List;
import java.util.Map;

public interface InsPreservationPayAPIService extends IService<InsPreservationPay> {

    public List<InsPreservationPay> findInsPreservationPayByKeyword(DwzPage page, Long userId, String pay_status, String start_time, String end_time, String keyword);

    public List<InsPreservationPayVo> findInsPreservationPayVoByKeyword(DwzPage page, Long userId, String pay_status, String start_time, String end_time, String keyword);

    public List<InsPreservationPay> findInsPreservationBillByKeyword(DwzPage page, Long userId, String pay_status, String start_time, String end_time, String keyword);

    public List<InsPreservationPayVo> findInsPreservationBillVoByKeyword(DwzPage page, Long userId, String pay_status, String start_time, String end_time, String keyword);
    public List<InsPreservationPayVo> findInsPreservationSettlementVoByKeyword(DwzPage page, Long userId, String start_time, String end_time, String keyword);
    public void downBillPay(Long userId, String pay_status, String start_time, String end_time, String keyword, HttpServletResponse response);
    public void downSettlementPay(Long userId, String start_time, String end_time, String keyword, HttpServletResponse response);
    public void downChildBillPay(Long userId, Long parentPayId, String pay_status, String start_time, String end_time, String keyword, HttpServletResponse response);
    public void downChildSettlementBillPay(Long userId, Long parentPayId, String start_time, String end_time, String keyword, HttpServletResponse response);

    List<InsPreservationPayVo> findInsPreservationChildBillVoByKeyword(DwzPage page, Long userId, Long parentPayId, String pay_status, String start_time, String end_time, String keyword);
    List<InsPreservationPayVo> findInsPreservationChildSettlementVoByKeyword(DwzPage page, Long userId, Long parentPayId, String start_time, String end_time, String keyword);

    /**
     * <b>根据页面勾选条目生成部分账单 </b>
     * @param isSummaryBill 是否为汇总账单
     * @param payIds 勾选数据列的id集合
     * @author ZXF
     * @create 2024/04/26 0026 11:07
     * @version
     * @注意事项 </b>
     */
    JSONObject createPartBill(String isSummaryBill, String[] payIds);
    JSONObject createPartBillByNo(String isSummaryBill, String[] payNos);
    public InsPreservationPayVo findIPPayVoById(Long oid);

    public InsPreservationPayVo findInsPreservationPayVoById(Long oid);

    public String uploadFile(MultipartFile roleFile, String savePath);

    public boolean savePayPath(Long oid, String path);

    public void findInsPreservationPayByPaymentType(String paymentType);

    /**
     * <b> 每月汇总分组账单，并对归属账单做标记（设置上级账单） </b>
     * @author ZXF
     * @create 2024/04/23 0023 15:10
     * @version
     * @注意事项 </b>
     */
    void createInsPreservationBillByThisMonth(String lastMonth);

    void createInsPreservationPayByThisMonth(String policyNo, Date star, Date end);

    public boolean setIPPay(InsPreservationRecord record, Map<String,String> map);

    public boolean updatePayStatusBySerialNum(String serial_num);

    public Result getFP(Long oid);

    public boolean getFPTask(Long oid);
}
