package com.bcxin.ins.service.order.impl;


import com.bcxin.ins.dao.order.SpecialExhibitionAPIDao;
import com.bcxin.ins.service.order.SpecialExhibitionAPIService;
import com.bcxin.ins.entity.policy_special.SpecialExhibition;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.SpecialExhibitionVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


/**
 * <b>展责险特殊字段业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class SpecialExhibitionAPIServiceImpl extends ServiceImpl<SpecialExhibitionAPIDao, SpecialExhibition> implements SpecialExhibitionAPIService {

	@Autowired
	private SpecialExhibitionAPIDao dao;

	@Override
	public SpecialExhibition initSpecialExhibition(){
		SpecialExhibition specialExhibition = new SpecialExhibition();//
		dao.insert(specialExhibition);
		return specialExhibition;
	}

	/**
	 * <b>根据Vo及展责ID更新SpecialExhibition数据 </b>
	 *
	 * @param vo
	 * @param seID 展责险id
	 * @author ZXF
	 * @date 2017年9月12日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToTheSpecialExhibitionVoSetUpSpecialExhibition(SpecialExhibitionVo vo, Long seID){
		SpecialExhibition specialExhibition = dao.selectById(seID);
		try {
			if(StringUtils.isEmpty(vo.getBuild_com_name())){
				vo.setBuild_com_name(" ");
			}
			if(StringUtils.isEmpty(vo.getSubcontracting_units())){
				vo.setSubcontracting_units(" ");
			}
			if(StringUtils.isEmpty(vo.getExhibitor_name())){
				vo.setExhibitor_name(" ");
			}
			if(StringUtils.isEmpty(vo.getExhibitor_type())){
				vo.setExhibitor_type(" ");
			}
			if(StringUtils.isEmpty(vo.getExhibitor_code())){
				vo.setExhibitor_code(" ");
			}
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), specialExhibition);
			specialExhibition.setEnd_time(DateUtil.convertStringToDate(vo.getEnd_time()));
		} catch (Exception e) {
			e.printStackTrace();
		}
		dao.updateById(specialExhibition);
	}

	/**
	 * <b>获取SpecialExhibitionVo根据展责险id查询展责险信息插入到SpecialExhibitionVo </b>
	 *
	 * @param vo 展责险辅助表
	 * @param seID 展责险id
	 * @author ZXF
	 * @date 2017年9月12日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void getSpecialExhibitionVoByPolicyID(SpecialExhibitionVo vo, Long seID){
		SpecialExhibition specialExhibition = dao.selectById(seID);
		if(specialExhibition == null){
			return;
		}
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(specialExhibition), vo);
			if(specialExhibition.getStar_time() != null){
				vo.setStar_time(DateUtil.convertDateToString(specialExhibition.getStar_time(),DateUtil.FORMAT2));
			}
			if(specialExhibition.getEnd_time() != null){
				vo.setEnd_time(DateUtil.convertDateToString(specialExhibition.getEnd_time(),DateUtil.FORMAT2));
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * <b>获取SpecialExhibitionVo根据展责险id查询展责险信息插入到SpecialExhibitionVo </b>
	 *
	 * @param vo 展责险辅助表
	 * @param seID 展责险id
	 * @author ZXF
	 * @date 2017年9月12日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void getSpecialExhibitionVoByPolicyID2(SpecialExhibitionVo vo, Long seID){
		SpecialExhibition specialExhibition = dao.selectById(seID);
		if(specialExhibition == null){
			return;
		}
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(specialExhibition), vo);
			if(specialExhibition.getStar_time() != null){
				vo.setStar_time(DateUtil.convertDateToString(specialExhibition.getStar_time(),DateUtil.FORMAT2));
			}
			if(specialExhibition.getEnd_time() != null){
				vo.setEnd_time(DateUtil.convertDateToString(specialExhibition.getEnd_time(),DateUtil.FORMAT2));
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
