package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.ShipInvoicesAPIDao;
import com.bcxin.ins.service.order.ShipInvoicesAPIService;
import com.bcxin.ins.entity.policy_core.InsShipInvoices;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


/**
 * 发票Service
 * @author liumd
 * @date 2016年12月30日
 */
@Service
@Transactional
public class ShipInvoicesAPIServiceImpl extends ServiceImpl<ShipInvoicesAPIDao, InsShipInvoices> implements ShipInvoicesAPIService {

	@Autowired
	private ShipInvoicesAPIDao shipInvoicesDao;

	@Override
	public InsShipInvoices getShipInvoicesById(Long id) {
		List<InsShipInvoices> lis = shipInvoicesDao.getShipInvoicesById(id);
		return lis.size() > 0 ? lis.get(0) : null;
	}

	@Override
	public List<InsShipInvoices> getShipInvoicesByShipDeclareId(Long shipDeclareId) {
		List<InsShipInvoices> lis = shipInvoicesDao.getShipInvoicesByShipDeclareId(shipDeclareId);
		return lis.size() > 0 ? lis : null;
	}

	@Override
	public List<InsShipInvoices> getShipInvoicesByShipExpireId(Long shipExpireId) {
		List<InsShipInvoices> lis = shipInvoicesDao.getShipInvoicesByShipExpireId(shipExpireId);
		return lis.size() > 0 ? lis : null;
	}


}
