package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.InsMailPolicyAPIDao;
import com.bcxin.ins.service.order.InsMailPolicyAPIService;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsMailPolicy;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.MailPolicyVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


@Service
@Transactional
public class InsMailPolicyAPIServiceImpl extends ServiceImpl<InsMailPolicyAPIDao, InsMailPolicy> implements InsMailPolicyAPIService {

	@Autowired
	private InsMailPolicyAPIDao dao;

	@Override
	public InsMailPolicy initInsMailPolicy() {
		InsMailPolicy insMailPolicy = new InsMailPolicy();
		dao.insert(insMailPolicy);
		return insMailPolicy;
	}

	/**
	 * <b>根据Vo及保单配送表ID更新InsMailPolicy数据 </b>
	 *
	 * @param vo
	 * @param insMailPolicyID 保单配送表id
	 * @author ZXF
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToTheMailPolicyVoSetUpInsMailPolicy(MailPolicyVo vo, Long insMailPolicyID){
		InsMailPolicy insMailPolicy = dao.selectById(insMailPolicyID);
		try {
			String result = ConstProp.BLANK_CHAR;
			for(String str : vo.getTaxpayer_number_invoice().split(",")){
				if(StringUtils.isNotBlank(str)){
					result = str;
					break;
				}
			}
			vo.setTaxpayer_number_invoice(result);
			MyConverUtil.map2PoToString(MyConverUtil.PO2Map(vo), insMailPolicy);
		} catch (Exception e) {
			e.printStackTrace();
		}
		insMailPolicy.setNeed_insur_bill(StringUtils.isEmpty(vo.getNeed_insur_bill())? 0 : Integer.parseInt(vo.getNeed_insur_bill()));
		insMailPolicy.setNeed_receipt(StringUtils.isEmpty(vo.getNeed_receipt())? 0 : Integer.parseInt(vo.getNeed_receipt()));
		insMailPolicy.setIs_send_einvoice(StringUtils.isEmpty(vo.getIs_send_einvoice())? 0 : Integer.parseInt(vo.getIs_send_einvoice()));
		insMailPolicy.setTax_cert(vo.getTax_cert());
		insMailPolicy.setTax_prove(vo.getTax_prove());
		insMailPolicy.setBank_licence(vo.getBank_licence());
		insMailPolicy.setBusiness_license(vo.getBusiness_license());
		insMailPolicy.setAuth_cert(vo.getAuth_cert());
		dao.updateByIdForManual(insMailPolicy);
	}

	/**
	 * <b>根据保单配送表信息转换成 MailPolicyVo </b>
	 *
	 * @param insMailPolicy
	 * @param vo
	 * @return
	 * @author ZXF
	 * @date 2017年1月8日 下午3:10:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToInsMailPolicyIntoMailPolicyVo(MailPolicyVo vo, InsMailPolicy insMailPolicy){
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insMailPolicy), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * <b>通过InsInsuranceSlipg获取InsMailPolicy设置到InsInsuranceSlipg </b>
	 * through the InsInsuranceSlipg for InsMailPolicy set up InsInsuranceSlipg
	 * @param iis
	 * @return
	 * @author ZXF
	 * @date 2017年1月7日 上午11:01:19
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void throughTheInsInsuranceSlipForInsMailPolicySetUpInsInsuranceSlip(InsInsuranceSlip iis){
		if(iis.getMailPolicy() != null){
			iis.setMailPolicy(dao.selectById(iis.getMailPolicy().getIns_mail_policy_id()));
		}
	}


	@Override
	public void dbSave(InsMailPolicy insMailPolicy){
		dao.insert(insMailPolicy);
	}

	/**
	 * <b> 根据保单号设置电子发票地址 </b>
	 * @author ZXF
	 * @create 2019/09/29 0029 14:34
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void updateUrlByExternalreference(String url, String externalreference){
		dao.updateUrlByExternalreference(url, externalreference);
	}

	/**
	 * <b> 根据订单id查询发票信息 </b>
	 * @author ZXF
	 * @create 2019/12/16 0016 16:09
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public InsMailPolicy getInsMailPolicyByOrderId(Long order_id){
		return dao.getInsMailPolicyByOrderId(order_id);
	}
}
