package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.InsArDebtorsAPIDao;
import com.bcxin.ins.service.order.InsArDebtorsAPIService;
import com.bcxin.ins.entity.policy_special.SpecialCreditSt;
import com.bcxin.ins.entity.policy_special.StArDebtors;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.ArDebtorsVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;


@Service
@Transactional
public class InsArDebtorsAPIServiceImpl extends ServiceImpl<InsArDebtorsAPIDao, StArDebtors> implements InsArDebtorsAPIService {

	@Autowired
	private InsArDebtorsAPIDao dao;

	/**
	 * <b>根据短期特殊字段表id查询应收账款余额分布列表 </b>
	 *
	 * @param oid
	 * @return
	 * @author ZXF
	 * @date 2017年1月6日 下午1:41:34
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<StArDebtors> selectInsArDebtorsByInsCommonExport(Long oid) {
		return dao.selectInsArDebtorsByInsCommonExport(oid);
	}

	/**
	 * <b>根据Vo及短期出口ID更新InsArDebtors数据 </b>
	 *
	 * @param vo
	 * @param common_export_id 短期出口特殊字段表id
	 * @author ZXF
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToTheArDebtorsVoSetUpInsArDebtors(ArDebtorsVo vo, Long common_export_id){
		StArDebtors insArDebtors = null;
		if(StrUtil.isNotBlank(vo.getOid())){
			insArDebtors = dao.selectById(Long.parseLong(vo.getOid()));
		}else{
			insArDebtors = new StArDebtors();
			SpecialCreditSt specialCreditSt = new SpecialCreditSt();
			insArDebtors.setSpecial_credit_st(specialCreditSt);
			insArDebtors.getSpecial_credit_st().setSpecial_credit_st_id(common_export_id);
			dao.insert(insArDebtors);
		}
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insArDebtors);
		} catch (Exception e) {
			e.printStackTrace();
		}
		dao.updateById(insArDebtors);
	}

	/**
	 * <b>接收页面传回的应收账款余额分布信息列表进行更新 </b>
	 *
	 * @param voList 应收账款余额分布信息列表
	 * @param common_export_id 企业短期id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void setArDebtorsByArDebtorsVo(List<ArDebtorsVo> voList, Long common_export_id){
		if(voList != null && voList.size()>0){
			for(ArDebtorsVo vo : voList){
				accordingToTheArDebtorsVoSetUpInsArDebtors(vo,common_export_id);
			}
		}
	}

	/**
	 * <b>根据企业短期id查询应收账款余额分布信息列表插入到ArDebtorsVo集合 </b>
	 *
	 * @param common_export_id 企业短期id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<ArDebtorsVo> getArDebtorsVoListByCommon_export_id(Long common_export_id){
		List<ArDebtorsVo> voList = new ArrayList<ArDebtorsVo>();
		List<StArDebtors> iadList = selectInsArDebtorsByInsCommonExport(common_export_id);
		if(iadList != null && iadList.size()>0){
			for(StArDebtors iad : iadList){
				voList.add(accordingToInsArDebtorsIntoArDebtorsVo(iad));
			}
		}
		return voList;
	}

	/**
	 * <b>根据应收账款余额分布表信息转换成 ArDebtorsVo</b>
	 *
	 * @param iad 应收账款余额分布表
	 * @return
	 * @author ZXF
	 * @date 2017年1月8日 下午2:22:26
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public ArDebtorsVo accordingToInsArDebtorsIntoArDebtorsVo(StArDebtors iad){
		ArDebtorsVo vo = new ArDebtorsVo();
		if(iad == null){
			return vo;
		}
		vo.setOid(String.valueOf(iad.getSt_ar_debtors_id()));
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(iad), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return vo;
	}
}
