package com.bcxin.ins.service.order.impl;


import com.bcxin.ins.dao.order.HirelingAPIDao;
import com.bcxin.ins.service.order.HirelingAPIService;
import com.bcxin.ins.entity.policy_special.Hireling;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.HirelingVo;
import com.bcxin.ins.vo.SpecialHirelingVo;
import com.bcxin.ins.vo.excel.ResultSetExcelVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.util.List;
import java.util.Map;


/**
 * <b>雇主责任险雇员特殊字段业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class HirelingAPIServiceImpl extends ServiceImpl<HirelingAPIDao, Hireling> implements HirelingAPIService {

	@Autowired
	private HirelingAPIDao dao;

	/**
	 * <b>根据Vo及订单ID更新Hireling数据 </b>
	 *
	 * @param vo
	 * @param order_id 订单id
	 * @author ZXF
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToTheHirelingVoSetUpHireling(SpecialHirelingVo vo, Long order_id) {
		List<HirelingVo> hvoList = vo.getHirelingVoList();
		Hireling hireling = null;
		List<Hireling> ahs = Lists.newArrayList();//新增
		List<Hireling> uhs = Lists.newArrayList();//修改
		try{
			IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
			for(HirelingVo hvo : hvoList){
				if(hvo.isNull()){
					continue;
				}
				if(StringUtils.isNotEmpty(hvo.getOid())){
					hireling = new Hireling();
					hireling.setHireling_id(Long.parseLong(hvo.getOid()));
					hireling.setIns_insurance_slip_id(order_id);
					try {
						MyConverUtil.map2PO(MyConverUtil.PO2Map(hvo), hireling);
					} catch (Exception e) {
						e.printStackTrace();
					}
					uhs.add(hireling);
				}else{
					hireling = new Hireling();

					hireling.setHireling_id(idWorker.nextId());
					try {
						MyConverUtil.map2PO(MyConverUtil.PO2Map(hvo), hireling);
						hireling.setIns_insurance_slip_id(order_id);
					} catch (Exception e) {
						e.printStackTrace();
					}
					ahs.add(hireling);
				}
			}
			if(ahs.size()>0){
				dao.batchInsert(ahs);
			}
			if(uhs.size()>0){
				dao.batchUpdate(uhs);
			}
		}catch (Exception e){
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			e.printStackTrace();
		}

	}

	/**
	 * <b>获取SpecialHirelingVo根据订单id查询雇员信息信息插入到SpecialHirelingVo </b>
	 *
	 * @param vo 雇主责任险雇员辅助表
	 * @param order_id 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void getSpecialHirelingVoByOrderID(SpecialHirelingVo vo, Long order_id){
		List<HirelingVo> list = dao.selectHirelingVoByOrderId(order_id);
		int count = 0;
		if(list != null){
			if(list.size()<3){
				count = list.size();
			}else{
				count = 100;
			}
		}
		if(count == 100){
			for(int i = count;i<3;i++){
				list.add(new HirelingVo());
			}
		}
		vo.setHirelingVoList(list);
	}

	/**
	 * 根据id删除雇员
	 * @param oid 雇员id
	 * @return
	 */
	@Override
	public boolean delectHirelingByOid(Long oid){
		try {
			dao.deleteById(oid);
			return true;
		}catch (Exception e){
			return false;
		}
	}

	/**
	 * 根据id删除订单下所有雇员
	 * @param oid 订单id
	 * @return
	 */
	@Override
	public boolean delectAllHireling(Long oid){
		try {
			Map<String, Object> map = Maps.newHashMap();
			map.put("ins_insurance_slip_id",oid);
			dao.deleteByMap(map);
			return true;
		}catch (Exception e){
			return false;
		}
	}

	/**
	 * <b> 根据订单id查询雇主保障人员列表，用ResultSetExcelVo对象接收 </b>
	 * @author ZXF
	 * @create 2019/11/07 0007 14:50
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public List<ResultSetExcelVo> selectHirelingListByOrderID(Long order_id){
		return dao.selectHirelingListByOrderID(order_id);
	}
}
