package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.ComBlogrollAPIDao;
import com.bcxin.ins.service.order.ComBlogrollAPIService;
import com.bcxin.ins.entity.common.ComBlogroll;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


@Service
@Transactional(readOnly = true)
public class ComBlogrollAPIServiceImpl extends ServiceImpl<ComBlogrollAPIDao, ComBlogroll> implements ComBlogrollAPIService {


	@Autowired
	private ComBlogrollAPIDao dao;

	@Override
	public List<ComBlogroll> findComBlogrollList(ComBlogroll blogroll, DwzPage page){
		String ae = "";
		if(blogroll != null){
			if("Y".equals(blogroll.getActive())){
				ae = "Y";
			}
		}
		Page<ComBlogroll> pageHelper = new Page<ComBlogroll>(page.getPageNum(), page.getNumPerPage());
		List<ComBlogroll> list = dao.findComBlogrollList(pageHelper,blogroll.getTcp_name(),ae);
		page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
		return list;
	}

}
