package com.bcxin.ins.service.order;


import com.bcxin.ins.dto.Result;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.vo.*;
import com.bcxin.ins.vo.shop.ImportInsuranceOrderRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.List;
import java.util.Map;


public interface PolicyService {

    public String getRecommendCodeByCookie(HttpServletRequest request);

    public Map<String, Object> createOrderFormByProductOid(Long product_id, Long user_id, String recommendCode,String trade_serial_number);

    public Map<String, Object> obtainMicroExportVoSetUp(MicroExportVo vo);

    public ResultDto pendingMicroExportPolicy(MicroExportVo vo, String recommendCode);

    public String getTPUserIDByOrderID(Long order_id);

    public OrderFormVo accordingToOrderIDToGetPolicyDto(Long order_id);

    public AdviceNoteVo accordingToOrderIDToGetAdviceNoteVo(Long order_id);

    public MicroExportVo accordingToOrderIDToGetMicroExportVo(Long order_id);

    public String updateOrderFormStatus(OrderFormVo vo);

    public ResultDto updateOrderFormStatusByRequest(HttpServletRequest request);

    /**
     * <b> 判断是否发送纸质保单、纸质发票的邮件通知 </b>
     * @author ZXF
     * @create 2019/12/16 0016 15:55
     * @version
     * @注意事项 </b>
     */
    public void sendZZPolicyEmail(String order_id);

    /**
     * <b> 客户下单到已核保、待支付、承保后支付状态时邮件通知客服人员 </b>
     * @author ZXF
     * @create 2019/12/16 0016 15:55
     * @version
     * @注意事项 </b>
     */
    public void sendInsureEmail(String order_id);

    public Map<String, String> findTotalPolicyNum(InsOrderSearchVo searchVo);

    /**
     * <b>有效保全单同步到支撑</b>
     *
     * @param record_id 保全单id
     * @author ZXF
     * @date 2017年7月5日 上午11:03:32
     * @注意事项 </b>
     * <b>
     */
    public boolean recordSyncZC(String record_id);

    public Map<String, Object> obtainCommonExportVo_1VoSetUp(CommonExportVo_1 vo);

    public ResultDto pendingCommonExportVo_1Policy(CommonExportVo_1 vo, String recommendCode);

    public Map<String, Object> obtainCommonExportVo_2VoSetUp(CommonExportVo_2 vo);

    public ResultDto pendingCommonExportVo_2Policy(CommonExportVo_2 vo);

    public Map<String, Object> obtainCommonExportVo_3VoSetUp(CommonExportVo_3 vo);

    public ResultDto pendingCommonExportVo_3Policy(CommonExportVo_3 vo);

    public CommonExportVo_1 accordingToOrderIDToGetCommonExportVo_1(Long order_id);

    public CommonExportVo_2 accordingToOrderIDToGetCommonExportVo_2(Long order_id);

    public CommonExportVo_3 accordingToOrderIDToGetCommonExportVo_3(Long order_id);

    public String uploadPayMentFileToTranction(String path_url, String order_id, String path_sign, String payAmount);

    public String accordingToOrderIDGainPathSign(Long order_id);

    public UnderwriteVo accordingToOrderIDGainInsUnderwrite(Long order_id);

    /**  -------------------------------- */

    public List<OrderFormVo> findPolicyForPage(InsOrderSearchVo search);

    public OrderFormVo findPolicyByExternalAndRoleName(String externalRefernce, String roleName);

    public boolean deleteRoleInPolicyByOid(String role_id);

    public boolean delectAllInsRole(String order_id);

    public boolean deleteHirelingByOid(String role_id);

    public boolean delectAllHireling(String order_id);

    public List<RoleSubjectVo> getComAndEmpByUserID_BBDAPI( String user_id, String sign);

    public List<RoleSubjectVo> getComAndEmpByUserID_API( String user_id, String sign);

    public List<RoleSubjectVo> getComAndEmpByCacheId_API( String cacheId, String sign);

    public List<InsPreservationResultSetVo> getPersonByUserID_BBDAPI( String user_id,String webType, String sign);

    public boolean saveOrderInfo(String order_id);

    public boolean saveOrderInfoPush(String order_id);

    public Result pushRepairOrderInfo(String order_id);

    /**
     * <b> 在保人员信息推送第三方线下保单（被标识为百联保购买的保单）关联 </b>
     * @author ZXF
     * @create 2019/05/28 0028 9:36
     * @version
     * @注意事项 </b>
     */
    public boolean pushOfflineOrderPerson(String order_id);

    public boolean savePolicyUrlPush(String order_id);

    /**
     * <b>请求第三方废弃保单</b>
     *
     * @param order_id 订单id
     * @author ZXF
     * @create 2019/05/10 0010 14:34
     * @version
     * @注意事项 </b>
     */
    public boolean deletePolicyPush(String order_id);

    public List<InsPreservationDetailVo> getPreservationDetailVoByApi( String cacheId, String sign);

    public boolean pushRecordInfo(String record_id);

    public boolean pushBackOrderID(String order_id);

    public boolean pushOrderToPSS(String order_id);

    public boolean pushZZXOrderToYWZC(String order_id);

    public List<BLBCommunicationDto> getBLBCommunicationDtoByUserID_PSSAPI( String user_id, String activity_type, String sign, String exclude_id);

    public BLBCommunicationDto getBLBCommunicationDtoByOrderID_PSSAPI( String order_id, String sign);

    public List<RoleSubjectVo> getRoleSubjectVoByUserID_PSSAPI( String user_id, String sign);

    public OrderFormVo getPolicyDtoByRcptNo(String rcptno);

    public void findPolicyListByLapsed() throws ParseException;

    public void policyPayment_bd_cpic(String policyId, String payType,String userId, HttpServletResponse response);

    public ResultDto uploadPayMentFile_com(String paymentPath, String oid);

    /**
     * 对接平安财-展责险，调编号2承保接口，记录承保信息（HTTP:以此开头为向第三方接口发起httpClient;PAC:平安财;ZZX:展责险;CB:承保）
     * @param oid 订单id
     * @throws Exception
     */
    public boolean HTTP_PAC_ZZX_CB(Long oid, Map<String,String> map);

    /**
     * 对接平安财-展责险，支付信息保存
     * @param map
     * @return
     */
    public boolean  PAC_ZZX_SAVE_PAY_MSG(Map<String,String> map);

    /**
     * 对接平安财-展责险，请求电子保单下载
     * @param oid
     */
    public String HTTP_PAC_ZZX_DZBD(Long oid);

    /**
     * 对接平安财-公责险，调编号2承保接口，记录承保信息（HTTP:以此开头为向第三方接口发起httpClient;PAC:平安财;GZX:公责险;CB:承保）
     * @param oid 订单id
     * @throws Exception
     */
    public boolean HTTP_PAC_GZX_CB(Long oid, Map<String,String> map);

    /**
     * 对接平安财-公责险，支付信息保存
     * @param map
     * @return
     */
    public boolean  PAC_GZX_SAVE_PAY_MSG(Map<String,String> map);

    /**
     * 对接平安财-公责险，请求电子保单下载
     * @param oid
     * @param map
     * @param ofVo
     */
    public void HTTP_PAC_GZX_DZBD(Long oid, Map<String,String> map, OrderFormVo ofVo);

    /**
     * 平安财-团意险-承保接口
     * @param oid
     * @param map
     * @return
     */
    public boolean HTTP_PAC_TYX_CB(Long oid, Map<String,String> map);

    /**
     * 平安财-雇主责任险-承保接口
     * @param oid
     * @param policyNo
     * @return
     */
    public boolean HTTP_PAC_GZZRX_CB(Long oid, String policyNo);

    /**
     * 平安财-雇主责任险线上-承保接口
     * @param oid
     * @param map
     * @return
     */
    public boolean HTTP_PAC_GZZRX_XS_CB(Long oid, Map<String,String> map);

    /**
     * 平安财-雇主责任险-电子保单接口
     * @return
     */
    public void HTTP_PAC_GZZRX_DZBD(OrderFormVo dto);

    /**
     * 长安-雇主责任险-承保接口
     * @param oid
     * @return
     */
    public boolean HTTP_CA_GZZRX_CB(Long oid);
    public boolean  BU_HTTP_CA_GZZRX_CB(Long oid,String policyNo,String eUrl);

    /**
     * 长安-雇主责任险-支付信息保存
     * @param map
     * @return
     */
    public boolean  CA_GZZRX_SAVE_PAY_MSG(Map<String,String> map);
    public boolean  BU_CA_GZZRX_SAVE_PAY_MSG(Map<String,String> map);

    /**
     * 长安-团意险-承保接口
     * @param oid
     * @return
     */
    public boolean HTTP_CA_TYX_CB(Long oid);
    public boolean  BU_HTTP_CA_TYX_CB(Long oid,String policyNo,String eUrl);

    /**
     * 长安-团意险-支付信息保存
     * @param map
     * @return
     */
    public boolean  CA_TYX_SAVE_PAY_MSG(Map<String,String> map);
    public boolean  BU_CA_TYX_SAVE_PAY_MSG(Map<String,String> map);


    /**
     * 长安-团意险-承保接口
     * @param oid
     * @return
     */
    public boolean HTTP_CA_GYX_CB(Long oid);
    public boolean  BU_HTTP_CA_GYX_CB(Long oid,String policyNo,String eUrl);

    /**
     * 长安-个人意外险-支付信息保存
     * @param map
     * @return
     */
    public boolean  CA_GYX_SAVE_PAY_MSG(Map<String,String> map);
    public boolean  BU_CA_GYX_SAVE_PAY_MSG(Map<String,String> map);


    /**
     * 长安-公众责任险-承保接口
     * @param oid
     * @return
     */
    public boolean HTTP_CA_GZX_CB(Long oid);
    public boolean  BU_HTTP_CA_GZX_CB(Long oid,String policyNo,String eUrl);

    /**
     * 长安-公众责任险-支付信息保存
     * @param map
     * @return
     */
    public boolean  CA_GZX_SAVE_PAY_MSG(Map<String,String> map);
    public boolean  BU_CA_GZX_SAVE_PAY_MSG(Map<String,String> map);


    /**
     * 长安-展会责任险-承保接口
     * @param oid
     * @return
     */
    public boolean HTTP_CA_ZZX_CB(Long oid);
    public boolean  BU_HTTP_CA_ZZX_CB(Long oid,String policyNo,String eUrl);

    /**
     * 长安-展会责任险-支付信息保存
     * @param map
     * @return
     */
    public boolean  CA_ZZX_SAVE_PAY_MSG(Map<String,String> map);
    public boolean  BU_CA_ZZX_SAVE_PAY_MSG(Map<String,String> map);

    /**
     * 平安财-雇主责任险-支付信息保存
     * @param map
     * @return
     */
    public boolean  PAC_GZZRX_SAVE_PAY_MSG(Map<String,String> map);

    /**
     * 平安财-团意险-支付信息保存
     * @param map
     * @return
     */
    public boolean  PAC_TYX_SAVE_PAY_MSG(Map<String,String> map);

    /**
     * 对接平安寿-团意险，调编号2承保接口，记录承保信息（HTTP:以此开头为向第三方接口发起httpClient;PAS:平安寿;TYX:团意险;CB:承保）
     * @param oid 订单id
     * @throws Exception
     */
    public boolean HTTP_PAS_TYX_CB(Long oid, Map<String,String> map) throws Exception;
    public boolean HTTP_PAS_TYX_CB_TEMPORARY(Long oid, Map<String,String> map);

    /**
     * 对接平安寿-团意险，支付信息保存
     * @param paVo
     * @return
     */
    public boolean  PAS_TYX_SAVE_PAY_MSG(PingAnPayVo paVo);
    public boolean  PAS_TYX_SAVE_PAY_MSG_TEMPORARY(PingAnPayVo paVo);

    /**
     * 对接平安寿-团意险，请求电子保单下载
     * @param oid
     * @param map
     * @param vo
     */
    public void HTTP_PAS_TYX_DZBD(Long oid, Map<String,String> map, OrderFormVo vo) throws Exception;

    /**
     * 对接众安-展责险，支付信息保存
     * @param map
     * @return
     */
    public boolean  ZA_ZZX_SAVE_PAY_MSG(Map<String,String> map);

    /**
     * 对接众安-展责险，调编号2承保接口，记录承保信息（HTTP:以此开头为向第三方接口发起httpClient;ZA:众安;ZZX:展责险;CB:承保）
     * @param oid 订单id
     * @throws Exception
     */
    public boolean HTTP_ZA_ZZX_CB(Long oid, Map<String,String> map);

    /**
     * 对接华泰-公责险，调编号2承保接口，记录承保信息（HTTP:以此开头为向第三方接口发起httpClient;HT:华泰;GZX:公责险;HBCB:核保并承保）
     * @throws Exception
     */
    public void HTTP_HT_GZX_HBCB(String orderNo,String transactionNo);

    /**
     * 平安对账承保
     * @param rcptno 投保单号
     * @param p_policy_no 保单号
     * @throws Exception
     */
    public void pa_reconciliation_underwrite(String rcptno, String p_policy_no) throws Exception;

    /**
     * 对接泰康-团意险，调编号2承保接口，记录承保信息（HTTP:以此开头为向第三方接口发起httpClient;TK:泰康;TYX:团意险;CB:承保）
     * @param oid 订单id
     * @throws Exception
     */
    public void HTTP_TK_TYX_CB(Long oid) throws Exception;

    public String HTTP_DB_BUILD_HB(String oid);

    public String HTTP_YG_BUILD_DZBD(String oid);

    /**
     * <b> 小微信用险影像接口 </b>
     * @author ZXF
     * @create 2018/04/12 0012 16:19
     */
    public boolean HTTP_TPC_XYX_YX(Long oid) throws Exception;

    /**
     * <b> 小微信用险承保 </b>
     * @author ZXF
     * @create 2018/04/12 0012 16:19
     */
    public boolean HTTP_TPC_XYX_CB(Long oid) throws Exception;

    /**
     * <b> 小微信用险电子保单查询 </b>
     * @author ZXF
     * @create 2018/04/12 0012 16:19
     */
    public String HTTP_TPC_XYX_DZBD(Long oid);

    /**
     * 对接太保：接口107002，通过投保单号查找保单号设置保单状态
     */
    public void policyEndStatus(String userId);

    public void port_107002(OrderFormVo dto);

    public void returnsAnOrderToTheSpecifiedPlatform(String orderId);

    public void TYX_TK_02();

    public void XYX_TB_CB();

    public List<OrderFormVo> selectInsOrderFormByStatusAndProductCode( String status, String productCode);

    /**
     * 获取电子保单，保函
     * @param policy
     * @param sign 标识1电子保单，2电子保函
     */
    public void policyToPDF(InsInsuranceSlip policy, String sign);





    public void saveTransaction(PolicyTransactionVo vo);

    public void saveExternalReference(PolicyTransactionVo vo);

    public void savePolicyOther(PolicyTransactionVo vo);

    public boolean saveOrUpdateTransaction_ss(String policyID, String payOrderUrl, String payAmount, String path_sign);

    public void downloadAttachment(String path, String name, HttpServletResponse response);

    public String createOrderAndGetOrderIDByProductID(Long product_id, Long user_id, String recommendCode,String trade_serial_number);

    /****************************BUILD*******************************/

    public Map<String, Object> obtainSpecialBidVoSetUp(SpecialBidVo vo);

    public ResultDto pendingSpecialBidPolicy(SpecialBidVo vo, String recommendCode);

    public SpecialBidVo accordingToOrderIDToGetSpecialBidVo(Long order_id);

    public Map<String, Object> obtainSpecialPerformanceVo_1SetUp(SpecialPerformanceVo_1 vo);

    public ResultDto pendingSpecialPerformance_1VoPolicy(SpecialPerformanceVo_1 vo,String recommendCode);

    public Map<String, Object> obtainSpecialPerformanceVo_2SetUp(SpecialPerformanceVo_2 vo);

    public ResultDto pendingSpecialPerformance_2VoPolicy(SpecialPerformanceVo_2 vo);

    public Map<String, Object> obtainSpecialPerformanceVo_3SetUp(SpecialPerformanceVo_3 vo);

    public ResultDto pendingSpecialPerformance_3VoPolicy(SpecialPerformanceVo_3 vo);

    public SpecialPerformanceVo_1 accordingToOrderIDToGetSpecialPerformanceVo_1(Long order_id);

    public SpecialPerformanceVo_2 accordingToOrderIDToGetSpecialPerformanceVo_2(Long order_id);

    public SpecialPerformanceVo_3 accordingToOrderIDToGetSpecialPerformanceVo_3(Long order_id);




    /****************************LAWSUIT*******************************/


    public Map<String, Object> obtainSpecialLitigationVo_1SetUp(SpecialLitigationVo_1 vo);

    public ResultDto pendingSpecialLitigation_1VoPolicy(SpecialLitigationVo_1 vo, String recommendCode);

    public Map<String, Object> obtainSpecialLitigationVo_2SetUp(SpecialLitigationVo_2 vo);

    public ResultDto pendingSpecialLitigation_2VoPolicy(SpecialLitigationVo_2 vo);

    public Map<String, Object> obtainSpecialLitigationVo_3SetUp(SpecialLitigationVo_3 vo);

    public ResultDto pendingSpecialLitigation_3VoPolicy(SpecialLitigationVo_3 vo);

    public SpecialLitigationVo_1 accordingToOrderIDToGetSpecialLitigationVo_1(Long order_id);

    public SpecialLitigationVo_2 accordingToOrderIDToGetSpecialLitigationVo_2(Long order_id);

    public SpecialLitigationVo_3 accordingToOrderIDToGetSpecialLitigationVo_3(Long order_id);

    public boolean deleteLnAccusedByOid(String lna_id);

    /****************************GMR*******************************/

    public Map<String, Object> obtainGMRPolicyVoSetUp(GMRPolicyVo vo);

    public ResultDto pendingGMRPolicyVoPolicy(GMRPolicyVo vo, String recommendCode);

    public GMRPolicyVo accordingToOrderIDToGetGMRPolicyVo(Long order_id);

    /****************************GZZRX*******************************/

    public Map<String, Object> obtainSpecialHirelingVoSetUp(SpecialHirelingVo vo);

    public ResultDto pendingSpecialHirelingVoPolicy(SpecialHirelingVo vo, String recommendCode);

    public SpecialHirelingVo accordingToOrderIDToGetSpecialHirelingVo(Long order_id);

    /****************************AFR*******************************/

    public Map<String, Object> obtainSpecialPublicDutyVoSetUp(SpecialPublicDutyVo vo);

    public ResultDto pendingSpecialPublicDutyVoPolicy(SpecialPublicDutyVo vo, String recommendCode);

    public SpecialPublicDutyVo accordingToOrderIDToGetSpecialPublicDutyVo(Long order_id);

    /****************************ZZX*******************************/

    public Map<String, Object> obtainLOTEPolicyVoSetUp(LOTEPolicyVo vo);

    public ResultDto pendingLOTEPolicyVoPolicy(LOTEPolicyVo vo, String recommendCode);

    public LOTEPolicyVo accordingToOrderIDToGetLOTEPolicyVo(Long order_id);

    /****************************GYX*******************************/

    public Map<String, Object> obtainGYXPolicyVoSetUp(GYXPolicyVo vo);

    public ResultDto pendingGYXPolicyVoPolicy(GYXPolicyVo vo, String recommendCode);

    public GYXPolicyVo accordingToOrderIDToGetGYXPolicyVo(Long order_id);

    public BigDecimal setInsuredAmountByProductId(Long pId);

    public String getArsPath(String sign);

    public String getArsPathWeb(String sign);

    public String pns_access_token();

    public String pnc_access_token();

    public void gainDZBDByTiming();

    public void yxTimer(Long order_id);

    public void payUrlChange(Long order_id) throws Exception;

    public void payUrlChangeZHGZ(Long order_id,String payNo,String payUrl) throws Exception;

    /**
     * <b> CA-初始化交易信息，保存支付号和交易地址 </b>
     * @author ZXF
     * @create 2019/10/28 0028 17:24
     * @version
     * @注意事项 </b>
     */
    public void payUrlChangeCA(Long order_id,String payNo,String payUrl) throws Exception;
    /**
     * <b> CA-初始化交易信息，保存支付号和交易地址 </b>
     * @author ZXF
     * @create 2019/10/28 0028 17:24
     * @version
     * @注意事项 </b>
     */
    public void payUrlChangeHT(Long order_id,String payNo,String payUrl) throws Exception;

    /**
     * <b> PAC-初始化交易信息，保存交易id和交易地址 </b>
     * @author ZXF
     * @create 2019/10/28 0028 17:24
     * @version
     * @注意事项 </b>
     */
    public void payUrlChangePAC(Long order_id,String tranNo,String payUrl) throws Exception;

    public String zzx_amount_count(String productCode, String exAcreage);

    /**
     * <b> 根据保单号设置发票记录表中的电子发票地址信息 </b>
     * @author ZXF
     * @create 2019/09/29 0029 14:42
     * @version
     * @注意事项 </b>
     */
    public void updateUrlByExternalreference(String url, String externalreference);

    /**
     * <b> 当订单待支付时客户要下载保障人员名单 </b>
     * @author ZXF
     * @create 2019/11/07 0007 14:35
     * @version
     * @注意事项 </b>
     */
    public void downSecurityPersonnel(Long oid, HttpServletResponse resp);

    /**
     * <b> 保险到期发送邮件 </b>
     * @author ZXF
     * @create 2020/03/17 0017 14:06
     * @version
     * @注意事项 </b>
     */
    public void policyExpireInform();

    public List<Map<String,Object>> orderList(String idCardNo);

    /**
     * <b> 做批单时，检索生效时间是否是到期时间当天 </b>
     * @author ZXF
     * @create 2020/09/07 0007 9:50
     * @version
     * @注意事项 </b>
     */
    int isDueToByPolicy(Long orderId,String inception_date);

    /**
     * <b> 上传缴费凭证发送邮件通知 </b>
     * @param orderId 订单id
     * @param payUrl 凭证地址
     * @author ZXF
     * @create 2021/10/28 0028 17:24
     * @version
     * @注意事项 </b>
     */
    void JFPZ_SendEmail(Long orderId, String payUrl);

    /**
     * <b> 订单复制，只有待支付才有此功能 </b>
     * @author ZXF
     * @create 2019/08/14 0014 11:33
     * @version
     * @注意事项 </b>
     */
    ResultDto copyPolicy(Long orderID);

    /**
     * <b> 创建订单推送任务 </b>
     * 将新增保单、批改、退保拆分成订单推送给商城
     * @param orderId 订单ID、批单ID
     * @param type 类型：1.批改 2.新增保单 3.退保
     * @param inceptionDate 开始时间 退保时必填，其它都能查到
     * @author ZXF
     * @create 2023/08/30 0030 11:15
     * @version
     * @注意事项 </b>
     */
    boolean createSendOrderTask(Long orderId,int type,String inceptionDate);

    /**
     * <b> 订单人员相关信息推送给商城 </b>
     * @author ZXF
     * @create 2023/08/31 0031 9:31
     * @version
     * @注意事项 </b>
     */
    public boolean sendOrderToShop(ImportInsuranceOrderRequest oRequest);
}
