package com.bcxin.ins.service.oauth;


import com.bcxin.ins.dto.Result;
import com.bcxin.ins.dto.oauth.AccessToken;
import com.bcxin.ins.vo.ClientUserVo;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public interface OAuthService {

    /**
     * 获取token处理
     *
     * @param response
     * @throws Exception
     */
    Result saveDispatch(HttpServletRequest request, HttpServletResponse response, String clientType)
            throws Exception;

    AccessToken getAccessToken(String clientType, ClientUserVo clientUserVo, String tokenId) throws OAuthSystemException;

    /**
     * 通过access_token获取AccessToken对象
     *
     * @param access_token
     * @return
     * @throws Exception
     */
    AccessToken getAccessToken(String access_token);

}
