package com.bcxin.ins.service.common.impl;

import com.bcxin.ins.dao.common.SysClientUserPostMapper;
import com.bcxin.ins.service.common.SysClientUserPostService;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.core.util.DOM;
import com.bcxin.ins.entity.user.SysClientUserPost;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.util.List;
import java.util.Map;

@Service
@Transactional
public class SysClientUserPostServiceImpl extends ServiceImpl<SysClientUserPostMapper, SysClientUserPost> implements SysClientUserPostService {
	private static Logger log = LoggerFactory.getLogger(SysClientUserPostServiceImpl.class);

	@Autowired
	private SysClientUserPostMapper sysClientUserPostMapper;

	@Override
	public R add(Map<Object, Object> p) {
		try{
			SysClientUserPost sysClientUserPost  = (SysClientUserPost) DOM.mtd(p,new SysClientUserPost());
			Map<String,Object> m = Maps.newHashMap();
			m.put("sys_client_user_id",p.get("sys_client_user_id"));
			List<SysClientUserPost> l = this.selectByMap(m);
			if(l.size()==0){
				this.insert(sysClientUserPost);
			}else{
				this.updateById(sysClientUserPost);
			}
			return new R(true,"操作成功");
		} catch (Exception e) {
			log.error("新增邮寄地址错误，事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new R(false,"操作失败");
		}
	}


}
